/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client;

import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.TransModeEnum;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.botp.client.AbstractExtRuleDefUI;
import com.kingdee.eas.base.botp.client.util.BotpDataFilterEntryInfo;
import com.kingdee.eas.base.botp.util.IBotpMetaData;
import com.kingdee.eas.base.commonquery.client.CommonEntityFilterPanel;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;

public class ExtRuleDefUI
extends AbstractExtRuleDefUI {
    private static final String RESXFILENAME = "com.kingdee.eas.base.botp.BotpResx";
    private static final String FILTERERROR = "FILTERERROR";
    private static final String BotpRuleHead = "BotpRuleHead";
    private ExtRuleDefUI myUI = null;
    private boolean noEntries = false;
    private BOTMappingInfo mappingInfo;
    protected CommonEntityFilterPanel pnlFilter;
    private static final String ENTRY_FILTER_PANAL = "ENTRY_FILTER_PANAL";
    private static final String ENTRY_NAMES = "ENTRY_NAMES";
    private static final String ENTRY_PK = "ENTRY_PK";
    private ArrayList entryList = new ArrayList();

    public ExtRuleDefUI() throws Exception {
        this.btnSchedule.setIcon(EASResource.getIcon((String)"imgTbtn_attemper"));
        this.cbxTransMode.setEnabled(false);
        this.myUI = this;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        if (this.pnlFilter != null && !this.pnlFilter.verify()) {
            return;
        }
        for (int i = 0; i < this.entryList.size(); ++i) {
            BotpDataFilterEntryInfo info = (BotpDataFilterEntryInfo)this.entryList.get(i);
            CommonEntityFilterPanel pnlEntryFilter = info.getPnlEntryFilter();
            if (pnlEntryFilter == null || pnlEntryFilter.verify()) continue;
            return;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = this.pnlFilter.getFilterInfo();
        String maskString = filterInfo.getMaskString();
        entityViewInfo.setFilter(filterInfo);
        FilterInfo entryFilterInfo = new FilterInfo();
        for (int i = 0; i < this.entryList.size(); ++i) {
            BotpDataFilterEntryInfo info = (BotpDataFilterEntryInfo)this.entryList.get(i);
            CommonEntityFilterPanel pnlEntryFilter = info.getPnlEntryFilter();
            entryFilterInfo = pnlEntryFilter.getFilterInfo();
            if (entryFilterInfo.getFilterItems().size() <= 0) continue;
            entryFilterInfo.setEntryilterType(EntryFilterType.NORMAL);
            entryFilterInfo.setEntryName(info.getEntryName());
            entityViewInfo.getEntryFilters().add(entryFilterInfo);
        }
        if (this.mappingInfo.getDefineSys().equals((Object)DefineSysEnum.DAP)) {
            CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)this.bpbCompany.getData();
            this.mappingInfo.getExtRule().setOrg(org);
            this.mappingInfo.getExtRule().setTransMode((TransModeEnum)((Object)this.cbxTransMode.getSelectedItem()));
            this.mappingInfo.getExtRule().setScheduleXml((String)this.btnSchedule.getUserObject());
        }
        this.mappingInfo.getExtRule().setFilter(entityViewInfo.toString());
        this.mappingInfo.getExtRule().setFilterMaskString(maskString);
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    public void setBotMapping(BOTMappingInfo mappingInfo) throws Exception {
        BotpDataFilterEntryInfo info;
        this.setMappingInfo(mappingInfo);
        if (this.mappingInfo.getDefineSys().equals((Object)DefineSysEnum.BTP)) {
            this.pnlDap.setVisible(false);
        } else {
            TransModeEnum transMode;
            if (this.mappingInfo.getExtRule().getOrg() != null) {
                if (!this.mappingInfo.getExtRule().getOrg().containsKey("name")) {
                    CompanyOrgUnitInfo org = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.mappingInfo.getExtRule().getOrg().getId()));
                    this.mappingInfo.getExtRule().setOrg(org);
                }
                this.bpbCompany.setData((Object)this.mappingInfo.getExtRule().getOrg());
            }
            if ((transMode = this.mappingInfo.getExtRule().getTransMode()).equals((Object)TransModeEnum.IMCreate)) {
                this.btnSchedule.setEnabled(false);
            }
            if (this.mappingInfo.getExtRule().getScheduleXml() != null && this.mappingInfo.getExtRule().getScheduleXml().length() > 0) {
                this.btnSchedule.setUserObject((Object)this.mappingInfo.getExtRule().getScheduleXml());
            } else if (this.mappingInfo.getExtRule().getProcessDefId() != null && (this.mappingInfo.getExtRule().getProcessDefId().length() == 44 || this.mappingInfo.getExtRule().getProcessDefId().length() == 28)) {
                EASWfServiceClient client = ExtRuleDefUI.getEASWfServiceClient();
                ProcessDefInfo processDefInfo = client.getProcessDefInfo(this.mappingInfo.getExtRule().getProcessDefId());
                String kpdl = EnactmentServiceFactory.createRemoteEnactService().getProcessDefByDefineHashValue(processDefInfo.getMd5HashValue()).toXml();
                String scheduleXml = KpdlParser.getScheduleXml((String)kpdl);
                this.btnSchedule.setUserObject((Object)scheduleXml);
                this.mappingInfo.getExtRule().setScheduleXml(scheduleXml);
            }
            this.cbxTransMode.setSelectedItem((Object)transMode);
        }
        MetaDataPK srcEntityPk = new MetaDataPK(this.mappingInfo.getSrcEntityFullName());
        FilterInfo filterInfo = null;
        boolean bExistEntryFilter = false;
        if (this.mappingInfo.getExtRule().getFilter() != null) {
            EntityViewInfo entityViewInfo = new EntityViewInfo(this.mappingInfo.getExtRule().getFilter());
            if (!StringUtils.isEmpty((String)this.mappingInfo.getExtRule().getFilterMaskString())) {
                entityViewInfo.getFilter().setMaskString(this.mappingInfo.getExtRule().getFilterMaskString());
            }
            filterInfo = entityViewInfo.getFilter();
            if (entityViewInfo.getEntryFilters() != null && entityViewInfo.getEntryFilters().size() > 0) {
                bExistEntryFilter = true;
                FilterCollection fc = entityViewInfo.getEntryFilters();
                for (int i = 0; i < fc.size(); ++i) {
                    FilterInfo temp = fc.get(i);
                    BotpDataFilterEntryInfo entryInfo = this.getEntryInfoByName(temp.getEntryName());
                    if (entryInfo == null) continue;
                    entryInfo.setEntryFilterInfo(temp);
                }
            }
        }
        if (!bExistEntryFilter) {
            for (int i = 0; i < this.entryList.size(); ++i) {
                info = (BotpDataFilterEntryInfo)this.entryList.get(i);
                String entryName = info.getEntryName();
                if (entryName == null || entryName.length() <= 0) continue;
                FilterInfo entryFilterInfo = new FilterInfo(EntryFilterType.NORMAL);
                entryFilterInfo.setEntryName(entryName);
                info.setEntryFilterInfo(entryFilterInfo);
            }
        }
        this.pnlFilter = this.buildFilterPanel((IMetaDataPK)srcEntityPk, filterInfo, EASResource.getString((String)RESXFILENAME, (String)BotpRuleHead));
        for (int i = 0; i < this.entryList.size(); ++i) {
            info = (BotpDataFilterEntryInfo)this.entryList.get(i);
            CommonEntityFilterPanel pnlEntryFilter = this.buildFilterPanel(info.getSrcEntryEntityPk(), info.getEntryFilterInfo(), info.getEntryAlias());
            info.setPnlEntryFilter(pnlEntryFilter);
        }
    }

    public BOTMappingInfo getMappingInfo() {
        return this.mappingInfo;
    }

    public void setMappingInfo(BOTMappingInfo mappingInfo) {
        this.mappingInfo = mappingInfo;
    }

    @Override
    protected void btnSchedule_actionPerformed(ActionEvent e) throws Exception {
        super.btnSchedule_actionPerformed(e);
        if (this.btnSchedule.getUserObject() == null) {
            this.btnSchedule.setUserObject((Object)ProcessSchedulePlan.open((Object)((Object)this), null));
        } else {
            this.btnSchedule.setUserObject((Object)ProcessSchedulePlan.open((Object)((Object)this), (String)this.btnSchedule.getUserObject().toString()));
        }
    }

    public static EASWfServiceClient getEASWfServiceClient() throws Exception {
        EASWfServiceClient client = new EASWfServiceClient();
        client.init(UIConfig.getUrl(), SysContext.getSysContext().getSessionID());
        return client;
    }

    @Override
    protected void cbxTransMode_actionPerformed(ActionEvent e) throws Exception {
        super.cbxTransMode_actionPerformed(e);
        TransModeEnum transMode = (TransModeEnum)((Object)this.cbxTransMode.getSelectedItem());
        if (transMode.equals((Object)TransModeEnum.IMCreate)) {
            this.btnSchedule.setEnabled(false);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.bpbCompany.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                CompanyF7 f7 = new CompanyF7((IUIObject)ExtRuleDefUI.this.myUI);
                f7.setUIAction((IUIObject)ExtRuleDefUI.this.myUI, (ItemAction)ExtRuleDefUI.this.myUI.actionAbout);
                CompanyOrgUnitInfo orgInfo = SysContext.getSysContext().getCurrentFIUnit();
                if (orgInfo != null) {
                    f7.setRootUnitID(orgInfo.getId().toString());
                }
                ExtRuleDefUI.this.bpbCompany.setDialog((KDPromptSelector)f7);
            }
        });
        super.onLoad();
        ArrayList srcDetailEntryList = (ArrayList)this.getUIContext().get("entry");
        if (srcDetailEntryList != null && srcDetailEntryList.size() > 0) {
            int n = srcDetailEntryList.size();
            for (int i = 0; i < n; ++i) {
                IBotpMetaData srcDetailBotpProperty = (IBotpMetaData)srcDetailEntryList.get(i);
                String entryName = srcDetailBotpProperty.getLongName();
                String entryAlias = srcDetailBotpProperty.getAlias();
                MetaDataPK srcEntryEntityPk = new MetaDataPK(srcDetailBotpProperty.getDetailEntity().getFullName());
                BotpDataFilterEntryInfo info = new BotpDataFilterEntryInfo(entryName, entryAlias, (IMetaDataPK)srcEntryEntityPk);
                this.entryList.add(info);
            }
        } else {
            this.noEntries = true;
        }
    }

    private CommonEntityFilterPanel buildFilterPanel(IMetaDataPK entityPK, FilterInfo entryFilterInfo, String title) throws Exception {
        CommonEntityFilterPanel pnlEntryFilter = new CommonEntityFilterPanel(entityPK, entryFilterInfo, null, null, false, true, true);
        KDContainer ctnEntryFilter = new KDContainer();
        ctnEntryFilter.getContentPane().setLayout(new BorderLayout());
        ctnEntryFilter.getContentPane().add((Component)pnlEntryFilter.getKdtTable(), "Center");
        ctnEntryFilter.addButton((JButton)pnlEntryFilter.getAddRowButton());
        ctnEntryFilter.addButton((JButton)pnlEntryFilter.getDelRowButton());
        if (pnlEntryFilter.getMoveUpRowButton() != null) {
            ctnEntryFilter.addButton((JButton)pnlEntryFilter.getMoveUpRowButton());
        }
        if (pnlEntryFilter.getMoveDownRowButton() != null) {
            ctnEntryFilter.addButton((JButton)pnlEntryFilter.getMoveDownRowButton());
        }
        if (pnlEntryFilter.getInsRowButton() != null) {
            ctnEntryFilter.addButton((JButton)pnlEntryFilter.getInsRowButton());
        }
        ctnEntryFilter.addButton((JButton)pnlEntryFilter.getClearButton());
        this.tabPanel.addTab(title, (Component)ctnEntryFilter);
        return pnlEntryFilter;
    }

    private BotpDataFilterEntryInfo getEntryInfoByName(String entryName) {
        for (int i = 0; i < this.entryList.size(); ++i) {
            BotpDataFilterEntryInfo info = (BotpDataFilterEntryInfo)this.entryList.get(i);
            String name = info.getEntryName();
            if (name == null || !name.equalsIgnoreCase(entryName)) continue;
            return info;
        }
        return null;
    }

    protected JButton getDefaultButton() {
        return this.btnOk;
    }
}

