/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client.builder.metas;

import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.base.botp.client.builder.BuilderResourceUtil;
import com.kingdee.eas.base.botp.client.builder.metas.BOSMetaTreeModelCreator;
import com.kingdee.eas.base.botp.client.builder.metas.BOSObj;
import com.kingdee.eas.base.botp.client.builder.metas.BOSObjMthd;
import com.kingdee.eas.base.botp.client.builder.metas.BOSObjProp;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;

public class BOSObjEntity
extends BOSObj {
    EntityObjectInfo entityInfo;
    Vector bosProps = new Vector();
    Vector bosMthds = new Vector();
    private static final String CHILD_ENTITY_NAME = "entries";

    public BOSObjEntity(EntityObjectInfo eoi) {
        if (eoi == null) {
            return;
        }
        this.entityInfo = eoi;
        BOSMetaTreeModelCreator.addDealingObj((BusinessObjectInfo)eoi);
        PropertyCollection props = this.entityInfo.getInheritedNoDuplicatedProperties();
        this.dealProperty(props);
    }

    private void dealProperty(PropertyCollection props) {
        if (props == null) {
            return;
        }
        for (int i = 0; i < props.size(); ++i) {
            PropertyInfo propInfo = props.get(i);
            BOSObjProp bosProp = new BOSObjProp();
            bosProp.setName(propInfo.getName());
            bosProp.setAlias(propInfo.getAlias());
            if (propInfo instanceof OwnPropertyInfo) {
                String htmlDesc = "";
                htmlDesc = htmlDesc + "<html><body>";
                htmlDesc = htmlDesc + "<b>" + BuilderResourceUtil.getString("PropertyType") + "</b> " + ((OwnPropertyInfo)propInfo).getJavaType();
                htmlDesc = htmlDesc + "</body></html>";
                bosProp.setType(((OwnPropertyInfo)propInfo).getJavaType());
                bosProp.setDesc(htmlDesc);
            }
            if (propInfo instanceof LinkPropertyInfo) {
                LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
                String htmlDesc = "";
                htmlDesc = htmlDesc + "<html><body>";
                htmlDesc = htmlDesc + "<b>" + BuilderResourceUtil.getString("PropertyType") + "</b> " + BuilderResourceUtil.getString("linkProperty");
                bosProp.setLinkPropertyInfo(linkProp);
                bosProp.setLinkPropertyClient(this.entityInfo);
                htmlDesc = htmlDesc + "</body></html>";
                bosProp.setDesc(htmlDesc);
            }
            this.bosProps.add(bosProp);
        }
    }

    private void dealMethod(MethodCollection mthds) {
        if (mthds == null) {
            return;
        }
        for (int i = 0; i < mthds.size(); ++i) {
            MethodInfo mthdInfo = mthds.get(i);
            if (this.entityInfo.isSystemMethod(mthdInfo)) continue;
            BOSObjMthd bosMthd = new BOSObjMthd();
            bosMthd.setName(mthdInfo.getName());
            bosMthd.setAlias(mthdInfo.getAlias());
            String dataType = BOSObjEntity.getReturnType(mthdInfo);
            bosMthd.setType(dataType);
            if (DataType.OBJECTVALUE.toString().equalsIgnoreCase(dataType) || DataType.OBJECTCOLLECTION.toString().equalsIgnoreCase(dataType)) {
                bosMthd.setIsEntity(true);
                String metaData = mthdInfo.getMetaDataRef();
                if (metaData == null || "".equals(metaData)) {
                    metaData = this.entityInfo.getFullName();
                }
                MetaDataPK pk = new MetaDataPK(metaData);
                bosMthd.setMetaPK(pk);
            }
            bosMthd.setDesc(BOSObjEntity.genParamsDescHtmlStr((BusinessObjectInfo)this.entityInfo, mthdInfo));
            this.bosMthds.add(bosMthd);
        }
    }

    @Override
    public String getObjClassName() {
        return this.entityInfo.getBusinessInterface();
    }

    public String getObjPropClassName() {
        return this.entityInfo.getObjectValueClass();
    }

    protected static String getReturnType(MethodInfo method) {
        if (method == null) {
            return null;
        }
        String dataType = method.getDataType();
        String metaData = method.getMetaDataRef();
        if (metaData == null) {
            return method.getReturnValueType().toString();
        }
        MetaDataPK pk = new MetaDataPK(metaData);
        if (DataType.OBJECTVALUE.toString().equalsIgnoreCase(dataType) || DataType.OBJECTCOLLECTION.toString().equalsIgnoreCase(dataType)) {
            return dataType;
        }
        return metaData;
    }

    protected static String genParamsDescHtmlStr(BusinessObjectInfo boInfo, MethodInfo mthdInfo) {
        String htmlDesc = "";
        htmlDesc = htmlDesc + "<html><body>";
        htmlDesc = htmlDesc + "<b>Return type:</b> " + BOSObjEntity.getReturnType(mthdInfo);
        htmlDesc = htmlDesc + "<hr>";
        htmlDesc = htmlDesc + "<b>Parameters: </b>";
        htmlDesc = htmlDesc + "<ul>";
        ParameterCollection pc = mthdInfo.getParameters();
        for (int k = 0; k < pc.size(); ++k) {
            ParameterInfo pi = pc.get(k);
            htmlDesc = htmlDesc + "<li><b>" + pi.getName() + "</b>  " + pi.getDataType() + "</li>";
        }
        htmlDesc = htmlDesc + "</ul>";
        htmlDesc = htmlDesc + "</body></html>";
        return htmlDesc;
    }

    @Override
    public BusinessObjectInfo getBizObj() {
        return this.entityInfo;
    }

    public void insert(MutableTreeNode newChild, int childIndex) {
        if (!this.allowsChildren) {
            throw new IllegalStateException("node does not allow children");
        }
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null");
        }
        MutableTreeNode oldParent = (MutableTreeNode)newChild.getParent();
        if (oldParent != null) {
            oldParent.remove(newChild);
        }
        newChild.setParent((MutableTreeNode)((Object)this));
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(newChild, childIndex);
    }

    public Vector getBosProps() {
        return this.bosProps;
    }

    @Override
    public String getText() {
        return this.entityInfo.getAlias();
    }

    @Override
    public String getName() {
        return this.entityInfo.getName();
    }
}

