/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreBillListUI;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetaDataUtil {
    private static String GET_SRCBILLENTRYID_METHOD = "getsourceBillEntryId";

    public static String getDisplayName(EntityObjectInfo entity) {
        if (entity.getAlias() != null && entity.getAlias().length() > 0) {
            return entity.getAlias();
        }
        return entity.getName();
    }

    public static String getDisplayName(PropertyInfo property) {
        if (property.getAlias() != null && property.getAlias().length() > 0) {
            return property.getAlias();
        }
        return property.getName();
    }

    public static boolean isNumric(DataType dataType) {
        return dataType.equals((Object)DataType.DECIMAL) || dataType.equals((Object)DataType.DOUBLE) || dataType.equals((Object)DataType.FLOAT) || dataType.equals((Object)DataType.INTEGER) || dataType.equals((Object)DataType.LONG) || dataType.equals((Object)DataType.SHORT);
    }

    public static Map getSourceEntryProNameByBillID(List billIDs) throws BOSException, EASBizException {
        HashMap<BOSObjectType, Object> retmap = new HashMap<BOSObjectType, Object>();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        String listui = null;
        for (int i = 0; i < billIDs.size(); ++i) {
            BOSObjectType bostype = null;
            try {
                bostype = BOSUuid.getBOSObjectType((String)billIDs.get(i).toString(), (boolean)true);
                if (retmap.get(bostype) != null) continue;
                EntityObjectInfo tempObj = loader.getEntity(bostype);
                listui = tempObj.getExtendedProperty("listUI") == null ? null : tempObj.getExtendedProperty("listUI").toString();
            }
            catch (Exception e) {
                throw new BTPException(BTPException.GETEXTENDPROPERROR, e);
            }
            if (listui == null) continue;
            try {
                Class<?> listUIClass = Class.forName(listui);
                Object uiObject = listUIClass.newInstance();
                if (!(uiObject instanceof CoreBillListUI)) continue;
                Method method = listUIClass.getMethod(GET_SRCBILLENTRYID_METHOD, null);
                Object returnVal = method.invoke(uiObject, null);
                retmap.put(bostype, returnVal);
                continue;
            }
            catch (Exception e) {
                retmap.put(bostype, null);
            }
        }
        return retmap;
    }

    public static Object getSourceEntryProNameByBillID(String billID) throws BOSException, EASBizException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        String listui = null;
        BOSObjectType bostype = null;
        try {
            bostype = BOSUuid.getBOSObjectType((String)billID, (boolean)true);
            EntityObjectInfo tempObj = loader.getEntity(bostype);
            listui = tempObj.getExtendedProperty("listUI") == null ? null : tempObj.getExtendedProperty("listUI").toString();
        }
        catch (Exception e) {
            throw new BTPException(BTPException.GETEXTENDPROPERROR, e);
        }
        if (listui != null) {
            try {
                Class<?> listUIClass = Class.forName(listui);
                Object uiObject = listUIClass.newInstance();
                if (uiObject instanceof CoreBillListUI) {
                    Method method = listUIClass.getMethod(GET_SRCBILLENTRYID_METHOD, null);
                    return method.invoke(uiObject, null);
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

