/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.btp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.biz.agent.DefaultMultiBillWorkAgent;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.base.botp.client.BOTMappingSelectUI;
import com.kingdee.eas.base.botp.client.util.MetaDataUtil;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.BTPUtil;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.btp.client.BOTClientTools;
import com.kingdee.eas.base.btp.client.BTPMakeBillUIWithoutGrp2;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.IBTPBillEdit;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.mutex.DataObjectMutex;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class BTPBillEditImpl
implements IBTPBillEdit {
    private CoreBillEditUI billEditUI = null;
    private boolean isCancel = true;
    private IUIWindow destBillUIWindow = null;
    public static String FINDMODEL = "findModel";
    private static String RESNAME = "com.kingdee.eas.base.btp.btpResource";
    private static final Logger logger = CoreUIObject.getLogger(BTPBillEditImpl.class);

    public BTPBillEditImpl(CoreBillEditUI billEditUI) {
        this.billEditUI = billEditUI;
    }

    public void init() throws Exception {
    }

    public IObjectPK save(Context ctx) throws Exception {
        ICoreBase instance = this.billEditUI.getBillInterface();
        if (instance instanceof ICoreBillBase) {
            BOTRelationCollection relations;
            IBTPManager iBTPManager = null;
            iBTPManager = ctx != null ? BTPManagerFactory.getRemoteInstanceWithObjectContext(ctx) : BTPManagerFactory.getRemoteInstance();
            CoreBillBaseInfo editData = this.billEditUI.getEditData();
            if (editData != null && editData.getId() != null && (relations = iBTPManager.getRelationCollection(editData.getId().toString())).size() > 0) {
                this.billEditUI.setMakeRelations(relations);
            }
            return iBTPManager.saveRelations(editData, this.billEditUI.getMakeRelations());
        }
        return this.billEditUI.runSave();
    }

    public IObjectPK submit(Context ctx) throws Exception {
        if (this.billEditUI.getBillInterface() instanceof ICoreBillBase) {
            BOTRelationCollection relations;
            IBTPManager iBTPManager = null;
            iBTPManager = ctx != null ? BTPManagerFactory.getRemoteInstanceWithObjectContext(ctx) : BTPManagerFactory.getRemoteInstance();
            CoreBillBaseInfo editData = this.billEditUI.getEditData();
            if (editData != null && editData.getId() != null && (relations = iBTPManager.getRelationCollection(editData.getId().toString())).size() > 0) {
                this.billEditUI.setMakeRelations(relations);
            }
            IObjectPK pk = iBTPManager.submitRelations(editData, this.billEditUI.getMakeRelations());
            if ("ADDNEW".equals(this.billEditUI.getOprtState()) || "COPYADDNEW".equals(this.billEditUI.getOprtState()) || "EXITING".equals(this.billEditUI.getOprtState())) {
                this.billEditUI.setMakeRelations(null);
            } else {
                this.billEditUI.setMakeRelations(iBTPManager.getRelationCollection(pk.toString()));
            }
            return pk;
        }
        return this.billEditUI.runSubmit();
    }

    protected String getCreateFromUI(int flag) {
        String fromUIClassName = "";
        if (flag == 0) {
            fromUIClassName = "com.kingdee.eas.base.btp.client.BTPMakeBillFromUI";
        } else if (flag == 1) {
            fromUIClassName = "com.kingdee.eas.base.btp.client.BTPMakeBillFromMultiData";
        } else if (flag == 2) {
            fromUIClassName = "com.kingdee.eas.base.btp.client.BTPMakeBillFromMultiDataListUI";
        }
        return fromUIClassName;
    }

    public void createFrom(Context ctx) throws Exception {
        this.createFrom(ctx, null);
    }

    protected IUIWindow openDialog(int flag, BOSObjectType destBosType, HashMap paramCtx, Context ctx) throws Exception {
        String createFromUI = this.getCreateFromUI(flag);
        UIContext uiContext = new UIContext((Object)this.billEditUI);
        uiContext.put("billEdit", this.billEditUI);
        uiContext.put("Dest_MainOrgContext", ctx);
        this.billEditUI.getUIContext().put("BOTPUIParam", "botp");
        if (paramCtx != null) {
            uiContext.put("BTPEDITPARAMETER", paramCtx);
        }
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = null;
        if (flag == 2) {
            return window;
        }
        uiContext.put("destBillBOSTypeString", destBosType);
        window = uiFactory.create(createFromUI, (Map)uiContext, null);
        return window;
    }

    public void createFrom(Context ctx, HashMap paramCtx) throws Exception {
        BOSObjectType destBosType;
        int flag = 2;
        flag = this.billEditUI.getBtpCreateFromType();
        IUIWindow window = this.openDialog(flag, destBosType = this.billEditUI.getBillInterface().getType(), paramCtx, ctx);
        if (window == null) {
            return;
        }
        window.show();
    }

    public void traceUp(CoreBillBaseInfo bill) throws Exception {
        Object sourceEntryIdProName;
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        String billID = bill.getId().toString();
        uiContext.put("billInfoID", billID);
        uiContext.put("findType", new Integer(0));
        uiContext.put("findBillType", "up");
        if (this.billEditUI.getUIContext().get("selectedEntries") != null) {
            uiContext.put("selectedEntries", this.billEditUI.getUIContext().get("selectedEntries"));
        }
        if ((sourceEntryIdProName = MetaDataUtil.getSourceEntryProNameByBillID(billID)) != null) {
            uiContext.put("sourceEntryIdProName", sourceEntryIdProName);
        }
        uiContext.put("BTPNAVCTX", this.billEditUI.getUIContext());
        IUIFactory uiFactory = this.createUIFactory(this.billEditUI);
        IUIWindow window = uiFactory.create("com.kingdee.eas.base.btp.client.BTPRelationNavUI", uiContext, null);
        if (window instanceof UIModelDialog) {
            Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension maxSize = new Dimension(820, 650);
            if ((double)screenDim.width > maxSize.getWidth() || (double)screenDim.height > maxSize.getHeight()) {
                screenDim = maxSize;
            }
            ((JPanel)((UIModelDialog)window).getContentPane()).setPreferredSize(screenDim);
        }
        window.show();
    }

    public void traceDown(CoreBillBaseInfo bill) throws Exception {
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        uiContext.put("BTPNAVCTX", this.billEditUI.getUIContext());
        if (this.billEditUI.getUIContext().get("selectedEntries") != null) {
            uiContext.put("selectedEntries", this.billEditUI.getUIContext().get("selectedEntries"));
        }
        String billID = bill.getId().toString();
        uiContext.put("billInfoID", billID);
        uiContext.put("findType", new Integer(1));
        uiContext.put("findBillType", "down");
        IUIFactory uiFactory = this.createUIFactory(this.billEditUI);
        IUIWindow window = uiFactory.create("com.kingdee.eas.base.btp.client.BTPRelationNavUI", uiContext, null);
        if (window instanceof UIModelDialog) {
            Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension maxSize = new Dimension(820, 650);
            if ((double)screenDim.width > maxSize.getWidth() || (double)screenDim.height > maxSize.getHeight()) {
                screenDim = maxSize;
            }
            ((JPanel)((UIModelDialog)window).getContentPane()).setPreferredSize(screenDim);
        }
        window.show();
    }

    private IUIFactory createUIFactory(CoreBillEditUI billEditUI) throws Exception {
        IUIWindow window = billEditUI.getUIWindow();
        if (window != null && window instanceof UIModelDialog) {
            return UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        }
        return UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
    }

    public String getCreateToMappingRuleSelUI() {
        String mappingSelUI = "com.kingdee.eas.base.botp.client.BOTMappingSelectUI";
        return mappingSelUI;
    }

    public String getCreateToDstTypeSelUI() {
        String srcBillSelUI = "com.kingdee.eas.base.btp.client.BTPMakeBillUIWithoutGrp2";
        return srcBillSelUI;
    }

    public void CreateTo(CoreBillBaseInfo bill) throws Exception {
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        uiContext.put("Owner", this.billEditUI);
        CoreBillBaseCollection bills = new CoreBillBaseCollection();
        bills.add(bill);
        if (bills == null || bills.size() == 0) {
            MsgBox.showWarning((Component)this.billEditUI, (String)"bill not saved\uff01");
            return;
        }
        uiContext.put("srcBillInfos", bills);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        uiContext.put("SRCBILLEDIT", this.billEditUI);
        String srcBillSelectUI = "com.kingdee.eas.base.btp.client.BTPMakeBillUIWithoutGrp2";
        IUIWindow window = uiFactory.create(srcBillSelectUI, uiContext, null);
        CtrlSwingUtilities.centerWindow((Window)((UIModelDialog)window));
        BTPMakeBillUIWithoutGrp2 uiWindow = (BTPMakeBillUIWithoutGrp2)window.getUIObject();
        uiWindow.setBTPImplCaller(this);
        window.show();
    }

    private List getSelectEntryIDs(CoreBillBaseCollection srcBills, String entryName) {
        ArrayList<String> entryids = new ArrayList<String>();
        if (StringUtils.isEmpty((String)entryName)) {
            return entryids;
        }
        for (int i = 0; i < srcBills.size(); ++i) {
            CoreBillBaseInfo bills = srcBills.get(i);
            IObjectCollection entries = (IObjectCollection)bills.get(entryName);
            if (entries == null) {
                return entryids;
            }
            for (CoreBaseInfo cInfo : entries) {
                String ss = cInfo.getId().toString();
                entryids.add(ss);
            }
        }
        return entryids;
    }

    private String getBillMainEntryName(EntityObjectInfo entity) {
        PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo propInfo : props) {
            RelationshipInfo relation;
            if (!(propInfo instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)propInfo).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(propInfo.getExtendedProperty("isEntries"))) continue;
            EntityObjectInfo relateEntity = null;
            if (relation.getClientObject().getFullName().equals(entity.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getSupplierObject();
            } else if (relation.getSupplierObject().getFullName().equals(entity.getFullName()) && (relation.getClientCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getClientCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getClientObject();
            }
            if (relateEntity == null) continue;
            return propInfo.getName();
        }
        return "entries";
    }

    public void CreateTo(CoreBillBaseInfo bill, String destBillType) throws Exception {
        CoreBillBaseInfo destBillInfo;
        int i;
        CoreBillBaseCollection srcBillInfos = new CoreBillBaseCollection();
        srcBillInfos.add(bill);
        this.billEditUI.beforeTransform((IObjectCollection)srcBillInfos, destBillType);
        IBOTMapping iBOTMapping = BOTMappingFactory.getRemoteInstance();
        IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
        BOTMappingInfo botMappingInfo = null;
        BOTMappingCollection botMappingCol = iBOTMapping.getMappingCollectionForSelect(srcBillInfos, destBillType, DefineSysEnum.BTP);
        BTPTransformResult btpResult = null;
        try {
            if (botMappingCol.size() == 0) {
                throw new BOTPException(BOTPException.MAPPINGNUMZERO);
            }
            if (botMappingCol.size() > 1) {
                botMappingCol = this.billEditUI.getRulesForBotp(destBillType, "CreateTo", botMappingCol);
                HashMap<String, Object> uiContext = new HashMap<String, Object>();
                uiContext.put("isMultiDAPTrans", false);
                uiContext.put("Owner", this.billEditUI);
                uiContext.put("BOTMappings", (Object)botMappingCol);
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                String mappingSelectUI = this.getCreateToMappingRuleSelUI();
                IUIWindow window = uiFactory.create(mappingSelectUI, uiContext, null);
                window.show();
                if (((BOTMappingSelectUI)window.getUIObject()).isCanceled() || ((BOTMappingSelectUI)window.getUIObject()).getSelectBotMappingInfo() == null) {
                    return;
                }
                botMappingInfo = ((BOTMappingSelectUI)window.getUIObject()).getSelectBotMappingInfo();
            } else {
                botMappingInfo = botMappingCol.get(0);
            }
            SelectorItemCollection botSelectors = null;
            if (!this.reBuildControl(botMappingInfo, srcBillInfos, destBillType)) {
                return;
            }
            botSelectors = null;
            if (botMappingInfo.getIsTempSave() == 2) {
                botSelectors = BOTClientTools.getBillEditUISelector(destBillType);
            }
            int count = srcBillInfos.size();
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo entity = loader.getEntity(bill.getBOSType());
            String entrysName = this.getBillMainEntryName(entity);
            String[] srcBillIDs = new String[count];
            for (int i2 = 0; i2 < count; ++i2) {
                srcBillIDs[i2] = srcBillInfos.get(i2).getId().toString();
            }
            btpResult = iBTPManager.transformForBotp(srcBillIDs, new String[]{entrysName}, this.getSelectEntryIDs(srcBillInfos, entrysName), botSelectors, destBillType, (IObjectPK)new ObjectUuidPK(botMappingInfo.getId().toString()), bill.getBOSType().toString());
            if (botMappingInfo.getIsShowEditUI() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.btp.btpResource.transSuccess"));
                return;
            }
        }
        catch (Exception ex) {
            MsgBox.showWarning((String)(EASResource.getString((String)"com.kingdee.eas.base.btp.btpResource.transFailed") + "  " + ex.getMessage()));
            return;
        }
        IObjectCollection destBillColls = btpResult.getBills();
        BOTRelationCollection botRelationCols = btpResult.getBOTRelationCollection();
        CoreBillBaseInfo billInfo = (CoreBillBaseInfo)destBillColls.getObject(0);
        String destBillEditUIClassName = billInfo.getBOTPEditUI();
        String destBillListUIClassName = billInfo.getBOTPListUI();
        if (StringUtils.isEmpty((String)destBillEditUIClassName)) {
            destBillEditUIClassName = BOTPTools.getEntityObjectInfoExtendProClient(destBillType, "editUI");
        }
        if (StringUtils.isEmpty((String)destBillListUIClassName)) {
            destBillListUIClassName = BOTPTools.getEntityObjectInfoExtendProClient(destBillType, "listUI");
        }
        IUIWindow uiWindow = null;
        Vector<String> idVector = new Vector<String>();
        RealModeIDList idList = RealModeIDList.getEmptyIDList();
        CoreBillBaseCollection destBillCols = new CoreBillBaseCollection();
        int count = destBillColls.size();
        for (i = 0; i < count; ++i) {
            destBillInfo = (CoreBillBaseInfo)destBillColls.getObject(i);
            destBillCols.add(destBillInfo);
        }
        this.sortByRule(botMappingInfo, destBillCols);
        if (destBillCols.size() >= 1) {
            count = destBillCols.size();
            for (i = 0; i < count; ++i) {
                destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
                DefaultMultiBillWorkAgent agent = new DefaultMultiBillWorkAgent();
                agent.markBotpTransfer((IObjectValue)destBillInfo, destBillInfo.getId().toString());
                if (botMappingInfo.getIsTempSave() != 1 && (destBillCols.size() <= 1 || botMappingInfo.getIsTempSave() != 2)) continue;
                idVector.add(destBillInfo.getId().toString());
                idList.add(destBillInfo.getId().toString());
            }
            if (botMappingInfo.getIsShowEditUI() == 1) {
                UIContext map = new UIContext((Object)this);
                map.put("srcBillID", srcBillInfos.get(0).getId().toString());
                map.put("BOTPViewStatus", new Integer(1));
                if (idList.size() > 0) {
                    idList.setCurrentIndex(0);
                    map.put("ID", idList.getCurrentID());
                    map.put("IDList", idList);
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(destBillEditUIClassName, (Map)map, null, OprtState.EDIT);
                    this.setDestBillUIWindow(uiWindow);
                    uiWindow.show();
                    if (uiWindow instanceof JFrame) {
                        ((JFrame)uiWindow).setExtendedState(6);
                    }
                } else {
                    Context bosctx = new Context();
                    IObjectPK pk = null;
                    pk = FrameWorkUtils.getOrgPKByCoreBillBaseInfo((CoreBillBaseInfo)((CoreBillBaseInfo)destBillCols.getObject(0)));
                    if (pk != null) {
                        FrameWorkUtils.switchOrg((Context)bosctx, (String)pk.toString());
                    }
                    map.put("InitDataObject", (CoreBillBaseInfo)destBillCols.getObject(0));
                    map.put(FINDMODEL, "false");
                    if (destBillCols.getObject(0).get("id") != null) {
                        DataObjectMutex mutextControl = new DataObjectMutex();
                        try {
                            mutextControl.requestDataObjectLock(destBillCols.getObject(0).get("id").toString());
                        }
                        catch (Throwable e) {
                            logger.error((Object)"error occur when requestDataObjectLock!--------");
                        }
                    }
                    if ((uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(destBillEditUIClassName, (Map)map, null, OprtState.ADDNEW)).getUIObject().getDataObject() == null || uiWindow.getUIObject().getDataObject().get("id") == null || !uiWindow.getUIObject().getDataObject().get("id").toString().equals(destBillCols.getObject(0).get("id").toString())) {
                        uiWindow.getUIObject().setDataObject(destBillCols.getObject(0));
                        uiWindow.getUIObject().loadFields();
                    }
                    ((CoreBillEditUI)uiWindow.getUIObject()).setMakeRelations(botRelationCols);
                    uiWindow.getUIObject().getUIContext().put("BOTPUIParam", "botp");
                    this.setDestBillUIWindow(uiWindow);
                    uiWindow.show();
                    if (uiWindow instanceof JFrame) {
                        ((JFrame)uiWindow).setExtendedState(6);
                    }
                }
            } else if (botMappingInfo.getIsShowEditUI() == 2) {
                EntityViewInfo botpFilter = BTPUtil.initIdFilter(idVector);
                HashMap<String, Object> uiCtx = new HashMap<String, Object>();
                uiCtx.put("BOTPViewStatus", new Integer(1));
                uiCtx.put("BOTPFilter", botpFilter);
                uiCtx.put("OwnerWindow", this.billEditUI.getUIContext().get("OwnerWindow"));
                Map uiContext = (Map)this.billEditUI.getUIContext().get("BTPNAVCTX");
                uiCtx.put("BTPNAVCTX", uiContext);
                if (this.billEditUI.getUIContext().get("BTPNAVCTX") != null) {
                    Map btpNavCtx = (Map)this.billEditUI.getUIContext().get("BTPNAVCTX");
                    uiCtx.put("BTPNAVCTX", btpNavCtx);
                }
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(destBillListUIClassName, uiCtx, null, OprtState.EDIT);
                uiWindow.getUIObject().getUIContext().put("BOTPUIParam", "botp");
                this.setDestBillUIWindow(uiWindow);
                uiWindow.show();
                if (uiWindow instanceof JFrame) {
                    ((JFrame)uiWindow).setExtendedState(6);
                }
            }
        }
    }

    private boolean hasReBuild(CoreBillBaseCollection srcBillInfos, String destBillTypeBOSType) throws BOSException {
        ArrayList<String> idlist = new ArrayList<String>();
        for (int i = 0; i < srcBillInfos.size(); ++i) {
            idlist.add(srcBillInfos.get(0).getId().toString());
        }
        String billIds = StringUtils.arrayToString((Object[])idlist.toArray(), (String)",");
        IBOTRelation iBOTRelation = BOTRelationFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterBill = new FilterInfo();
        FilterInfo filterMapping = new FilterInfo();
        filterBill.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billIds, CompareType.INCLUDE));
        filterMapping.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destBillTypeBOSType, CompareType.EQUALS));
        filterBill.mergeFilter(filterMapping, "And");
        viewInfo.setFilter(filterBill);
        BOTRelationCollection relations = iBOTRelation.getCollection(viewInfo);
        return relations != null && relations.size() != 0;
    }

    private boolean reBuildControl(BOTMappingInfo botMappingInfo, CoreBillBaseCollection srcBillInfos, String destBillTypeBOSType) throws Exception {
        String reBuildControl = "";
        String extconfig = botMappingInfo.getExtConfig();
        BotpExtConfigHelper.ExtConfigInfo info = null;
        BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper().new BotpExtConfigHelper.XMLProcessor();
        if (extconfig != null && !extconfig.equals("")) {
            info = processor.marshallingExtConfig(extconfig);
            reBuildControl = info.getReBuildControl();
            if (reBuildControl == null || reBuildControl.equals("")) {
                reBuildControl = "1";
            }
        } else {
            reBuildControl = "1";
        }
        if (reBuildControl.equals("1")) {
            return true;
        }
        if (reBuildControl.equals("2")) {
            if (this.hasReBuild(srcBillInfos, destBillTypeBOSType)) {
                MsgBox.showWarning((Component)this.billEditUI, (String)EASResource.getString((String)RESNAME, (String)"notReBuild"));
                return false;
            }
        } else if (reBuildControl.equals("3")) {
            if (BOTClientTools.hasRebuildEntry(srcBillInfos, destBillTypeBOSType, botMappingInfo)) {
                MsgBox.showWarning((Component)this.billEditUI, (String)EASResource.getString((String)RESNAME, (String)"notReBuild"));
                return false;
            }
        } else if (this.hasReBuild(srcBillInfos, destBillTypeBOSType)) {
            MsgBox.showWarning((Component)this.billEditUI, (String)EASResource.getString((String)RESNAME, (String)"reBuildHint"));
        }
        return true;
    }

    private void sortByRule(BOTMappingInfo botMappingInfo, CoreBillBaseCollection billCols) throws Exception {
        block6: {
            CoreBillBaseInfo bill;
            int i;
            String extconfig = botMappingInfo.getExtConfig();
            BotpExtConfigHelper.ExtConfigInfo info = null;
            BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper().new BotpExtConfigHelper.XMLProcessor();
            if (extconfig == null || extconfig.equals("")) break block6;
            info = processor.marshallingExtConfig(extconfig);
            if (info.getOrderField() == null || info.getOrderField().equals("")) {
                return;
            }
            String orderField = info.getOrderField();
            String orderStyle = info.getOrderStyle();
            CoreBillBaseInfoComparator comparator = new CoreBillBaseInfoComparator(orderField);
            ArrayList<CoreBillBaseInfo> list = new ArrayList<CoreBillBaseInfo>();
            int size = billCols.size();
            for (i = 0; i < size; ++i) {
                bill = billCols.get(i);
                list.add(bill);
            }
            Collections.sort(list, comparator);
            billCols.clear();
            if (orderStyle.equals("asc")) {
                size = list.size();
                for (i = 0; i < size; ++i) {
                    bill = (CoreBillBaseInfo)list.get(i);
                    billCols.add(bill);
                }
            } else {
                for (i = list.size(); i > 0; --i) {
                    CoreBillBaseInfo bill2 = (CoreBillBaseInfo)list.get(i - 1);
                    billCols.add(bill2);
                }
            }
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public IUIWindow getDestBillUIWindow() {
        return this.destBillUIWindow;
    }

    public void setDestBillUIWindow(IUIWindow destBillUIWindow) {
        this.destBillUIWindow = destBillUIWindow;
    }

    public void getRelationDiagram(CoreBillBaseInfo bill) throws Exception {
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        uiContext.put("BTPNAVCTX", this.billEditUI.getUIContext());
        if (this.billEditUI.getUIContext().get("selectedEntries") != null) {
            uiContext.put("selectedEntries", this.billEditUI.getUIContext().get("selectedEntries"));
        }
        String billID = bill.getId().toString();
        uiContext.put("billInfoID", billID);
        IUIFactory uiFactory = this.createUIFactory(this.billEditUI);
        IUIWindow window = uiFactory.create("com.kingdee.eas.base.btp.client.BTPRelationDiagramUI", uiContext, null);
        if (window instanceof UIModelDialog) {
            Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension maxSize = new Dimension(820, 650);
            if ((double)screenDim.width > maxSize.getWidth() || (double)screenDim.height > maxSize.getHeight()) {
                screenDim = maxSize;
            }
            ((JPanel)((UIModelDialog)window).getContentPane()).setPreferredSize(screenDim);
        }
        window.show();
    }

    class CoreBillBaseInfoComparator
    implements Comparator {
        String orderField = null;

        public CoreBillBaseInfoComparator(String orderField) {
            this.orderField = orderField;
        }

        public int compare(Object arg0, Object arg1) {
            CoreBillBaseInfo info1 = (CoreBillBaseInfo)arg0;
            CoreBillBaseInfo info2 = (CoreBillBaseInfo)arg1;
            Object value1 = info1.get(this.orderField);
            Object value2 = info2.get(this.orderField);
            if (value1 == null || value2 == null) {
                return 0;
            }
            if (value1 instanceof BigDecimal) {
                return ((BigDecimal)value1).compareTo((BigDecimal)value2);
            }
            if (value1 instanceof Integer) {
                return ((Integer)value1).compareTo((Integer)value2);
            }
            if (value1 instanceof Date) {
                return ((Date)value1).compareTo((Date)value2);
            }
            return value1.toString().compareToIgnoreCase(value2.toString());
        }
    }
}

