/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.btp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.client.BOTClientTools;
import com.kingdee.eas.base.btp.client.BTPMakeBillFIUI;
import com.kingdee.eas.base.btp.client.BTPMakeBillUIWithoutGrp;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.IBatchOrgListBiz;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IBTPBillList;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BTPBillListImpl
implements IBTPBillList {
    private CoreBillListUI billListUI = null;
    private boolean isCancel = true;
    private IUIWindow destBillUIWindow = null;
    private String sourceEntryIdProName = null;

    public BTPBillListImpl(CoreBillListUI billListUI) {
        this.billListUI = billListUI;
    }

    public void init() throws Exception {
    }

    public void createTo(CoreBillBaseCollection bills) throws Exception {
        if (bills == null || bills.size() == 0) {
            MsgBox.showWarning((Component)this.billListUI, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneSelect_Bill"));
            return;
        }
        Map params = this.getParams(bills);
        String[] idList = (String[])params.get("idList");
        String[] entryNames = (String[])params.get("entryNames");
        List entriesKey = (List)params.get("entriesKey");
        String srcBillType = (String)params.get("srcBillType");
        SelectorItemCollection botpSelectors = (SelectorItemCollection)params.get("botpSelectors");
        this.createTo(idList, entryNames, entriesKey, srcBillType, botpSelectors);
    }

    private Map getParams(CoreBillBaseCollection bills) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String[] idList = new String[bills.size()];
        for (int i = 0; i < bills.size(); ++i) {
            idList[i] = bills.get(i).getId().toString();
        }
        String[] entryNames = new String[]{this.billListUI.getEntriesName()};
        List entriesKey = this.getSelectEntryIDs(bills);
        String srcBillType = bills.get(0).getBOSType().toString();
        Object botpSelectors = null;
        params.put("idList", idList);
        params.put("entryNames", entryNames);
        params.put("entriesKey", entriesKey);
        params.put("srcBillType", srcBillType);
        params.put("botpSelectors", botpSelectors);
        return params;
    }

    private List getSelectEntryIDs(CoreBillBaseCollection srcBills) {
        ArrayList<String> entryids = new ArrayList<String>();
        if (this.billListUI == null) {
            return entryids;
        }
        String entryName = this.billListUI.getEntriesName();
        for (int i = 0; i < srcBills.size(); ++i) {
            CoreBillBaseInfo bills = srcBills.get(i);
            IObjectCollection entries = (IObjectCollection)bills.get(entryName);
            if (entries == null) {
                return entryids;
            }
            for (CoreBaseInfo cInfo : entries) {
                String ss = cInfo.getId().toString();
                entryids.add(ss);
            }
        }
        return entryids;
    }

    public void createTo(String[] idList, String[] entryNames, List entriesKey, String srcBillType, SelectorItemCollection botpSelectors) throws Exception {
        this.createTo(idList, entryNames, entriesKey, srcBillType, botpSelectors, null);
    }

    public void createTo(String[] idList, String[] entryNames, List entriesKey, String srcBillType, SelectorItemCollection botpSelectors, boolean multiOrgBillType) throws Exception {
        this.createTo(idList, entryNames, entriesKey, srcBillType, botpSelectors, null);
    }

    public void createTo(String[] idList, String[] entryNames, List entriesKey, String srcBillType, SelectorItemCollection botpSelectors, CtrlUnitInfo cu) throws Exception {
        CoreUI uiWindow;
        HashMap<String, Object> uiContext;
        if (idList == null || idList.length == 0) {
            MsgBox.showWarning((Component)this.billListUI, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneSelect_Bill"));
            return;
        }
        String mainOrgName = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entityObjectInfo = loader.getEntity(BOSObjectType.create((String)BOSUuid.read((String)idList[0]).getType().toString()));
        try {
            if (this.billListUI instanceof IBatchOrgListBiz) {
                mainOrgName = ((IBatchOrgListBiz)this.billListUI).getMainBizOrgPropertyName();
                mainOrgName = entityObjectInfo.getFieldByFullName(mainOrgName).getMappingField().getName();
            } else {
                mainOrgName = this.getOrgFiledByEntity(entityObjectInfo);
                if (!StringUtils.isEmpty((String)mainOrgName)) {
                    mainOrgName = entityObjectInfo.getFieldByFullName(mainOrgName).getMappingField().getName();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String fid = entityObjectInfo.getFieldByFullName("id").getMappingField().getName();
        DataTableInfo table = entityObjectInfo.getTable();
        String tableName = table.getName();
        List<String> billIDs = new ArrayList<String>();
        HashMap orgBillIDs = new HashMap();
        ArrayList<String> orgIDs = new ArrayList<String>();
        ArrayList<String> orgIDsTmp = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)mainOrgName)) {
            for (String id : idList) {
                String sql = "select distinct " + mainOrgName + " from " + tableName + " where " + fid + " in('" + id + "')";
                SQLExecutor executor = new SQLExecutor(sql);
                IRowSet rowSet = executor.executeSQL();
                while (rowSet.next()) {
                    String orgId = rowSet.getString(mainOrgName);
                    orgIDsTmp.add(orgId);
                    if (billIDs.size() == 0) {
                        billIDs.add(id);
                        orgBillIDs.put(orgId, billIDs);
                        continue;
                    }
                    if (!orgBillIDs.containsKey(orgId)) {
                        ArrayList<String> billIDs2 = new ArrayList<String>();
                        billIDs2.add(id);
                        orgBillIDs.put(orgId, billIDs2);
                        continue;
                    }
                    if (((List)orgBillIDs.get(orgId)).indexOf(id) >= 0) continue;
                    billIDs = (List)orgBillIDs.get(orgId);
                    billIDs.add(id);
                    orgBillIDs.put(orgId, billIDs);
                }
            }
            for (String orgId : orgIDsTmp) {
                if (orgIDs.contains(orgId)) continue;
                orgIDs.add(orgId);
            }
        }
        if (this.billListUI instanceof IBatchOrgListBiz) {
            if (orgIDs.size() == 1) {
                cu = BOTClientTools.getCUByOrgId((String)orgIDs.get(0));
                uiContext = new HashMap();
                uiContext.put("Owner", this.billListUI);
                uiContext.put("idList", idList);
                uiContext.put("entryNames", entryNames);
                uiContext.put("entriesKey", entriesKey);
                uiContext.put("srcBillType", srcBillType);
                uiContext.put("botpSelectors", botpSelectors);
                uiContext.put("SRCBILLLIST", this.billListUI);
                uiContext.put("ctrlUnit", cu);
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                IUIWindow window = uiFactory.create("com.kingdee.eas.base.btp.client.BTPMakeBillUIWithoutGrp", uiContext, null);
                CtrlSwingUtilities.centerWindow((Window)((UIModelDialog)window));
                uiWindow = (BTPMakeBillUIWithoutGrp)window.getUIObject();
                uiWindow.setBTPImplCaller(this);
                window.show();
                Logger.info((String)"createTo finished!");
            } else {
                if (orgIDs == null || orgIDs.size() <= 0) {
                    throw new BOSException("The list of control unit can not be empty!  param:");
                }
                if (orgIDs.size() > 1) {
                    throw new BOSException((Throwable)((Object)new BOTPException(BOTPException.NOTSUPPORTMULTIORG)));
                }
                cu = null;
                srcBillType = BOSUuid.read((String)idList[0]).getType().toString();
                uiContext = new HashMap();
                uiContext.put("Owner", this.billListUI);
                uiContext.put("idList", idList);
                uiContext.put("entryNames", entryNames);
                uiContext.put("entriesKey", entriesKey);
                uiContext.put("srcBillType", srcBillType);
                uiContext.put("botpSelectors", botpSelectors);
                uiContext.put("SRCBILLLIST", this.billListUI);
                uiContext.put("ctrlUnit", cu);
                uiContext.put("ctrlUnitList", orgIDs);
                uiContext.put("cuBillsRelation", orgBillIDs);
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                IUIWindow window = uiFactory.create("com.kingdee.eas.base.btp.client.BTPMakeBillFIUI", uiContext, null);
                CtrlSwingUtilities.centerWindow((Window)((UIModelDialog)window));
                uiWindow = (BTPMakeBillFIUI)window.getUIObject();
                uiWindow.setBTPImplCaller(this);
                window.show();
                Logger.info((String)"createTo finished!");
            }
        } else {
            if (orgIDs.size() > 0) {
                cu = BOTClientTools.getCUByOrgId((String)orgIDs.get(0));
            }
            if (idList == null || idList.length == 0) {
                MsgBox.showWarning((Component)this.billListUI, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneSelect_Bill"));
                return;
            }
            uiContext = new HashMap<String, Object>();
            uiContext.put("Owner", this.billListUI);
            uiContext.put("idList", idList);
            uiContext.put("entryNames", entryNames);
            uiContext.put("entriesKey", entriesKey);
            uiContext.put("srcBillType", srcBillType);
            uiContext.put("botpSelectors", botpSelectors);
            uiContext.put("SRCBILLLIST", this.billListUI);
            uiContext.put("ctrlUnit", cu);
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow window = uiFactory.create("com.kingdee.eas.base.btp.client.BTPMakeBillUIWithoutGrp", uiContext, null);
            CtrlSwingUtilities.centerWindow((Window)((UIModelDialog)window));
            uiWindow = (BTPMakeBillUIWithoutGrp)window.getUIObject();
            uiWindow.setBTPImplCaller(this);
            window.show();
            Logger.info((String)"createTo finished!");
        }
    }

    private String getOrgFiledByEntity(EntityObjectInfo entity) {
        String bizOrgPropertyName;
        String infoClassName = entity.getObjectValueClassRuntime();
        try {
            Class<?> clz = Class.forName(infoClassName);
            Object obj = clz.newInstance();
            Method method = clz.getMethod("getBizOrgPropertyName", null);
            bizOrgPropertyName = (String)method.invoke(obj, null);
            if (bizOrgPropertyName == null || bizOrgPropertyName.length() == 0) {
                bizOrgPropertyName = entity.getExtendedProperty("MainOrgFieldName");
            }
        }
        catch (Exception e) {
            try {
                bizOrgPropertyName = entity.getExtendedProperty("MainOrgFieldName");
            }
            catch (Exception e1) {
                bizOrgPropertyName = "CU";
            }
        }
        return bizOrgPropertyName;
    }

    public void traceUp(CoreBillBaseCollection bills, String entryIDName) throws Exception {
        this.traceUp(bills, entryIDName, null);
    }

    public void traceUp(CoreBillBaseCollection bills, String entryIDName, Map ctx) throws Exception {
        if (bills == null || bills.size() == 0) {
            MsgBox.showWarning((Component)this.billListUI, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneSelect_Bill"));
            return;
        }
        if (ctx.get("sourceEntryIdProName") != null) {
            this.sourceEntryIdProName = ctx.get("sourceEntryIdProName").toString();
        }
        CoreBillBaseInfo bill = bills.get(0);
        String billID = bill.getId().toString();
        String entryName = StringUtils.split((String)entryIDName, (String)".")[0];
        ctx.put("entryName", entryName);
        IObjectCollection entryCol = (IObjectCollection)bill.get(entryName);
        ArrayList<String> entryIDs = new ArrayList<String>();
        if (entryCol != null) {
            for (int i = 0; i < entryCol.size(); ++i) {
                String entryId = ((CoreBillEntryBaseInfo)entryCol.getObject(i)).getId().toString();
                entryIDs.add(entryId);
            }
        }
        this.traceUp(billID, entryIDs, ctx);
    }

    public void traceUp(String billID, List entryIDs, Map ctx) throws Exception {
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        if (ctx != null) {
            uiContext.put("BTPNAVCTX", ctx);
        }
        if (billID == null) {
            MsgBox.showWarning((Component)this.billListUI, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneSelect_Bill"));
            return;
        }
        uiContext.put("billInfoID", billID);
        uiContext.put("findType", new Integer(0));
        uiContext.put("selectedEntries", entryIDs);
        uiContext.put("sourceEntryIdProName", this.sourceEntryIdProName);
        uiContext.put("findBillType", "up");
        IUIFactory uiFactory = this.createUIFactory(this.billListUI);
        IUIWindow window = uiFactory.create("com.kingdee.eas.base.btp.client.BTPRelationNavUI", uiContext, null);
        window.show();
    }

    private IUIFactory createUIFactory(CoreBillListUI billListUI) throws Exception {
        IUIWindow window = billListUI.getUIWindow();
        if (window != null && window instanceof UIModelDialog) {
            return UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        }
        return UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
    }

    public void traceDown(CoreBillBaseCollection bills, String entryIDName) throws Exception {
        this.traceDown(bills, entryIDName, null);
    }

    public void traceDown(CoreBillBaseCollection bills, String entryIDName, Map ctx) throws Exception {
        if (bills == null || bills.size() == 0) {
            MsgBox.showWarning((Component)this.billListUI, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneSelect_Bill"));
            return;
        }
        CoreBillBaseInfo bill = bills.get(0);
        String billID = bill.getId().toString();
        String entryName = StringUtils.split((String)entryIDName, (String)".")[0];
        ctx.put("entryName", entryName);
        IObjectCollection entryCol = (IObjectCollection)bill.get(entryName);
        ArrayList<String> entryIDs = new ArrayList<String>();
        if (entryCol != null) {
            for (int i = 0; i < entryCol.size(); ++i) {
                String entryId = ((CoreBillEntryBaseInfo)entryCol.getObject(i)).getId().toString();
                entryIDs.add(entryId);
            }
        }
        this.traceDown(billID, entryIDs, ctx);
    }

    public void traceDown(String billID, List entryIDs, Map ctx) throws Exception {
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        if (ctx != null) {
            uiContext.put("BTPNAVCTX", ctx);
        }
        if (billID == null) {
            MsgBox.showWarning((Component)this.billListUI, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneSelect_Bill"));
            return;
        }
        uiContext.put("billInfoID", billID);
        uiContext.put("findType", new Integer(1));
        uiContext.put("selectedEntries", entryIDs);
        uiContext.put("findBillType", "down");
        IUIFactory uiFactory = this.createUIFactory(this.billListUI);
        IUIWindow window = uiFactory.create("com.kingdee.eas.base.btp.client.BTPRelationNavUI", uiContext, null);
        window.show();
    }

    public void traceUp(CoreBillBaseCollection bills) throws Exception {
    }

    public void traceDown(CoreBillBaseCollection bills) throws Exception {
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public IUIWindow getDestBillUIWindow() {
        return this.destBillUIWindow;
    }

    public void setDestBillUIWindow(IUIWindow destBillUIWindow) {
        this.destBillUIWindow = destBillUIWindow;
    }

    public void getRelationDiagram(CoreBillBaseCollection bills, String entryIDName, Map ctx) throws Exception {
        if (bills == null || bills.size() == 0) {
            MsgBox.showWarning((Component)this.billListUI, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneSelect_Bill"));
            return;
        }
        if (bills.size() > 1) {
            MsgBox.showWarning((Component)this.billListUI, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelectOne"));
            return;
        }
        CoreBillBaseInfo bill = bills.get(0);
        String billID = bill.getId().toString();
        String entryName = StringUtils.split((String)entryIDName, (String)".")[0];
        ctx.put("entryName", entryName);
        IObjectCollection entryCol = (IObjectCollection)bill.get(entryName);
        ArrayList<String> entryIDs = new ArrayList<String>();
        if (entryCol != null) {
            for (int i = 0; i < entryCol.size(); ++i) {
                String entryId = ((CoreBillEntryBaseInfo)entryCol.getObject(i)).getId().toString();
                entryIDs.add(entryId);
            }
        }
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        if (ctx != null) {
            uiContext.put("BTPNAVCTX", ctx);
        }
        if (billID == null) {
            MsgBox.showWarning((Component)this.billListUI, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneSelect_Bill"));
            return;
        }
        uiContext.put("billInfoID", billID);
        uiContext.put("selectedEntries", entryIDs);
        IUIFactory uiFactory = this.createUIFactory(this.billListUI);
        IUIWindow window = uiFactory.create("com.kingdee.eas.base.btp.client.BTPRelationDiagramUI", uiContext, null);
        window.show();
    }
}

