/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.eas.base.codingrule.CodingRuleMultiOrgCollection;
import com.kingdee.eas.base.codingrule.CodingRuleMultiOrgFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Locale;

public class CodingRuleClientUtils {
    public static final String strResource = "com.kingdee.eas.base.codingrule.CodingRuleResource.";
    public static final String template_orgId = "00000000-0000-0000-0000-00000000000000000000";
    public static final String codingrule_ex = "isBindingProperty";
    public static final String seqSegmentEnabled = "seqSegmentEnabled";

    private CodingRuleClientUtils() {
    }

    public static String getDefaultF7(String propertyName, String boType, IMetaDataLoader metaLoader, EntityObjectInfo eo) {
        try {
            if (propertyName == null || propertyName.trim().length() == 0 || boType == null || boType.trim().length() == 0) {
                return "";
            }
            String strF7 = "";
            if (metaLoader == null) {
                metaLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            }
            EntityObjectInfo meta = null;
            meta = eo != null ? eo : metaLoader.getEntity((IMetaDataPK)new MetaDataPK(boType));
            String[] properties = propertyName.split("\\.");
            if (properties.length == 2) {
                PropertyCollection pc = meta.getInheritedPropertiesRuntime();
                for (int i = 0; i < pc.size(); ++i) {
                    PropertyInfo childproperty = pc.get(i);
                    if (!properties[0].equalsIgnoreCase(childproperty.getName())) continue;
                    LinkPropertyInfo lp = (LinkPropertyInfo)childproperty;
                    EntityObjectInfo propertyMeta = null;
                    propertyMeta = lp.getRelationship().getSupplierObject().getType().toString().equalsIgnoreCase(boType) ? lp.getRelationship().getClientObject() : lp.getRelationship().getSupplierObject();
                    strF7 = propertyMeta.getExtendedProperty("defaultF7Query");
                }
            } else {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_Property_invalid"));
            }
            return strF7;
        }
        catch (MetaDataNotFoundException err) {
            return "NoMeataData";
        }
    }

    public static String getLinkObjectBizPK(String propertyName, String boType, IMetaDataLoader metaLoader, EntityObjectInfo eo) {
        try {
            if (propertyName == null || propertyName.trim().length() == 0 || boType == null || boType.trim().length() == 0) {
                return "";
            }
            String bizPK = "";
            if (metaLoader == null) {
                metaLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            }
            EntityObjectInfo meta = null;
            meta = eo != null ? eo : metaLoader.getEntity((IMetaDataPK)new MetaDataPK(boType));
            String[] properties = propertyName.split("\\.");
            if (properties.length == 1) {
                bizPK = boType;
            } else if (properties.length == 2) {
                PropertyCollection pc = meta.getInheritedPropertiesRuntime();
                for (int i = 0; i < pc.size(); ++i) {
                    PropertyInfo childproperty = pc.get(i);
                    if (!properties[0].equalsIgnoreCase(childproperty.getName())) continue;
                    LinkPropertyInfo lp = (LinkPropertyInfo)childproperty;
                    EntityObjectInfo propertyMeta = null;
                    propertyMeta = lp.getRelationship().getSupplierObject().getType().toString().equalsIgnoreCase(boType) ? lp.getRelationship().getClientObject() : lp.getRelationship().getSupplierObject();
                    bizPK = propertyMeta.getPackage() + "." + propertyMeta.getName();
                }
            } else {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_Property_invalid"));
            }
            return bizPK;
        }
        catch (MetaDataNotFoundException err) {
            return "NoMeataData";
        }
    }

    public static String getPropertyAlias(String propertyName, String boType, IMetaDataLoader metaLoader, EntityObjectInfo eo) {
        try {
            if (propertyName == null || propertyName.trim().length() == 0 || boType == null || boType.trim().length() == 0) {
                return "";
            }
            String propertyAlias = propertyName;
            Locale mylocale = SysContext.getSysContext().getOriginLocale();
            if (metaLoader == null) {
                metaLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            }
            EntityObjectInfo meta = null;
            meta = eo != null ? eo : metaLoader.getEntity((IMetaDataPK)new MetaDataPK(boType));
            String[] properties = propertyName.split("\\.");
            if (properties.length == 1) {
                PropertyCollection pc = meta.getInheritedPropertiesRuntime();
                for (int i = 0; i < pc.size(); ++i) {
                    PropertyInfo childproperty = pc.get(i);
                    if (!properties[0].equalsIgnoreCase(childproperty.getName())) continue;
                    propertyAlias = childproperty.getAlias(mylocale);
                    if (propertyAlias != null) {
                        return propertyAlias;
                    }
                    return properties[0];
                }
            } else if (properties.length >= 2) {
                PropertyCollection pc = meta.getInheritedPropertiesRuntime();
                for (int i = 0; i < pc.size(); ++i) {
                    PropertyInfo childproperty = pc.get(i);
                    if (!properties[0].equalsIgnoreCase(childproperty.getName())) continue;
                    propertyAlias = childproperty.getAlias(mylocale);
                    propertyAlias = CodingRuleClientUtils.createPropertyAlias(properties, childproperty, boType, propertyAlias, mylocale);
                    return propertyAlias;
                }
            } else {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_Property_invalid"));
            }
            return propertyAlias;
        }
        catch (MetaDataNotFoundException err) {
            return "NoMeataData";
        }
    }

    private static String createPropertyAlias(String[] properties, PropertyInfo childproperty, String boType, String propertyAlias, Locale mylocale) {
        for (int k = 1; k <= properties.length - 1; ++k) {
            LinkPropertyInfo lp = (LinkPropertyInfo)childproperty;
            EntityObjectInfo propertyMeta = null;
            propertyMeta = lp.getRelationship().getSupplierObject().getType().toString().equalsIgnoreCase(boType) ? lp.getRelationship().getClientObject() : lp.getRelationship().getSupplierObject();
            PropertyCollection childpc = propertyMeta.getInheritedPropertiesRuntime();
            for (int j = 0; j < childpc.size(); ++j) {
                PropertyInfo grandproperty = childpc.get(j);
                if (!grandproperty.getName().equalsIgnoreCase(properties[k])) continue;
                childproperty = grandproperty;
                propertyAlias = grandproperty.getAlias(mylocale) == null || grandproperty.getAlias(mylocale).trim().length() < 1 ? propertyAlias + "." + properties[k] : propertyAlias + "." + grandproperty.getAlias(mylocale);
            }
        }
        return propertyAlias;
    }

    public static String getPropertyAlias(String propertyName, String boType, IMetaDataLoader metaLoader, EntityObjectInfo eo, boolean isWhole) {
        try {
            String[] properties = propertyName.split("\\.");
            if (propertyName == null || propertyName.trim().length() == 0 || boType == null || boType.trim().length() == 0) {
                return "";
            }
            String propertyAlias = propertyName;
            Locale mylocale = SysContext.getSysContext().getOriginLocale();
            if (metaLoader == null) {
                metaLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            }
            EntityObjectInfo meta = null;
            if (properties[0].equals("Period")) {
                meta = metaLoader.getEntity((IMetaDataPK)new MetaDataPK("com.kingdee.eas.basedata.assistant.app.Period"));
            } else if (properties[0].equals("User")) {
                meta = metaLoader.getEntity((IMetaDataPK)new MetaDataPK("com.kingdee.eas.base.permission.app.User"));
            } else if (properties[0].equals("City")) {
                meta = metaLoader.getEntity((IMetaDataPK)new MetaDataPK("com.kingdee.eas.basedata.assistant.app.City"));
            }
            if ((properties.length == 2 || properties[0].equals("Period") && properties.length == 3) && null != meta) {
                PropertyCollection pc = meta.getInheritedPropertiesRuntime();
                for (int i = 0; i < pc.size(); ++i) {
                    PropertyInfo childproperty = pc.get(i);
                    if (!properties[1].equalsIgnoreCase(childproperty.getName())) continue;
                    propertyAlias = childproperty.getAlias(mylocale);
                    if (propertyAlias == null || propertyAlias.length() < 1) {
                        propertyName = properties[1];
                    }
                    propertyAlias = meta.getAlias(mylocale) + "." + propertyAlias;
                }
            }
            if (properties[0].equals("Period") && properties.length == 3) {
                propertyAlias = propertyAlias + "." + SystemEnum.getEnum((String)properties[2]).getAlias();
            }
            return propertyAlias;
        }
        catch (MetaDataNotFoundException err) {
            return "NoMeataData";
        }
    }

    public static String getBOAlias(String boTypeFullname, IMetaDataLoader metaLoader, EntityObjectInfo eo) {
        if (boTypeFullname == null || boTypeFullname.trim().length() == 0) {
            return "";
        }
        String boAlias = "";
        Locale mylocale = SysContext.getSysContext().getOriginLocale();
        if (metaLoader == null) {
            metaLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        }
        EntityObjectInfo meta = null;
        if (eo != null) {
            meta = eo;
        } else {
            try {
                meta = metaLoader.getEntity((IMetaDataPK)new MetaDataPK(boTypeFullname));
            }
            catch (MetaDataNotFoundException err) {
                return "NoMeataData";
            }
        }
        boAlias = meta.getAlias(mylocale);
        return boAlias;
    }

    public static IRowSet getPropertyValues(String bosType, String propertyName) {
        MetaDataPK pk1 = new MetaDataPK(bosType);
        IDataProvider q = EntityExecutorFactory.getRemoteInstance((IMetaDataPK)pk1);
        try {
            EntityViewInfo eviTemp = new EntityViewInfo("select " + propertyName);
            SorterItemInfo sortItem = new SorterItemInfo();
            sortItem.setPropertyName(propertyName);
            eviTemp.getSorter().add(sortItem);
            q.setObjectView(eviTemp);
            q.option().isAutoIgnoreDuplicatedRow = true;
            IRowSet rs = q.executeQuery();
            return rs;
        }
        catch (Exception err) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_GetPropertyValues"));
            return null;
        }
    }

    public static String getMaxSerialNumber(KDTable table) {
        int max = 1;
        if (!table.getStyleAttributes().isLocked()) {
            if (table.getRowCount() > 1) {
                for (int i = 0; i < table.getRowCount(); ++i) {
                    IRow row = table.getRow(i);
                    Object obj = row.getCell("serialNumber").getValue();
                    if (obj == null || max >= Integer.parseInt(obj.toString())) continue;
                    max = Integer.parseInt(obj.toString());
                }
            } else {
                return "1";
            }
        }
        return max + 1 + "";
    }

    public static BizEnumValueCollection getEnumValues(IMetaDataLoader metaLoader, String boType, String propertyName) {
        EntityObjectInfo meta;
        PropertyInfo childproperty;
        String[] properties = propertyName.split("\\.");
        BizEnumValueCollection enumValuess = new BizEnumValueCollection();
        if (properties.length == 1 && (childproperty = (meta = metaLoader.getEntity((IMetaDataPK)new MetaDataPK(boType))).getPropertyByNameRuntime(propertyName)) instanceof OwnPropertyInfo) {
            OwnPropertyInfo op = (OwnPropertyInfo)childproperty;
            if (op.getDataType().equals((Object)DataType.ENUM)) {
                BizEnumInfo bizEnumInfo = metaLoader.getEnum((IMetaDataPK)new MetaDataPK(op.getMetaDataRef()));
                enumValuess = bizEnumInfo.getEnumValue();
            } else if (op.getDataType().equals((Object)DataType.BOOLEAN)) {
                BizEnumValueInfo item = new BizEnumValueInfo();
                Locale locale = SysContext.getSysContext().getOriginLocale();
                item.setName("TRUE");
                item.put("alias", (Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"55_CodingRuleClientUtils"), locale);
                item.setValue((Object)"1");
                enumValuess.add(item);
                item = new BizEnumValueInfo();
                item.setName("FALSE");
                item.put("alias", (Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"56_CodingRuleClientUtils"), locale);
                item.setValue((Object)"0");
                enumValuess.add(item);
            }
        }
        return enumValuess;
    }

    public static FullOrgUnitInfo getDefaultFullOrgUnitInfo(String strOrgType) {
        FullOrgUnitInfo fullOrg = null;
        String orgType = strOrgType;
        if (orgType == null) {
            orgType = OrgType.ControlUnit.getName();
        }
        AdminOrgUnitInfo obj = null;
        if (orgType.equalsIgnoreCase(OrgType.Admin.getName())) {
            obj = SysContext.getSysContext().getCurrentAdminUnit();
            if (obj != null) {
                fullOrg = obj.castToFullOrgUnitInfo();
            }
        } else if (orgType.equalsIgnoreCase(OrgType.Company.getName())) {
            obj = SysContext.getSysContext().getCurrentFIUnit();
            if (obj != null) {
                fullOrg = ((CompanyOrgUnitInfo)obj).castToFullOrgUnitInfo();
            }
        } else if (orgType.equalsIgnoreCase(OrgType.Sale.getName())) {
            obj = SysContext.getSysContext().getCurrentSaleUnit();
            if (obj != null) {
                fullOrg = ((SaleOrgUnitInfo)obj).castToFullOrgUnitInfo();
            }
        } else if (orgType.equalsIgnoreCase(OrgType.Purchase.getName())) {
            obj = SysContext.getSysContext().getCurrentPurchaseUnit();
            if (obj != null) {
                fullOrg = ((PurchaseOrgUnitInfo)obj).castToFullOrgUnitInfo();
            }
        } else if (orgType.equalsIgnoreCase(OrgType.Storage.getName())) {
            obj = SysContext.getSysContext().getCurrentStorageUnit();
            if (obj != null) {
                fullOrg = ((StorageOrgUnitInfo)obj).castToFullOrgUnitInfo();
            }
        } else if (orgType.equalsIgnoreCase(OrgType.CostCenter.getName())) {
            obj = SysContext.getSysContext().getCurrentCostUnit();
            if (obj != null) {
                fullOrg = ((CostCenterOrgUnitInfo)obj).castToFullOrgUnitInfo();
            }
        } else if (orgType.equalsIgnoreCase(OrgType.ProfitCenter.getName())) {
            obj = SysContext.getSysContext().getCurrentProfitUnit();
            if (obj != null) {
                fullOrg = ((ProfitCenterOrgUnitInfo)obj).castToFullOrgUnitInfo();
            }
        } else if (orgType.equalsIgnoreCase(OrgType.ControlUnit.getName())) {
            obj = SysContext.getSysContext().getCurrentCtrlUnit();
            if (obj != null) {
                fullOrg = ((CtrlUnitInfo)obj).castToFullOrgUnitInfo();
            }
        } else if (orgType.equalsIgnoreCase(OrgType.HRO.getName())) {
            obj = SysContext.getSysContext().getCurrentHRUnit();
            if (obj != null) {
                fullOrg = ((HROrgUnitInfo)obj).castToFullOrgUnitInfo();
            }
        } else if (orgType.equalsIgnoreCase(OrgType.NONE.getName())) {
            obj = SysContext.getSysContext().getCurrentCtrlUnit();
            if (obj != null) {
                fullOrg = ((CtrlUnitInfo)obj).castToFullOrgUnitInfo();
            }
        } else {
            obj = SysContext.getSysContext().getCurrentCtrlUnit();
            if (obj != null) {
                fullOrg = ((CtrlUnitInfo)obj).castToFullOrgUnitInfo();
            }
        }
        return fullOrg;
    }

    public static CodingRuleMultiOrgCollection getMultiOrgCRs(String strOrgs) throws BOSException {
        EntityViewInfo tmpevi = new EntityViewInfo();
        tmpevi.getSelector().add("codingrule.*");
        tmpevi.getSelector().add("appOrgUnit.*");
        tmpevi.getSelector().add("codingrule.bindingProperty.*");
        FilterInfo tmpfilter = new FilterInfo();
        tmpfilter.getFilterItems().add(new FilterItemInfo("appOrgUnit", (Object)strOrgs, CompareType.INCLUDE));
        tmpfilter.getFilterItems().add(new FilterItemInfo("isMainOrg", (Object)true, CompareType.NOTEQUALS));
        tmpevi.setFilter(tmpfilter);
        CodingRuleMultiOrgCollection orgCol = CodingRuleMultiOrgFactory.getRemoteInstance().getCodingRuleMultiOrgCollection(tmpevi);
        return orgCol;
    }
}

