/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleFactory;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRule;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.client.AbstractCodingRuleListUI;
import com.kingdee.eas.base.codingrule.client.CodingRuleClientUtils;
import com.kingdee.eas.base.codingrule.client.CodingRuleListUI_Template;
import com.kingdee.eas.base.forewarn.client.TestForewarnUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreeSelectionModel;
import org.apache.log4j.Logger;

public class CodingRuleListUI
extends AbstractCodingRuleListUI {
    private ICodingRuleManager iCRM = null;
    private IMetaDataLoader metaLoader = null;
    private Logger logger = Logger.getLogger(CodingRuleListUI.class);
    private boolean isTemplate;
    private ICompanyOrgUnit iOrg = null;
    private HashMap hm = new HashMap();
    private HashMap aliasHM = new HashMap();
    private boolean isOnload;
    private static WeakHashMap whm;
    private int curIndex = -1;

    @Override
    public boolean isPrepareActionAddNew() {
        return false;
    }

    @Override
    public boolean isPrepareActionDelete() {
        return true;
    }

    @Override
    public boolean isPrepareActionRefresh() {
        return true;
    }

    @Override
    public boolean isPrepareActionSee() {
        return false;
    }

    @Override
    public boolean isPrepareActionUpdate() {
        return false;
    }

    @Override
    public RequestContext prepareActionAddNew(IItemAction itemAction) throws Exception {
        return super.prepareActionAddNew(itemAction);
    }

    @Override
    public RequestContext prepareActionDelete(IItemAction itemAction) throws Exception {
        return super.prepareActionDelete(itemAction);
    }

    @Override
    public RequestContext prepareActionRefresh(IItemAction itemAction) throws Exception {
        return super.prepareActionRefresh(itemAction);
    }

    @Override
    public RequestContext prepareActionSee(IItemAction itemAction) throws Exception {
        return super.prepareActionSee(itemAction);
    }

    @Override
    public RequestContext prepareActionUpdate(IItemAction itemAction) throws Exception {
        return super.prepareActionUpdate(itemAction);
    }

    public void setIsTemplate(boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    public void setIsOnload(boolean isOnload) {
        this.isOnload = isOnload;
    }

    public boolean isIsTemplate() {
        return this.isTemplate;
    }

    public boolean isIsOnload() {
        return this.isOnload;
    }

    public CodingRuleListUI() throws Exception {
        this.initIcon();
    }

    private void initIcon() {
        this.menuItemSee.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemUpdate.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.menuItemDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.menuItemAdNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.menuItemExitCurrent.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void initUIMenuBarLayout() {
        this.menuBar.add((JMenu)this.menuFile);
        this.menuBar.add((JMenu)this.menuEdit);
        this.menuBar.add((JMenu)this.menuView);
        this.menuBar.add((JMenu)this.menuTool);
        this.menuBar.add((JMenu)this.menuHelp);
        this.menuFile.add((JMenuItem)this.menuItemPageSetup);
        this.menuFile.add((JMenuItem)this.menuItemAdNew);
        this.menuFile.add((Component)this.kDSeparator1);
        this.menuFile.add((JMenuItem)this.menuItemExitCurrent);
        this.menuTool.add((JMenuItem)this.menuItemSendMessage);
        this.menuEdit.add((JMenuItem)this.menuItemUpdate);
        this.menuEdit.add((JMenuItem)this.menuItemDelete);
        this.menuView.add((JMenuItem)this.menuItemSee);
        this.menuView.add((Component)this.kDSeparator3);
        this.menuView.add((JMenuItem)this.menuItemRefresh);
        this.menuHelp.add((JMenuItem)this.menuItemHelp);
        this.menuHelp.add((Component)this.kDSeparator12);
        this.menuHelp.add((JMenuItem)this.menuItemAbout);
    }

    private void refreshQueryData() throws Exception {
        EntityViewInfo evi;
        this.setIsOnload(false);
        this.codingRuleListQuery = evi = new EntityViewInfo();
        this.filterData();
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = this.prepareQueryContext(null);
            request.put("isTemplate", (Object)new Boolean(this.isTemplate));
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        super.enableExportExcel(this.tblList);
        this.setIsOnload(true);
        if (this.getUIContext().get("UIClassParam") != null && ("template".equalsIgnoreCase(this.getUIContext().get("UIClassParam").toString()) || this instanceof CodingRuleListUI_Template)) {
            this.setIsTemplate(true);
        } else {
            this.setIsTemplate(false);
        }
        this.tblList.checkParsed();
        this.initWorkButton();
        this.initTitle();
        this.logger.debug((Object)"loger:   onLoad event ...");
        this.initTree();
        this.tblList.getSelectManager().setSelectMode(2);
        this.tblList.getStyleAttributes().setLocked(true);
        this.lcOrg.setVisible(false);
        this.registScriptExportWindows();
    }

    private void initTitle() {
        if (this.isTemplate) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_ListUITitle_Template"));
        } else {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_ListUITitle_Define"));
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.wbtAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.wbtDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.wbtUpdate.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.wbtRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.wbtSee.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void tblList_tableClicked(KDTMouseEvent e) {
        if (e.getClickCount() == 2) {
            try {
                if (this.tblList.getSelectManager().getActiveRowIndex() == -1) {
                    return;
                }
                this.showDetailWindows("readonly");
            }
            catch (Exception err) {
                ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_ListToEdit"), (Throwable)err);
            }
        }
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        try {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeEntity.getLastSelectedPathComponent();
            if (node == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectObject"));
                return;
            }
            if (!node.isLeaf()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectObjectRight"));
                return;
            }
            MetaDataBriefInfo uo = (MetaDataBriefInfo)node.getUserObject();
            this.logger.debug((Object)(uo.getAlias() + " , " + uo.getName()));
            if (uo.isPackage()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectObjectRight"));
                return;
            }
            EntityObjectInfo eo = (EntityObjectInfo)uo.getMetaData(this.createIMetaDataLoader());
            if (eo.getExtendedProperty("OrgType") == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_OrgTypeNull"));
                return;
            }
            if (eo.getExtendedProperty("OrgType").equalsIgnoreCase("none") && !SysContext.getSysContext().getCurrentCtrlUnit().getCU().getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_GroupRight"));
                return;
            }
            this.showDetailWindows("addnew");
        }
        catch (Exception err) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_ListToEdit"), (Throwable)err);
        }
    }

    @Override
    public void actionSee_actionPerformed(ActionEvent e) throws Exception {
        try {
            if (this.tblList.getSelectManager().getActiveRowIndex() == -1) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectCR"));
                return;
            }
            this.showDetailWindows("readonly");
        }
        catch (Exception err) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_ListToEdit"), (Throwable)err);
        }
    }

    @Override
    public void actionUpdate_actionPerformed(ActionEvent e) throws Exception {
        try {
            boolean isEnabled;
            if (this.tblList.getSelectManager().getActiveRowIndex() == -1) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectCR"));
                return;
            }
            IRow row = this.tblList.getRow(this.tblList.getSelectManager().getActiveRowIndex());
            if (this.isTemplate && row.getCell("ruleType").getValue().toString().equals("2")) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_CannotDelete"));
                return;
            }
            if (this.tblList.getRow(this.tblList.getSelectManager().getActiveRowIndex()).getCell("isEnabled") != null && (isEnabled = ((Boolean)this.tblList.getRow(this.tblList.getSelectManager().getActiveRowIndex()).getCell("isEnabled").getValue()).booleanValue())) {
                if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_InfoUpdateLimited")) == 0) {
                    this.showDetailWindows("update_limited");
                }
                return;
            }
            this.showDetailWindows("update");
        }
        catch (Exception err) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_ListToEdit"), (Throwable)err);
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        block15: {
            boolean isEnabled;
            if (this.tblList.getSelectManager().getActiveRowIndex() == -1) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectCRBeforeDelete"));
                return;
            }
            IRow row = this.tblList.getRow(this.tblList.getSelectManager().getActiveRowIndex());
            if (row.getCell("number") == null) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectCRBeforeDelete"));
                return;
            }
            this.beforeDeleteAction();
            if (!this.chechCuOrgBeforeAction("delete")) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_Must_CurrentCuOrg"));
                return;
            }
            if (row.getCell("isEnabled") != null && (isEnabled = ((Boolean)this.tblList.getRow(this.tblList.getSelectManager().getActiveRowIndex()).getCell("isEnabled").getValue()).booleanValue())) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_DisabledBeforeUpdate"));
                return;
            }
            if (this.isTemplate && row.getCell("ruleType").getValue().toString().equals("2")) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_CannotDelete"));
                return;
            }
            if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_Confirm_DeleteCR")))) {
                return;
            }
            try {
                String codingRuleNumber;
                if (this.iCRM == null) {
                    this.iCRM = CodingRuleManagerFactory.getRemoteInstance();
                }
                if ((codingRuleNumber = row.getCell("number").getValue().toString().trim()) != null && codingRuleNumber.trim().length() > 0) {
                    try {
                        boolean bl = this.iCRM.deleteByNumber(codingRuleNumber);
                    }
                    catch (CodingRuleException err) {
                        if (err.getSubCode().equals(CodingRuleException.ERROR_DELETEREFERENCE.getCode())) {
                            Locale mylocale = SysContext.getSysContext().getOriginLocale();
                            MsgBox.showError((String)err.getMessage(mylocale));
                            return;
                        }
                        if (err.getSubCode().equals(CodingRuleException.ERROR_HASMAXSERIAL.getCode())) {
                            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource", (String)"msg_deletecodingrule")) == 0) {
                                this.iCRM.deleteByNumber(codingRuleNumber, false);
                            }
                            return;
                        }
                        throw err;
                    }
                    this.refreshKDTable(this.tblList);
                    this.afterDeleteAction();
                    this.showResultMessage("com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_Delete_OK");
                    break block15;
                }
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_Number_Null"));
            }
            catch (Exception err) {
                ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_Delete"), (Throwable)err);
            }
        }
    }

    protected void afterDeleteAction() {
    }

    protected void beforeDeleteAction() {
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refreshKDTable(this.tblList);
    }

    public RequestContext prepareQueryContext(RequestRowSetEvent e) {
        int start = 0;
        int length = 100;
        RequestContext request = new RequestContext();
        if (e != null) {
            start = (Integer)e.getParam1();
            length = (Integer)e.getParam2() - start + 1;
        } else {
            length = Integer.MAX_VALUE;
        }
        request.setStart(start);
        request.setLength(length);
        request.setQueryPK(this.codingRuleListQueryPK);
        request.setQuery(this.codingRuleListQuery);
        return request;
    }

    @Override
    protected void tblList_doRequestRowSet(RequestRowSetEvent e) {
        if (this.codingRuleListQuery != null) {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            String id = "";
            HashSet<String> multiNum = new HashSet<String>();
            String orgName = "";
            try {
                CacheServiceFactory.getInstance().discardQuery(this.codingRuleListQueryPK);
                IQueryExecutor exec = this.getQueryExecutor(this.codingRuleListQueryPK, this.codingRuleListQuery);
                IRowSet rowSet = exec.executeQuery(start, length);
                String businessObject = "";
                String businessObjectAlias = "";
                ArrayList<String> l = new ArrayList<String>();
                Map m = null;
                Locale mylocale = SysContext.getSysContext().getOriginLocale();
                this.aliasHM.clear();
                while (rowSet.next() && rowSet.getMetaData().getColumnCount() > 15) {
                    if (rowSet.getString("multiOrgFirst") == null || !String.valueOf(rowSet.getString("multiOrgFirst")).equals("true")) continue;
                    id = rowSet.getString("id").toString();
                    multiNum.add(id);
                }
                ICodingRule iCodingRule = CodingRuleFactory.getRemoteInstance();
                if (multiNum.size() != 0) {
                    Iterator it = multiNum.iterator();
                    while (it.hasNext()) {
                        id = it.next().toString();
                        l.add(id);
                    }
                    m = iCodingRule.getAppOrgName(l);
                }
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    if (m != null && m.containsKey(rowSet.getString("id"))) {
                        rowSet.updateString("appOrgUnit.name", m.get(rowSet.getString("id")).toString());
                    }
                    if (rowSet.getString("businessObject") == null || rowSet.getString("businessObject").length() <= 0) continue;
                    String eoType = rowSet.getString("businessObject");
                    if (rowSet.getString("bp.propertyName") != null && rowSet.getString("bp.propertyName").length() > 0) {
                        BizEnumValueCollection enumValues;
                        String propertyName = rowSet.getString("bp.propertyName").trim();
                        if (this.hm != null && this.hm.containsKey(eoType)) {
                            rowSet.updateString("bp.propertyName", CodingRuleClientUtils.getPropertyAlias(propertyName, eoType, this.createIMetaDataLoader(), null));
                        } else {
                            rowSet.updateString("bp.propertyName", CodingRuleClientUtils.getPropertyAlias(propertyName, eoType, this.createIMetaDataLoader(), null));
                            this.logger.debug((Object)("not foung in hm eoType :" + eoType));
                        }
                        if (rowSet.getString("bp.propertyValue") != null && (enumValues = CodingRuleClientUtils.getEnumValues(this.createIMetaDataLoader(), eoType, propertyName)) != null && enumValues.size() > 0) {
                            for (int i = 0; i < enumValues.size(); ++i) {
                                if (!rowSet.getString("bp.propertyValue").trim().equals(enumValues.get(i).getValue())) continue;
                                rowSet.updateString("bp.propertyValue", enumValues.get(i).getAlias(mylocale));
                                break;
                            }
                        }
                    }
                    if (businessObject.equals(eoType)) {
                        rowSet.updateString("businessObject", businessObjectAlias);
                        continue;
                    }
                    businessObject = eoType;
                    businessObjectAlias = this.hm != null && this.hm.containsKey(eoType) ? ((MetaDataBriefInfo)this.hm.get(eoType)).getAlias(mylocale) : CodingRuleClientUtils.getBOAlias(rowSet.getString("businessObject"), this.createIMetaDataLoader(), null);
                    rowSet.updateString("businessObject", businessObjectAlias);
                    this.aliasHM.put(businessObjectAlias, businessObject);
                }
                rowSet.beforeFirst();
                e.setRowSet(rowSet);
                this.onGetRowSet(rowSet);
            }
            catch (Exception ee) {
                e.setRowSet(null);
                this.handUIException(ee);
            }
        }
    }

    @Override
    protected void treeEntity_valueChanged(TreeSelectionEvent e) throws Exception {
        this.treeEntity.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.refreshQueryData();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.treeEntity.setCursor(Cursor.getDefaultCursor());
        }
        this.checkTable(this.tblList);
    }

    void initTree() {
        DefaultKingdeeTreeNode root = this.createNode();
        this.treeEntity.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.treeEntity.repaint();
        TreeSelectionModel treeSelectionModel = this.treeEntity.getSelectionModel();
        this.treeEntity.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        this.treeEntity.setSelectionRow(1);
    }

    private void printree(DefaultKingdeeTreeNode tree) {
        if (tree == null) {
            return;
        }
        if (!tree.isLeaf()) {
            for (int i = 0; i < tree.getChildCount(); ++i) {
                this.printree((DefaultKingdeeTreeNode)tree.getChildAt(i));
            }
        }
    }

    private void printreeForTheLevel(DefaultKingdeeTreeNode tree) {
        if (tree == null) {
            return;
        }
        if (tree.getLevel() <= 0) {
            for (int i = 0; i < tree.getChildCount(); ++i) {
                this.printreeForTheLevel((DefaultKingdeeTreeNode)tree.getChildAt(i));
            }
        }
    }

    private void testSubSystemTree() {
        DefaultKingdeeTreeNode rootNode = null;
        IBriefViewTreeNode entityTree1 = SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_vc");
        if (entityTree1 != null) {
            rootNode = SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)entityTree1);
            this.printreeForTheLevel(rootNode);
        }
    }

    private DefaultKingdeeTreeNode createNode() {
        DefaultKingdeeTreeNode rootNode = null;
        try {
            IBriefViewTreeNode entityTree1 = SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_codingrule");
            if (entityTree1 != null) {
                rootNode = SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)entityTree1));
                return rootNode;
            }
        }
        catch (Exception err) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_tree"), (Throwable)err);
        }
        return rootNode;
    }

    private ArrayList getBOList(DefaultKingdeeTreeNode root) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (root.isLeaf()) {
            list.add(root.getUserObject());
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                if (root.getChildAt(i).isLeaf()) {
                    Object childrenNode = ((DefaultKingdeeTreeNode)root.getChildAt(i)).getUserObject();
                    list.add(childrenNode);
                    continue;
                }
                list.addAll(this.getBOList((DefaultKingdeeTreeNode)root.getChildAt(i)));
            }
        }
        return list;
    }

    private ArrayList getTreeBOList() {
        KDTree tree = this.treeEntity;
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)tree.getLastSelectedPathComponent();
        ArrayList list = null;
        if (selectedNode != null && selectedNode.getParent() != null) {
            list = this.getBOList(selectedNode);
        } else {
            this.logger.debug((Object)"tree event:No select Leaf Node!");
        }
        return list;
    }

    private void filterData() throws Exception {
        FilterInfo filter = new FilterInfo();
        StringBuilder sbFormula = new StringBuilder("");
        String strBizObj = "";
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeEntity.getLastSelectedPathComponent();
        if (node != null) {
            if (node.isLeaf()) {
                Object obj = node.getUserObject();
                MetaDataBriefInfo uo = (MetaDataBriefInfo)obj;
                strBizObj = uo.getMetaDataPK().getPackage() + "." + uo.getMetaDataPK().getName();
                filter.getFilterItems().add(new FilterItemInfo("businessObject", (Object)strBizObj, CompareType.EQUALS));
            } else {
                strBizObj = "10";
                filter.getFilterItems().add(new FilterItemInfo("businessObject", (Object)strBizObj, CompareType.EQUALS));
            }
            sbFormula.append("#0");
        }
        String strFormula = "";
        int boFilterCount = filter.getFilterItems().size();
        if (this.isTemplate) {
            FilterItemInfo fi = new FilterItemInfo("ruleType", (Object)"0", CompareType.NOTEQUALS);
            filter.getFilterItems().add(fi);
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
            strFormula = boFilterCount > 0 ? "( " + sbFormula.toString() + " ) and #" + boFilterCount + " and (#" + (boFilterCount + 1) + " or #" + (boFilterCount + 2) + " or #" + (boFilterCount + 3) + " ) " : "#0";
        } else {
            FilterItemInfo fi = new FilterItemInfo("ruleType", (Object)"0", CompareType.EQUALS);
            filter.getFilterItems().add(fi);
            fi = new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(fi);
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
            String strOrgID = null;
            StringBuilder tmpFormula = new StringBuilder("");
            if (node != null && node.isLeaf()) {
                String orgType = this.createIMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(strBizObj)).getExtendedProperty("OrgType");
                FullOrgUnitInfo fOrg = CodingRuleClientUtils.getDefaultFullOrgUnitInfo(orgType);
                if (fOrg == null || fOrg.getId() == null) {
                    fOrg = CodingRuleClientUtils.getDefaultFullOrgUnitInfo(OrgType.ControlUnit.getName());
                }
                strOrgID = fOrg.getId().toString();
                filter.getFilterItems().add(new FilterItemInfo("MULTIORG.appOrgUnit.id", (Object)strOrgID, CompareType.EQUALS));
                tmpFormula.append("#").append(boFilterCount + 3).append(" ");
                filter.getFilterItems().add(new FilterItemInfo("MULTIORG.appOrgUnit.id", null, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)strOrgID, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("MULTIORG.appOrgUnit.id", null, CompareType.NOTEQUALS));
                strFormula = boFilterCount > 0 ? "( " + sbFormula.toString() + " ) and #" + boFilterCount + " and (" + tmpFormula.toString() + " or (#" + (boFilterCount + 4) + " and (#" + (boFilterCount + 1) + " or #" + (boFilterCount + 2) + ")) or (#" + (boFilterCount + 5) + " and #" + (boFilterCount + 6) + "))" : "#0";
            }
        }
        filter.setMaskString(strFormula);
        this.logger.debug((Object)("strFormula :" + strFormula));
        if (this.codingRuleListQuery.getSorter().size() == 0) {
            SorterItemInfo sorterItem = new SorterItemInfo();
            sorterItem.setPropertyName("businessObject");
            sorterItem.setSortType(SortType.ASCEND);
            this.codingRuleListQuery.getSorter().add(sorterItem);
            sorterItem = new SorterItemInfo();
            sorterItem.setPropertyName("number");
            sorterItem.setSortType(SortType.ASCEND);
            this.codingRuleListQuery.getSorter().add(sorterItem);
        }
        this.codingRuleListQuery.setFilter(filter);
        this.refreshKDTable(this.tblList);
    }

    private EntityViewInfo mergeFilter(EntityViewInfo QueryFilter) throws BOSException {
        FilterInfo filterCU = this.getDefaultFilterForQuery();
        if (filterCU != null && filterCU.size() > 0) {
            if (QueryFilter.getFilter() != null && QueryFilter.getFilter().size() > 0 && !QueryFilter.getFilter().toString().equals("")) {
                FilterItemCollection filters = QueryFilter.getFilter().getFilterItems();
                boolean hasCUFilter = false;
                for (int i = 0; i < filters.size(); ++i) {
                    if (!filters.get(i).getPropertyName().equals("CU.id")) continue;
                    hasCUFilter = true;
                    break;
                }
                if (!hasCUFilter) {
                    QueryFilter.getFilter().mergeFilter(filterCU, "AND");
                }
            } else {
                QueryFilter.setFilter(filterCU);
            }
        }
        return QueryFilter;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filter.setMaskString(" #0 or #1 ");
        return filter;
    }

    private void registScriptExportWindows() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke("F11"), "DataCenterFunction");
        this.getActionMap().put("DataCenterFunction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TestForewarnUI.class.getName(), CodingRuleListUI.this.getUIContext(), null, null);
                    uiWindow.show();
                }
                catch (UIException e1) {
                    CodingRuleListUI.this.logger.info((Object)"", (Throwable)e1);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showDetailWindows(String flag) throws Exception {
        EntityObjectInfo eo;
        UIContext hm;
        block15: {
            block16: {
                if (!"readonly".equals(flag) && !this.chechCuOrgBeforeAction(flag)) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_Must_CurrentCuOrg"));
                    return;
                }
                hm = new UIContext((Object)this);
                hm.put("flag", flag);
                hm.put("isTemplate", Boolean.toString(this.isTemplate));
                hm.put("parent", this);
                if (this.iCRM != null) {
                    hm.put("iCRM", this.iCRM);
                }
                hm.put("metaLoader", this.createIMetaDataLoader());
                eo = null;
                if (this.tblList.getSelectManager().getActiveRowIndex() < 0 || this.aliasHM == null || this.aliasHM.size() <= 0 || this.tblList.getRow(this.tblList.getSelectManager().getActiveRowIndex()).getCell("businessObject").getValue() == null) break block16;
                String fbusinessObject = String.valueOf(this.tblList.getRow(this.tblList.getSelectManager().getActiveRowIndex()).getCell("businessObject").getValue());
                String eoType = null;
                if (!StringUtils.isEmpty((String)fbusinessObject)) {
                    eoType = String.valueOf(this.aliasHM.get(String.valueOf(this.tblList.getRow(this.tblList.getSelectManager().getActiveRowIndex()).getCell("businessObject").getValue())));
                }
                if (eo == null && !StringUtils.isEmpty(eoType) && !eoType.equals("null")) {
                    eo = this.createIMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(eoType));
                    break block15;
                } else {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeEntity.getLastSelectedPathComponent();
                    if (node != null && node.isLeaf()) {
                        MetaDataBriefInfo uo = (MetaDataBriefInfo)node.getUserObject();
                        if (uo.isPackage()) {
                            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectObject"));
                            return;
                        }
                        eo = (EntityObjectInfo)uo.getMetaData(this.createIMetaDataLoader());
                        break block15;
                    } else {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectObject"));
                        return;
                    }
                }
            }
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeEntity.getLastSelectedPathComponent();
            if (node != null && node.isLeaf()) {
                MetaDataBriefInfo uo = (MetaDataBriefInfo)node.getUserObject();
                if (uo.isPackage()) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectObject"));
                    return;
                }
                eo = (EntityObjectInfo)uo.getMetaData(this.createIMetaDataLoader());
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectObject"));
                return;
            }
        }
        hm.put("EntityObjectInfo", eo);
        if (SysContext.getSysContext().getCurrentFIUnit() != null) {
            CompanyOrgUnitInfo orgInfo = SysContext.getSysContext().getCurrentFIUnit();
            hm.put("CompanyOrgUnitInfo", orgInfo);
        }
        if (!flag.equals("addnew") && (flag.equals("update") || flag.equals("readonly") || flag.equals("update_limited"))) {
            hm.put("CodingRule_Number", this.tblList.getRow(this.tblList.getSelectManager().getActiveRowIndex()).getCell("number").getValue());
            hm.put("CodingRule_Id", this.tblList.getRow(this.tblList.getSelectManager().getActiveRowIndex()).getCell("id").getValue());
            ArrayList idList = new ArrayList();
            int currentIndex = this.createIDList(this.tblList, idList);
            if (idList.size() > 1) {
                hm.put("currentIndex", new Integer(currentIndex));
                hm.put("idList", idList);
            }
        }
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
        hm.put("canResize", "false");
        IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.base.codingrule.client.CodingRuleEditUI", (Map)hm, null, null);
        if (uiWindow instanceof Frame) {
            Frame frame = (Frame)uiWindow;
        }
        uiWindow.show();
        this.refreshKDTable(this.tblList);
    }

    private int createIDList(KDTable table, ArrayList idList) {
        int currentIndex = -1;
        String currentId = table.getRow(this.tblList.getSelectManager().getActiveRowIndex()).getCell("id").getValue().toString();
        for (int i = 0; i < this.tblList.getRowCount(); ++i) {
            IRow row = table.getRow(i);
            if (row.getCell("id").getValue() == null) continue;
            idList.add(row.getCell("id").getValue().toString());
            if (!row.getCell("id").getValue().toString().equals(currentId)) continue;
            currentIndex = i;
        }
        return currentIndex;
    }

    public ICompanyOrgUnit createICompanyOrgUnit() throws Exception {
        this.iOrg = CompanyOrgUnitFactory.getRemoteInstance();
        return this.iOrg;
    }

    public IMetaDataLoader createIMetaDataLoader() {
        this.metaLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return this.metaLoader;
    }

    protected void saveCurrentLocation(KDTable table) {
        KDTSelectBlock selectBlock = table.getSelectManager().get();
        this.curIndex = selectBlock != null ? selectBlock.getTop() : 0;
    }

    protected void restoreCurrentLocation(KDTable table) {
        if (table.getRow(this.curIndex) != null) {
            table.getSelectManager().select(this.curIndex, 0);
        }
    }

    private void checkTable(KDTable table) {
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (table.getRow(i) == null || table.getRow(i).getCell("custompro") == null || table.getRow(i).getCell("custompro").getValue() != null) continue;
            table.getRow(i).getCell("custompro").setValue((Object)"number");
            table.getRow(i).getCell("customproname").setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource", (String)"codingrule"));
        }
    }

    protected void refreshKDTable(KDTable table) {
        this.saveCurrentLocation(table);
        table.removeRows();
        this.restoreCurrentLocation(table);
        this.checkTable(table);
    }

    protected boolean chechCuOrgBeforeAction(String action) throws Exception {
        boolean canDoAction = true;
        IRow row = this.tblList.getRow(this.tblList.getSelectManager().getActiveRowIndex());
        if ("delete".equalsIgnoreCase(action)) {
            if (!this.isTemplate && row.getCell("cu.id").getValue() != null) {
                canDoAction = row.getCell("cu.id").getValue().toString().trim().equals(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            } else if (this.isTemplate) {
                String codingRuleId = row.getCell("id").getValue().toString();
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)codingRuleId));
                SelectorItemCollection sc = new SelectorItemCollection();
                sc.add(new SelectorItemInfo("CU"));
                ICodingRule iCR = CodingRuleFactory.getRemoteInstance();
                CodingRuleInfo cr = iCR.getCodingRuleInfo((IObjectPK)pk, sc);
                canDoAction = cr.getCU().getId().toString().equals(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            }
        } else if ("addnew".equalsIgnoreCase(action)) {
            if (!this.isTemplate) {
                canDoAction = SysContext.getSysContext().getCurrentCtrlUnit() != null;
            }
        } else if ("update".equalsIgnoreCase(action)) {
            if (!this.isTemplate && row.getCell("cu.id").getValue() != null) {
                canDoAction = row.getCell("cu.id").getValue().toString().trim().equals(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            } else {
                String codingRuleId = row.getCell("id").getValue().toString();
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)codingRuleId));
                SelectorItemCollection sc = new SelectorItemCollection();
                sc.add(new SelectorItemInfo("CU"));
                ICodingRule iCR = CodingRuleFactory.getRemoteInstance();
                CodingRuleInfo cr = iCR.getCodingRuleInfo((IObjectPK)pk, sc);
                canDoAction = cr.getCU().getId().toString().equals(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            }
        }
        return canDoAction;
    }

    protected void showResultMessage(String message) {
        this.setMessageText(EASResource.getString((String)message));
        this.showMessage();
    }

    private static class PreChangeHandler
    implements PreChangeListener {
        private PreChangeHandler() {
        }

        public void preChange(PreChangeEvent e) {
            e.setResult(1);
        }
    }

    static class TreeObject {
        private BusinessObjectInfo bo;
        private String nodeText;

        TreeObject(BusinessObjectInfo bo, String nodeText) {
            this.bo = bo;
            this.nodeText = nodeText;
        }

        public BusinessObjectInfo getBusinessObjectInfo() {
            return this.bo;
        }

        public String toString() {
            return this.nodeText;
        }
    }
}

