/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleFactory;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.IMaxSerial;
import com.kingdee.eas.base.codingrule.MaxSerialFactory;
import com.kingdee.eas.base.codingrule.MaxSerialInfo;
import com.kingdee.eas.base.codingrule.SegmentStateEnum;
import com.kingdee.eas.base.codingrule.SeqSegmentEntryCollection;
import com.kingdee.eas.base.codingrule.SeqSegmentEntryFactory;
import com.kingdee.eas.base.codingrule.SeqSegmentEntryInfo;
import com.kingdee.eas.base.codingrule.SeqSegmentFactory;
import com.kingdee.eas.base.codingrule.SeqSegmentInfo;
import com.kingdee.eas.base.codingrule.client.AbstractSeqSegmentEditUI;
import com.kingdee.eas.base.codingrule.client.CodingRuleClientUtils;
import com.kingdee.eas.base.codingrule.client.CodingRulePropertyNameF7;
import com.kingdee.eas.base.codingrule.client.EntityProperty;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SeqSegmentEditUI
extends AbstractSeqSegmentEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SeqSegmentEditUI.class);
    private KDWorkButton btAdd = null;
    private KDWorkButton btDelete = null;
    private IMetaDataLoader metaLoader = null;
    private EntityObjectInfo eo = null;
    private String boType = "";
    private String actionFlag = "";
    private boolean readOnly = false;
    private Map aliasMap = new HashMap();
    private String seqFID = "";
    private Color[] color = new Color[]{Color.WHITE, new Color(217, 217, 208)};
    private SeqSegmentInfo oldEditData = null;
    private int step = 1;
    private boolean isModifed = false;

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }

    public void onLoad() throws Exception {
        this.kdtEntries.checkParsed();
        this.initContext();
        super.onLoad();
        this.oldEditData = (SeqSegmentInfo)this.editData.clone();
        KDTSortManager sm = new KDTSortManager(this.kdtEntries);
        sm.setSortAuto(true);
        for (int index = 0; index < this.kdtEntries.getColumnCount(); ++index) {
            this.kdtEntries.getColumn(index).setSortable(true);
        }
    }

    private void initContext() {
        if (this.getUIContext().get("EntityObjectInfo") != null) {
            this.eo = (EntityObjectInfo)this.getUIContext().get("EntityObjectInfo");
        }
        this.metaLoader = this.getUIContext().get("metaLoader") != null ? (IMetaDataLoader)this.getUIContext().get("metaLoader") : MetaDataLoaderFactory.getRemoteMetaDataLoader();
        if (this.getUIContext().get("flag") != null) {
            this.actionFlag = this.getUIContext().get("flag").toString();
        }
        if (this.getUIContext().get("BoType") != null) {
            this.boType = this.getUIContext().get("BoType").toString();
        }
        if (this.getUIContext().get("SeqRowIndex") != null) {
            this.seqFID = this.getUIContext().get("SeqRowIndex").toString();
        }
        if (this.getUIContext().get("step") != null) {
            this.step = Integer.parseInt(this.getUIContext().get("step").toString());
        }
    }

    @Override
    public void loadFields() {
        this.dataBinder.loadHeader();
        this.initF7();
        this.loadDetailData();
    }

    private long getUsedNum(String strAttrValue) {
        long usedNum = 0L;
        if (strAttrValue == null || this.seqFID == null || this.seqFID.trim().length() == 0) {
            return 0L;
        }
        try {
            IMaxSerial fac = MaxSerialFactory.getRemoteInstance();
            EntityViewInfo eviTemp = new EntityViewInfo();
            FilterInfo filterTemp = new FilterInfo();
            filterTemp.getFilterItems().add(new FilterItemInfo("segmentAttrValue", (Object)strAttrValue));
            filterTemp.getFilterItems().add(new FilterItemInfo("codingRuleEntry", (Object)this.seqFID));
            eviTemp.setFilter(filterTemp);
            MaxSerialInfo mi = fac.getMaxSerialCollection(eviTemp).get(0);
            if (mi != null) {
                usedNum = mi.getSerialNumber();
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        if (usedNum < 0L) {
            usedNum = 0L;
        }
        return usedNum;
    }

    private void loadDetailData() {
        if (this.editData.getId() != null && this.editData.getAttrName() == null) {
            try {
                this.editData = (SeqSegmentInfo)SeqSegmentFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            }
            catch (EASBizException e1) {
                logger.error((Object)"\u53d6\u533a\u95f4\u4fe1\u606f\u5931\u8d25");
            }
            catch (BOSException e1) {
                logger.error((Object)"\u53d6\u533a\u95f4\u4fe1\u606f\u5931\u8d25");
                return;
            }
        }
        SeqSegmentEntryCollection entries = this.editData.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            SeqSegmentEntryInfo entryInfo = entries.get(i);
            if (entryInfo.getId() != null && entryInfo.getAttrValue() == null) {
                try {
                    entryInfo = (SeqSegmentEntryInfo)SeqSegmentEntryFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(entryInfo.getId()));
                }
                catch (EASBizException e) {
                    logger.error((Object)"\u53d6\u5206\u6bb5\u4fe1\u606f\u5931\u8d25");
                }
                catch (BOSException e) {
                    logger.error((Object)"\u53d6\u5206\u6bb5\u4fe1\u606f\u5931\u8d25");
                    continue;
                }
            }
            if (entryInfo.getAttrValue() == null || entryInfo.getAttrValue().trim().length() <= 0) continue;
            long tmpNum = 0L;
            long defaultNum = 0L;
            defaultNum = this.step > 0 ? entryInfo.getEndNum() : entryInfo.getBeginNum();
            tmpNum = entryInfo.getState().equals((Object)SegmentStateEnum.State_close) ? defaultNum : this.getUsedNum(entryInfo.getLinkID());
            if (entryInfo.getState().equals((Object)SegmentStateEnum.State_close)) {
                tmpNum = defaultNum;
            }
            entryInfo.setUsedNum(0L);
            if (tmpNum > entryInfo.getEndNum() || tmpNum < entryInfo.getBeginNum() && entryInfo.getState().equals((Object)SegmentStateEnum.State_open)) {
                tmpNum = 0L;
            }
            this.addSegment(entryInfo.getAttrValue(), entryInfo.getBeginNum(), entryInfo.getEndNum(), tmpNum, entryInfo);
        }
        if (this.kdtEntries.getRowCount() == 0) {
            this.attrNameF7.setEnabled(true);
        }
        this.initOldData((IObjectValue)this.editData);
    }

    protected void loadData() throws Exception {
        this.setOprtState("ADDNEW");
        super.loadData();
    }

    @Override
    public void storeFields() {
        logger.debug((Object)"\u4fdd\u5b58\u5206\u6bb5\u8bbe\u7f6e\u5206\u5f55");
        this.dataBinder.storeHeader();
        int tblSize = this.kdtEntries.getRowCount();
        SeqSegmentEntryCollection entries = this.editData.getEntries();
        while (entries.size() > 0) {
            entries.removeObject(0);
        }
        for (int rowIndex = 0; rowIndex < tblSize; ++rowIndex) {
            SeqSegmentEntryInfo entry;
            IRow row = this.kdtEntries.getRow(rowIndex);
            Object cellObj = row.getCell("attrValue").getValue();
            String strAttrValue = "";
            String strID = "";
            if (cellObj != null && cellObj instanceof ObjectBaseInfo) {
                ObjectBaseInfo propObj = (ObjectBaseInfo)cellObj;
                strAttrValue = propObj.get("name").toString();
                strID = propObj.get("ID").toString();
            } else if (cellObj != null && cellObj instanceof String) {
                strAttrValue = cellObj.toString();
                if (row.getCell("linkID").getValue() != null) {
                    strID = row.getCell("linkID").getValue().toString();
                }
            }
            if (strAttrValue == null || strAttrValue.trim().length() == 0) continue;
            long tmpUsedNum = 0L;
            if (row.getCell("usedNum") != null) {
                tmpUsedNum = Long.parseLong(row.getCell("usedNum").getValue().toString());
            }
            if ((entry = entries.get(rowIndex)) == null) {
                entry = new SeqSegmentEntryInfo();
                entries.addObject(rowIndex, (IObjectValue)entry);
            }
            entry.setAttrValue(strAttrValue);
            entry.setLinkID(strID);
            entry.setBeginNum(Long.parseLong(row.getCell("beginNum").getValue().toString().trim()));
            entry.setEndNum(Long.parseLong(row.getCell("endNum").getValue().toString().trim()));
            if (this.step > 0 && tmpUsedNum >= entry.getEndNum() || this.step < 0 && tmpUsedNum <= entry.getBeginNum() && tmpUsedNum > 0L) {
                entry.setState(SegmentStateEnum.State_close);
            } else {
                entry.setState(SegmentStateEnum.State_open);
            }
            entry.setUsedNum(0L);
            if (row.getCell("id").getValue() != null) {
                entry.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            }
            entry.setParent(this.editData);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (this.btAdd == null) {
            this.btAdd = new KDWorkButton();
            this.btDelete = new KDWorkButton();
            this.actionBtnInsert.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
            this.btAdd = (KDWorkButton)this.SegListContainer.add((Action)((Object)this.actionBtnInsert));
            this.btAdd.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_AddNewLine"));
            this.btAdd.setText(null);
            this.actionBtnDelete.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteline"));
            this.btDelete = (KDWorkButton)this.SegListContainer.add((Action)((Object)this.actionBtnDelete));
            this.btDelete.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_DeleteLine"));
            this.btDelete.setText(null);
            this.btAdd.setEnabled(true);
            this.btAdd.setVisible(true);
            this.btDelete.setEnabled(true);
            this.btDelete.setVisible(true);
        }
        if (this.actionFlag.equalsIgnoreCase("readOnly")) {
            this.btnSubmit.setEnabled(false);
        }
    }

    private void initF7() {
        logger.debug((Object)"\u8bbe\u7f6e\u5c5e\u6027\u503cF7\u63a7\u4ef6");
        SeqSegmentInfo segmentInfo = (SeqSegmentInfo)this.getDataObject();
        try {
            EntityProperty nameFormatter;
            EntityProperty nameEP;
            CodingRulePropertyNameF7 namef7 = new CodingRulePropertyNameF7();
            namef7.setBoType(this.boType);
            namef7.setParentWindow((Object)this);
            namef7.setSeqSegmentEnabled(true);
            if (this.metaLoader == null) {
                this.metaLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            }
            namef7.setMetaLoader(this.metaLoader);
            this.attrNameF7.setSelector((KDPromptSelector)namef7);
            if (this.editData.getAttrName() != null && this.editData.getAttrName().trim().length() > 0) {
                String propertyAlias = CodingRuleClientUtils.getPropertyAlias(this.editData.getAttrName(), this.boType, this.metaLoader, this.eo);
                nameFormatter = nameEP = new EntityProperty(propertyAlias, this.editData.getAttrName());
                this.attrNameF7.setEnabled(true);
            } else {
                nameEP = null;
                nameFormatter = new EntityProperty("", "");
                this.attrNameF7.setEnabled(true);
            }
            this.attrNameF7.setData(nameEP);
            this.attrNameF7.setDisplayFormatter((IFormatter)nameFormatter);
            this.attrNameF7.setCommitParser((IParser)nameFormatter);
            this.attrNameF7.setEditable(false);
            if (this.readOnly) {
                this.attrNameF7.setEnabled(!this.readOnly);
            }
        }
        catch (Exception err) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_F7"), (Throwable)err);
        }
        if (segmentInfo.getEntries().size() > 0) {
            this.attrNameF7.setEnabled(false);
        }
    }

    private void addSegment(String strValue, long sNum, long eNum, long uNum, SeqSegmentEntryInfo info) {
        IRow row = this.kdtEntries.addRow();
        row.setUserObject((Object)new SeqSegmentEntryInfo());
        row.getCell("beginNum").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)this.createIntFieldForNum(sNum)));
        row.getCell("beginNum").setValue((Object)new Integer(sNum + ""));
        row.getCell("endNum").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)this.createIntFieldForNum(eNum)));
        row.getCell("endNum").setValue((Object)new Integer(eNum + ""));
        row.getCell("usedNum").setValue((Object)new Integer(uNum + ""));
        KDBizPromptBox attrValueF7 = new KDBizPromptBox();
        row.getCell("attrValue").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)attrValueF7));
        row.getCell("attrValue").getStyleAttributes().setBackground(this.color[0]);
        row.getCell("endNum").getStyleAttributes().setBackground(this.color[0]);
        row.getCell("beginNum").getStyleAttributes().setBackground(this.color[0]);
        if (uNum != 0L) {
            String strField = "beginNum";
            if (this.step < 0) {
                strField = "endNum";
            }
            row.getCell(strField).getStyleAttributes().setLocked(true);
            row.getCell(strField).getStyleAttributes().setBackground(this.color[1]);
            row.getCell("attrValue").getStyleAttributes().setLocked(true);
            row.getCell("attrValue").getStyleAttributes().setBackground(this.color[1]);
        }
        row.getCell("usedNum").getStyleAttributes().setBackground(this.color[1]);
        if (info.getId() != null) {
            row.getCell("id").setValue((Object)info.getId().toString());
        }
        row.getCell("linkID").setValue((Object)info.getLinkID());
        if (info.getState() != null && info.getState().equals((Object)SegmentStateEnum.State_close)) {
            row.getCell("attrValue").setValue((Object)strValue);
            row.getStyleAttributes().setBackground(this.color[1]);
            row.getStyleAttributes().setLocked(true);
            return;
        }
        this.aliasMap.put(info.getLinkID(), info.getLinkID());
        this.valueF7Config(attrValueF7, row, strValue);
    }

    private KDFormattedTextField createIntFieldForNum(long initNum) {
        KDFormattedTextField numField = new KDFormattedTextField(0);
        numField.setDataVerifierType(12);
        numField.setDataType(0);
        numField.setMaximumValue((Comparable)new Long(999999999L));
        numField.setMinimumValue((Comparable)new Long(0L));
        numField.setValue((Object)new Long(initNum));
        return numField;
    }

    private void valueF7Config(KDBizPromptBox attrValueF7, IRow row, String strValue) {
        try {
            String strDefaultF7 = "";
            if (this.metaLoader == null) {
                this.metaLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            }
            if (this.attrNameF7.getData() == null) {
                this.kdtEntries.remove(row.getRowIndex());
                return;
            }
            String tmpValue = ((EntityProperty)this.attrNameF7.getData()).getPropertyNameValue();
            if (tmpValue != null && tmpValue.trim().length() > 0) {
                this.editData.setAttrName(tmpValue);
            }
            if (this.editData.getAttrName() != null && this.editData.getAttrName().trim().length() > 0) {
                strDefaultF7 = CodingRuleClientUtils.getDefaultF7(this.editData.getAttrName(), this.boType, this.metaLoader, this.eo);
                row.getCell("attrValue").setValue((Object)strValue);
                attrValueF7.setEditable(false);
            }
            if (strDefaultF7 != null && strDefaultF7.length() > 0) {
                attrValueF7.setQueryInfo(strDefaultF7);
                attrValueF7.setDisplayFormat("$name$");
                attrValueF7.setCommitFormat("$number$;$name$");
                attrValueF7.setEditable(false);
            }
        }
        catch (Exception err) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_F7"), (Throwable)err);
        }
    }

    private boolean checkData() {
        if (this.kdtEntries.getRowCount() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SegmentInfoIsNull"));
            return false;
        }
        for (int rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
            Object cellObj;
            IRow tmpRow = this.kdtEntries.getRow(rowIndex);
            if (tmpRow == null || (cellObj = tmpRow.getCell("attrValue").getValue()) != null && cellObj.toString().trim().length() != 0) continue;
            MsgBox.showError((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_LineNumberInfoEmpty"), rowIndex + 1));
            return false;
        }
        return true;
    }

    private void saveSegment() throws EASBizException, BOSException {
        Object[] sInfos = this.getSortedSegments();
        if (sInfos.length > 1) {
            SeqSegmentEntryInfo currentEntry = (SeqSegmentEntryInfo)sInfos[0];
            for (int index = 1; index < sInfos.length; ++index) {
                SeqSegmentEntryInfo nextEntry = (SeqSegmentEntryInfo)sInfos[index];
                if (currentEntry.getEndNum() != nextEntry.getBeginNum() - 1L && MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SegmentNotFull")) == 2) {
                    return;
                }
                currentEntry = nextEntry;
            }
        }
        CodingRuleInfo crInfo = (CodingRuleInfo)this.getUIContext().get("CodingRule");
        if (this.editData.getId() == null && crInfo != null && crInfo.getId() != null) {
            crInfo.setSeqSegment(this.editData);
            CodingRuleFactory.getRemoteInstance().submit((CoreBaseInfo)crInfo);
            return;
        }
        SeqSegmentFactory.getRemoteInstance().submit(this.editData);
        this.showSubmitSuccess();
        this.isModifed = false;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkData()) {
            return;
        }
        this.storeFields();
        if (!this.checkSegmentsValid()) {
            return;
        }
        this.saveSegment();
        this.initOldData((IObjectValue)this.editData);
        this.oldEditData = this.editData;
    }

    public boolean destroyWindow() {
        if (!this.checkSegmentsValid()) {
            return false;
        }
        if (this.editData.getId() != null && !this.checkData()) {
            return false;
        }
        super.destroyWindow();
        if (this.editData.getId() == null) {
            return true;
        }
        if (this.editData.equals(this.oldEditData)) {
            return true;
        }
        while (this.editData.getEntries().size() > 0) {
            this.editData.getEntries().removeObject(0);
        }
        for (int i = 0; i < this.oldEditData.getEntries().size(); ++i) {
            this.editData.getEntries().addObject(i, (IObjectValue)this.oldEditData.getEntries().get(i));
        }
        return true;
    }

    public boolean isModify() {
        if (this.actionFlag.equalsIgnoreCase("readOnly")) {
            return false;
        }
        return this.isModifed;
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    protected void kdtEntries_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        super.kdtEntries_activeCellChanged(e);
    }

    private void attrCell_editStoped(KDTEditEvent e) throws Exception {
        KDTable table = (KDTable)e.getSource();
        IRow row = table.getRow(e.getRowIndex());
        Object cellObj = row.getCell("attrValue").getValue();
        if (cellObj != null && cellObj instanceof ObjectBaseInfo) {
            ObjectBaseInfo propObj = (ObjectBaseInfo)cellObj;
            if (this.aliasMap.get(propObj.get("ID")) != null) {
                long iEndNum = 0L;
                long iUsedNum = -1L;
                if (row.getCell("endNum") != null) {
                    iEndNum = Long.parseLong(row.getCell("endNum").getValue().toString().trim());
                }
                if (row.getCell("usedNum") != null) {
                    iUsedNum = Long.parseLong(row.getCell("usedNum").getValue().toString().trim());
                }
                if (iUsedNum < iEndNum) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SegmentAttrDuplicated"));
                    e.setCancel(true);
                    row.getCell("attrValue").setValue(e.getOldValue());
                    return;
                }
            }
            row.getCell("linkID").setValue(propObj.get("ID"));
            this.aliasMap.remove(e.getOldValue().toString());
            this.aliasMap.put(propObj.get("ID"), propObj.get("ID"));
            this.isModifed = true;
        }
    }

    private void bNum_editStoped(KDTEditEvent e) throws Exception {
        KDTable table = (KDTable)e.getSource();
        IRow row = table.getRow(e.getRowIndex());
        Object cellObj = row.getCell("beginNum").getValue();
        boolean validFlag = true;
        long bNum = 0L;
        long eNum = 0L;
        if (cellObj != null) {
            bNum = Long.parseLong(cellObj.toString().trim());
            if (row.getCell("beginNum").getValue() != null && bNum >= (eNum = Long.parseLong(row.getCell("endNum").getValue().toString().trim()))) {
                validFlag = false;
            }
            if (validFlag) {
                validFlag = this.checkNumValid(bNum);
            }
        }
        if (!validFlag) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SegmentBNumIllegal"));
            row.getCell("beginNum").setValue((Object)new Integer(e.getOldValue().toString()));
            e.setCancel(true);
            return;
        }
        if (this.step > 0 && !e.getValue().equals(e.getOldValue())) {
            validFlag = this.checkSegmentsValid(bNum, eNum);
        }
        if (validFlag) {
            this.isModifed = true;
        }
    }

    private void eNum_editStoped(KDTEditEvent e) throws Exception {
        KDTable table = (KDTable)e.getSource();
        IRow row = table.getRow(e.getRowIndex());
        Object ecellObj = row.getCell("endNum").getValue();
        Object bcellObj = row.getCell("beginNum").getValue();
        Object ucellObj = row.getCell("usedNum").getValue();
        boolean validFlag = true;
        long eNum = 0L;
        long bNum = 0L;
        long uNum = 0L;
        if (ecellObj != null) {
            eNum = Long.parseLong(ecellObj.toString().trim());
            if (bcellObj != null && (bNum = Long.parseLong(bcellObj.toString().trim())) >= eNum) {
                validFlag = false;
            }
            if (ucellObj != null) {
                uNum = Long.parseLong(ucellObj.toString().trim());
                if (eNum < uNum) {
                    validFlag = false;
                } else if (eNum == uNum && eNum > 0L) {
                    if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SegmentClos")) == 0) {
                        row.getStyleAttributes().setLocked(true);
                        row.getStyleAttributes().setBackground(this.color[1]);
                        Object cellObj = row.getCell("linkID").getValue();
                        if (cellObj != null) {
                            if (cellObj instanceof EntityProperty) {
                                EntityProperty propObj = (EntityProperty)cellObj;
                                this.aliasMap.remove(propObj.getPropertyNameText());
                            } else {
                                this.aliasMap.remove(cellObj.toString().trim());
                            }
                        }
                    } else {
                        row.getCell("endNum").setValue(e.getOldValue());
                        e.setCancel(true);
                    }
                    return;
                }
            }
            if (!validFlag) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SegmentENumIllegal"));
                row.getCell("endNum").setValue(e.getOldValue());
                e.setCancel(true);
                return;
            }
            if (this.step < 0 && !e.getValue().equals(e.getOldValue())) {
                validFlag = this.checkSegmentsValid(bNum, eNum);
            }
            if (validFlag) {
                this.isModifed = true;
            }
        }
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        if (e.getOldValue() != null && e.getValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        KDTable table = (KDTable)e.getSource();
        IColumn col = table.getColumn(e.getColIndex());
        if (col.getFieldName().equalsIgnoreCase("attrValue")) {
            this.attrCell_editStoped(e);
        } else if (col.getFieldName().equalsIgnoreCase("beginNum")) {
            this.bNum_editStoped(e);
        } else if (col.getFieldName().equalsIgnoreCase("endNum")) {
            this.eNum_editStoped(e);
        }
    }

    protected IObjectValue createNewData() {
        SeqSegmentInfo info = (SeqSegmentInfo)this.getUIContext().get("SegmentInfo");
        if (info.getId() != null) {
            try {
                info = SeqSegmentFactory.getRemoteInstance().getSeqSegmentInfo((IObjectPK)new ObjectUuidPK(info.getId()));
            }
            catch (EASBizException eASBizException) {
            }
            catch (BOSException bOSException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SeqSegmentFactory.getRemoteInstance();
    }

    @Override
    public void actionBtnDelete_actionPerformed(ActionEvent e) throws Exception {
        Object cellObj;
        int index = -1;
        index = this.kdtEntries.getSelectManager().getActiveRowIndex();
        if (index == -1) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectCREBeforeDeleteSegment"));
            return;
        }
        IRow row = this.kdtEntries.getRow(index);
        if (!row.getCell("usedNum").getValue().toString().equalsIgnoreCase("0")) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_CantDeleteSegment"));
            return;
        }
        if (this.kdtEntries.getRowCount() == 1) {
            this.attrNameF7.setEnabled(true);
        }
        if ((cellObj = row.getCell("linkID").getValue()) != null) {
            this.aliasMap.remove(cellObj.toString().trim());
        }
        this.kdtEntries.removeRow(index);
        this.storeFields();
    }

    @Override
    public void actionBtnInsert_actionPerformed(ActionEvent e) throws Exception {
        if (this.attrNameF7.getValue() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectAttrFirst"));
            return;
        }
        if (this.kdtEntries.getRowCount() > 0) {
            Object prev = this.kdtEntries.getRow(this.kdtEntries.getRowCount() - 1).getCell(0).getValue();
            if (null == prev) {
                return;
            }
            if (StringUtils.isEmpty((String)prev.toString())) {
                return;
            }
        }
        SeqSegmentEntryInfo rInfo = this.getRecomandSegment();
        rInfo.setState(SegmentStateEnum.State_open);
        this.addSegment("", rInfo.getBeginNum(), rInfo.getEndNum(), 0L, rInfo);
        this.attrNameF7.setEnabled(false);
    }

    private Object[] getSortedSegments() {
        this.storeFields();
        SeqSegmentEntryCollection entries = this.editData.getEntries();
        Object[] sInfoArray = entries.toArray();
        Arrays.sort(sInfoArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                SeqSegmentEntryInfo so1 = (SeqSegmentEntryInfo)o1;
                SeqSegmentEntryInfo so2 = (SeqSegmentEntryInfo)o2;
                return (int)(so1.getBeginNum() - so2.getBeginNum());
            }
        });
        return sInfoArray;
    }

    private SeqSegmentEntryInfo getRecomandSegment() {
        SeqSegmentEntryInfo eInfo = new SeqSegmentEntryInfo();
        Object[] sInfos = this.getSortedSegments();
        if (sInfos.length == 0) {
            eInfo.setBeginNum(1L);
            eInfo.setEndNum(1001L);
        } else {
            eInfo.setBeginNum(((SeqSegmentEntryInfo)sInfos[sInfos.length - 1]).getEndNum() + 1L);
            eInfo.setEndNum(eInfo.getBeginNum() + 1000L);
        }
        return eInfo;
    }

    private boolean checkNumValid(long num) {
        Object[] sInfos = this.getSortedSegments();
        for (int index = sInfos.length - 1; index >= 0; --index) {
            SeqSegmentEntryInfo entry = (SeqSegmentEntryInfo)sInfos[index];
            if (num > entry.getEndNum()) {
                return true;
            }
            if (num <= entry.getBeginNum() || num >= entry.getEndNum()) continue;
            return false;
        }
        return true;
    }

    private boolean checkSegmentValid(long sNum, long eNum, int rowId) {
        Object[] sInfos = this.getSortedSegments();
        if (sInfos.length == 0) {
            return true;
        }
        long preEnum = 0L;
        for (int index = sInfos.length - 1; index >= 0; --index) {
            SeqSegmentEntryInfo entry = (SeqSegmentEntryInfo)sInfos[index];
            if (eNum > sNum && sNum > preEnum && eNum < entry.getBeginNum()) {
                return true;
            }
            preEnum = entry.getEndNum();
        }
        return false;
    }

    private boolean checkSegmentsValid(long sNum, long eNum) {
        Object[] sInfos = this.getSortedSegments();
        if (sInfos.length < 2) {
            return true;
        }
        SeqSegmentEntryInfo currentEntry = (SeqSegmentEntryInfo)sInfos[0];
        for (int index = 1; index < sInfos.length; ++index) {
            SeqSegmentEntryInfo nextEntry = (SeqSegmentEntryInfo)sInfos[index];
            if (currentEntry.getBeginNum() > currentEntry.getEndNum() || currentEntry.getEndNum() >= nextEntry.getBeginNum()) {
                String strValue = "";
                strValue = currentEntry.getBeginNum() == sNum && currentEntry.getEndNum() == eNum ? currentEntry.getAttrValue() : nextEntry.getAttrValue();
                MsgBox.showError((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_AttrValueInvalid"), strValue));
                return false;
            }
            currentEntry = nextEntry;
        }
        return true;
    }

    private boolean checkSegmentsValid() {
        Object[] sInfos = this.getSortedSegments();
        if (sInfos.length < 2) {
            return true;
        }
        SeqSegmentEntryInfo currentEntry = (SeqSegmentEntryInfo)sInfos[0];
        for (int index = 1; index < sInfos.length; ++index) {
            SeqSegmentEntryInfo nextEntry = (SeqSegmentEntryInfo)sInfos[index];
            if (currentEntry.getBeginNum() > currentEntry.getEndNum() || currentEntry.getEndNum() >= nextEntry.getBeginNum()) {
                MsgBox.showError((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_AttrValueInvalid"), currentEntry.getAttrValue()));
                return false;
            }
            currentEntry = nextEntry;
        }
        return true;
    }
}

