/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CodingPropertiesUtil {
    private static HashMap cache = new HashMap();
    private static Logger logger = Logger.getLogger((String)CodingPropertiesUtil.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(String configFile) {
        Properties properties = new Properties();
        InputStream is = null;
        try {
            is = CodingPropertiesUtil.class.getResourceAsStream(configFile);
            properties.load(is);
            cache.put(configFile, properties);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)(" not found file: " + configFile), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.info((Object)e);
            }
        }
    }

    public static void unload(String configFile) {
        cache.remove(configFile);
    }

    public static void clearAll() {
        cache.clear();
    }

    public static Properties getProperties(String configFile) {
        if (!cache.containsKey(configFile)) {
            CodingPropertiesUtil.load(configFile);
        }
        return (Properties)cache.get(configFile);
    }

    public static String getDefaultFullName(String relativeFileName) {
        String portalConfig = System.getProperty("portal.config");
        if (portalConfig == null || "".equals(portalConfig)) {
            logger.error((Object)"[Eas Portal] please set system property [portal.config].");
        }
        File portalConfigFile = new File(portalConfig);
        String configPath = portalConfigFile.getParentFile().getAbsolutePath() + "/" + relativeFileName;
        return configPath;
    }
}

