/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.common.util;

import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public final class DateUtils {
    public static final String SHORT_FORMAT = "yyyyMMdd";
    public static final String LONG_FORMAT = "yyyyMMddHHmmss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HHmmss";
    public static final String YEAR_MONTH_FORMAT = "yyyyMM";
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_SPLIT_FORMAT = "yyyy-MM-dd";
    public static final String TIME_SPLIT_FORMAT = "HH:mm:ss";
    public static final String TIMESTAMP_MILLISECOND_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";

    public static String getCustomDateString(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static String parseMillisecond2String(long time, String format) {
        SimpleDateFormat dateFormat = null;
        dateFormat = StringUtils.isEmpty((String)format) ? new SimpleDateFormat(TIMESTAMP_MILLISECOND_FORMAT) : new SimpleDateFormat(format);
        return dateFormat.format(time);
    }

    public static Date parseCustomDateString(String sDate, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Date d = null;
        if (sDate != null && sDate.length() == format.length()) {
            try {
                d = dateFormat.parse(sDate);
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return d;
    }

    public static Date parseDateLongFormat(String sDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(LONG_FORMAT);
        Date d = null;
        if (sDate != null && sDate.length() == LONG_FORMAT.length()) {
            try {
                d = dateFormat.parse(sDate);
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return d;
    }

    public static String getLongDateString(Date date) {
        return DateUtils.getLongDateString(date, TimeZone.getDefault());
    }

    public static String getLongDateString(Date date, TimeZone zone) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(LONG_FORMAT);
        dateFormat.setTimeZone(zone);
        return dateFormat.format(date);
    }

    public static String paseTimestamp2String(Timestamp timestamp, String parten) {
        SimpleDateFormat sdf = new SimpleDateFormat(parten);
        return sdf.format(timestamp);
    }

    public static void printEnd(String title, long begin, long end, Logger logger) {
        if (null == logger) {
            System.out.println(String.format("%s beginTime: %s,endTime: %s,cost: %d ms,%d s", title, DateUtils.parseMillisecond2String(begin, null), DateUtils.parseMillisecond2String(end, null), end - begin, (end - begin) / 1000L));
            return;
        }
        logger.error((Object)String.format("%s beginTime: %s,endTime: %s,cost: %d ms\u951f\u65a4\u62f7%d s", title, DateUtils.parseMillisecond2String(begin, null), DateUtils.parseMillisecond2String(end, null), end - begin, (end - begin) / 1000L));
    }

    public static void printBegin(String title, long begin, Logger logger) {
        if (null == logger) {
            System.out.println(String.format("%s beginTime: %s", title, DateUtils.parseMillisecond2String(begin, null)));
            return;
        }
        logger.error((Object)String.format("%s beginTime: %s", title, DateUtils.parseMillisecond2String(begin, null)));
    }
}

