/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.common.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.interfaces.RSAPrivateKey;
import java.text.MessageFormat;

public class SysToolUtil {
    public static RSAPrivateKey privateKey = null;

    public static String getJmxconnectorPath(String serverName) {
        StringBuffer sb = new StringBuffer();
        sb.append(SysToolUtil.getConfigPath(serverName)).append(File.separator).append("jmxconnector.properties");
        return sb.toString();
    }

    public static String getConfigPath(String serverName) {
        StringBuffer sb = new StringBuffer();
        sb.append(SysToolUtil.getProfilesPath()).append(File.separator).append("{0}").append(File.separator).append("config");
        return MessageFormat.format(sb.toString(), serverName);
    }

    public static String getProfilesPath() {
        StringBuffer sb = new StringBuffer();
        sb.append(SysToolUtil.getServerPath()).append(File.separator).append("profiles");
        return sb.toString();
    }

    public static String getServerPath() {
        StringBuffer sb = new StringBuffer();
        sb.append(SysToolUtil.getEASHomePath()).append(File.separator).append("server");
        return sb.toString();
    }

    public static String getEASHomePath() {
        return System.getProperty("EAS_HOME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void contentToTxt(String filePath, String content, boolean isAppend) {
        String strOld = new String();
        String strNew = new String();
        BufferedWriter output = null;
        BufferedReader input = null;
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                f.createNewFile();
            }
            if (isAppend) {
                input = new BufferedReader(new FileReader(f));
                while ((strOld = input.readLine()) != null) {
                    strNew = strNew + strOld + "\n";
                }
                input.close();
            }
            strNew = strNew + content;
            output = new BufferedWriter(new FileWriter(f));
            output.write(strNew);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void objToTxt(String filePath, RSAPrivateKey content, boolean isAppend) {
        try {
            FileOutputStream out = null;
            ObjectOutputStream objOut = null;
            try {
                out = new FileOutputStream(filePath);
                objOut = new ObjectOutputStream(out);
                objOut.writeObject(content);
                objOut.flush();
                System.out.println("write object success!");
            }
            catch (IOException e) {
                System.out.println("write object failed");
                e.printStackTrace();
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (objOut != null) {
                    objOut.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSAPrivateKey loadPrivateKey(String filePath) throws IOException {
        RSAPrivateKey temp = null;
        File file = new File(filePath);
        FileInputStream in = null;
        ObjectInputStream objIn = null;
        try {
            in = new FileInputStream(file);
            objIn = new ObjectInputStream(in);
            temp = (RSAPrivateKey)objIn.readObject();
            System.out.println("read object success!");
        }
        catch (IOException e) {
            System.out.println("read object failed");
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (objIn != null) {
                objIn.close();
            }
        }
        return temp;
    }

    public static String getCurrentLoginServer() {
        String serverName = System.getProperty("EAS_INSTANCE_NAME");
        return serverName;
    }

    public static String getLogsPath(String serverName) {
        StringBuffer sb = new StringBuffer();
        sb.append(SysToolUtil.getProfilesPath()).append(File.separator).append(serverName).append(File.separator).append("logs");
        return sb.toString();
    }
}

