/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.listener;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.listener.DataListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum ListenerManager {
    INSTANCE;

    private static Map<String, DataListener> listeners;

    public static Map<String, DataListener> getListeners() {
        return listeners;
    }

    public void registerListener(String topic, DataListener listener) {
        listeners.put(topic, listener);
    }

    public void removeListener(String topic) {
        listeners.remove(topic);
    }

    public void publishError(Context ctx, String topic, String msg) {
        DataListener listener = listeners.get(topic);
        if (listener != null) {
            listener.publishErrorMsg(ctx, topic, msg);
        }
    }

    public void publishFinish(Context ctx, String topic, String msg) {
        DataListener listener = listeners.get(topic);
        if (listener != null) {
            listener.publishFinishMsg(ctx, topic, msg);
        }
    }

    public static ListenerManager getInstance() {
        return INSTANCE;
    }

    public Map getListenerResult(Context ctx, String topic) {
        DataListener listener = listeners.get(topic);
        if (listener != null) {
            return listener.getMsg(ctx, topic);
        }
        return Collections.emptyMap();
    }

    static {
        listeners = new HashMap<String, DataListener>();
    }
}

