/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.unitdata.be.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.evs.unitdata.be.BEDocUnit;
import com.kingdee.eas.base.evs.unitdata.be.BkrsDocUnit;
import com.kingdee.eas.base.evs.unitdata.billData.IBEInfoHandler;
import com.kingdee.eas.base.evs.util.AS;
import com.kingdee.eas.base.evs.util.BeUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ElStatementInvoiceInfoHandler
implements IBEInfoHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.evs.unitdata.be.handler.ElStatementInvoiceInfoHandler");
    private static String IdentificationCodeOfIssuer = "IdentificationCodeOfIssuer";
    private static String NumberOfBankBranch = "NumberOfBankBranch";
    private static String Currency = "Currency";
    private static String CustomerSettlementBankAccount = "CustomerSettlementBankAccount";
    private static String NameOfCustomerAccount = "NameOfCustomerAccount";
    private static String CodeOfBankCustomer = "CodeOfBankCustomer";
    private static String YearOfBankReconciliationStatement = "YearOfBankReconciliationStatement";
    private static String MonthOfBankReconciliationStatement = "MonthOfBankReconciliationStatement";
    private static String PrintTimes = "PrintTimes";
    private static String PrintDate = "PrintDate";
    private static String AccountBalanceAtTheEndOfReconciliationCycleAmount = "AccountBalanceAtTheEndOfReconciliationCycleAmount";
    private static String ReserveBalanceAtTheEndOfReconciliationCycle = "ReserveBalanceAtTheEndOfReconciliationCycle";
    private static String FrozenBalanceAtTheEndOfReconciliationCycle = "FrozenBalanceAtTheEndOfReconciliationCycle";
    private static String OverdraftBalanceAtEndOfReconciliationCycle = "OverdraftBalanceAtEndOfReconciliationCycle";
    private static String AvailableBalanceAtTheEndOfReconciliationCycleAmount = "AvailableBalanceAtTheEndOfReconciliationCycleAmount";
    private static String InformationOfReconcileDetailsTuple = "InformationOfReconcileDetailsTuple";
    private static String DateOfBookkeeping = "DateOfBookkeeping";
    private static String TypesOfBusinessProducts = "TypesOfBusinessProducts";
    private static String BusinessSerialNumber = "BusinessSerialNumber";
    private static String TypeOfSourceDocument = "TypeOfSourceDocument";
    private static String NumberOfSourceDocument = "NumberOfSourceDocument";
    private static String NotesOfBankElectronicReceipt = "NotesOfBankElectronicReceipt";
    private static String IdentificationOfCreditOrDebit = "IdentificationOfCreditOrDebit";
    private static String TransactionAmount = "TransactionAmount";
    private static String DebitOrCreditOfBalance = "DebitOrCreditOfBalance";
    private static String AccountBalance = "AccountBalance";
    private static String TransactionCode = "TransactionCode";
    private static String AccountOfCounterparty = "AccountOfCounterparty";
    private static String NameOfCounterparty = "NameOfCounterparty";
    private static String DepositoryBankOfCounterparty = "DepositoryBankOfCounterparty";
    private static String Bookkeeper = "Bookkeeper";
    private static String TimeOfBookkeeping = "TimeOfBookkeeping";
    private static String JournalAccountOfBookkeeping = "JournalAccountOfBookkeeping";
    private static String OtherAccountingInformation = "OtherAccountingInformation";
    private static String NumberOfBankElectronicReceipt = "NumberOfBankElectronicReceipt";

    @Override
    public Map<String, BEDocUnit> getDocsByBillIds(Context ctx, List<String> ids) throws EASBizException {
        HashMap<String, BEDocUnit> map = new HashMap<String, BEDocUnit>();
        Map<String, IObjectValue> eReceipt = BeUtils.getElStatementBill(ctx, ids);
        for (Map.Entry<String, IObjectValue> entry : eReceipt.entrySet()) {
            String id = entry.getKey();
            IObjectValue objValue = entry.getValue();
            BEDocUnit doc = this.getElsDoc(ctx, ElStatementInvoiceInfoHandler.eleBankStatement2Map(objValue));
            doc.put("PK", id);
            map.put(id, doc);
        }
        return map;
    }

    private static Map<String, Object> eleBankStatement2Map(IObjectValue object) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("authority", object.get("authority"));
        objectMap.put("networkSalesNum", object.get("networksalesnum"));
        objectMap.put("currency", object.get("currency") == null ? null : ((IObjectValue)object.get("currency")).get("isocode"));
        objectMap.put("bankAccountNumber", object.get("bankaccount") == null ? null : ((IObjectValue)object.get("bankaccount")).get("bankaccountnumber"));
        objectMap.put("bankAcctName", object.get("bankacctname"));
        objectMap.put("bankClientCode", object.get("bankclientcode"));
        objectMap.put("transDate", object.get("transdate"));
        objectMap.put("printCount", object.get("printcount"));
        objectMap.put("printDate", object.get("printdate"));
        objectMap.put("endBalance", object.get("endbalance"));
        objectMap.put("endRetainedAmt", object.get("endretainedamt"));
        objectMap.put("endFrezonAmt", object.get("endfrezonamt"));
        objectMap.put("endOverdraftAmt", object.get("endoverdraftamt"));
        objectMap.put("endAvailableAmt", object.get("endavailableamt"));
        IObjectCollection entry = (IObjectCollection)object.get("entry");
        ArrayList list = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf1 = new SimpleDateFormat("HH:mm:ss");
        objectMap.put("entry", list);
        for (int i = 0; i < entry.size(); ++i) {
            IObjectValue value = entry.getObject(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("bookDate", value.get("bookdate") == null ? "" : sdf.format((Date)value.get("bookdate")));
            map.put("bizProductType", value.get("bizproducttype"));
            map.put("vourcherType", value.get("vourchertype"));
            map.put("businessNum", value.get("businessnum"));
            map.put("creditAmount", value.get("creditamount"));
            map.put("debitAmount", value.get("debitamount"));
            map.put("vourcherNum", value.get("vourchernum"));
            map.put("decreption", value.get("decreption"));
            map.put("debitStatus", value.get("debitstatus"));
            map.put("acctBalance", value.get("acctbalance"));
            map.put("tradeCode", value.get("tradecode"));
            map.put("oppBankNumber", value.get("oppbanknumber"));
            map.put("oppBankName", value.get("oppbankname"));
            map.put("oppBank", value.get("oppbank"));
            map.put("bookKeeper", value.get("bookkeeper"));
            map.put("bookTime", value.get("booktime") == null ? "" : sdf1.format((Timestamp)value.get("booktime")));
            map.put("bookDetail", value.get("bookdetail"));
            map.put("otherBookMsg", value.get("otherbookmsg"));
            map.put("ereceiptNum", value.get("ereceiptnum"));
            list.add(map);
        }
        return objectMap;
    }

    private BEDocUnit getElsDoc(Context ctx, Map<String, Object> map) {
        BkrsDocUnit beDoc = new BkrsDocUnit();
        beDoc.put(IdentificationCodeOfIssuer, AS.valueOf(map.get("authority")));
        beDoc.put(NumberOfBankBranch, AS.valueOf(map.get("networkSalesNum")));
        beDoc.put(Currency, AS.valueOf(map.get("currency")));
        beDoc.put(CustomerSettlementBankAccount, AS.valueOf(map.get("bankAccountNumber")));
        beDoc.put(NameOfCustomerAccount, AS.valueOf(map.get("bankAcctName")));
        beDoc.put(CodeOfBankCustomer, AS.valueOf(map.get("bankClientCode")));
        Calendar instance = Calendar.getInstance();
        instance.setTime((Date)map.get("transDate"));
        beDoc.put(YearOfBankReconciliationStatement, instance.get(1));
        int month = instance.get(2) + 1;
        beDoc.put(MonthOfBankReconciliationStatement, month >= 10 ? Integer.valueOf(month) : "0" + month);
        beDoc.put(PrintTimes, AS.valueOf(map.get("printCount")));
        beDoc.put(PrintDate, AS.valueOf(map.get("printDate")));
        beDoc.put(AccountBalanceAtTheEndOfReconciliationCycleAmount, AS.valueOf(map.get("endBalance")));
        beDoc.put(ReserveBalanceAtTheEndOfReconciliationCycle, AS.valueOf(map.get("endRetainedAmt")));
        beDoc.put(FrozenBalanceAtTheEndOfReconciliationCycle, AS.valueOf(map.get("endFrezonAmt")));
        beDoc.put(OverdraftBalanceAtEndOfReconciliationCycle, AS.valueOf(map.get("endOverdraftAmt")));
        beDoc.put(AvailableBalanceAtTheEndOfReconciliationCycleAmount, AS.valueOf(map.get("endAvailableAmt")));
        List entry = (List)map.get("entry");
        JSONArray tuples = new JSONArray();
        for (int i = 0; i < entry.size(); ++i) {
            Map entryMap = (Map)entry.get(i);
            JSONObject entryJson = new JSONObject();
            entryJson.put(DateOfBookkeeping, (Object)AS.valueOf(entryMap.get("bookDate")));
            entryJson.put(TypesOfBusinessProducts, (Object)AS.valueOf(entryMap.get("bizProductType")));
            entryJson.put(BusinessSerialNumber, (Object)AS.valueOf(entryMap.get("businessNum")));
            entryJson.put(TypeOfSourceDocument, (Object)AS.valueOf(entryMap.get("vourcherType")));
            entryJson.put(NumberOfSourceDocument, (Object)AS.valueOf(entryMap.get("vourcherNum")));
            entryJson.put(NotesOfBankElectronicReceipt, (Object)AS.valueOf(entryMap.get("decreption")));
            String creditAmount = AS.valueOf(entryMap.get("creditAmount"));
            String debitAmount = AS.valueOf(entryMap.get("debitAmount"));
            entryJson.put(TransactionAmount, (Object)(StringUtils.isEmpty((String)debitAmount) ? creditAmount : debitAmount));
            entryJson.put(IdentificationOfCreditOrDebit, (Object)(StringUtils.isEmpty((String)debitAmount) ? "1" : "0"));
            entryJson.put(DebitOrCreditOfBalance, (Object)AS.valueOf(entryMap.get("debitStatus")));
            entryJson.put(AccountBalance, (Object)AS.valueOf(entryMap.get("acctBalance")));
            entryJson.put(TransactionCode, (Object)AS.valueOf(entryMap.get("tradeCode")));
            entryJson.put(AccountOfCounterparty, (Object)AS.valueOf(entryMap.get("oppBankNumber")));
            entryJson.put(NameOfCounterparty, (Object)AS.valueOf(entryMap.get("oppBankName")));
            entryJson.put(DepositoryBankOfCounterparty, (Object)AS.valueOf(entryMap.get("oppBank")));
            entryJson.put(Bookkeeper, (Object)AS.valueOf(entryMap.get("bookKeeper")));
            entryJson.put(TimeOfBookkeeping, (Object)AS.valueOf(entryMap.get("bookTime")));
            entryJson.put(JournalAccountOfBookkeeping, (Object)AS.valueOf(entryMap.get("bookDetail")));
            entryJson.put(OtherAccountingInformation, (Object)AS.valueOf(entryMap.get("otherBookMsg")));
            entryJson.put(NumberOfBankElectronicReceipt, (Object)AS.valueOf(entryMap.get("ereceiptNum")));
            tuples.add((Object)entryJson);
        }
        beDoc.put(InformationOfReconcileDetailsTuple, tuples);
        return beDoc;
    }
}

