/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.xbrlBuild.assembler.voucher;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.base.evs.app.elcertificate.BkerInvoiceCollection;
import com.kingdee.eas.base.evs.app.elcertificate.BkerInvoiceFactory;
import com.kingdee.eas.base.evs.app.elcertificate.BkerInvoiceInfo;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryCollection;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryInfo;
import com.kingdee.eas.base.evs.util.AS;
import com.kingdee.eas.base.evs.util.OfdUtil;
import com.kingdee.eas.base.evs.util.SQLUtils;
import com.kingdee.eas.base.evs.util.XbrlAssemblerUtil;
import com.kingdee.eas.base.evs.xbrlBuild.AbstractEVSInfo;
import com.kingdee.eas.base.evs.xbrlBuild.EVSInfo;
import com.kingdee.eas.base.evs.xbrlBuild.IssuerOFD;
import com.kingdee.eas.base.evs.xbrlBuild.IssuerXbrl;
import com.kingdee.eas.base.evs.xbrlBuild.ReceiverJson;
import com.kingdee.eas.base.evs.xbrlBuild.ReceiverXbrl;
import com.kingdee.eas.base.evs.xbrlBuild.assembler.ICompanyAssembler;
import com.kingdee.eas.base.evs.xbrlBuild.assembler.IssureInputStreamFactory;
import com.kingdee.eas.base.evs.xbrlBuild.assembler.IssureInputStreamable;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BkerXbrlAssembler
implements ICompanyAssembler,
IssureInputStreamable {
    private static Logger logger = Logger.getLogger((String)BkerXbrlAssembler.class.getName());

    @Override
    public IObjectCollection getOriDataCollection(Context ctx, String companyPk, int year, int month, Map<String, Object> otherParam) throws BOSException, EASBizException {
        String oql = "select *,voucherEntry.voucherId where periodYear = " + year + " and periodNumber = " + month + " and creditCode = '" + companyPk + "'";
        BkerInvoiceCollection bkerInvoiceCollection = BkerInvoiceFactory.getLocalInstance((Context)ctx).getBkerInvoiceCollection(oql);
        if (otherParam.containsKey("voucherIds") && otherParam.get("voucherIds") instanceof List) {
            List list = (List)otherParam.get("voucherIds");
            for (int i = 0; i < bkerInvoiceCollection.size(); ++i) {
                BkerInvoiceInfo info = bkerInvoiceCollection.get(i);
                InvoiceVoucherEntryCollection voucherEntry = info.getVoucherEntry();
                boolean isContains = false;
                for (int j = 0; j < voucherEntry.size(); ++j) {
                    if (!list.contains(voucherEntry.get(j).getVoucherId())) continue;
                    isContains = true;
                    break;
                }
                if (isContains) continue;
                bkerInvoiceCollection.removeObject(i);
                --i;
            }
        }
        return bkerInvoiceCollection;
    }

    public IObjectCollection getOriDataCollection(Context ctx, List<String> identifyingCodes) throws Exception {
        return BkerInvoiceFactory.getLocalInstance((Context)ctx).getBkerInvoiceCollection("where identifyingCode in (" + SQLUtils.getSQL(identifyingCodes) + "");
    }

    @Override
    public Map<String, Map<String, Map<String, List<EVSInfo>>>> createEVSInfo(Context ctx, IObjectCollection colls, Map<String, Object> otherParam) throws EASBizException {
        HashMap<String, Map<String, Map<String, List<EVSInfo>>>> result = new HashMap<String, Map<String, Map<String, List<EVSInfo>>>>();
        BkerInvoiceCollection bkers = (BkerInvoiceCollection)colls;
        List fileTypes = new ArrayList();
        List voucherLists = new ArrayList();
        if (otherParam.containsKey("voucherIds") && otherParam.get("voucherIds") instanceof List) {
            voucherLists = (List)otherParam.get("voucherIds");
        }
        if (otherParam.containsKey("fileTypes") && otherParam.get("fileTypes") instanceof List) {
            fileTypes = (List)otherParam.get("fileTypes");
        }
        for (int i = 0; i < bkers.size(); ++i) {
            BkerInvoiceInfo info = bkers.get(i);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("IdentifyingCode", (Object)info.getIdentifyingCode());
            jsonObject.put("Currency", (Object)info.getCurrency());
            jsonObject.put("TransactionAmountInFigures", (Object)info.getTransAmount());
            jsonObject.put("ContractNumber", (Object)info.getContractNumber());
            jsonObject.put("TypeOfInvoice", (Object)info.getInvoiceType());
            jsonObject.put("DateOfIssue", (Object)info.getDateOfIssue());
            jsonObject.put("UniqueCodeOfInvoice", (Object)info.getUniqueCode());
            jsonObject.put("AmountPayableAndReceivable", (Object)info.getPaymentAmount());
            jsonObject.put("WhetherInvoiceHasBeenClaimed", (Object)info.getIsClaimed());
            jsonObject.put("WhetherReceiptHasBeenBooked", (Object)AS.valueOf(info.getIsBooked(), "true"));
            jsonObject.put("WhetherReceiptHasBeenReconciled", (Object)info.getIsReconciled());
            jsonObject.put("WhetherReceiptHasBeenTransferredToBank", (Object)info.getTransToBank());
            jsonObject.put("UnifiedSocialCreditCodeOfAccountingEntity", (Object)info.getCreditCode());
            jsonObject.put("NameOfAccountingEntity", (Object)info.getAccountName());
            JSONArray voucherArrInfo = JSONArray.parseArray((String)info.getVoucher());
            for (Map.Entry entry : jsonObject.entrySet()) {
                if (entry.getValue() != null) continue;
                entry.setValue("");
            }
            InvoiceVoucherEntryCollection voucherEntry = info.getVoucherEntry();
            String issuerDate = info.getDateOfIssue().replace("-", "");
            for (int j = 0; j < voucherEntry.size(); ++j) {
                Map<String, Object> map;
                ArrayList<String> billIds;
                InvoiceVoucherEntryInfo entryInfo = voucherEntry.get(j);
                String voucherId = entryInfo.getVoucherId();
                if (!voucherLists.contains(voucherId)) continue;
                if (!result.containsKey(voucherId)) {
                    HashMap map2 = new HashMap();
                    map2.put("bker", new HashMap());
                    result.put(voucherId, map2);
                }
                Map typeMap = (Map)((Map)result.get(voucherId)).get("bker");
                ArrayList<AbstractEVSInfo> evsInfos = new ArrayList<AbstractEVSInfo>();
                typeMap.put(info.getIdentifyingCode(), evsInfos);
                jsonObject.put("InformationOfAccountingDocumentsTuple", (Object)voucherArrInfo.getJSONObject(j));
                String postDate = XbrlAssemblerUtil.getPostDate(voucherArrInfo.getJSONObject(j));
                if (fileTypes.contains("receiverJson")) {
                    ReceiverJson receiverJson = new ReceiverJson("bker_receiver_" + postDate + "_" + info.getIdentifyingCode() + ".json", new ByteArrayInputStream(jsonObject.toJSONString().getBytes()), "bker", postDate, jsonObject.toJSONString());
                    evsInfos.add(receiverJson);
                }
                if (fileTypes.contains("receiverXbrl")) {
                    ReceiverXbrl receiverXbrl = new ReceiverXbrl("bker_receiver_" + postDate + "_" + info.getIdentifyingCode() + ".xml", new ByteArrayInputStream(OfdUtil.json2Xbrl(jsonObject, this.getCinfigId()).getBytes()), "bker", postDate);
                    evsInfos.add(receiverXbrl);
                }
                if (fileTypes.contains("issuerXbrl")) {
                    IssuerXbrl issuerXbrl = null;
                    billIds = new ArrayList<String>(1);
                    billIds.add(info.getBillId());
                    map = IssureInputStreamFactory.getInstance(ctx, "bker").getIs(ctx, billIds);
                    if (map != null && !map.isEmpty()) {
                        InputStream is = null;
                        Object xbrlName = map.get(info.getBillId() + "-xbrlName");
                        Object o = map.get(info.getBillId());
                        if (o != null) {
                            if (o instanceof InputStream) {
                                is = (InputStream)o;
                            } else if (o instanceof byte[]) {
                                is = new ByteArrayInputStream((byte[])o);
                            }
                        }
                        issuerXbrl = new IssuerXbrl(xbrlName != null ? xbrlName + "" : "bker_issuer_" + issuerDate + "_" + info.getIdentifyingCode() + ".xml", is, "bker", issuerDate);
                        evsInfos.add(issuerXbrl);
                    }
                }
                if (!fileTypes.contains("issuerOFD")) continue;
                IssuerOFD issuerOfd = null;
                billIds = new ArrayList(1);
                billIds.add(info.getBillId());
                try {
                    map = this.getOfdInputStream(ctx, billIds);
                    if (map != null && !map.isEmpty()) {
                        Map fileMap = (Map)map.get("pdfMap");
                        Map erMap = (Map)map.get("erMap");
                        if (!fileMap.containsKey(info.getBillId())) continue;
                        byte[] bytes = (byte[])fileMap.get(info.getBillId());
                        issuerOfd = new IssuerOFD(!StringUtils.isEmpty((String)info.getFileName()) ? info.getFileName() : ((Map)erMap.get(info.getBillId())).get("fileName") + "", new ByteArrayInputStream(bytes), "bker", issuerDate);
                        evsInfos.add(issuerOfd);
                        continue;
                    }
                    logger.error((Object)("\u6839\u636e\u56de\u5355id\u627e\u4e0d\u5230\u6587\u4ef6,id:" + info.getBillId()));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("\u62ff\u4e0d\u5230\u7535\u5b50\u56de\u5355\u6587\u4ef6\u4fe1\u606f\uff1a" + e.getMessage()), (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> getIs(Context ctx, List<String> billIds) {
        if (billIds.isEmpty()) {
            return null;
        }
        try {
            Map<String, Object> map = this.getOfdInputStream(ctx, billIds);
            if (map != null && !map.isEmpty()) {
                byte[] bytes;
                Map<String, byte[]> xbrlMap;
                Iterator<Map.Entry<String, byte[]>> iterator;
                Map fileMap = (Map)map.get("pdfMap");
                HashMap<String, Object> result = new HashMap<String, Object>(1);
                if (fileMap.containsKey(billIds.get(0)) && (iterator = (xbrlMap = OfdUtil.getxbrlBytes(bytes = (byte[])fileMap.get(billIds.get(0)))).entrySet().iterator()).hasNext()) {
                    Map.Entry<String, byte[]> entry = iterator.next();
                    String xbrlName = entry.getKey();
                    byte[] xbrlBytes = entry.getValue();
                    result.put(billIds.get(0), xbrlBytes);
                    result.put(billIds.get(0) + "-xbrlName", xbrlName);
                    return result;
                }
            } else {
                logger.error((Object)("\u6839\u636e\u56de\u5355id\u627e\u4e0d\u5230\u6587\u4ef6,id:" + billIds.get(0)));
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u62ff\u4e0d\u5230\u7535\u5b50\u56de\u5355\u6587\u4ef6\u4fe1\u606f\uff1a" + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    private Map<String, Object> getOfdInputStream(Context ctx, List<String> billIds) {
        Map map = null;
        try {
            Class<?> clazz = Class.forName("com.kingdee.eas.fm.common.EReceiptCommonHelper");
            Method method = clazz.getMethod("getPDFValueByIdList", Context.class, List.class, Boolean.class);
            Object iobj = method.invoke(null, ctx, billIds, false);
            if (iobj instanceof Map) {
                map = (Map)iobj;
                return map;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u62ff\u4e0d\u5230\u7535\u5b50\u56de\u5355\u6587\u4ef6\u4fe1\u606f\uff1a" + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    @Override
    public String getCinfigId() {
        return "bker_receiver";
    }
}

