/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extendcontrols;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.AbstractPromptSelector;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormatter;
import com.kingdee.bos.ctrl.extendcontrols.BizFormatterFactory;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.ExtendResultObject;
import com.kingdee.bos.ctrl.extendcontrols.IF7ObjectProvider;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.extendcontrols.IKDCommonPromptSelector;
import com.kingdee.bos.ctrl.extendcontrols.IKDPromptIsCUSelector;
import com.kingdee.bos.ctrl.extendcontrols.IKDPromptStringSelector;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.IUserData;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptPopupF8;
import com.kingdee.bos.ctrl.extendcontrols.KDPromptEditorAssistor;
import com.kingdee.bos.ctrl.extendcontrols.KingdeeBizPromptBoxUI;
import com.kingdee.bos.ctrl.extendcontrols.QueryAgent;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonAfterPerformedListener;
import com.kingdee.bos.ctrl.extendcontrols.ext.CommonF7KDTableListener;
import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.extendcontrols.ext.IMultiOUsFilterInfoProducer;
import com.kingdee.bos.ctrl.extendcontrols.util.BosHelper;
import com.kingdee.bos.ctrl.extendcontrols.util.ParamHelper;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptPopup;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataErrorEvent;
import com.kingdee.bos.dao.AbstractBaseObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnit;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnitCollection;
import com.kingdee.bos.metadata.access.query.SimpleQuery;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ui.IMainUIContainer;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class KDBizPromptBox
extends KDPromptBox
implements ChangeListener,
IUserData {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox");
    protected QueryAgent queryAgent = new QueryAgent();
    protected IFormatter editFormatter;
    protected IFormatter dispFormatter;
    protected IParser commitParser;
    protected IBadValueHandler badHandler;
    protected boolean hasCUDefaultFilter = true;
    private boolean handleCUFilter = true;
    protected boolean isOnlyReturn = false;
    protected KDPromptEditorAssistor assistor = null;
    private int assistInfoLimit = 100;
    protected boolean isHistoryRecordEnabled = false;
    protected boolean isMyCommonUseEnabled = true;
    protected static String F7fuzzySearchEnabled = "true";
    protected boolean isDynQueryEnabled = false;
    private FilterFieldItem[] filterFields;
    private FilterInfo quickQueryFilter = new FilterInfo();
    private EntityViewInfo quickQueryEvi = new EntityViewInfo();
    private ArrayList quickQueryContent;
    private boolean isQuickQueryEnable = true;
    private String allFilterFieldName = null;
    private static final String numberAndName = "number+name";
    private String recordName = null;
    private boolean isNeedConvert = false;
    private CommonAfterPerformedListener cmAfterPerformed;
    protected List commitFormatters;
    private boolean hasHideQuichFilterPanel = false;
    protected boolean refresh = true;
    protected String defaultF7UIName = null;
    private Object userData;
    private UIContext maintainUIContext = new UIContext((Object)this);
    private boolean useCacheObject = false;
    private IFilterInfoProducer ifip;
    private CtrlUnitInfo currentCtrlUnit;
    private OrgUnitInfo currentMainBizOrgUnit;
    private OrgType currentMainBizOrgUnitType;
    private boolean isEnabledToMaintainBizdata = true;
    private OrgUnitCollection mainBizOrgs;
    private OrgType typeOfMainBizOrgs;
    private boolean isDefaultFilterFieldsEnabled = true;
    private CommonF7KDTableListener cmF7TblListener;
    private String[] mergeColumnKeys = null;
    private String[] precisionColumns = null;
    private String[] precisionDisplayColumns = null;
    private boolean isHRHistoryEnbable = false;
    private boolean isHRCommonUseEnbable = false;

    public boolean isNeedConvert() {
        return this.isNeedConvert;
    }

    public void setNeedConvert(boolean isNeedConvert) {
        this.isNeedConvert = isNeedConvert;
    }

    public KDBizPromptBox() {
        this.queryAgent.addChangeListener(this);
        this.initReturnOnlyRecord();
        this.initAssistor();
        this.initHistoryRecordEnabled();
        this.initUsingFuzzySearch();
        this.initDynQueryEnabled();
    }

    protected void initDynQueryEnabled() {
        String dynQueryEnabled = ParamHelper.getDynQueryEnabled();
        this.isDynQueryEnabled = dynQueryEnabled != null && dynQueryEnabled.trim().equalsIgnoreCase("true");
    }

    private void initReturnOnlyRecord() {
        String returnOnlyRecord = ParamHelper.getReturnOnlyRecord();
        this.isOnlyReturn = returnOnlyRecord != null && returnOnlyRecord.trim().equalsIgnoreCase("true");
    }

    private void initAssistor() {
        String historyRecordEnabled = ParamHelper.getHistoryRecordEnabled();
        this.isHistoryRecordEnabled = historyRecordEnabled != null && historyRecordEnabled.trim().equalsIgnoreCase("true");
        if (this.assistor == null) {
            this.assistor = new KDPromptEditorAssistor((KDTextField)this.edt);
            this.assistor.installListeners();
        }
        this.assistor.setAssistorMaximumRowCount(this.assistInfoLimit);
        this.setHistoryRecordEnabled(this.isHistoryRecordEnabled);
        this.setMyCommonUseEnabled(true);
    }

    private void initHistoryRecordEnabled() {
        String historyRecordEnabled = ParamHelper.getHistoryRecordEnabled();
        this.isHistoryRecordEnabled = historyRecordEnabled != null && historyRecordEnabled.trim().equalsIgnoreCase("true");
        this.setHistoryRecordEnabled(this.isHistoryRecordEnabled);
    }

    public void setHistoryRecordEnabled(boolean isHistoryRecordEnabled) {
        super.setHistoryRecordEnabled(false);
        this.isHistoryRecordEnabled = isHistoryRecordEnabled;
        if (this.assistor != null) {
            this.assistor.setHistoryRecordEnabled(isHistoryRecordEnabled);
        }
    }

    public void setMyCommonUseEnabled(boolean isMyCommonUseEnabled) {
        this.isMyCommonUseEnabled = isMyCommonUseEnabled;
        this.assistor.setMyCommonUseEnabled(isMyCommonUseEnabled);
    }

    public boolean isMyCommonUseEnabled() {
        return this.isMyCommonUseEnabled;
    }

    private void initUsingFuzzySearch() {
        F7fuzzySearchEnabled = "true";
    }

    protected KDPromptPopup createDownPanel() {
        if (this.downPanel == null) {
            this.downPanel = new KDCommonPromptPopupF8(this);
        }
        return this.downPanel;
    }

    protected void configDownPanel(Object param) {
        if (this.downPanel == null || !(this.downPanel instanceof KDCommonPromptPopupF8)) {
            this.downPanel = new KDCommonPromptPopupF8(this);
        }
        KDCommonPromptPopupF8 commonPromptPopupF8 = (KDCommonPromptPopupF8)this.downPanel;
        IRowSet rowSet = null;
        String text = this.getText();
        IParser parser = this.getCommitParser();
        if (parser != null) {
            rowSet = parser.getRowSetForPopupF8(text);
        }
        if (rowSet == null || rowSet.size() == 0) {
            this.setHasDownPanel(false);
            return;
        }
        this.setHasDownPanel(true);
        commonPromptPopupF8.setQueryInfo(this.queryAgent.getQueryInfoPK());
        commonPromptPopupF8.setEntityViewInfo(this.queryAgent.getRuntimeEntityView());
        commonPromptPopupF8.setSelectorCollection(this.queryAgent.getSelectorCollection());
        commonPromptPopupF8.setQueryExecutor(this.queryAgent.getQueryExecutor());
        commonPromptPopupF8.setEnabledMultiSelection(this.queryAgent.isEnabledMultiSelection());
        commonPromptPopupF8.setReturnValueType(this.queryAgent.getReturnValueType());
        commonPromptPopupF8.putRowSet(rowSet);
        commonPromptPopupF8.setIsDefaultFilterFieldsEnabled(this.getIsDefaultFilterFieldsEnabled());
        commonPromptPopupF8.addCommonF7KDTableListener(this.getCommonF7KDTableListener());
        commonPromptPopupF8.refreshTable();
    }

    public void setQueryInfo(String queryInfoStr) {
        MetaDataPK pk = this.parseQueryInfo(queryInfoStr);
        this.setQueryInfoPK(pk);
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (this.getName() == null || this.getName().trim().length() == 0) {
            if (this.getEntityViewInfo() == null) {
                if (pk != null && pk.toString().length() > 0) {
                    this.assistor.setRecordName(userID + pk.toString());
                    this.setRecordName(userID + pk.toString());
                } else {
                    this.assistor.setRecordName(userID + queryInfoStr);
                    this.setRecordName(userID + queryInfoStr);
                }
            } else if (pk != null && pk.toString().length() > 0) {
                int vhash = this.getEntityViewInfo().toString().hashCode();
                this.assistor.setRecordName(userID + pk.toString() + vhash);
                this.setRecordName(userID + pk.toString() + vhash);
            } else {
                int vhash = this.getEntityViewInfo().toString().hashCode();
                this.assistor.setRecordName(userID + queryInfoStr + vhash);
                this.setRecordName(userID + queryInfoStr + vhash);
            }
        } else if (this.getEntityViewInfo() == null) {
            this.assistor.setRecordName(userID + this.getName().trim());
            this.setRecordName(userID + this.getName().trim());
        } else {
            int vhash = this.getEntityViewInfo().toString().hashCode();
            this.assistor.setRecordName(userID + this.getName().trim() + vhash);
            this.setRecordName(userID + this.getName().trim() + vhash);
        }
        if (pk == null) {
            return;
        }
    }

    public void setRecordName(String name) {
        String n = null;
        if (name != null) {
            n = name.replaceAll("\\\\|/|\\:|\\*|\"|>|<|\\|\\.| |-|'|=|(|)|", "");
        }
        this.recordName = n;
        this.assistor.setRecordName(name);
    }

    public String getRecordName() {
        return this.recordName;
    }

    private BOSObjectType getBOSTypeFromQueryMainObject() {
        return Utils.getBOSTypeFromQueryPK((IMetaDataPK)this.getQueryInfoPK());
    }

    public String getQueryInfo() {
        MetaDataPK pk = this.getQueryInfoPK();
        if (pk != null) {
            return pk.toString();
        }
        return "";
    }

    public EntityViewInfo getEntityViewInfo() {
        return this.queryAgent.getEntityViewInfo();
    }

    public void setEntityViewInfo(EntityViewInfo v) {
        FilterItemCollection filterItemCollection;
        FilterInfo filterInfo;
        String queryInfo;
        if (v == null) {
            v = new EntityViewInfo();
        }
        if (ParamHelper.isAccountQueryInfo(queryInfo = this.getQueryInfo()) && (filterInfo = v.getFilter()) != null && (filterItemCollection = filterInfo.getFilterItems()) != null && filterItemCollection.size() > 0) {
            FilterItemInfo filterItemInfo = null;
            String propertyName = null;
            String cuId = "CU.id";
            int count = filterItemCollection.size();
            for (int i = 0; i < count; ++i) {
                filterItemInfo = filterItemCollection.get(i);
                propertyName = filterItemInfo.getPropertyName();
                if (!cuId.equalsIgnoreCase(propertyName)) continue;
                String msg = this.getMLS("0_KDBizPromptBox", "0_KDBizPromptBox");
                MsgBox.showWarning((String)msg);
                break;
            }
        }
        this.queryAgent.setEntityViewInfo(v);
        this.putMaintainUIContext("EntityViewInfo", v);
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        int vhash = v.toString().hashCode();
        if (this.getName() == null || this.getName().trim().length() == 0) {
            if (this.getQueryInfo() == null) {
                this.assistor.setRecordName(userID + vhash);
                this.setRecordName(userID + vhash);
            } else {
                this.assistor.setRecordName(userID + this.getQueryInfo() + vhash);
                this.setRecordName(userID + this.getQueryInfo() + vhash);
            }
        } else {
            this.assistor.setRecordName(userID + this.getName().trim() + vhash);
            this.setRecordName(userID + this.getName().trim() + vhash);
        }
    }

    public void setEditFormat(String editFormatStr) {
        IFormatter f = this.getEditFormatter();
        if (f != null) {
            f.applyPattern(editFormatStr);
        } else {
            this.setEditFormatter(BizFormatterFactory.getFormatter(editFormatStr));
        }
    }

    public void setDisplayFormat(String displayFormatStr) {
        if (this.isLabelVisible()) {
            this.setDisplayFormatInnerly("$number$");
        } else {
            this.setDisplayFormatInnerly(displayFormatStr);
        }
    }

    public void setCommitFormat(String commitFormatStr) {
        IParser pr = this.getCommitParser();
        if (pr != null) {
            pr.applyPattern(commitFormatStr);
        } else {
            pr = this.createParser(commitFormatStr);
            this.setCommitParser(pr);
        }
        String[] str = null;
        if (!StringUtil.isEmptyString((String)commitFormatStr)) {
            str = commitFormatStr.split(";");
        }
        if (str != null && str.length > 0) {
            BizDataFormatter bf = null;
            if (this.commitFormatters == null) {
                this.commitFormatters = new ArrayList();
            }
            if (!this.commitFormatters.isEmpty()) {
                this.commitFormatters.clear();
            }
            for (int i = 0; i < str.length; ++i) {
                if (StringUtil.isEmptyString((String)str[i])) continue;
                bf = BizFormatterFactory.getFormatter(str[i]);
                this.commitFormatters.add(bf);
            }
        }
    }

    public void setEditFormatter(IFormatter df) {
        this.editFormatter = df;
        if (this.hasFocus()) {
            this.updateData();
        }
    }

    public void setDisplayFormatter(IFormatter df) {
        this.dispFormatter = df;
        if (!this.hasFocus()) {
            this.updateData();
        }
    }

    public boolean getHasCUDefaultFilter() {
        return this.hasCUDefaultFilter;
    }

    public void setHasCUDefaultFilter(boolean isCUEffective) {
        this.hasCUDefaultFilter = isCUEffective;
        this.queryAgent.setHasCUDefaultFilter(isCUEffective);
    }

    public void setHandleCUFilter(boolean handleCUFilter) {
        this.handleCUFilter = handleCUFilter;
        this.queryAgent.setHandleCUFilter(handleCUFilter);
    }

    public boolean isHandleCUFilter() {
        return this.handleCUFilter;
    }

    public void setCommitParser(IParser pr) {
        this.commitParser = pr;
    }

    public IFormatter getEditFormatter() {
        return this.editFormatter;
    }

    public IFormatter getDisplayFormatter() {
        return this.dispFormatter;
    }

    public IParser getCommitParser() {
        return this.commitParser;
    }

    public QueryAgent getQueryAgent() {
        return this.queryAgent;
    }

    protected void setQueryAgent(QueryAgent agent) {
        this.queryAgent = agent;
    }

    public IBadValueHandler getBadHandler() {
        return this.badHandler;
    }

    public void setEditable(boolean aFlag) {
        super.setEditable(aFlag);
        if (this.assistor != null) {
            this.assistor.setQuickQueryEnable(aFlag);
            this.setHistoryMyCommonUseRecord(this.getParent(), aFlag);
        }
    }

    private void setHistoryMyCommonUseRecord(Container parent, boolean flag) {
        if (parent == null) {
            return;
        }
        if (parent instanceof CoreUIObject) {
            String oprtState = ((CoreUIObject)parent).getOprtState();
            if ("VIEW".equals(oprtState)) {
                this.assistor.setHistoryRecordEnabled(false);
                this.assistor.setMyCommonUseEnabled(false);
            } else {
                this.initAssistor();
            }
        } else {
            this.setHistoryMyCommonUseRecord(parent.getParent(), flag);
        }
    }

    public void setBadHandler(IBadValueHandler handler) {
        this.badHandler = handler;
    }

    protected KDPromptSelector createSelector(Object param) {
        KDPromptSelector sel = null;
        String className = this.getDefaultF7UIName();
        if (!StringUtil.isEmptyString((String)className)) {
            sel = this.createDefaultF7UIByName(className);
        }
        if (sel == null) {
            sel = this.createSpecialSelector();
        }
        if (sel == null) {
            Object owner;
            Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
            KDCommonPromptDialog cqd = null;
            if (parent == null && this.maintainUIContext != null && this.maintainUIContext.get((Object)"Owner") != null && (owner = this.maintainUIContext.get((Object)"Owner")) instanceof IUIObject) {
                Component c = (Component)owner;
                parent = SwingUtilities.getWindowAncestor(c);
            }
            cqd = parent instanceof Dialog ? new KDCommonPromptDialog((Dialog)parent) : (parent instanceof Frame ? new KDCommonPromptDialog((Frame)parent) : new KDCommonPromptDialog());
            cqd.setMaintainUIContext(this.maintainUIContext);
            cqd.setResizable(true);
            sel = cqd;
        }
        this.setRefresh(true);
        return sel;
    }

    protected MetaDataPK parseQueryInfo(String info) {
        if (StringUtil.isEmptyString((String)info)) {
            return null;
        }
        int pos = info.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        String packageName = info.substring(0, pos);
        String className = info.substring(pos + 1);
        return new MetaDataPK(packageName, className);
    }

    public void setText(String t) {
        super.setText(t);
        this.setEditorTooltipsText(t);
    }

    protected String valueToString(Object o) {
        if (o == null) {
            return null;
        }
        IFormatter ftr = null;
        ftr = this.isEditable() && this.hasFocus() ? this.getEditFormatter() : this.getDisplayFormatter();
        if (ftr == null) {
            if (o instanceof Object[]) {
                for (int i = 0; i < ((Object[])o).length; ++i) {
                    Object temp = ((Object[])o)[i];
                    if (temp != null) continue;
                    return "";
                }
                return o.toString();
            }
            return o.toString();
        }
        return ftr.valueToString(o);
    }

    public void addCommonAfterPerformedListener(CommonAfterPerformedListener listener) {
        this.cmAfterPerformed = listener;
    }

    public CommonAfterPerformedListener getCommonAtferPerformedListener() {
        return this.cmAfterPerformed;
    }

    protected Object stringToValue(String t) {
        if (this.isNeedConvert && t != null && t.indexOf(".") >= 0) {
            t = t.replaceAll("\\.", "!");
        }
        Object obj = new Object();
        if (t != null && t.indexOf("'") >= 0) {
            if (this.getCommitParser() instanceof ExtendParser) {
                return t;
            }
            String msg = EASResource.getString((String)"com.kingdee.eas.common.EASCommonResource.f7QueryContextInvalid");
            MsgBox.showInfo((String)msg);
            return KDPromptBox.DEFAULTVALUE;
        }
        IParser pr = this.getCommitParser();
        if (pr == null) {
            obj = super.stringToValue(t);
        } else {
            pr.setQuickQureyEntityViewInfo(this.quickQueryEvi);
            obj = pr.stringToValue(t);
            this.quickQueryEvi = null;
        }
        if (this.cmAfterPerformed != null) {
            this.cmAfterPerformed.performed(obj);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object stringToValueForHistoryOrMyCommonUse(String t, boolean isNeedSetData) {
        String newText = this.edt.getText();
        if (newText != null && newText.length() > 0 && !this.doFireCommitEvent(newText)) {
            return null;
        }
        IMainUIContainer ui = SystemEntry.instance.getCurrenContainer();
        NewMainFrame mainFrame = null;
        if (ui != null && ui instanceof NewMainFrame && (mainFrame = (NewMainFrame)ui) != null) {
            mainFrame.setCursor(Cursor.getPredefinedCursor(3));
        }
        Object datas = KDPromptBox.DEFAULTVALUE;
        try {
            Object isCUSelector;
            QueryAgent agent = this.getQueryAgent();
            HashMap<String, String> mapID = new HashMap<String, String>();
            mapID.put("id", t);
            HashMap<String, String> mapNumber = new HashMap<String, String>();
            mapNumber.put("number", t);
            Map[] maps = new Map[]{mapID, mapNumber};
            this.getQueryAgent().setQueryExecutor(null);
            IRowSet equalRowSet = null;
            boolean isCufilter = false;
            if (this.getSelector() instanceof IKDPromptIsCUSelector) {
                isCUSelector = (IKDPromptIsCUSelector)this.getSelector();
                isCufilter = isCUSelector.isCUFilter();
                this.getQueryAgent().setHasCUDefaultFilter(isCufilter);
            } else {
                this.getQueryAgent().setHasCUDefaultFilter(false);
                this.getQueryAgent().setDefaultFilterInfo(null);
            }
            this.configDefaultFilterFromFilterInfoProducer(isCufilter);
            if (!this.getQueryAgent().upgradeEntityViewFromOriginEqual(maps)) {
                logger.info((Object)"warning: view set filter failed!");
                isCUSelector = KDPromptBox.DEFAULTVALUE;
                return isCUSelector;
            }
            EntityViewInfo eviFromAgent = null;
            try {
                eviFromAgent = new EntityViewInfo(this.getQueryAgent().getRuntimeEntityView().toString());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            equalRowSet = this.getQueryAgent().executeQuery(0, Integer.MAX_VALUE);
            int equalRowSetSize = 0;
            if (equalRowSet != null) {
                equalRowSetSize = equalRowSet.size();
            }
            if (equalRowSetSize == 0) {
                Object[] objectArray = datas;
                return objectArray;
            }
            if (agent.isEnabledMultiSelection()) {
                datas = this.buildReturnValue(this.getQueryAgent(), equalRowSet, equalRowSetSize);
            } else {
                Object[] result = this.buildReturnValue(this.getQueryAgent(), equalRowSet, equalRowSetSize);
                if (result != null && result.length > 0) {
                    datas = result[0];
                }
            }
            Object[] objectArray = datas;
            return objectArray;
        }
        finally {
            if (mainFrame != null) {
                mainFrame.setCursor(Cursor.getDefaultCursor());
            }
            if (isNeedSetData) {
                this.setData(datas, true);
            }
        }
    }

    protected Object[] buildReturnValue(QueryAgent agent, BOSUuid id) {
        ArrayList<IObjectValue> result = new ArrayList<IObjectValue>();
        BOSObjectType type = id.getType();
        try {
            EntityViewInfo evInfo = new EntityViewInfo();
            FilterInfo fInfo = new FilterInfo();
            fInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id.toString()));
            fInfo.mergeFilter(agent.getEntityViewInfo().getFilter(), "AND");
            evInfo.setFilter(fInfo);
            evInfo.getSelector().addObjectCollection((IObjectCollection)agent.getSelectorCollection());
            IObjectCollection coll = DynamicObjectFactory.getRemoteInstanceWithObjectContext((Context)this.getF7Context()).getCollection(type, evInfo);
            int count = coll.size();
            for (int i = 0; i < count; ++i) {
                IObjectValue ov = coll.getObject(i);
                result.add(ov);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return result.toArray();
    }

    public Object stringToValueForHistoryOrMyCommonUse(String t) {
        boolean isNeedSetData = false;
        return this.stringToValueForHistoryOrMyCommonUse(t, isNeedSetData);
    }

    public Map[] getConditionMaps(String t) {
        int size = 0;
        if (this.commitFormatters != null) {
            size = this.commitFormatters.size();
        } else {
            this.commitFormatters = new ArrayList(1);
        }
        BizDataFormatter df = null;
        if (size < 1) {
            return null;
        }
        size = this.commitFormatters.size();
        Map[] maps = new Map[size];
        int realSize = 0;
        Map map = null;
        for (int i = 0; i < size; ++i) {
            df = (BizDataFormatter)this.commitFormatters.get(i);
            if (df == null || (map = (Map)df.stringToValue(t)) == null || map.isEmpty()) continue;
            maps[realSize] = map;
            ++realSize;
        }
        if (realSize > 0) {
            Map[] ret = new Map[realSize];
            for (int i = 0; i < realSize; ++i) {
                ret[i] = maps[i];
            }
            return ret;
        }
        return null;
    }

    protected Object[] buildReturnValue(QueryAgent agent, IRowSet rw, int size) {
        ArrayList<IObjectValue> result = new ArrayList<IObjectValue>();
        Object value = null;
        String id = "";
        String mainKey = BosHelper.getMainObjectPKField(this.getQueryInfoPK());
        if (rw == null || StringUtil.isEmptyString((String)mainKey)) {
            return result.toArray();
        }
        try {
            HashSet<String> ids = new HashSet<String>();
            rw.beforeFirst();
            for (int i = 0; i < size; ++i) {
                if (!rw.next() || (value = rw.getObject(mainKey)) == null) continue;
                id = value.toString();
                ids.add(id);
            }
            BOSObjectType type = BosHelper.getMainEntityType(this.getQueryInfoPK());
            EntityViewInfo evInfo = new EntityViewInfo();
            FilterInfo fInfo = new FilterInfo();
            fInfo.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            evInfo.setFilter(fInfo);
            evInfo.getSelector().addObjectCollection((IObjectCollection)agent.getSelectorCollection());
            IObjectCollection coll = DynamicObjectFactory.getRemoteInstanceWithObjectContext((Context)this.getF7Context()).getCollection(type, evInfo);
            int count = coll.size();
            for (int i = 0; i < count; ++i) {
                IObjectValue ov = coll.getObject(i);
                result.add(ov);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return result.toArray();
    }

    protected IParser createParser(String pattern) {
        return new DefaultParser(pattern, this);
    }

    public void setHasHideQuichFilterPanel(boolean hasHideQucikFilterPanel) {
        this.hasHideQuichFilterPanel = hasHideQucikFilterPanel;
    }

    public boolean getIsHideQuichFilterPanel() {
        return this.hasHideQuichFilterPanel;
    }

    protected void configSelector(Object param) {
        super.configSelector(param);
        if (this.selector instanceof KDCommonPromptDialog) {
            KDCommonPromptDialog dlg = (KDCommonPromptDialog)this.selector;
            if (this.isRefresh()) {
                dlg.setQueryInfo(this.queryAgent.getQueryInfoPK());
                dlg.setEntityViewInfo(this.queryAgent.getRuntimeEntityView());
                dlg.setSelectorCollection(this.queryAgent.getSelectorCollection());
                dlg.setQueryExecutor(this.queryAgent.getQueryExecutor());
                this.setRefresh(false);
            }
            dlg.setMainOrgContext(this.queryAgent.getMainOrgContext());
            dlg.setMainBizOrgsType(this.getMainBizOrgsType());
            dlg.setMainBizOrgs(this.getMainBizOrgs());
            dlg.setCurrentMainBizOrgUnit(this.getCurrentMainBizOrgUnit());
            dlg.setEnabledMultiSelection(this.queryAgent.isEnabledMultiSelection());
            dlg.setReturnValueType(this.queryAgent.getReturnValueType());
            dlg.setUseCacheObject(this.isUseCacheObject());
            dlg.setEnableToMaintainBizdata(this.getEnableToMaintainBizdata());
            dlg.setIsDefaultFilterFieldsEnabled(this.getIsDefaultFilterFieldsEnabled());
            dlg.addCommonF7KDTableListener(this.cmF7TblListener);
            dlg.setHasHideQuichFilterPanel(this.getIsHideQuichFilterPanel());
            dlg.setLastData(this.getData());
            dlg.setMergeColumnKeys(this.getMergeColumnKeys());
            dlg.setPrecisionColumns(this.getPrecisionColumns());
            dlg.setPrecisionDisplayColumns(this.getPrecisionDisplayColumns());
            dlg.setResizable(true);
            dlg.setParentF7(this);
        }
        if (this.selector instanceof AbstractPromptSelector) {
            AbstractPromptSelector abstractPromptSelector = (AbstractPromptSelector)this.selector;
            abstractPromptSelector.setBizPromptBox(this);
        }
    }

    protected Object popupSelector(Object param) {
        Object ret = super.popupSelector(param);
        if (this.selector instanceof KDCommonPromptDialog && !this.isEnabledMultiSelection() && ret != DEFAULTVALUE) {
            Object[] d;
            if (ret == BADVALUE) {
                ret = null;
            } else if (ret instanceof Object[] && (d = (Object[])ret) != null && d.length > 0) {
                ret = d[0];
            }
        }
        this.queryAgent.resetRuntimeEntityView();
        return ret;
    }

    protected MetaDataPK getQueryInfoPK() {
        return this.queryAgent.getQueryInfoPK();
    }

    protected void setQueryInfoPK(MetaDataPK pk) {
        this.queryAgent.setQueryInfoPK(pk);
    }

    public SelectorItemCollection getSelectorCollection() {
        return this.queryAgent.getSelectorCollection();
    }

    public void setSelectorCollection(SelectorItemCollection selectorCollection) {
        this.queryAgent.setSelectorCollection(selectorCollection);
    }

    public boolean isEnabledMultiSelection() {
        return this.queryAgent.isEnabledMultiSelection();
    }

    public void setEnabledMultiSelection(boolean b) {
        boolean multiSelection = this.queryAgent.isEnabledMultiSelection();
        if (multiSelection != b) {
            Object[] os = null;
            if (multiSelection) {
                os = (Object[])this.getData();
                if (os != null && os.length > 0) {
                    this.setData(os[0]);
                } else {
                    this.setData(null);
                }
            } else {
                os = new Object[]{this.getData()};
                this.setData(os);
            }
            this.queryAgent.setEnabledMultiSelection(b);
        }
    }

    public int getReturnValueType() {
        return this.queryAgent.getReturnValueType();
    }

    public void setReturnValueType(int returnValueType) {
        this.queryAgent.setReturnValueType(returnValueType);
    }

    public IBadValueHandler getBadValueHandler() {
        return this.badHandler;
    }

    public void setBadValueHandler(IBadValueHandler handler) {
        this.badHandler = handler;
    }

    protected void handleBadValue(int when, Object value) {
        IBadValueHandler handler = this.getBadValueHandler();
        if (handler != null) {
            handler.handleBadValue((Component)((Object)this), value.toString());
        } else {
            super.handleBadValue(when, value);
        }
    }

    public void updateUI() {
        this.setUI(KingdeeBizPromptBoxUI.createUI((JComponent)((Object)this)));
    }

    public Class getDataType() {
        return null;
    }

    public void setDataType(Class cl) {
    }

    public void setDataType(String className) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setRefresh(true);
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean b) {
        this.refresh = b;
    }

    public void setDefaultF7UIName(String className) {
        this.setSelector(null);
        this.defaultF7UIName = className;
    }

    public String getDefaultF7UIName() {
        return this.defaultF7UIName;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(Object data) {
        this.userData = data;
    }

    public void putMaintainUIContext(Object key, Object value) {
        this.maintainUIContext.put(key, value);
    }

    public UIContext gettMaintainUIContext() {
        return this.maintainUIContext;
    }

    protected KDPromptSelector createDefaultF7UIByName(String className) {
        KDPromptSelector sel = null;
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        Class[] params = null;
        try {
            Class<?> cl = Class.forName(className);
            if (parent instanceof Dialog) {
                params = new Class[]{Dialog.class};
                Constructor<?> ctr = cl.getConstructor(params);
                sel = (KDPromptSelector)ctr.newInstance(parent);
            } else if (parent instanceof Frame) {
                params = new Class[]{Frame.class};
                Constructor<?> ctr = cl.getConstructor(params);
                sel = (KDPromptSelector)ctr.newInstance(parent);
            } else {
                sel = (KDPromptSelector)cl.newInstance();
            }
            if (sel != null && sel instanceof IKDCommonPromptSelector) {
                ((IKDCommonPromptSelector)sel).setMaintainUIContext(this.gettMaintainUIContext());
            }
        }
        catch (SecurityException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return sel;
    }

    public boolean isUseCacheObject() {
        return this.useCacheObject;
    }

    public void setUseCacheObject(boolean b) {
        this.useCacheObject = b;
    }

    private KDPromptSelector createSpecialSelector() {
        String extendedProperty = "defaultF7UI";
        Class[] specialConstructorParam = new Class[]{HashMap.class};
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("EntityViewInfo", this.queryAgent.getRuntimeEntityView());
        hm.put("HasCUDefaultFilter", new Boolean(this.getHasCUDefaultFilter()));
        hm.put("EnableMultiSelection", new Boolean(this.isEnabledMultiSelection()));
        hm.put("UseCacheObject", new Boolean(this.isUseCacheObject()));
        hm.put("IsRefresh", new Boolean(this.isRefresh()));
        hm.put("BadHandler", this.getBadHandler());
        hm.put("BadValueHandler", this.getBadValueHandler());
        hm.put("ReturnValueType", new Integer(this.getReturnValueType()));
        hm.put("UserData", this.getUserData());
        hm.put("SelectorCollection", this.getSelectorCollection());
        hm.put("QueryExecutor", this.queryAgent.getQueryExecutor());
        Object[] specialConstructorValue = new Object[]{hm};
        String specialSelectorName = null;
        SimpleQuery query = BosHelper.getQuery(this.queryAgent.getQueryInfoPK());
        if (query != null) {
            specialSelectorName = query.getExtendedProperty("defaultF7UI");
        }
        if (specialSelectorName == null || specialSelectorName.equals("")) {
            return null;
        }
        Object specialSelectorObject = null;
        try {
            Class<?> specialSelectorClass = Class.forName(specialSelectorName);
            Constructor<?> specialSelectorConstructor = specialSelectorClass.getDeclaredConstructor(specialConstructorParam);
            specialSelectorObject = specialSelectorConstructor.newInstance(specialConstructorValue);
        }
        catch (Exception e) {
            return null;
        }
        if (specialSelectorObject == null || !(specialSelectorObject instanceof KDPromptSelector)) {
            return null;
        }
        if (specialSelectorObject instanceof IKDCommonPromptSelector) {
            ((IKDCommonPromptSelector)specialSelectorObject).setMaintainUIContext(this.gettMaintainUIContext());
        }
        return specialSelectorObject;
    }

    public void setLabelVisible(boolean isVisible) {
        super.setLabelVisible(isVisible);
        if (this.isLabelVisible()) {
            this.setDisplayFormatInnerly("$number$");
        }
    }

    private void setDisplayFormatInnerly(String displayFormatStr) {
        IFormatter f = this.getDisplayFormatter();
        if (f != null) {
            f.applyPattern(displayFormatStr);
        } else {
            this.setDisplayFormatter(BizFormatterFactory.getFormatter(displayFormatStr));
        }
    }

    public void updateData() {
        super.updateData();
        if (this.isLabelVisible()) {
            Object o = this.getData();
            if (o != null && o instanceof IObjectValue) {
                IObjectValue iov = (IObjectValue)o;
                String theName = (String)iov.get("name");
                this.setLabelText(theName);
            } else {
                this.setLabelText("");
            }
        }
    }

    public void setDataBySelector() {
        if (this.selector == null || this.selector.getClass().getName().equals(KDCommonPromptDialog.class.getName())) {
            this.configDefaultFilterFromFilterInfoProducer();
        }
        super.setDataBySelector();
    }

    public void commitEdit() throws ParseException {
        if (this.hasDownPanel() && this.hasDownPanelSelected() && !StringUtils.isEmpty((String)((KDTextField)this.getEditor()).getText())) {
            return;
        }
        this.configDefaultFilterFromFilterInfoProducer();
        if (this.isDirty()) {
            this.setHasCommitEdit(true);
            this.assistor.setCloseAble(false);
            this.commitEditImmediately();
            this.assistor.setCloseAble(true);
            if (this.assistor.isShowing()) {
                this.assistor.setShowing(false);
            }
            if (this.isDirty()) {
                DataErrorEvent event = new DataErrorEvent((Object)this);
                this.fireDataErrorDialog(event);
                throw new ParseException("KDPromptBox commit error!", 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitEditImmediately() {
        IMainUIContainer ui = SystemEntry.instance.getCurrenContainer();
        NewMainFrame mainFrame = null;
        if (ui != null && ui instanceof NewMainFrame && (mainFrame = (NewMainFrame)ui) != null) {
            mainFrame.setCursor(Cursor.getPredefinedCursor(3));
        }
        try {
            Object newData = null;
            String newText = this.edt.getText();
            if (newText != null && newText.length() > 0) {
                if (!this.doFireCommitEvent(newText)) {
                    return;
                }
                newData = this.stringToValue(newText);
            }
            if (newData == BADVALUE) {
                this.setData(BADVALUE);
                this.handleBadValue(1, newText);
            } else if (newData == DEFAULTVALUE) {
            } else {
                this.setData(newData, true);
            }
        }
        finally {
            if (mainFrame != null) {
                mainFrame.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void configDefaultFilterFromFilterInfoProducer() {
        this.queryAgent.setHasCUDefaultFilter(false);
        if (this.ifip == null) {
            this.setFilterInfoProducer(FilterInfoProducerFactory.getControlTypeFilterInfoProducer(this.getQueryInfoPK(), this.hasCUDefaultFilter));
        }
        if (this.currentMainBizOrgUnit != null && this.ifip != null) {
            this.ifip.setCurrentCtrlUnit(this.currentMainBizOrgUnit.getCU());
        }
        this.queryAgent.setDefaultFilterInfo(this.ifip.getFilterInfo());
    }

    private void configDefaultFilterFromFilterInfoProducer(boolean isCufilter) {
        this.queryAgent.setHasCUDefaultFilter(isCufilter);
        if (this.ifip == null) {
            this.setFilterInfoProducer(FilterInfoProducerFactory.getControlTypeFilterInfoProducer(this.getQueryInfoPK(), this.hasCUDefaultFilter));
        }
        if (this.currentMainBizOrgUnit != null && this.ifip != null) {
            this.ifip.setCurrentCtrlUnit(this.currentMainBizOrgUnit.getCU());
        }
        this.queryAgent.setDefaultFilterInfo(this.ifip.getFilterInfo());
    }

    public void setFilterInfoProducer(IFilterInfoProducer ifip) {
        this.ifip = ifip;
        if (ifip != null) {
            if (this.currentCtrlUnit != null) {
                ifip.setCurrentCtrlUnit(this.currentCtrlUnit);
            }
            if (this.currentMainBizOrgUnit != null && this.currentMainBizOrgUnitType != null) {
                ifip.setCurrentMainBizOrgUnit(this.currentMainBizOrgUnit, this.currentMainBizOrgUnitType);
            }
            if (this.mainBizOrgs != null && this.typeOfMainBizOrgs != null && ifip instanceof IMultiOUsFilterInfoProducer) {
                ((IMultiOUsFilterInfoProducer)ifip).setMainBizOrgs(this.mainBizOrgs, this.typeOfMainBizOrgs);
            }
        }
        this.setRefresh(true);
    }

    public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
        this.currentCtrlUnit = cui;
        if (this.ifip != null && cui != null) {
            this.ifip.setCurrentCtrlUnit(cui);
        }
        this.figureOutWhetherEnableToMaintainBizdata(cui);
        this.setRefresh(true);
    }

    public CtrlUnitInfo getCurrentCtrlUnit() {
        return this.currentCtrlUnit;
    }

    public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
        this.setCurrentMainBizOrgUnit(oui, ot, this.getF7Context());
    }

    public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot, Context mainOrgContext) {
        this.currentMainBizOrgUnit = oui;
        this.currentMainBizOrgUnitType = ot;
        if (this.ifip != null && oui != null && ot != null) {
            this.ifip.setCurrentMainBizOrgUnit(oui, ot);
            if (mainOrgContext != null) {
                this.queryAgent.setMainOrgContext(mainOrgContext);
            } else {
                this.queryAgent.switchMainOrgContext(oui.getId().toString());
            }
            this.ifip.setCurrentCtrlUnit(oui.getCU());
        }
        this.setRefresh(true);
    }

    public void setF7Context(Context f7Context) {
        this.queryAgent.setMainOrgContext(f7Context);
    }

    public Context getF7Context() {
        return this.queryAgent.getMainOrgContext();
    }

    public OrgUnitInfo getCurrentMainBizOrgUnit() {
        return this.currentMainBizOrgUnit;
    }

    public OrgType getCurrentMainBizOrgUnitType() {
        return this.currentMainBizOrgUnitType;
    }

    public void setEnableToMaintainBizdata(boolean enabled) {
        this.isEnabledToMaintainBizdata = enabled;
    }

    public boolean getEnableToMaintainBizdata() {
        return this.isEnabledToMaintainBizdata;
    }

    public boolean isDynQueryEnabled() {
        return this.isDynQueryEnabled;
    }

    public void setDynQueryEnabled(boolean isDynQueryEnabled) {
        this.isDynQueryEnabled = isDynQueryEnabled;
    }

    private void figureOutWhetherEnableToMaintainBizdata(CtrlUnitInfo cui) {
        BOSUuid currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId();
        BOSUuid givenCUID = cui.getId();
        this.setEnableToMaintainBizdata(currentCUID.equals((Object)givenCUID));
    }

    public void setMainBizOrgs(OrgUnitCollection ouc, OrgType ot) {
        this.setMainBizOrgs(ouc, ot, this.getF7Context());
    }

    public void setMainBizOrgs(OrgUnitCollection ouc, OrgType ot, Context mainOrgContext) {
        this.mainBizOrgs = ouc;
        this.typeOfMainBizOrgs = ot;
        if (this.ifip != null && ouc != null && ot != null && this.ifip instanceof IMultiOUsFilterInfoProducer) {
            ((IMultiOUsFilterInfoProducer)this.ifip).setMainBizOrgs(ouc, ot);
        }
        if (ouc != null && ouc.size() > 0) {
            OrgUnitInfo ouInfo = ouc.get(0);
            String orgID = ouInfo.getId().toString();
            if (mainOrgContext != null) {
                this.queryAgent.setMainOrgContext(mainOrgContext);
            } else {
                this.queryAgent.switchMainOrgContext(orgID);
            }
        }
        this.setRefresh(true);
    }

    public OrgUnitCollection getMainBizOrgs() {
        return this.mainBizOrgs;
    }

    public OrgType getMainBizOrgsType() {
        return this.typeOfMainBizOrgs;
    }

    public void setIsDefaultFilterFieldsEnabled(boolean enabled) {
        this.isDefaultFilterFieldsEnabled = enabled;
    }

    public boolean getIsDefaultFilterFieldsEnabled() {
        return this.isDefaultFilterFieldsEnabled;
    }

    public void addCommonF7KDTableListener(CommonF7KDTableListener listener) {
        this.cmF7TblListener = listener;
    }

    public CommonF7KDTableListener getCommonF7KDTableListener() {
        return this.cmF7TblListener;
    }

    public String[] getMergeColumnKeys() {
        return this.mergeColumnKeys;
    }

    public void setMergeColumnKeys(String[] mergeColumnKeys) {
        this.mergeColumnKeys = mergeColumnKeys;
    }

    public String[] getPrecisionColumns() {
        return this.precisionColumns;
    }

    public void setPrecisionColumns(String[] precisionColumns) {
        this.precisionColumns = precisionColumns;
    }

    public String[] getPrecisionDisplayColumns() {
        return this.precisionDisplayColumns;
    }

    public void setPrecisionDisplayColumns(String[] precisionDisplayColumns) {
        this.precisionDisplayColumns = precisionDisplayColumns;
    }

    public static Context createF7Context(String orgId) throws Exception {
        Context ctx = new Context();
        FrameWorkUtils.switchOrg((Context)ctx, (String)orgId);
        return ctx;
    }

    public void setOnlyReturn(boolean isOnlyReturn) {
        this.isOnlyReturn = isOnlyReturn;
    }

    public boolean isOnlyReturn() {
        return this.isOnlyReturn;
    }

    protected void setData(Object newdata, boolean postEvent, boolean notify) {
        if (newdata == null) {
            super.setData(newdata, postEvent, notify);
            return;
        }
        if (this.edt instanceof KDTextField && this.isHistoryRecordEnabled) {
            if (newdata instanceof AbstractBaseObjectValue) {
                AbstractBaseObjectValue data = (AbstractBaseObjectValue)newdata;
                String idFormatter = "id";
                String editFormatter = "number";
                String displayFormatter = "name";
                String idStr = "";
                String displayStr = " ";
                String editValue = " ";
                if (data.get(idFormatter) != null) {
                    idStr = data.get(idFormatter).toString();
                }
                if (idStr == null) {
                    super.setData(newdata, postEvent, notify);
                    return;
                }
                if (data.get(editFormatter) != null) {
                    editValue = data.get(editFormatter).toString();
                }
                if (data.get(displayFormatter) != null) {
                    displayStr = data.get(displayFormatter).toString();
                }
                if (!" ".equals(editValue)) {
                    this.assistor.memorizeAssistorInfo(idStr + "\t" + editValue + "\t" + displayStr);
                }
            } else if (newdata instanceof AbstractBaseObjectValue[]) {
                AbstractBaseObjectValue data = null;
                String idFormatter = "id";
                String editFormatter = "number";
                String displayFormatter = "name";
                String idStr = "";
                String displayStr = " ";
                String editValue = " ";
                for (int i = 0; i < ((AbstractBaseObjectValue[])newdata).length; ++i) {
                    data = ((AbstractBaseObjectValue[])newdata)[i];
                    idStr = "";
                    displayStr = " ";
                    editValue = " ";
                    if (data.get(idFormatter) != null) {
                        idStr = data.get(idFormatter).toString();
                    }
                    if (idStr == null) {
                        super.setData(newdata, postEvent, notify);
                        return;
                    }
                    if (data.get(editFormatter) != null) {
                        editValue = data.get(editFormatter).toString();
                    }
                    if (data.get(displayFormatter) != null) {
                        displayStr = data.get(displayFormatter).toString();
                    }
                    if (" ".equals(editValue) || " ".equals(displayStr)) continue;
                    this.assistor.memorizeAssistorInfo(idStr + "\t" + editValue + "\t" + displayStr);
                }
            } else if (newdata instanceof Object[]) {
                AbstractBaseObjectValue data = null;
                String idFormatter = "id";
                String editFormatter = "number";
                String displayFormatter = "name";
                String idStr = "";
                String displayStr = " ";
                String editValue = " ";
                for (int i = 0; i < ((Object[])newdata).length; ++i) {
                    if (((Object[])newdata)[i] == null || !(((Object[])newdata)[i] instanceof AbstractBaseObjectValue)) continue;
                    data = (AbstractBaseObjectValue)((Object[])newdata)[i];
                    idStr = "";
                    displayStr = " ";
                    editValue = " ";
                    if (data.get(idFormatter) != null) {
                        idStr = data.get(idFormatter).toString();
                    }
                    if (idStr == null) {
                        super.setData(newdata, postEvent, notify);
                        return;
                    }
                    if (data.get(editFormatter) != null) {
                        editValue = data.get(editFormatter).toString();
                    }
                    if (data.get(displayFormatter) != null) {
                        displayStr = data.get(displayFormatter).toString();
                    }
                    if (" ".equals(editValue) || " ".equals(displayStr)) continue;
                    this.assistor.memorizeAssistorInfo(idStr + "\t" + editValue + "\t" + displayStr);
                }
            } else if (newdata instanceof String) {
                this.assistor.memorizeAssistorInfo((String)newdata);
            }
        }
        super.setData(newdata, postEvent, notify);
    }

    public void popupDownPanel(Object param) {
        if (this.isDynQueryEnabled) {
            super.popupDownPanel(param);
        }
    }

    public FilterFieldItem[] getFilterFields() {
        int i;
        if (this.queryAgent.getQueryInfoPK() == null) {
            return null;
        }
        ArrayList<FilterFieldItem> al = new ArrayList<FilterFieldItem>();
        SimpleQuery query = BosHelper.getQuery(this.queryAgent.getQueryInfoPK());
        SimplePropertyUnitCollection spuCol = query.propertyUnits().getCommonQueryFilter();
        if (spuCol != null) {
            SimplePropertyUnit spu = null;
            ConstDataType cdt = null;
            int size = spuCol.size();
            for (i = 0; i < size; ++i) {
                spu = spuCol.get(i);
                try {
                    cdt = spu.getReturnType();
                }
                catch (Exception e) {
                    cdt = ConstDataType.STRING;
                }
                if (cdt.equals((Object)ConstDataType.DATE) || cdt.equals((Object)ConstDataType.BOOLEAN) || cdt.equals((Object)ConstDataType.TIME) || cdt.equals((Object)ConstDataType.TIMESTAMP) || spu.isReturnTypeEnum()) continue;
                al.add(new FilterFieldItem(spu.getName(), spu.getDisplayName(), cdt));
            }
        }
        int sizeOfAL = al.size();
        FilterFieldItem[] ffis = new FilterFieldItem[sizeOfAL];
        for (i = 0; i < sizeOfAL; ++i) {
            ffis[i] = (FilterFieldItem)al.get(i);
        }
        if (ffis.length == 0 && this.isDefaultFilterFieldsEnabled) {
            ffis = new FilterFieldItem[]{new FilterFieldItem("number", this.getMLS("number", "Number"), ConstDataType.STRING), new FilterFieldItem("name", this.getMLS("name", "Name"), ConstDataType.STRING)};
        }
        ffis = this.addNumberNameCompFilter(ffis);
        this.allFilterFieldName = query.getExtendedProperty("allFilterFieldName");
        if (this.allFilterFieldName != null) {
            String allFilterFieldDesc = this.getMLS("numbernamehelpcode", "number+name+helpcode");
            FilterFieldItem ffisall = new FilterFieldItem(this.allFilterFieldName, allFilterFieldDesc, ConstDataType.STRING);
            FilterFieldItem[] rtFf = new FilterFieldItem[ffis.length + 1];
            rtFf[0] = ffisall;
            System.arraycopy(ffis, 0, rtFf, 1, ffis.length);
            ffis = rtFf;
        }
        return ffis;
    }

    private FilterFieldItem[] addNumberNameCompFilter(FilterFieldItem[] ff) {
        if (ff != null) {
            int count = 0;
            for (int i = 0; i < ff.length; ++i) {
                if (ff[i] != null && "number".equals(ff[i].getName())) {
                    ++count;
                    continue;
                }
                if (ff[i] == null || !"name".equals(ff[i].getName())) continue;
                ++count;
            }
            if (count == 2) {
                FilterFieldItem ffis = new FilterFieldItem(numberAndName, this.getMLS("number", "Number") + "+" + this.getMLS("name", "Name"), ConstDataType.STRING);
                FilterFieldItem[] rtFf = new FilterFieldItem[ff.length + 1];
                rtFf[0] = ffis;
                System.arraycopy(ff, 0, rtFf, 1, ff.length);
                ff = rtFf;
            }
        }
        return ff;
    }

    private String getMLS(String key, String defaultValue) {
        Locale local = Locale.getDefault();
        if (local.toString().toLowerCase().indexOf("l") >= 0) {
            local = this.shortToLong(local);
        }
        return LanguageManager.getLangMessage((String)key, (String)"com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog", (Locale)local, (String)defaultValue);
    }

    private Locale shortToLong(Locale local) {
        if ("l2".equalsIgnoreCase(local.toString())) {
            return Locale.SIMPLIFIED_CHINESE;
        }
        if ("l3".equalsIgnoreCase(local.toString())) {
            return Locale.TRADITIONAL_CHINESE;
        }
        if ("l1".equalsIgnoreCase(local.toString())) {
            return Locale.ENGLISH;
        }
        logger.info((Object)"KDCommonPromptDialog.shortToLong ,illegal Locale!");
        return local;
    }

    public void setQuickQureyEntityViewInfo(EntityViewInfo quickQueryEvi) {
        this.quickQueryEvi = quickQueryEvi;
    }

    public EntityViewInfo getQuickQureyEntityViewInfo() {
        return this.quickQueryEvi;
    }

    public boolean isQuickQueryEnable() {
        return this.isQuickQueryEnable;
    }

    public void setQuickQueryEnable(boolean isQuickQueryEnable) {
        this.isQuickQueryEnable = isQuickQueryEnable;
        if (!isQuickQueryEnable) {
            this.assistor.uninstallListeners();
        }
    }

    public boolean isHRHistoryEnbable() {
        return this.isHRHistoryEnbable;
    }

    public void setHRHistoryEnbable(boolean isHRHistoryEnbable) {
        this.isHRHistoryEnbable = isHRHistoryEnbable;
    }

    public boolean isHRCommonUseEnbable() {
        return this.isHRCommonUseEnbable;
    }

    public void setHRCommonUseEnbable(boolean isHRCommonUseEnbable) {
        this.isHRCommonUseEnbable = isHRCommonUseEnbable;
    }

    public static class FilterFieldItem {
        private String ffiName;
        private String ffiDisplayName;
        private ConstDataType fficdt;

        FilterFieldItem(String name, String displayName, ConstDataType cdt) {
            this.ffiName = name;
            this.ffiDisplayName = displayName;
            this.fficdt = cdt;
        }

        public String toString() {
            return this.ffiDisplayName;
        }

        public String getName() {
            return this.ffiName;
        }

        public ConstDataType getType() {
            return this.fficdt;
        }
    }

    public static class DefultBadValueHandler
    implements IBadValueHandler {
        @Override
        public void handleBadValue(Component c, String text) {
            JDialog dlg = null;
            Window parent = SwingUtilities.getWindowAncestor(c);
            dlg = parent instanceof Dialog ? new JDialog((Dialog)parent) : (parent instanceof Frame ? new JDialog((Frame)parent) : new JDialog());
            dlg.setTitle("bad value");
            dlg.setModal(true);
            dlg.setVisible(true);
            dlg.dispose();
        }
    }

    public static interface IBadValueHandler {
        public void handleBadValue(Component var1, String var2);
    }

    public static class DefaultParser
    implements IParser {
        protected KDBizPromptBox prompt = null;
        protected static final int MAXSIZE = 1;
        EntityViewInfo quickQueryEvi = new EntityViewInfo();
        private KDPromptSelector selector;

        @Override
        public void setQuickQureyEntityViewInfo(EntityViewInfo quickQueryEvi) {
            this.quickQueryEvi = quickQueryEvi;
        }

        public EntityViewInfo getQuickQureyEntityViewInfo() {
            return this.quickQueryEvi;
        }

        public DefaultParser(KDBizPromptBox pb) {
            this.prompt = pb;
        }

        public DefaultParser(String str, KDBizPromptBox pb) {
            this.prompt = pb;
            this.applyPattern(str);
        }

        @Override
        public void applyPattern(String pattern) {
            String[] str = null;
            if (!StringUtil.isEmptyString((String)pattern)) {
                str = pattern.split(";");
            }
            if (str != null && str.length > 0) {
                BizDataFormatter bf = null;
                if (this.prompt.commitFormatters == null) {
                    this.prompt.commitFormatters = new ArrayList();
                }
                if (!this.prompt.commitFormatters.isEmpty()) {
                    this.prompt.commitFormatters.clear();
                }
                for (int i = 0; i < str.length; ++i) {
                    if (StringUtil.isEmptyString((String)str[i])) continue;
                    bf = BizFormatterFactory.getFormatter(str[i]);
                    this.prompt.commitFormatters.add(bf);
                }
            }
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            if (this.prompt.commitFormatters != null) {
                BizDataFormatter df = null;
                int size = this.prompt.commitFormatters.size();
                for (int i = 0; i < size; ++i) {
                    df = (BizDataFormatter)this.prompt.commitFormatters.get(i);
                    if (df != null) {
                        str.append(df.toString());
                    }
                    if (i >= size - 1) continue;
                    str.append(';');
                }
            }
            return str.toString();
        }

        @Override
        public Object stringToValue(String t) {
            if (t != null && t.indexOf("\t") > 0) {
                t = t.substring(0, t.lastIndexOf("\t"));
            }
            if (StringUtil.isEmptyString((String)t)) {
                return null;
            }
            QueryAgent agent = this.prompt.getQueryAgent();
            if (agent == null) {
                return null;
            }
            String extendImpClassName = this.getExtendImpClassName(BosHelper.getQuery(agent.getQueryInfoPK()));
            Object o = new Object();
            o = extendImpClassName == null || extendImpClassName.length() == 0 ? this.stringToValueImp(t, agent, KDPromptBox.DEFAULTVALUE) : this.stringToValueExtendImp(t, agent, KDPromptBox.DEFAULTVALUE, extendImpClassName);
            agent.resetRuntimeEntityView();
            return o;
        }

        protected String getExtendImpClassName(SimpleQuery queryInfo) {
            if (queryInfo == null) {
                return null;
            }
            String className = queryInfo.getExtendedProperty("f7QueryClassName");
            if (className == null) {
                className = queryInfo.getExtendedProperty("f7queryclassname");
            }
            return className;
        }

        protected Object stringToValueExtendImp(String t, QueryAgent agent, Object defaultValue, String className) {
            try {
                Class<?> classDefinition = Class.forName(className);
                IF7ObjectProvider provider = (IF7ObjectProvider)classDefinition.newInstance();
                UIContext uictx = this.prompt.maintainUIContext;
                uictx.put((Object)"F7", (Object)this.prompt);
                EntityViewInfo eviFromAgent = null;
                try {
                    eviFromAgent = new EntityViewInfo(agent.getRuntimeEntityView().toString());
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                String queryInfo = this.prompt.getQueryInfo();
                queryInfo = queryInfo.replaceAll("\\\\", ".");
                ExtendResultObject ero = provider.stringToValueImp(t, queryInfo, agent.getRuntimeEntityView(), this.prompt.getCurrentMainBizOrgUnit(), uictx);
                if (ero == null || !ero.isExecuteQuery()) {
                    return this.stringToValueImp(t, agent, KDPromptBox.DEFAULTVALUE);
                }
                IRowSet rowset = ero.getRowset();
                Object o = defaultValue;
                if (rowset == null) {
                    return defaultValue;
                }
                int size = rowset.size();
                if (size < 1) {
                    return defaultValue;
                }
                o = agent.isEnabledMultiSelection() ? (size > 1 ? this.getDataBySelector(rowset, agent, o, eviFromAgent) : this.buildReturnValue(agent, rowset, size)) : (size > 1 ? this.getDataBySelector(rowset, agent, o, eviFromAgent) : this.buildReturnValue(agent, rowset, 1)[0]);
                return o;
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                return defaultValue;
            }
        }

        protected Object stringToValueImp(String t, QueryAgent agent, Object defaultValue) {
            Object o = defaultValue;
            int PAGELENGTH = 100;
            Map[] maps = this.getConditionMaps(t);
            this.prompt.getQueryAgent().setQueryExecutor(null);
            IRowSet equalRowSet = null;
            if (this.prompt.getSelector() instanceof IKDPromptIsCUSelector) {
                IKDPromptIsCUSelector isCUSelector = (IKDPromptIsCUSelector)this.prompt.getSelector();
                boolean orgF7isCuFilter = isCUSelector.isCUFilter();
                this.prompt.getQueryAgent().setHasCUDefaultFilter(orgF7isCuFilter);
            } else {
                this.prompt.getQueryAgent().setHasCUDefaultFilter(false);
            }
            if (!this.prompt.getQueryAgent().upgradeEntityViewFromOriginEqual(maps)) {
                logger.info((Object)"warning: view set filter failed!");
                return defaultValue;
            }
            EntityViewInfo eviFromAgent = null;
            try {
                eviFromAgent = new EntityViewInfo(this.prompt.getQueryAgent().getRuntimeEntityView().toString());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            equalRowSet = this.prompt.getQueryAgent().executeQuery(0, 100);
            int equalRowSetSize = 0;
            if (equalRowSet != null) {
                equalRowSetSize = equalRowSet.size();
            }
            if (equalRowSetSize == 1 && this.prompt.isOnlyReturn) {
                o = agent.isEnabledMultiSelection() ? this.buildReturnValue(this.prompt.getQueryAgent(), equalRowSet, 1) : ((o = this.buildReturnValue(this.prompt.getQueryAgent(), equalRowSet, 1)) != null && o instanceof Object[] && ((Object[])o).length > 0 ? o[0] : defaultValue);
                return o;
            }
            this.prompt.getQueryAgent().setQueryExecutor(null);
            IRowSet likeRowSet = null;
            IRowSet rowSet = null;
            if (!this.prompt.getQueryAgent().upgradeEntityViewFromOriginLike(maps)) {
                logger.info((Object)"warning: view set filter failed!");
                return defaultValue;
            }
            likeRowSet = this.prompt.getQueryAgent().executeQuery(0, 100 - equalRowSetSize);
            this.prompt.getQueryAgent().resetRuntimeEntityView();
            try {
                if (equalRowSet != null) {
                    if (likeRowSet == null) {
                        rowSet = equalRowSet;
                    } else {
                        rowSet = DynamicRowSet.create((IRowSet)equalRowSet);
                        ((DynamicRowSet)rowSet).insertRows(equalRowSet);
                        ((DynamicRowSet)rowSet).insertRows(likeRowSet);
                        rowSet.beforeFirst();
                    }
                } else {
                    rowSet = likeRowSet;
                }
            }
            catch (SQLException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
            }
            if (rowSet == null) {
                return defaultValue;
            }
            int size = rowSet.size();
            if (size < 1) {
                return defaultValue;
            }
            this.prompt.getQueryAgent().setQueryExecutor(null);
            if (!this.prompt.getQueryAgent().upgradeEntityViewFromOrigin(maps)) {
                logger.info((Object)"warning: view set filter failed!");
                return defaultValue;
            }
            if (equalRowSetSize < 100) {
                try {
                    eviFromAgent = new EntityViewInfo(this.prompt.getQueryAgent().getEntityViewInfo().toString());
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            o = agent.isEnabledMultiSelection() ? (size > 1 ? this.getDataBySelector(rowSet, this.prompt.getQueryAgent(), o, eviFromAgent) : this.buildReturnValue(this.prompt.getQueryAgent(), rowSet, size)) : (size > 1 ? this.getDataBySelector(rowSet, this.prompt.getQueryAgent(), o, eviFromAgent) : this.buildReturnValue(this.prompt.getQueryAgent(), rowSet, 1)[0]);
            return o;
        }

        public Map[] getConditionMaps(String t) {
            int size = 0;
            if (this.prompt.commitFormatters != null) {
                size = this.prompt.commitFormatters.size();
            } else {
                this.prompt.commitFormatters = new ArrayList(1);
            }
            BizDataFormatter df = null;
            if (size < 1) {
                return null;
            }
            size = this.prompt.commitFormatters.size();
            Map[] maps = new Map[size];
            int realSize = 0;
            Map map = null;
            for (int i = 0; i < size; ++i) {
                df = (BizDataFormatter)this.prompt.commitFormatters.get(i);
                if (df == null || (map = (Map)df.stringToValue(t)) == null || map.isEmpty()) continue;
                maps[realSize] = map;
                ++realSize;
            }
            if (realSize > 0) {
                Map[] ret = new Map[realSize];
                for (int i = 0; i < realSize; ++i) {
                    ret[i] = maps[i];
                }
                return ret;
            }
            return null;
        }

        protected Object[] buildReturnValue(QueryAgent agent, IRowSet rw, int size) {
            ArrayList<IObjectValue> result = new ArrayList<IObjectValue>();
            Object value = null;
            String id = "";
            String mainKey = BosHelper.getMainObjectPKField(agent.getQueryInfoPK());
            if (rw == null || StringUtil.isEmptyString((String)mainKey)) {
                return result.toArray();
            }
            try {
                HashSet<String> ids = new HashSet<String>();
                rw.beforeFirst();
                for (int i = 0; i < size; ++i) {
                    if (!rw.next() || (value = rw.getObject(mainKey)) == null) continue;
                    id = value.toString();
                    ids.add(id);
                }
                BOSObjectType type = BosHelper.getQuery(agent.getQueryInfoPK()).mainEntity().getType();
                EntityViewInfo evInfo = new EntityViewInfo();
                FilterInfo fInfo = new FilterInfo();
                fInfo.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                evInfo.setFilter(fInfo);
                evInfo.getSelector().addObjectCollection((IObjectCollection)agent.getSelectorCollection());
                IObjectCollection coll = DynamicObjectFactory.getRemoteInstanceWithObjectContext((Context)this.prompt.getF7Context()).getCollection(type, evInfo);
                int count = coll.size();
                for (int i = 0; i < count; ++i) {
                    IObjectValue ov = coll.getObject(i);
                    result.add(ov);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            return result.toArray();
        }

        protected Object[] buildReturnValue_BAK(QueryAgent agent, IRowSet rw, int size) {
            Object[] ret = new Object[size];
            Object value = null;
            String id = "";
            boolean valid = true;
            boolean returnId = agent.getReturnValueType() == 1;
            String mainKey = BosHelper.getMainObjectPKField(agent.getQueryInfoPK());
            if (rw == null || StringUtil.isEmptyString((String)mainKey)) {
                return ret;
            }
            try {
                rw.beforeFirst();
                for (int i = 0; i < size; ++i) {
                    valid = rw.next();
                    if (!valid) continue;
                    value = rw.getObject(mainKey);
                    id = value != null ? value.toString() : "";
                    if (returnId) {
                        ret[i] = id;
                        continue;
                    }
                    if (id.length() <= 0) continue;
                    BOSObjectType boType = this.prompt.getBOSTypeFromQueryMainObject();
                    ret[i] = value = BosHelper.getRemoteValue(id, boType == null ? BOSUuid.read((String)id).getType() : boType, agent.getSelectorCollection());
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            return ret;
        }

        private Object getDataBySelector(IRowSet rowset, QueryAgent agent, Object defaultValue, EntityViewInfo eviFromAgent) {
            Object o = this.prompt.getClientProperty("poppable");
            if (o == Boolean.FALSE) {
                return null;
            }
            Object ret = this.popupSelectorImp(rowset, agent, eviFromAgent);
            if (!agent.isEnabledMultiSelection() && ret != KDPromptBox.DEFAULTVALUE) {
                if (ret == KDPromptBox.BADVALUE) {
                    ret = null;
                } else if (ret instanceof Object[]) {
                    Object[] d = (Object[])ret;
                    if (d != null && d.length > 0) {
                        ret = d[0];
                    }
                } else {
                    if (ret instanceof Object) {
                        return ret;
                    }
                    ret = null;
                }
            }
            if (ret == KDPromptBox.DEFAULTVALUE) {
                return defaultValue;
            }
            return ret;
        }

        private Object popupSelectorImp(Object param, QueryAgent agent, EntityViewInfo eviFromAgent) {
            this.selector = this.prompt.selector;
            if (this.selector != null && this.selector instanceof IKDPromptStringSelector) {
                try {
                    ((IKDPromptStringSelector)this.selector).setInputStringData(this.prompt.getText());
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                this.selector = this.createSelector();
            }
            if (this.selector instanceof KDCommonPromptDialog) {
                KDCommonPromptDialog dlg = (KDCommonPromptDialog)this.selector;
                dlg.setQueryInfo(agent.getQueryInfoPK());
                dlg.setEntityViewInfo(eviFromAgent);
                dlg.setSelectorCollection(agent.getSelectorCollection());
                dlg.setQueryExecutor(agent.getQueryExecutor());
                dlg.getQueryExecutor().setObjectView(agent.getRuntimeEntityView());
                dlg.setInnerFilter(agent.getRuntimeEntityView());
                dlg.setEnabledMultiSelection(agent.isEnabledMultiSelection());
                dlg.setReturnValueType(agent.getReturnValueType());
                dlg.putRowSet((IRowSet)param);
                dlg.setEnableToMaintainBizdata(this.prompt.getEnableToMaintainBizdata());
                dlg.setIsDefaultFilterFieldsEnabled(this.prompt.getIsDefaultFilterFieldsEnabled());
                dlg.addCommonF7KDTableListener(this.prompt.getCommonF7KDTableListener());
                dlg.setNullValue();
                dlg.setResizable(true);
                dlg.setParentF7(this.prompt);
                UIContext uiContext = dlg.getMaintainUIContext();
                if (uiContext == null) {
                    uiContext = new UIContext();
                    dlg.setMaintainUIContext(uiContext);
                }
                uiContext.put((Object)"inputText", (Object)this.prompt.getText());
            }
            this.selector.show();
            if (this.selector.isCanceled()) {
                return KDPromptBox.DEFAULTVALUE;
            }
            return this.selector.getData();
        }

        private KDPromptSelector createSelector() {
            KDPromptSelector sel = null;
            sel = this.prompt.createSpecialSelector();
            if (sel == null) {
                Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this.prompt));
                sel = parent instanceof Dialog ? new KDCommonPromptDialog((Dialog)parent) : (parent instanceof Frame ? new KDCommonPromptDialog((Frame)parent) : new KDCommonPromptDialog());
                ((KDCommonPromptDialog)sel).setMaintainUIContext(this.prompt.maintainUIContext);
            }
            return sel;
        }

        @Override
        public IRowSet getRowSetForPopupF8(String text) {
            IRowSet rowSet = null;
            int PAGELENGTH = 10;
            Map[] maps = this.getConditionMaps(text);
            this.prompt.getQueryAgent().setQueryExecutor(null);
            if (!this.prompt.getQueryAgent().upgradeEntityViewFromOrigin(maps)) {
                logger.info((Object)"warning: view set filter failed!");
                return rowSet;
            }
            rowSet = this.prompt.getQueryAgent().executeQuery(0, 10);
            if (rowSet == null) {
                return rowSet;
            }
            int size = rowSet.size();
            if (size < 1) {
                return rowSet;
            }
            if (!this.prompt.getQueryAgent().upgradeEntityViewFromOrigin(maps)) {
                logger.info((Object)"warning: view set filter failed!");
                return rowSet;
            }
            this.prompt.getQueryAgent().resetRuntimeEntityView();
            return rowSet;
        }
    }
}

