/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.analysis.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.ssc.BillAnalysisInfo;
import com.kingdee.eas.base.ssc.BussinessAttributeFactory;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.DynamicValueFactory;
import com.kingdee.eas.base.ssc.DynamicValueInfo;
import com.kingdee.eas.base.ssc.JobExtInfo;
import com.kingdee.eas.base.ssc.JobHisCollection;
import com.kingdee.eas.base.ssc.JobHisExtFactory;
import com.kingdee.eas.base.ssc.JobHisExtInfo;
import com.kingdee.eas.base.ssc.JobHisFactory;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.UnpassReasonFactory;
import com.kingdee.eas.base.ssc.UnpassReasonInfo;
import com.kingdee.eas.base.ssc.analysis.ThreadPoll.AnalysisFlowFactory;
import com.kingdee.eas.base.ssc.analysis.ThreadPoll.IAnalysisFlowCallback;
import com.kingdee.eas.base.ssc.analysis.util.AnalysisData;
import com.kingdee.eas.base.ssc.app.SatisfactionEvaluateEnum;
import com.kingdee.eas.base.ssc.app.assign.util.AssignFlowUtils;
import com.kingdee.eas.base.ssc.assign.AssignFlowRegisterFactory;
import com.kingdee.eas.base.ssc.assign.AssignFlowRegisterInfo;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.workDate.WorkDateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AnalysisUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.analysis.util.AnalysisUtil");

    private static double millSecondsToHour(long ms) {
        return (double)ms / 3600000.0;
    }

    public static PauseAndRescan getJobPauseAndRescanTime(Context ctx, List<SimpleJobStateTime> sjsList) throws EASBizException {
        PauseAndRescan pauseAndRescan = new PauseAndRescan();
        for (int i = 0; i < sjsList.size() - 1; ++i) {
            AnalysisUtil.getOneCost(ctx, pauseAndRescan, sjsList.get(i), sjsList.get(i + 1));
        }
        return pauseAndRescan;
    }

    public static SpecialOperation getJobSpecialOperation(Context ctx, List<SimpleJobStateTime> sjsList) throws EASBizException {
        SpecialOperation specialOperation = new SpecialOperation();
        for (int i = 0; i < sjsList.size() - 2; ++i) {
            AnalysisUtil.getSpecialOperationTime(ctx, specialOperation, sjsList.get(i), sjsList.get(i + 1), sjsList.get(i + 2));
        }
        return specialOperation;
    }

    private static void getSpecialOperationTime(Context ctx, SpecialOperation specialOperation, SimpleJobStateTime pre, SimpleJobStateTime next, SimpleJobStateTime third) throws SSCException {
        if (("2".equals(pre.getOldJobState()) || "7".equals(pre.getOldJobState())) && "1".equals(pre.getNewJobState()) && "1".equals(next.getOldJobState()) && "8".equals(next.getNewJobState()) && "8".equals(third.getOldJobState()) && ("2".equals(third.getNewJobState()) || "7".equals(third.getNewJobState()))) {
            long reScanWaitTime = (long)WorkDateUtil.getInstance(ctx, pre.getShareCenterID(), false).getCalWorkTimes(pre.getChangeTime(), next.getChangeTime(), 0);
            if (specialOperation.getReScanWaitTime() == null) {
                specialOperation.setReScanWaitTime(new BigDecimal(AnalysisUtil.millSecondsToHour(reScanWaitTime)));
            } else {
                specialOperation.setReScanWaitTime(new BigDecimal(specialOperation.getReScanWaitTime().doubleValue() + AnalysisUtil.millSecondsToHour(reScanWaitTime)));
            }
        }
        if (("2".equals(pre.getOldJobState()) || "7".equals(pre.getOldJobState())) && "0".equals(pre.getNewJobState()) && "0".equals(next.getOldJobState()) && "8".equals(next.getNewJobState()) && "8".equals(third.getOldJobState()) && ("2".equals(third.getNewJobState()) || "7".equals(third.getNewJobState()))) {
            long PauseWaitTimes = (long)WorkDateUtil.getInstance(ctx, pre.getShareCenterID(), false).getCalWorkTimes(pre.getChangeTime(), next.getChangeTime(), 0);
            if (specialOperation.getPauseWaitTimes() == null) {
                specialOperation.setPauseWaitTimes(new BigDecimal(AnalysisUtil.millSecondsToHour(PauseWaitTimes)));
            } else {
                specialOperation.setPauseWaitTimes(new BigDecimal(specialOperation.getPauseWaitTimes().doubleValue() + AnalysisUtil.millSecondsToHour(PauseWaitTimes)));
            }
        }
        if (("0".equals(pre.getOldJobState()) || "1".equals(pre.getOldJobState())) && "8".equals(pre.getNewJobState()) && "8".equals(next.getOldJobState()) && ("2".equals(next.getNewJobState()) || "7".equals(next.getNewJobState())) && ("2".equals(third.getOldJobState()) || "7".equals(third.getOldJobState())) && ("0".equals(third.getNewJobState()) || "1".equals(third.getNewJobState()))) {
            long ToBeAssignWaitTime = (long)WorkDateUtil.getInstance(ctx, next.getShareCenterID(), false).getCalWorkTimes(pre.getChangeTime(), third.getChangeTime(), 0);
            if (specialOperation.getToBeAssignWaitTime() == null) {
                specialOperation.setToBeAssignWaitTime(new BigDecimal(AnalysisUtil.millSecondsToHour(ToBeAssignWaitTime)));
            } else {
                specialOperation.setToBeAssignWaitTime(new BigDecimal(specialOperation.getToBeAssignWaitTime().doubleValue() + AnalysisUtil.millSecondsToHour(ToBeAssignWaitTime)));
            }
        }
    }

    public static List<SimpleJobStateTime> getJobStateTime(Context ctx, String jobId) {
        ArrayList<SimpleJobStateTime> list = new ArrayList<SimpleJobStateTime>();
        try {
            StringBuffer buf = new StringBuffer();
            buf.append(" SELECT job.FSHARECENTERID ,ths.FID, ths.FNEWJOBSTATE ,ths.FOLDJOBSTATE ,ths.FCHANGETIME ");
            buf.append(" FROM T_SSC_JOBHIS job inner join T_SSC_JobStaTimHis ths  ");
            buf.append(" on job.fid = ths.FJOBIDID  ");
            buf.append(" where job.fid='" + jobId + "' ");
            buf.append(" order by ths.FCHANGETIME asc ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
            while (rs.next()) {
                SimpleJobStateTime sjs = new SimpleJobStateTime();
                sjs.setShareCenterID(rs.getString("FSHARECENTERID"));
                sjs.setOldJobState(rs.getString("FOLDJOBSTATE"));
                sjs.setNewJobState(rs.getString("FNEWJOBSTATE"));
                sjs.setChangeTime(rs.getTimestamp("FCHANGETIME"));
                list.add(sjs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static void getOneCost(Context ctx, PauseAndRescan pauseAndRescan, SimpleJobStateTime pre, SimpleJobStateTime next) throws EASBizException {
        if (("2".equals(pre.getOldJobState()) || "7".equals(pre.getOldJobState())) && "1".equals(pre.getNewJobState()) && "1".equals(next.getOldJobState()) && ("2".equals(next.getNewJobState()) || "7".equals(next.getNewJobState()))) {
            long reScanWaitTime = (long)WorkDateUtil.getInstance(ctx, pre.getShareCenterID(), false).getCalWorkTimes(pre.getChangeTime(), next.getChangeTime(), 0);
            if (pauseAndRescan.getReScanWaitTime() == null) {
                pauseAndRescan.setReScanWaitTime(new BigDecimal(AnalysisUtil.millSecondsToHour(reScanWaitTime)));
            } else {
                pauseAndRescan.setReScanWaitTime(new BigDecimal(pauseAndRescan.getReScanWaitTime().doubleValue() + AnalysisUtil.millSecondsToHour(reScanWaitTime)));
            }
        }
        if (("2".equals(pre.getOldJobState()) || "7".equals(pre.getOldJobState())) && "0".equals(pre.getNewJobState()) && "0".equals(next.getOldJobState()) && ("2".equals(next.getNewJobState()) || "7".equals(next.getNewJobState()))) {
            long PauseWaitTimes = (long)WorkDateUtil.getInstance(ctx, pre.getShareCenterID(), false).getCalWorkTimes(pre.getChangeTime(), next.getChangeTime(), 0);
            if (pauseAndRescan.getPauseWaitTimes() == null) {
                pauseAndRescan.setPauseWaitTimes(new BigDecimal(AnalysisUtil.millSecondsToHour(PauseWaitTimes)));
            } else {
                pauseAndRescan.setPauseWaitTimes(new BigDecimal(pauseAndRescan.getPauseWaitTimes().doubleValue() + AnalysisUtil.millSecondsToHour(PauseWaitTimes)));
            }
        }
    }

    public static Timestamp getJobFristAssignTimeJob(Context ctx, String jobId) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("  SELECT top 1 ths.FCHANGETIME ");
        buffer.append("  FROM T_SSC_JOB job inner join T_SSC_JobStateTime ths  ");
        buffer.append("  on job.fid = ths.FJOBIDID  ");
        buffer.append("  where job.fid='" + jobId + "'  and ths.FOPERATION in ('14','8','6') ");
        buffer.append("  order by ths.FCHANGETIME asc ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
        if (rs.next()) {
            return rs.getTimestamp("FCHANGETIME");
        }
        buffer = new StringBuffer();
        buffer.append("  SELECT top 1 ths.FCHANGETIME ");
        buffer.append("  FROM T_SSC_JOB his inner join T_SSC_JobStateTime ths  ");
        buffer.append("  on his.fid = ths.FJOBIDID  ");
        buffer.append("  where his.fid='" + jobId + "'  and ths.FOPERATION in ('1') ");
        buffer.append("  order by ths.FCHANGETIME asc ");
        rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
        if (rs.next()) {
            return rs.getTimestamp("FCHANGETIME");
        }
        return null;
    }

    public static Timestamp getJobFristAssignTime(Context ctx, String jobId) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("  SELECT top 1 ths.FCHANGETIME ");
        buffer.append("  FROM T_SSC_JOBHIS job inner join T_SSC_JobStaTimHis ths  ");
        buffer.append("  on job.fid = ths.FJOBIDID  ");
        buffer.append("  where job.fid='" + jobId + "'  and ths.FOPERATION in ('14','8','6') ");
        buffer.append("  order by ths.FCHANGETIME asc ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
        if (rs.next()) {
            return rs.getTimestamp("FCHANGETIME");
        }
        buffer = new StringBuffer();
        buffer.append("  SELECT top 1 ths.FCHANGETIME ");
        buffer.append("  FROM T_SSC_JOBHIS his inner join T_SSC_JOBSTATIMHIS ths  ");
        buffer.append("  on his.fid = ths.FJOBIDID  ");
        buffer.append("  where his.fid='" + jobId + "'  and ths.FOPERATION in ('1') ");
        buffer.append("  order by ths.FCHANGETIME asc ");
        rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
        if (rs.next()) {
            return rs.getTimestamp("FCHANGETIME");
        }
        return null;
    }

    public static void doInitReasonField(Context context, JobHisExtInfo jobHisExtInfo) {
        String dealReason = "";
        String unpassReaIds = jobHisExtInfo.getDealReason() + "";
        if (!StringUtils.isEmpty((String)unpassReaIds)) {
            String[] unpassReaArray = unpassReaIds.split(",");
            for (int j = 0; j < unpassReaArray.length; ++j) {
                try {
                    UnpassReasonInfo info = UnpassReasonFactory.getLocalInstance(context).getUnpassReasonInfo((IObjectPK)new ObjectUuidPK(unpassReaArray[j]));
                    dealReason = dealReason + "/" + info.getName() + "";
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
        if (dealReason.length() > 500) {
            dealReason.substring(0, 500);
        }
        jobHisExtInfo.setDealReason(dealReason);
    }

    public static void setBilNumber(Context ctx, String uuid, String analysisType, Map<String, Object> map) throws BOSException {
        String acutalBillId = uuid;
        BillAnalysisInfo billAnalysisInfo = new BillAnalysisInfo();
        JobHisExtInfo jobHisExtInfo = new JobHisExtInfo();
        JobExtInfo jobExtInfo = new JobExtInfo();
        Collection<Object> infos = map.values();
        for (Object coreBaseInfo : infos) {
            if (coreBaseInfo instanceof BillAnalysisInfo) {
                billAnalysisInfo = (BillAnalysisInfo)coreBaseInfo;
                continue;
            }
            if (coreBaseInfo instanceof JobHisExtInfo) {
                jobHisExtInfo = (JobHisExtInfo)coreBaseInfo;
                continue;
            }
            jobExtInfo = (JobExtInfo)coreBaseInfo;
        }
        ObjectUuidPK uuidPK = new ObjectUuidPK(acutalBillId);
        BOSObjectType bosType = uuidPK.getObjectType();
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectValue objectValue = iDynamicObject.getValue(bosType, H.PK(acutalBillId));
        if (objectValue != null) {
            billAnalysisInfo.setBillNumber(objectValue.get("number") + "");
            jobHisExtInfo.setBillNumber(objectValue.get("number") + "");
            jobExtInfo.setBillNumber(objectValue.get("number") + "");
            if ("bill".equals(analysisType)) {
                billAnalysisInfo.setBillName(objectValue.get("name") + "");
            }
        }
    }

    public static void updateCreatorNumber(Context context, JobHisInfo jobHisInfo) {
        if (!StringUtils.isEmpty((String)jobHisInfo.getCreatorNumber())) {
            return;
        }
        try {
            DynamicValueInfo info = DynamicValueFactory.getLocalInstance(context).getDynamicValueInfo("where dynamicID.id ='4VBUlqSUQuO8g8sPkTkXsZvLn80=' and jobID.id ='" + jobHisInfo.getId().toString() + "'");
            jobHisInfo.setCreatorNumber(info.getDinamicValue());
            JobHisFactory.getLocalInstance(context).update(H.PK(jobHisInfo.getId().toString()), (CoreBaseInfo)jobHisInfo);
        }
        catch (Exception e) {
            logger.error((Object)"\u7531\u4e8e\u4ece\u52a8\u6001\u5c5e\u6027\u4e2d\u672a\u627e\u5230\u6ee1\u8db3\u6570\u636e\uff0c\u66f4\u65b0\u63d0\u5355\u4eba\u5931\u8d25\uff01");
        }
    }

    public static void setJobDoingTime(Context ctx, JobInfo jobInfo, JobExtInfo jobExtInfo) throws EASBizException {
        BigDecimal sscassign = BigDecimal.ZERO;
        BigDecimal sscpause = BigDecimal.ZERO;
        BigDecimal sscrescan = BigDecimal.ZERO;
        BigDecimal sscQueuingDeal = BigDecimal.ZERO;
        BigDecimal costWorkTime = BigDecimal.ZERO;
        Timestamp jobFristAssignTime = null;
        SpecialOperation specialOperation = null;
        PauseAndRescan pauseAndRescan = null;
        try {
            jobFristAssignTime = AnalysisUtil.getJobFristAssignTimeJob(ctx, jobInfo.getId().toString());
            List<SimpleJobStateTime> sjsList = AnalysisUtil.getJobStateTime(ctx, jobInfo.getId().toString());
            pauseAndRescan = AnalysisUtil.getJobPauseAndRescanTime(ctx, sjsList);
            specialOperation = AnalysisUtil.getJobSpecialOperation(ctx, sjsList);
            double toBeAss = AnalysisUtil.getTime(ctx, jobInfo.getShareCenterID().getId().toString(), new Date(jobInfo.getCreateTime().getTime()), new Date(jobFristAssignTime.getTime()));
            if (null == jobInfo.getCompleteTme()) {
                jobInfo.setCompleteTme(new Timestamp(System.currentTimeMillis()));
            }
            sscassign = sscassign.add(new BigDecimal(String.valueOf(toBeAss)).add(specialOperation.getToBeAssignWaitTime())).setScale(4, 4);
            sscpause = sscpause.add(pauseAndRescan.getPauseWaitTimes().add(specialOperation.getPauseWaitTimes())).setScale(4, 4);
            sscrescan = sscrescan.add(pauseAndRescan.getReScanWaitTime().add(specialOperation.getReScanWaitTime())).setScale(4, 4);
            if (null == jobExtInfo.getApproveTime()) {
                jobExtInfo.setApproveTime(BigDecimal.ZERO);
            }
            costWorkTime = costWorkTime.add(jobExtInfo.getApproveTime().divide(new BigDecimal(60000), 2, 4)).setScale(4, 4);
            sscQueuingDeal = sscQueuingDeal.add(costWorkTime).subtract(sscpause).subtract(sscrescan).subtract(sscassign).setScale(4, 4);
            jobExtInfo.setQueueTime(sscQueuingDeal);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new SSCException(SSCException.UNKNOW, new Object[]{"\u8fd0\u8425\u9b54\u65b9\u8ba1\u7b97\u5f02\u5e38\uff01"});
        }
    }

    public static void setBaseTime(Context ctx, Map<String, Object> map, JobHisCollection jobHisCollection, JobHisInfo jobHisInfo) throws EASBizException {
        BillAnalysisInfo billAnalysisInfo = new BillAnalysisInfo();
        JobHisExtInfo jobHisExtInfo = new JobHisExtInfo();
        if (jobHisCollection == null) {
            jobHisCollection = new JobHisCollection();
            jobHisCollection.add(jobHisInfo);
        }
        Collection<Object> infos = map.values();
        for (Object coreBaseInfo : infos) {
            if (coreBaseInfo instanceof BillAnalysisInfo) {
                billAnalysisInfo = (BillAnalysisInfo)coreBaseInfo;
                continue;
            }
            jobHisExtInfo = (JobHisExtInfo)coreBaseInfo;
        }
        BigDecimal sscassign = BigDecimal.ZERO;
        BigDecimal sscpause = BigDecimal.ZERO;
        BigDecimal sscrescan = BigDecimal.ZERO;
        BigDecimal sscQueuingDeal = BigDecimal.ZERO;
        BigDecimal costWorkTime = BigDecimal.ZERO;
        BigDecimal costTime = BigDecimal.ZERO;
        BigDecimal standardCoe = BigDecimal.ZERO;
        HashMap<String, BigDecimal> standardCoeMap = new HashMap<String, BigDecimal>();
        Timestamp jobFristAssignTime = null;
        SpecialOperation specialOperation = null;
        PauseAndRescan pauseAndRescan = null;
        JobHisExtInfo jobExtInfo = null;
        for (int i = 0; i < jobHisCollection.size(); ++i) {
            try {
                jobHisInfo = jobHisCollection.get(i);
                jobExtInfo = JobHisExtFactory.getLocalInstance(ctx).getJobHisExtInfo("where job.id = '" + jobHisInfo.getId().toString() + "'");
                jobFristAssignTime = AnalysisUtil.getJobFristAssignTime(ctx, jobHisInfo.getId().toString());
                List<SimpleJobStateTime> sjsList = AnalysisUtil.getJobStateTime(ctx, jobHisInfo.getId().toString());
                pauseAndRescan = AnalysisUtil.getJobPauseAndRescanTime(ctx, sjsList);
                specialOperation = AnalysisUtil.getJobSpecialOperation(ctx, sjsList);
                BussinessAttributeInfo bussAttrInfo = BussinessAttributeFactory.getLocalInstance(ctx).getBussinessAttributeInfo((IObjectPK)new ObjectUuidPK(jobHisInfo.getBussAttrID().getId()));
                if (!standardCoeMap.containsKey(bussAttrInfo.getNumber()) || ((BigDecimal)standardCoeMap.get(bussAttrInfo.getNumber())).compareTo(bussAttrInfo.getStandardCoe()) < 0) {
                    standardCoeMap.put(bussAttrInfo.getNumber(), bussAttrInfo.getStandardCoe());
                }
                double toBeAss = AnalysisUtil.getTime(ctx, jobHisCollection.get(0).getShareCenterID().getId().toString(), new Date(jobHisInfo.getCreateTime().getTime()), new Date(jobFristAssignTime.getTime()));
                if (null == jobHisInfo.getCompleteTme()) {
                    jobHisInfo.setCompleteTme(new Timestamp(System.currentTimeMillis()));
                }
                sscassign = sscassign.add(new BigDecimal(String.valueOf(toBeAss)).add(specialOperation.getToBeAssignWaitTime())).setScale(4, 4);
                sscpause = sscpause.add(pauseAndRescan.getPauseWaitTimes().add(specialOperation.getPauseWaitTimes())).setScale(4, 4);
                sscrescan = sscrescan.add(pauseAndRescan.getReScanWaitTime().add(specialOperation.getReScanWaitTime())).setScale(4, 4);
                costWorkTime = costWorkTime.add(jobExtInfo.getApproveTime().divide(new BigDecimal(60000), 2, 4)).setScale(4, 4);
                sscQueuingDeal = sscQueuingDeal.add(costWorkTime).subtract(sscpause).subtract(sscrescan).subtract(sscassign).setScale(4, 4);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new SSCException(SSCException.UNKNOW, new Object[]{"\u8fd0\u8425\u9b54\u65b9\u8ba1\u7b97\u5f02\u5e38\uff01"});
            }
            if (sscassign.compareTo(BigDecimal.ZERO) != -1) {
                billAnalysisInfo.setSscAssign(sscassign);
                jobHisExtInfo.setSscassign(sscassign);
            }
            if (sscQueuingDeal.compareTo(BigDecimal.ZERO) != -1) {
                billAnalysisInfo.setSscQueuingDeal(sscQueuingDeal);
                jobHisExtInfo.setSscQueuingDeal(sscQueuingDeal);
            }
            if (costWorkTime.compareTo(BigDecimal.ZERO) != -1) {
                billAnalysisInfo.setSscDeal(costWorkTime);
            }
            if (jobHisCollection == null) continue;
            billAnalysisInfo.setSscPause(sscpause);
            billAnalysisInfo.setPause(sscpause.compareTo(BigDecimal.ZERO) > 0);
            billAnalysisInfo.setSscRescan(sscrescan);
            billAnalysisInfo.setRescan(sscrescan.compareTo(BigDecimal.ZERO) > 0);
        }
        for (Map.Entry m : standardCoeMap.entrySet()) {
            standardCoe = standardCoe.add((BigDecimal)m.getValue());
        }
        billAnalysisInfo.setStandardSum(standardCoe);
    }

    private void setBilNumber(Context context, Map<String, Object> map, String billID, String sscBillId, String analysisType) throws BOSException {
        String acutalBillId = StringUtils.isEmpty((String)sscBillId) ? billID : sscBillId;
        BillAnalysisInfo billAnalysisInfo = new BillAnalysisInfo();
        JobHisExtInfo jobHisExtInfo = new JobHisExtInfo();
        JobExtInfo jobExtInfo = new JobExtInfo();
        Collection<Object> infos = map.values();
        for (Object coreBaseInfo : infos) {
            if (coreBaseInfo instanceof BillAnalysisInfo) {
                billAnalysisInfo = (BillAnalysisInfo)coreBaseInfo;
                continue;
            }
            if (coreBaseInfo instanceof JobHisExtInfo) {
                jobHisExtInfo = (JobHisExtInfo)coreBaseInfo;
                continue;
            }
            jobExtInfo = (JobExtInfo)coreBaseInfo;
        }
        ObjectUuidPK uuidPK = new ObjectUuidPK(acutalBillId);
        BOSObjectType bosType = uuidPK.getObjectType();
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)context);
        IObjectValue objectValue = iDynamicObject.getValue(bosType, H.PK(acutalBillId));
        if (objectValue != null) {
            billAnalysisInfo.setBillNumber(objectValue.get("number") + "");
            jobHisExtInfo.setBillNumber(objectValue.get("number") + "");
            jobExtInfo.setBillNumber(objectValue.get("number") + "");
            if ("bill".equals(analysisType)) {
                billAnalysisInfo.setBillName(objectValue.get("name") + "");
            }
        }
    }

    public static String getEvaluateTranslate(SatisfactionEvaluateEnum score) {
        if (score == SatisfactionEvaluateEnum.worst) {
            return "\u975e\u5e38\u4e0d\u6ee1\u610f";
        }
        if (score == SatisfactionEvaluateEnum.dissatisfied) {
            return "\u4e0d\u6ee1\u610f";
        }
        if (score == SatisfactionEvaluateEnum.ordinary) {
            return "\u4e00\u822c";
        }
        if (score == SatisfactionEvaluateEnum.contentment) {
            return "\u6ee1\u610f";
        }
        return "\u7279\u522b\u6ee1\u610f";
    }

    public static void invokeInterface(Context ctx, AnalysisData analysisData) throws Exception {
        AssignFlowRegisterInfo info = AssignFlowUtils.getFlowRegisterId((Context)ctx, (String)"SSCAnalysis");
        String classPath = AnalysisUtil.getCallbackClassPath(ctx, info.getId().toString());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)classPath)) {
            throw new SSCException(SSCException.UNKNOW, new Object[]{"\u672a\u627e\u5230\u5b9e\u73b0\u7c7b\uff01"});
        }
        IAnalysisFlowCallback ctr = AnalysisFlowFactory.getInstanse(classPath);
        try {
            String string = ctr.afterFlow(ctx, analysisData);
        }
        catch (Exception e) {
            logger.error((Object)("\u8fd0\u8425\u9b54\u65b9\u8fd0\u884c\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
        }
    }

    private static String getCallbackClassPath(Context ctx, String flowRegisterId) throws EASBizException, BOSException {
        AssignFlowRegisterInfo info = AssignFlowRegisterFactory.getLocalInstance(ctx).getAssignFlowRegisterInfo((IObjectPK)new ObjectUuidPK(flowRegisterId));
        return info.getObserverClass();
    }

    public static double getTime(Context ctx, String shareCenterId, Date startDate, Date endDate) throws SSCException {
        WorkDateUtil workDUtil = null;
        try {
            workDUtil = WorkDateUtil.getInstance(ctx, shareCenterId, true);
        }
        catch (Exception e) {
            logger.error((Object)("\u521d\u59cb\u5316\u5de5\u4f5c\u65e5\u5386\u5f02\u5e38\uff01" + e));
            throw new SSCException(SSCException.UNKNOW, new Object[]{"\u8bf7\u5148\u914d\u7f6e\u8be5\u5171\u4eab\u4e2d\u5fc3\u5de5\u4f5c\u65e5\u5386\uff01"});
        }
        long value = workDUtil.calWorkTimeBetweenDays(startDate, endDate);
        Double valueToHour = (double)value * 1.0 / 3600000.0;
        return valueToHour;
    }

    public static class SimpleJobStateTime {
        private Timestamp changeTime;
        private String oldJobState;
        private String newJobState;
        private String shareCenterID;

        public SimpleJobStateTime() {
        }

        public SimpleJobStateTime(Timestamp changeTime, String oldJobState, String newJobState) {
            this.changeTime = changeTime;
            this.oldJobState = oldJobState;
            this.newJobState = newJobState;
        }

        public Timestamp getChangeTime() {
            return this.changeTime;
        }

        public void setChangeTime(Timestamp changeTime) {
            this.changeTime = changeTime;
        }

        public String getOldJobState() {
            return this.oldJobState;
        }

        public void setOldJobState(String oldJobState) {
            this.oldJobState = oldJobState;
        }

        public String getNewJobState() {
            return this.newJobState;
        }

        public void setNewJobState(String newJobState) {
            this.newJobState = newJobState;
        }

        public String getShareCenterID() {
            return this.shareCenterID;
        }

        public void setShareCenterID(String shareCenterID) {
            this.shareCenterID = shareCenterID;
        }
    }

    public static class SpecialOperation {
        private BigDecimal pauseWaitTimes = new BigDecimal(0);
        private BigDecimal reScanWaitTime = new BigDecimal(0);
        private BigDecimal toBeAssignWaitTime = new BigDecimal(0);

        public BigDecimal getPauseWaitTimes() {
            return this.pauseWaitTimes;
        }

        public void setPauseWaitTimes(BigDecimal pauseWaitTimes) {
            this.pauseWaitTimes = pauseWaitTimes;
        }

        public BigDecimal getReScanWaitTime() {
            return this.reScanWaitTime;
        }

        public void setReScanWaitTime(BigDecimal reScanWaitTime) {
            this.reScanWaitTime = reScanWaitTime;
        }

        public BigDecimal getToBeAssignWaitTime() {
            return this.toBeAssignWaitTime;
        }

        public void setToBeAssignWaitTime(BigDecimal toBeAssignWaitTime) {
            this.toBeAssignWaitTime = toBeAssignWaitTime;
        }
    }

    public static class PauseAndRescan {
        private BigDecimal pauseWaitTimes = new BigDecimal(0);
        private BigDecimal reScanWaitTime = new BigDecimal(0);

        public BigDecimal getPauseWaitTimes() {
            return this.pauseWaitTimes;
        }

        public void setPauseWaitTimes(BigDecimal pauseWaitTimes) {
            this.pauseWaitTimes = pauseWaitTimes;
        }

        public BigDecimal getReScanWaitTime() {
            return this.reScanWaitTime;
        }

        public void setReScanWaitTime(BigDecimal reScanWaitTime) {
            this.reScanWaitTime = reScanWaitTime;
        }
    }
}

