/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.image.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.JobFactory;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.app.image.webservice.GuosenWSProxy;
import com.kingdee.eas.base.ssc.image.helper.NoticeImageSysHelper;
import com.kingdee.eas.base.ssc.image.pojo.NoticeImageSysViewInfo;
import com.kingdee.eas.base.ssc.image.pojo.NoticeImageSysViewOnPhoneInfo;
import com.kingdee.eas.base.wssc.ImageSystemException;
import com.kingdee.eas.base.wssc.app.trd.webservice.image.PublicImageCenterWsSoapBindingStub;
import com.kingdee.eas.base.wssc.app.util.WSSCUtils;
import com.kingdee.eas.base.wssc.image.pojo.Service_CreateImagePath;
import com.kingdee.eas.base.wssc.image.pojo.Service_CreateImagePathes;
import com.siit.image.wscommon.obj.CreateImagePath;
import com.siit.image.wscommon.obj.base.Params;
import com.siit.image.wscommon.obj.base.Safety;
import com.siit.image.wscommon.obj.base.Serverbody;
import com.siit.image.wscommon.obj.base.Service;
import com.siit.image.wscommon.tools.Encryptions;
import com.siit.image.wscommon.tools.ResultMsg;
import com.siit.image.wscommon.tools.XmlToResultMsg;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.rpc.ServiceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class NoticeImageSysHelper_GXHC
extends NoticeImageSysHelper {
    public final String key = "GXHC";
    private Logger logger = Logger.getLogger(NoticeImageSysHelper_GXHC.class);

    @Override
    public String viewPhoto(NoticeImageSysViewInfo viewPhotoInfo) throws BOSException, ImageSystemException {
        String url = null;
        String webService = viewPhotoInfo.getWebServiceUrl();
        try {
            url = webService.contains("/imageWS/services/ImageService.asmx?wsdl") ? this.wsInvokeGetImageUrl(webService, viewPhotoInfo.getBarCode(), viewPhotoInfo.isAllowRescan(), viewPhotoInfo.getViewUserNumber()) : this.wsInvokeGetImageUrl(webService, viewPhotoInfo.getBarCode(), viewPhotoInfo.isAllowRescan(), viewPhotoInfo.isApp(), viewPhotoInfo.getViewUserNumber());
        }
        catch (ServiceException e) {
            this.logger.error((Object)("\u67e5\u770b\u5f71\u50cf--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edfwebservice\u51fa\u73b0\u5f02\u5e38,\u629b\u51fa,\u6b64\u5904\u4e0d\u8f93\u51fa\u6808\u5806!viewPhotoInfo:" + viewPhotoInfo + "\n\u5f02\u5e38\u4fe1\u606f:" + (Object)((Object)e)));
            throw new ImageSystemException(ImageSystemException.IMAGESYS_INNER_EXCEPTION, (Throwable)e);
        }
        catch (RemoteException e) {
            this.logger.error((Object)("\u67e5\u770b\u5f71\u50cf--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edfwebservice\u51fa\u73b0\u5f02\u5e38,\u629b\u51fa,\u6b64\u5904\u4e0d\u8f93\u51fa\u6808\u5806!viewPhotoInfo:" + viewPhotoInfo + "\n\u5f02\u5e38\u4fe1\u606f:" + e));
            throw new ImageSystemException(ImageSystemException.IMAGESYS_INNER_EXCEPTION, (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error((Object)("\u67e5\u770b\u5f71\u50cf--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edfwebservice\u51fa\u73b0\u5f02\u5e38,\u629b\u51fa,\u6b64\u5904\u4e0d\u8f93\u51fa\u6808\u5806!viewPhotoInfo:" + viewPhotoInfo + "\n\u5f02\u5e38\u4fe1\u606f:" + e));
            throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, (Throwable)e);
        }
        return url;
    }

    @Override
    public String viewPhotoOnPhone(NoticeImageSysViewOnPhoneInfo viewPhotoInfo) throws BOSException, ImageSystemException {
        viewPhotoInfo.setApp(true);
        return this.viewPhoto(viewPhotoInfo);
    }

    @Override
    public String viewPhotos(NoticeImageSysViewInfo[] viewPhotoInfos) throws BOSException, ImageSystemException {
        throw new ImageSystemException(ImageSystemException.NOT_IMPLEMENT_YET);
    }

    @Override
    public String viewPhotosOnPhone(NoticeImageSysViewOnPhoneInfo[] viewPhotoInfos) throws BOSException, ImageSystemException {
        throw new ImageSystemException(ImageSystemException.NOT_IMPLEMENT_YET);
    }

    private String wsInvokeGetImageUrl(String url, String imageNumber, boolean canRescan, boolean isApp, String viewUser) throws RemoteException, ServiceException, Exception {
        Context ctx = JobFactory.getRemoteInstance().getContext();
        String sscNumber = WSSCUtils.getSSCNumberByImageNb((Context)ctx, (String)imageNumber);
        if (url.contains("/imageWS/services/ImageService.asmx?wsdl")) {
            throw new ImageSystemException(ImageSystemException.WRING_CINFIG);
        }
        GuosenParamsHelper guosenParamsHelper = new GuosenParamsHelper();
        ParamsSiit params = guosenParamsHelper.buildCreateImagePathParams(imageNumber, canRescan, false, viewUser);
        PublicImageCenterWsSoapBindingStub proxy = new PublicImageCenterWsSoapBindingStub(new URL(url), (javax.xml.rpc.Service)new org.apache.axis.client.Service());
        String strResult = proxy.imageInterfaceService(params.toXml());
        this.logger.info((Object)("\u56fd\u4fe1\u67e5\u770b\u5f71\u50cf\u65b0\u63a5\u53e3,\u8fd4\u56de\u503c\u4e3a:" + strResult));
        String success = ((ResultMsg)XmlToResultMsg.toObj((String)strResult).get(0)).getSuccess();
        if (StringUtils.isEmpty((CharSequence)success)) {
            throw new SSCException(SSCException.UNKNOW, new Object[]{((ResultMsg)XmlToResultMsg.toObj((String)strResult).get(0)).getErrormsg()});
        }
        return success;
    }

    private String wsInvokeGetImageUrl(String url, String imageNumber, boolean canRescan, String viewUser) throws RemoteException, ServiceException, Exception {
        GuosenParamsHelper guosenParamsHelper = new GuosenParamsHelper();
        Params params = guosenParamsHelper.buildCreateImagePathParams(imageNumber, canRescan, viewUser);
        Context ctx = JobFactory.getRemoteInstance().getContext();
        String sscNumber = WSSCUtils.getSSCNumberByImageNb((Context)ctx, (String)imageNumber);
        url.replace("/SiitFrameWs/services/AutoImageCenter.ws?wsdl", "/imageWS/services/ImageService.asmx?wsdl");
        GuosenWSProxy proxy = new GuosenWSProxy(url);
        List list = proxy.invokeWS(params);
        return ((ResultMsg)list.get(0)).getSuccess();
    }

    public class ParamsSiit
    extends Params {
        public String toString() {
            String tmp = ((Object)((Object)this)).getClass().getName() + ":{";
            try {
                tmp = tmp + this.toXml() + "}";
            }
            catch (Exception exception) {
                // empty catch block
            }
            return tmp;
        }

        public String toXml() throws Exception {
            Document doc = DocumentHelper.createDocument();
            Element root = doc.addElement("params");
            Element safetyElement = root.addElement("safety");
            Safety safety = this.getSafety();
            safetyElement.addElement("clientcode").setText(safety.getClientcode());
            safetyElement.addElement("servicecode").setText(safety.getServicecode());
            safetyElement.addElement("time").setText(safety.getTime());
            safetyElement.addElement("ticket").setText(safety.getTicket());
            Element serverbodyElement = root.addElement("serverbody");
            Serverbody serverbody = this.getServerbody();
            serverbodyElement.addElement("servername").setText(serverbody.getServername());
            serverbodyElement.addElement("servertype").setText(serverbody.getServertype());
            Element servicesElement = serverbodyElement.addElement("services");
            List serviceList = serverbody.getServices();
            this.reflectXml(servicesElement, serviceList);
            OutputFormat format = OutputFormat.createCompactFormat();
            StringWriter writer = new StringWriter();
            XMLWriter output = new XMLWriter((Writer)writer, format);
            try {
                output.write(doc);
                writer.close();
                output.close();
            }
            catch (IOException e) {
                NoticeImageSysHelper_GXHC.this.logger.error((Object)("\u56fd\u4fe1\u8f6c\u6362\u53c2\u6570IOException\u5f02\u5e38!\u629b\u51fa,\u4e0d\u8f93\u51fa\u6808\u5806.\u5f02\u5e38\u4fe1\u606f:" + e));
                throw e;
            }
            return writer.toString();
        }

        private void reflectXml(Element servernameElement, List<Service> serviceList) {
            if (serviceList == null || serviceList.size() <= 0) {
                return;
            }
            for (Service service : serviceList) {
                Element serviceElement = servernameElement.addElement("service");
                Field[] fields = service.getClass().getFields();
                for (int i = 0; i < fields.length; ++i) {
                    String fieldName = fields[i].getName();
                    try {
                        Object fieldValue = fields[i].get(service);
                        if (fieldValue != null) {
                            serviceElement.addElement(fieldName).setText(fieldValue.toString());
                            continue;
                        }
                        serviceElement.addElement(fieldName).setText("");
                        continue;
                    }
                    catch (SecurityException e) {
                        NoticeImageSysHelper_GXHC.this.logger.error((Object)"\u56fd\u4fe1\u8f6c\u6362\u53c2\u6570SecurityException\u5f02\u5e38,\u5403\u6389,\u7b80\u5355\u8bb0\u5f55\u5f02\u5e38\u4fe1\u606f:", (Throwable)e);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        NoticeImageSysHelper_GXHC.this.logger.error((Object)"\u56fd\u4fe1\u8f6c\u6362\u53c2\u6570IllegalArgumentException\u5f02\u5e38,\u5403\u6389,\u7b80\u5355\u8bb0\u5f55\u5f02\u5e38\u4fe1\u606f:", (Throwable)e);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        NoticeImageSysHelper_GXHC.this.logger.error((Object)"\u56fd\u4fe1\u8f6c\u6362\u53c2\u6570IllegalAccessException\u5f02\u5e38,\u5403\u6389,\u7b80\u5355\u8bb0\u5f55\u5f02\u5e38\u4fe1\u606f:", (Throwable)e);
                    }
                }
            }
        }
    }

    public class GuosenParamsHelper {
        public Params buildCreateImagePathParams(String barcode, boolean canRescan, String viewUser) {
            Params params = new Params();
            params.setSafety(this.buildSafetySiit());
            params.setServerbody(this.buildServerBody("createImagePath", (Service)this.buildCreateImagePath(barcode, canRescan, viewUser)));
            return params;
        }

        public ParamsSiit buildCreateImagePathParams(NoticeImageSysViewInfo[] viewPhotoInfos) {
            ParamsSiit params = new ParamsSiit();
            params.setSafety(this.buildSafetySiit());
            params.setServerbody(this.buildServerBody("createImagePaths", (Service)this.buildCreateImagePathsSerivce(viewPhotoInfos)));
            return params;
        }

        private Service_CreateImagePathes buildCreateImagePathsSerivce(NoticeImageSysViewInfo[] viewPhotoInfos) {
            Service_CreateImagePathes service = new Service_CreateImagePathes();
            service.setType(viewPhotoInfos[0].getType());
            service.setUsername(viewPhotoInfos[0].getViewPersonName());
            service.setUserstaff(viewPhotoInfos[0].getViewUserNumber());
            ArrayList<Service_CreateImagePathes.Barcode> barcodes = new ArrayList<Service_CreateImagePathes.Barcode>(viewPhotoInfos.length);
            for (int i = 0; i < viewPhotoInfos.length; ++i) {
                Service_CreateImagePathes.Barcode barcode = new Service_CreateImagePathes.Barcode(service);
                barcode.setBar(viewPhotoInfos[i].getBarCode());
                barcodes.add(barcode);
            }
            service.setBarcodes(barcodes);
            return service;
        }

        private CreateImagePath buildCreateImagePath(String barcode, boolean canRescan, String viewUser) {
            CreateImagePath createImagePath = new CreateImagePath();
            createImagePath.serviceid = "1";
            createImagePath.barcode = barcode;
            createImagePath.type = "1";
            createImagePath.evaluation = canRescan ? "1" : "0";
            createImagePath.candownprint = "1";
            createImagePath.commenttype = "1";
            createImagePath.imageop = "0";
            createImagePath.userid = StringUtils.isNotBlank((CharSequence)viewUser) ? viewUser : "zhangsan";
            createImagePath.accountdate = "2014-01-01";
            createImagePath.showother = "1";
            return createImagePath;
        }

        public ParamsSiit buildCreateImagePathParams(String barcode, boolean canRescan, boolean isApp, String viewUser) {
            ParamsSiit params = new ParamsSiit();
            params.setSafety(this.buildSafetySiit());
            params.setServerbody(this.buildServerBody("createImagePath", (Service)this.buildCreateImagePathSerivce(barcode, canRescan, isApp, viewUser)));
            return params;
        }

        private Service_CreateImagePath buildCreateImagePathSerivce(String barcode, boolean canRescan, boolean isApp, String viewUser) {
            Service_CreateImagePath createImagePath = new Service_CreateImagePath();
            createImagePath.serviceid = "1";
            createImagePath.barcode = barcode;
            createImagePath.type = "1";
            createImagePath.evaluation = canRescan ? "1" : "0";
            createImagePath.candownprint = "1";
            createImagePath.commenttype = "1";
            createImagePath.imageop = "0";
            createImagePath.userid = StringUtils.isNotBlank((CharSequence)viewUser) ? viewUser : "zhangsan";
            createImagePath.accountdate = "2014-01-01";
            createImagePath.showother = "1";
            createImagePath.isapp = isApp ? "1" : "0";
            return createImagePath;
        }

        private Serverbody buildServerBody(String methodName, Service service) {
            Serverbody serverbody = new Serverbody();
            serverbody.setServername(methodName);
            serverbody.setServertype("1");
            serverbody.setServices(this.buildServices(service));
            return serverbody;
        }

        private List<Service> buildServices(Service service) {
            ArrayList<Service> services = new ArrayList<Service>();
            services.add(service);
            return services;
        }

        private Safety buildSafetySiit() {
            Safety safety = new Safety();
            safety.setClientcode("FK");
            safety.setServicecode("ImageCenter");
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
            String time = df.format(new Date());
            String key = "KINGDEE";
            safety.setTicket(Encryptions.getMD5str((String)(time + "ImageCenterFK" + key)));
            safety.setTime(time);
            return safety;
        }
    }
}

