/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.shr.bean;

import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class RealDataFetcher {
    private IQueryExecutor exec;
    private List data;
    private int count;
    private int start;
    private int length;

    public static RealDataFetcher createInstance(IQueryExecutor exec, int start, int length) {
        RealDataFetcher fetcher = new RealDataFetcher(exec, start, length);
        fetcher.executeRealPageData();
        return fetcher;
    }

    private RealDataFetcher(IQueryExecutor exec, int start, int length) {
        this.exec = exec;
        this.start = start;
        this.length = length;
    }

    public int getCount() {
        return this.count;
    }

    public List getData() {
        return this.data;
    }

    public void setData(List data) {
        this.data = data;
    }

    public int getRowCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Object getRowData(int index) {
        return this.data.get(index);
    }

    public IQueryExecutor getQueryExecutor() {
        return this.exec;
    }

    public void reload() {
        this.executeRealPageData();
    }

    private void executeRealPageData() {
        try {
            this.data = new LinkedList();
            IRowSet rowSet = this.exec.executeQueryForRealPage(this.start, this.length);
            IRowSetMetaData md = rowSet.getRowSetMetaData();
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                int count = md.getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    String columnName = md.getColumnName(i);
                    Object value = rowSet.getObject(i);
                    map.put(columnName, value);
                }
                this.data.add(map);
            }
            this.count = this.data.size();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

