/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;

public class JsonXmlUtils {
    public static String jsonToPrettyXml(JSONObject json) throws IOException, SAXException {
        Document document = JsonXmlUtils.jsonToDocument(json);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setIndent(" ");
        format.setIndentSize(4);
        StringWriter formatXml = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)formatXml, format);
        writer.write(document);
        return formatXml.toString();
    }

    public static String JsonToXml(JSONObject json) throws SAXException {
        return JsonXmlUtils.jsonToDocument(json).asXML();
    }

    public static Document jsonToDocument(JSONObject json) throws SAXException {
        Document document;
        block0: {
            document = DocumentHelper.createDocument();
            Iterator iterator = json.keySet().iterator();
            if (!iterator.hasNext()) break block0;
            String rootKey = (String)iterator.next();
            Element root = JsonXmlUtils.jsonToElement(json.getJSONObject(rootKey), rootKey);
            document.add(root);
        }
        return document;
    }

    public static Element jsonToElement(JSONObject json, String nodeName) {
        Element node = DocumentHelper.createElement((String)nodeName);
        for (String key : json.keySet()) {
            Object child = json.get((Object)key);
            if (child instanceof JSONObject) {
                node.add(JsonXmlUtils.jsonToElement(json.getJSONObject(key), key));
                continue;
            }
            Element element = DocumentHelper.createElement((String)key);
            element.setText(json.getString(key));
            node.add(element);
        }
        return node;
    }

    public static JSONObject xmlToJson(String xml) throws DocumentException {
        JSONObject json = new JSONObject();
        SAXReader reader = new SAXReader();
        Document document = reader.read((Reader)new StringReader(xml));
        Element root = document.getRootElement();
        json.put(root.getName(), (Object)JsonXmlUtils.elementToJson(root));
        return json;
    }

    public static JSONObject elementToJson(Element element) {
        JSONObject json = new JSONObject();
        for (Object child : element.elements()) {
            Element e = (Element)child;
            if (e.elements().isEmpty()) {
                json.put(e.getName(), (Object)e.getText());
                continue;
            }
            json.put(e.getName(), (Object)JsonXmlUtils.elementToJson(e));
        }
        return json;
    }

    public static void main(String[] args) {
        try {
            String content = "";
            JSONObject json = JsonXmlUtils.xmlToJson(content);
            System.out.println(JSON.toJSONString((Object)json, (boolean)true));
            String xml = JsonXmlUtils.JsonToXml(json);
            System.out.println(xml);
            System.out.println("----------------------------------------\n\n");
            xml = JsonXmlUtils.jsonToPrettyXml(json);
            System.out.println(xml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

