/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.weibo.util;

import sun.misc.BASE64Decoder;

public class WeiboUtil {
    public static String encodeBillId(String billId) {
        String encodeId = billId.replaceAll("/", "888");
        encodeId = encodeId.replaceAll("\\+", "999");
        return encodeId;
    }

    public static String decodeBillId(String billId) {
        String decodeId = billId.replaceAll("888", "/");
        decodeId = decodeId.replaceAll("999", "\\+");
        return decodeId;
    }

    public static String getSignedWeiboId(String signedRequest) {
        String base64Content = WeiboUtil.getFromBASE64(signedRequest);
        return WeiboUtil.getSplitWeiboId(base64Content);
    }

    private static String getSplitWeiboId(String content) {
        if (content == null) {
            return null;
        }
        int bIndex = content.indexOf("user_id");
        String subContent = content.substring(bIndex + 10);
        int cIndex = subContent.indexOf("\"");
        String weiboId = subContent.substring(0, cIndex);
        return weiboId;
    }

    public static String getFromBASE64(String s) {
        if (s == null) {
            return null;
        }
        s = WeiboUtil.decodeSpecialLetter1(s);
        s = s.replace("*", "+");
        s = s.replace("-", "/");
        s = s + "=";
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            byte[] b = decoder.decodeBuffer(s);
            return new String(b);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String decodeSpecialLetter1(String str) {
        str = str.replace("-X-", "*");
        str = str.replace("-XX", "-X");
        return str;
    }
}

