/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.mcloud.admin.action.xt.base;

import com.kingdee.mcloud.admin.action.xt.base.XTMessage;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public abstract class XTResponse
extends XTMessage {
    public static final XTResponse CODE_ERROR_RESP = XTResponse.errorMsgProcess();
    public static final XTResponse CODE_UNKNOWN_ALG_RESP = XTResponse.errorAlg();
    public static final XTResponse CODE_UNKNOWN_SERVICEID_RESP = XTResponse.errorServiceIDType();
    public static final XTResponse CODE_ERROR_MSG_FORMAT_RESP = XTResponse.errorMessageFormat();
    public static final XTResponse CODE_ERROR_PARAM_RESP = XTResponse.errorMsgParam();
    protected String error;
    protected int errorCode;

    @Override
    public JSONObject encodeBody() {
        JSONObject data = new JSONObject();
        data.put((Object)"error", (Object)this.error);
        data.put((Object)"errorCode", (Object)this.errorCode);
        return data;
    }

    @Override
    public void decodeBody(JSONObject bodyJSON) {
        this.errorCode = bodyJSON.getInt("errorCode");
        this.error = bodyJSON.getString("error");
        this.decodeBodyData(bodyJSON);
    }

    public void decodeBodyData(JSONObject bodyJSON) {
    }

    public static XTResponse error(String msg, int code) {
        return new CommonErrorResponse(msg, code);
    }

    public static XTResponse errorMsgProcess() {
        return new CommonErrorResponse("\u6d88\u606f\u5904\u7406\u5931\u8d25", 1);
    }

    public static XTResponse errorAlg() {
        return new CommonErrorResponse("\u672a\u77e5\u7684\u52a0\u5bc6\u7b97\u6cd5", 2);
    }

    public static XTResponse errorServiceIDType() {
        return new CommonErrorResponse("\u672a\u77e5\u7684\u6d88\u606f\u7c7b\u578b", 2);
    }

    public static XTResponse errorMessageFormat() {
        return new CommonErrorResponse("\u6d88\u606f\u683c\u5f0f\u4e0d\u6b63\u786e", 4);
    }

    public static XTResponse errorMsgParam() {
        return new CommonErrorResponse("\u53c2\u6570\u6821\u9a8c\u5931\u8d25", 5);
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public boolean isOk() {
        return this.errorCode == 0;
    }

    public static class CommonErrorResponse
    extends XTResponse {
        public CommonErrorResponse(String error, int errorCode) {
            this.header = new XTMessage.Header();
            this.header.error = StringUtils.isBlank((String)error) ? "" : error;
            this.header.errorCode = errorCode;
        }

        @Override
        public void decodeBody(JSONObject bodyJSON) {
        }

        @Override
        public JSONObject encodeBody() {
            return null;
        }

        @Override
        public String getServiceId() {
            return null;
        }
    }
}

