/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weibo4j.User;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class DirectMessage
extends WeiboResponse
implements Serializable {
    private String id;
    private String text;
    private String sender_id;
    private String recipient_id;
    private Date created_at;
    private String sender_screen_name;
    private String recipient_screen_name;
    private static final long serialVersionUID = -3253021825891789737L;
    private User sender;
    private User recipient;

    DirectMessage(Response res, Weibo weibo) throws WeiboException {
        super(res);
        this.init(res, res.asDocument().getDocumentElement(), weibo);
    }

    DirectMessage(Response res, Element elem, Weibo weibo) throws WeiboException {
        super(res);
        this.init(res, elem, weibo);
    }

    DirectMessage(JSONObject json) throws WeiboException {
        try {
            this.id = json.getString("id");
            this.text = json.getString("text");
            this.sender_id = json.getString("sender_id");
            this.recipient_id = json.getString("recipient_id");
            this.created_at = DirectMessage.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.sender_screen_name = json.getString("sender_screen_name");
            this.recipient_screen_name = json.getString("recipient_screen_name");
            if (!json.isNull("sender")) {
                this.sender = new User(json.getJSONObject("sender"));
            }
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone.getMessage() + ":" + json.toString(), jsone);
        }
    }

    private void init(Response res, Element elem, Weibo weibo) throws WeiboException {
        DirectMessage.ensureRootNodeNameIs("direct_message", elem);
        this.sender = new User(res, (Element)elem.getElementsByTagName("sender").item(0), weibo);
        this.recipient = new User(res, (Element)elem.getElementsByTagName("recipient").item(0), weibo);
        this.id = DirectMessage.getChildText("id", elem);
        this.text = DirectMessage.getChildText("text", elem);
        this.sender_id = DirectMessage.getChildText("sender_id", elem);
        this.recipient_id = DirectMessage.getChildText("recipient_id", elem);
        this.created_at = DirectMessage.getChildDate("created_at", elem);
        this.sender_screen_name = DirectMessage.getChildText("sender_screen_name", elem);
        this.recipient_screen_name = DirectMessage.getChildText("recipient_screen_name", elem);
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public String getSenderId() {
        return this.sender_id;
    }

    public String getRecipientId() {
        return this.recipient_id;
    }

    public Date getCreatedAt() {
        return this.created_at;
    }

    public String getSenderScreenName() {
        return this.sender_screen_name;
    }

    public String getRecipientScreenName() {
        return this.recipient_screen_name;
    }

    public User getSender() {
        return this.sender;
    }

    public User getRecipient() {
        return this.recipient;
    }

    static List<DirectMessage> constructDirectMessages(Response res, Weibo weibo) throws WeiboException {
        Document doc = res.asDocument();
        if (DirectMessage.isRootNodeNilClasses(doc)) {
            return new ArrayList<DirectMessage>(0);
        }
        try {
            DirectMessage.ensureRootNodeNameIs("direct-messages", doc);
            NodeList list = doc.getDocumentElement().getElementsByTagName("direct_message");
            int size = list.getLength();
            ArrayList<DirectMessage> messages = new ArrayList<DirectMessage>(size);
            for (int i = 0; i < size; ++i) {
                Element status = (Element)list.item(i);
                messages.add(new DirectMessage(res, status, weibo));
            }
            return messages;
        }
        catch (WeiboException te) {
            if (DirectMessage.isRootNodeNilClasses(doc)) {
                return new ArrayList<DirectMessage>(0);
            }
            throw te;
        }
    }

    static List<DirectMessage> constructDirectMessages(Response res) throws WeiboException {
        JSONArray list = res.asJSONArray();
        try {
            int size = list.length();
            ArrayList<DirectMessage> messages = new ArrayList<DirectMessage>(size);
            for (int i = 0; i < size; ++i) {
                messages.add(new DirectMessage(list.getJSONObject(i)));
            }
            return messages;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof DirectMessage && ((DirectMessage)obj).id == this.id;
    }

    public String toString() {
        return "DirectMessage{id=" + this.id + ", text='" + this.text + '\'' + ", sender_id=" + this.sender_id + ", recipient_id=" + this.recipient_id + ", created_at=" + this.created_at + ", sender_screen_name='" + this.sender_screen_name + '\'' + ", recipient_screen_name='" + this.recipient_screen_name + '\'' + ", sender=" + this.sender + ", recipient=" + this.recipient + '}';
    }
}

