/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Group
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = -3517566426034716779L;
    public String id;
    public String name;
    public String profile_image_url;
    public String description;
    public String bulletin;

    Group(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.id = json.getString("id");
            this.name = json.getString("name");
            this.profile_image_url = json.getString("profile_image_url");
            this.description = json.getString("description");
            this.bulletin = json.getString("bulletin");
        }
        catch (JSONException je) {
            throw new WeiboException(je.getMessage() + ":" + json.toString(), je);
        }
    }

    Group(JSONObject json) throws WeiboException {
        try {
            this.id = json.getString("id");
            this.name = json.getString("name");
            this.profile_image_url = json.getString("profile_image_url");
            this.description = json.getString("description");
            this.bulletin = json.getString("bulletin");
        }
        catch (JSONException je) {
            throw new WeiboException(je.getMessage() + ":" + json.toString(), je);
        }
    }

    static List<Group> constructList(Response res) throws WeiboException {
        JSONArray list = res.asJSONArray();
        try {
            int size = list.length();
            ArrayList<Group> groups = new ArrayList<Group>(size);
            for (int i = 0; i < size; ++i) {
                groups.add(new Group(list.getJSONObject(i)));
            }
            return groups;
        }
        catch (JSONException je) {
            throw new WeiboException(je.getMessage() + ":" + list.toString(), je);
        }
    }
}

