/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.ArrayList;
import java.util.List;
import weibo4j.Query;
import weibo4j.Tweet;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.WeiboSupport;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class QueryResult
extends WeiboResponse {
    private long sinceId;
    private long maxId;
    private String refreshUrl;
    private int resultsPerPage;
    private int total = -1;
    private String warning;
    private double completedIn;
    private int page;
    private String query;
    private List<Tweet> tweets;
    private static final long serialVersionUID = -9059136565234613286L;

    QueryResult(Response res, WeiboSupport weiboSupport) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.sinceId = json.getLong("since_id");
            this.maxId = json.getLong("max_id");
            this.refreshUrl = QueryResult.getString("refresh_url", json, true);
            this.resultsPerPage = json.getInt("results_per_page");
            this.warning = QueryResult.getString("warning", json, false);
            this.completedIn = json.getDouble("completed_in");
            this.page = json.getInt("page");
            this.query = QueryResult.getString("query", json, true);
            JSONArray array = json.getJSONArray("results");
            this.tweets = new ArrayList<Tweet>(array.length());
            for (int i = 0; i < array.length(); ++i) {
                JSONObject tweet = array.getJSONObject(i);
                this.tweets.add(new Tweet(tweet, weiboSupport));
            }
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone.getMessage() + ":" + json.toString(), jsone);
        }
    }

    QueryResult(Query query) throws WeiboException {
        this.sinceId = query.getSinceId();
        this.resultsPerPage = query.getRpp();
        this.page = query.getPage();
        this.tweets = new ArrayList<Tweet>(0);
    }

    public long getSinceId() {
        return this.sinceId;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public int getResultsPerPage() {
        return this.resultsPerPage;
    }

    public int getTotal() {
        return this.total;
    }

    public String getWarning() {
        return this.warning;
    }

    public double getCompletedIn() {
        return this.completedIn;
    }

    public int getPage() {
        return this.page;
    }

    public String getQuery() {
        return this.query;
    }

    public List<Tweet> getTweets() {
        return this.tweets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryResult that = (QueryResult)o;
        if (Double.compare(that.completedIn, this.completedIn) != 0) {
            return false;
        }
        if (this.maxId != that.maxId) {
            return false;
        }
        if (this.page != that.page) {
            return false;
        }
        if (this.resultsPerPage != that.resultsPerPage) {
            return false;
        }
        if (this.sinceId != that.sinceId) {
            return false;
        }
        if (this.total != that.total) {
            return false;
        }
        if (!this.query.equals(that.query)) {
            return false;
        }
        if (this.refreshUrl != null ? !this.refreshUrl.equals(that.refreshUrl) : that.refreshUrl != null) {
            return false;
        }
        if (this.tweets != null ? !this.tweets.equals(that.tweets) : that.tweets != null) {
            return false;
        }
        return !(this.warning != null ? !this.warning.equals(that.warning) : that.warning != null);
    }

    public int hashCode() {
        int result = (int)(this.sinceId ^ this.sinceId >>> 32);
        result = 31 * result + (int)(this.maxId ^ this.maxId >>> 32);
        result = 31 * result + (this.refreshUrl != null ? this.refreshUrl.hashCode() : 0);
        result = 31 * result + this.resultsPerPage;
        result = 31 * result + this.total;
        result = 31 * result + (this.warning != null ? this.warning.hashCode() : 0);
        long temp = this.completedIn != 0.0 ? Double.doubleToLongBits(this.completedIn) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.page;
        result = 31 * result + this.query.hashCode();
        result = 31 * result + (this.tweets != null ? this.tweets.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "QueryResult{sinceId=" + this.sinceId + ", maxId=" + this.maxId + ", refreshUrl='" + this.refreshUrl + '\'' + ", resultsPerPage=" + this.resultsPerPage + ", total=" + this.total + ", warning='" + this.warning + '\'' + ", completedIn=" + this.completedIn + ", page=" + this.page + ", query='" + this.query + '\'' + ", tweets=" + this.tweets + '}';
    }
}

