/*
 * Decompiled with CFR 0.152.
 */
package weibo4j.http;

import java.io.Serializable;
import javax.crypto.spec.SecretKeySpec;
import weibo4j.WeiboException;
import weibo4j.http.Response;

abstract class OAuthToken
implements Serializable {
    private static final long serialVersionUID = 2385887178385032767L;
    private String token;
    private String tokenSecret;
    private transient SecretKeySpec secretKeySpec;
    String[] responseStr = null;

    public OAuthToken(String token, String tokenSecret) {
        this.token = token;
        this.tokenSecret = tokenSecret;
    }

    OAuthToken(Response response) throws WeiboException {
        this(response.asString());
    }

    OAuthToken(String string) {
        this.responseStr = string.split("&");
        this.tokenSecret = this.getParameter("oauth_token_secret");
        this.token = this.getParameter("oauth_token");
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    void setSecretKeySpec(SecretKeySpec secretKeySpec) {
        this.secretKeySpec = secretKeySpec;
    }

    SecretKeySpec getSecretKeySpec() {
        return this.secretKeySpec;
    }

    public String getParameter(String parameter) {
        String value = null;
        for (String str : this.responseStr) {
            if (!str.startsWith(parameter + '=')) continue;
            value = str.split("=")[1].trim();
            break;
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuthToken)) {
            return false;
        }
        OAuthToken that = (OAuthToken)o;
        if (this.secretKeySpec != null ? !this.secretKeySpec.equals(that.secretKeySpec) : that.secretKeySpec != null) {
            return false;
        }
        if (!this.token.equals(that.token)) {
            return false;
        }
        return this.tokenSecret.equals(that.tokenSecret);
    }

    public int hashCode() {
        int result = this.token.hashCode();
        result = 31 * result + this.tokenSecret.hashCode();
        result = 31 * result + (this.secretKeySpec != null ? this.secretKeySpec.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "OAuthToken{token='" + this.token + '\'' + ", tokenSecret='" + this.tokenSecret + '\'' + ", secretKeySpec=" + this.secretKeySpec + '}';
    }
}

