/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.image.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.ImageOperation;
import com.kingdee.eas.base.wssc.ImageSystemException;
import com.kingdee.eas.base.wssc.app.trd.webservice.WebServiceConfig;
import com.kingdee.eas.base.wssc.image.helper.NoticeImageSysHelper;
import com.kingdee.eas.base.wssc.image.pojo.ImageSysSuperBaseInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSys2RejectBillInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSys2RescanInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSys2SendNoteInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSys2getScanHomeInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysArchive;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysCancelRescanInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysCreateJobInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysDeleteInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysDestroyInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysSubmitInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysSynVoucherInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysToAppParamInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysUploadInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysViewInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysViewOnPhoneInfo;
import com.kingdee.eas.base.wssc.imageNew.util.HttpPostUtil;
import com.kingdee.eas.base.wssc.imageNew.util.ImageLogUtil;
import com.kingdee.eas.base.wssc.util.MD5;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class NoticeImageSysHelper_FPY
extends NoticeImageSysHelper {
    private Logger logger = Logger.getLogger(NoticeImageSysHelper_FPY.class);
    public static final String ENTRUST_TYPE_ID = "00000000-0000-0000-0000-0000000000010FE9F8B5";
    public final String key = "FPY";
    private StringBuffer bufferParam = new StringBuffer();
    private StringBuffer bufferException = new StringBuffer();
    private String clientId = null;
    private String sign = null;
    private long timestamp = 0L;
    private String token = null;
    private String phoneNumber = null;
    private String taxNo = null;
    private String feasUid = null;

    private String getRequestToken(Context ctx, String barCode) throws Exception {
        this.initToken(ctx, barCode);
        return this.token;
    }

    private void initToken(Context ctx, String barCode) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.feasUid)) {
            this.feasUid = ctx.getCaller().toString();
        } else if (BOSUuid.isValid((String)this.feasUid, (boolean)false)) {
            ObjectUuidPK uuid = new ObjectUuidPK(this.feasUid);
            if (uuid != null && "80EF7DED".equals(uuid.getObjectType().toString())) {
                this.logger.error((Object)("id\u4e3apersonId:[" + this.feasUid + "],"));
                try {
                    EntityViewInfo view = new EntityViewInfo();
                    view.getFilter().getFilterItems().add(new FilterItemInfo("isDelete", (Object)false));
                    view.getFilter().getFilterItems().add(new FilterItemInfo("isForbidden", (Object)false));
                    view.getFilter().getFilterItems().add(new FilterItemInfo("person", (Object)this.feasUid));
                    UserCollection coll = UserFactory.getLocalInstance((Context)ctx).getUserCollection(view);
                    this.feasUid = coll.get(0).getId().toString();
                }
                catch (Exception e) {
                    this.logger.error((Object)"\u6839\u636epersonid\u67e5\u8be2userid\u51fa\u73b0\u5f02\u5e38!");
                }
            } else if (uuid == null || !"13B7DE7F".equals(uuid.getObjectType().toString())) {
                this.logger.error((Object)("\u65e0\u6548\u7684\u7528\u6237id,\u66ff\u6362\u4e3actx\u7684caller;\u539fid:" + this.feasUid + ";caller:" + ctx.getCaller()));
                this.feasUid = ctx.getCaller().toString();
            }
        } else {
            this.logger.error((Object)("\u65e0\u6548\u7684\u7528\u6237id,\u66ff\u6362\u4e3actx\u7684caller;\u539fid:" + this.feasUid + ";caller:" + ctx.getCaller()));
            this.feasUid = ctx.getCaller().toString();
        }
        if (this.phoneNumber == null) {
            this.initPhoneNumber(ctx);
        }
        if (this.clientId == null) {
            this.initParamsByUserID(ctx);
        }
        this.token = this.getTokenFromFPY(ctx, this.clientId, this.sign, this.timestamp, this.phoneNumber, this.taxNo, this.feasUid);
    }

    private void initParamsByUserID(Context ctx) throws BOSException, SQLException {
        this.timestamp = System.currentTimeMillis();
        String sql = "select oa.FID,oa.FlongNumber from T_ORG_Admin oa, T_ORG_PositionMember opm,T_ORG_Position op,T_PM_User pu where opm.FPositionID = op.FID and opm.FPersonID = pu.FPersonID and opm.FISPrimary = 1 and oa.FID = op.FAdminOrgUnitID and pu.FID = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{this.feasUid});
        String longNumber = null;
        if (rs.next()) {
            longNumber = rs.getString(2);
        }
        if (longNumber != null) {
            String sql3;
            IRowSet rs3;
            String[] numbers = longNumber.split("!");
            String companyLongNumber = null;
            for (int i = numbers.length - 1; i >= 0; --i) {
                String sql2 = "select oc.FlongNumber from T_ORG_UNITRELATION ur, T_ORG_Admin oa, T_ORG_Company oc where ur.FFromUnitID = oa.FID and ur.FToUnitID = oc.FID and FTYPERELATIONID = ? and oa.FNumber = ?";
                IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new Object[]{ENTRUST_TYPE_ID, numbers[i]});
                if (!rs2.next()) continue;
                companyLongNumber = rs2.getString(1);
                break;
            }
            if (companyLongNumber != null && (rs3 = DbUtil.executeQuery((Context)ctx, (String)(sql3 = "select FTAXNUMBER,FAuthorizationCode,FAuthorizationKey from T_ORG_Company where (charindex('!'||FNUMBER||'!', '" + companyLongNumber + "') > 1  or charindex(FNUMBER||'!','" + companyLongNumber + "') = 1 or FlongNumber = '" + companyLongNumber + "' ) and FTAXNUMBER is not null order by FLongNumber desc"), (Object[])new Object[0])).next()) {
                this.taxNo = rs3.getString(1);
                this.clientId = rs3.getString(2);
                this.sign = rs3.getString(3);
            }
        }
        this.sign = this.clientId + this.sign + this.timestamp;
        this.sign = MD5.md5crypt(this.sign);
    }

    private String getPostURLHeader(Context ctx) {
        String url = "https://api.piaozone.com";
        String ip = WebServiceConfig.getPropertiesValue((Context)ctx, (String)"image.ip");
        if (!StringUtils.isEmpty((CharSequence)ip)) {
            String port = WebServiceConfig.getPropertiesValue((Context)ctx, (String)"image.port");
            String urlprefix = WebServiceConfig.getPropertiesValue((Context)ctx, (String)"image.url.prefix") == null ? "http" : WebServiceConfig.getPropertiesValue((Context)ctx, (String)"image.url.prefix").trim();
            url = StringUtils.isEmpty((CharSequence)port) ? urlprefix + "://" + ip : urlprefix + "://" + ip + ":" + port;
        }
        return url;
    }

    private String getTokenFromFPY(Context ctx, String clientId, String sign, long timestamp, String phoneNumber, String ftaxNo, String feasUid) throws Exception {
        String retToken = null;
        String fsource = "2";
        String url = this.getPostURLHeader(ctx);
        String getTokenUrl = WebServiceConfig.getPropertiesValue((Context)ctx, (String)"image.token.tail");
        getTokenUrl = getTokenUrl == null ? "/archivebase/scan/login/token" : getTokenUrl;
        url = url + getTokenUrl;
        JSONObject param = new JSONObject();
        param.put((Object)"clientId", (Object)clientId);
        param.put((Object)"sign", (Object)sign);
        param.put((Object)"timestamp", (Object)timestamp);
        param.put((Object)"fphoneNumber", (Object)phoneNumber);
        param.put((Object)"ftaxNo", (Object)ftaxNo);
        param.put((Object)"feasUid", (Object)feasUid);
        param.put((Object)"fsource", (Object)fsource);
        this.logger.error((Object)("\u53d1\u7968\u4e91\u53d6token,Param:" + param));
        JSONObject retJsonObj = JSONObject.fromObject((Object)HttpPostUtil.postInterface(url, param.toString(), true));
        this.logger.error((Object)("\u53d1\u7968\u4e91\u53d6token,retJsonObj:" + retJsonObj));
        String errcode = retJsonObj.get("errcode") + "";
        if (!"0000".equals(errcode)) {
            this.logger.error((Object)("\u83b7\u53d6\u53d1\u7968\u4e91token\u8bf7\u6c42\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
            throw new Exception("\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edftoken\u8fd4\u56de\u9519\u8bef\u7801:" + errcode + ";\u9519\u8bef\u4fe1\u606fdescription:" + (retJsonObj.get("description") == null ? "" : retJsonObj.get("description")));
        }
        retToken = ((Map)retJsonObj.get("data")).get("accessToken") + "";
        return retToken;
    }

    private void initPhoneNumber(Context ctx) throws EASBizException, BOSException {
        if (UserFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(this.feasUid))) {
            UserInfo userInfo = null;
            if (this.phoneNumber == null) {
                userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(this.feasUid));
                this.phoneNumber = userInfo.getCell();
                if (this.phoneNumber == null && userInfo.getPerson() != null) {
                    PersonInfo pInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(userInfo.getPerson().getId()));
                    this.phoneNumber = pInfo.getCell();
                }
            }
            if (this.phoneNumber == null) {
                throw new RuntimeException("\u8d26\u53f7:" + userInfo.getNumber() + ",\u672a\u8bbe\u7f6e\u624b\u673a\u53f7\u7801,\u65e0\u6cd5\u8bf7\u6c42\u53d1\u7968\u4e91\u7cfb\u7edf\u67e5\u770b\u53d1\u7968\u4e91\u5f71\u50cf.\u8bf7\u8054\u7cfbEAS\u7ba1\u7406\u5458\u5728\u7528\u6237\u7ba1\u7406\u9875\u9762\u7ef4\u62a4\u624b\u673a\u53f7\u7801!");
            }
        } else {
            throw new RuntimeException("\u65e0\u6548\u7684\u7528\u6237id:" + this.feasUid + ",\u65e0\u5bf9\u5e94\u7528\u6237,\u65e0\u6cd5\u83b7\u53d6\u624b\u673a\u53f7!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getScanHomeUrl(NoticeImageSys2getScanHomeInfo scanHomeInfo) throws BOSException, ImageSystemException {
        String url = null;
        Context ctx = scanHomeInfo.getCtx();
        String requestUrl = this.getPostURLHeader(ctx);
        this.bufferParam.setLength(0);
        this.bufferException.setLength(0);
        try {
            try {
                String scan_tail = WebServiceConfig.getPropertiesValue((Context)ctx, (String)"image.scan.homeurl");
                scan_tail = scan_tail == null ? "/scan/bill/outside/getHomeUrl" : scan_tail;
                requestUrl = requestUrl + scan_tail;
                requestUrl = requestUrl + "?access_token=" + this.getRequestToken(ctx, scanHomeInfo.getBarCode());
                this.bufferParam.append("[").append(requestUrl).append("][").append(scanHomeInfo).append("]");
                JSONObject param = new JSONObject();
                String json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("getScanHomeUrl;return json:" + json));
                JSONObject retJsonObj = JSONObject.fromObject((Object)json);
                String errcode = retJsonObj.get("errcode") + "";
                if ("1300".equals(errcode)) {
                    this.logger.error((Object)("\u83b7\u53d6\u53d1\u7968\u4e91\u626b\u63cf\u9996\u9875\u8bf7\u6c42\u5931\u8d25!token\u5931\u6548!\u6e05\u9664token,\u91cd\u65b0\u5c1d\u8bd5\u8bf7\u6c42!token:" + this.token + ";retJsonObj:" + retJsonObj.get("description")));
                    String oldToken = this.token;
                    this.token = null;
                    this.token = this.getRequestToken(ctx, scanHomeInfo.getBarCode());
                    requestUrl = requestUrl.replace(oldToken, this.token);
                    json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                    this.logger.error((Object)("getScanHomeUrl\u7b2c\u4e8c\u6b21;return json:" + json));
                    retJsonObj = JSONObject.fromObject((Object)json);
                    errcode = retJsonObj.get("errcode") + "";
                }
                if (!"0000".equals(errcode)) {
                    this.logger.error((Object)("\u83b7\u53d6\u53d1\u7968\u4e91\u626b\u63cf\u9996\u9875\u8bf7\u6c42\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
                    throw new Exception("\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u83b7\u53d6\u626b\u63cf\u9996\u9875\u8fd4\u56de\u9519\u8bef\u7801:" + errcode + ";\u9519\u8bef\u4fe1\u606fdescription:" + (retJsonObj.get("description") == null ? "" : retJsonObj.get("description")));
                }
                url = ((Map)retJsonObj.get("data")).get("url") + "";
            }
            catch (RemoteException e) {
                this.logger.error((Object)("\u83b7\u53d6\u626b\u63cf\u9996\u9875--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + ctx.getAIS() + ";" + ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";scanHomeInfo:" + scanHomeInfo + "\n" + e), (Throwable)e);
                throw new ImageSystemException(ImageSystemException.IMAGESYS_INNER_EXCEPTION, e);
            }
            catch (Exception e) {
                throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, e);
            }
            String string = url;
            return string;
        }
        finally {
            ImageLogUtil.writeErrLog(ctx, scanHomeInfo.getBarCode(), ImageOperation.scanHome, this.bufferParam.toString(), this.bufferException.toString());
        }
    }

    @Override
    public String rescan(NoticeImageSys2RescanInfo rescanInfo) throws BOSException, ImageSystemException {
        this.bufferParam.setLength(0);
        this.bufferException.setLength(0);
        Context ctx = rescanInfo.getCtx();
        String requestUrl = this.getPostURLHeader(ctx);
        try {
            this.feasUid = rescanInfo.getUserId();
            String rescan_tail = WebServiceConfig.getPropertiesValue((Context)ctx, (String)"image.rescan");
            rescan_tail = rescan_tail == null ? "/scan/bill/outside/reject" : rescan_tail;
            requestUrl = requestUrl + rescan_tail;
            requestUrl = requestUrl + "?access_token=" + this.getRequestToken(ctx, rescanInfo.getBarCode());
            this.bufferParam.append("[").append(requestUrl).append("][").append(rescanInfo).append("]");
            JSONObject param = new JSONObject();
            param.put((Object)"scanBillNo", (Object)rescanInfo.getBarCode());
            param.put((Object)"rejectReason", (Object)(rescanInfo.getRescanMessage() == null ? "" : rescanInfo.getRescanMessage()));
            String json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
            this.logger.error((Object)("rescan;return json:" + json));
            JSONObject retJsonObj = JSONObject.fromObject((Object)json);
            String errcode = retJsonObj.get("errcode") + "";
            if ("1300".equals(errcode)) {
                this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf\u9000\u56de\u91cd\u626b\u5931\u8d25!token\u5931\u6548!\u6e05\u9664token,\u91cd\u65b0\u5c1d\u8bd5\u8bf7\u6c42!token:" + this.token + ";retJsonObj:" + retJsonObj.get("description")));
                String oldToken = this.token;
                this.token = null;
                this.token = this.getRequestToken(ctx, rescanInfo.getBarCode());
                requestUrl = requestUrl.replace(oldToken, this.token);
                json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("rescan\u7b2c\u4e8c\u6b21;return json:" + json));
                retJsonObj = JSONObject.fromObject((Object)json);
                errcode = retJsonObj.get("errcode") + "";
            }
            if ("0000".equals(errcode)) {
                return "1";
            }
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf\u9000\u56de\u91cd\u626b\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
            return "-2";
        }
        catch (RemoteException e) {
            this.logger.error((Object)("\u9000\u56de\u91cd\u626b--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + ctx.getAIS() + ";" + ctx.getCaller() + ";phone:" + this.phoneNumber + "ctx:" + ctx.getAIS() + ";" + ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";rescanInfo:" + rescanInfo + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.IMAGESYS_INNER_EXCEPTION, e);
        }
        catch (Exception e) {
            this.logger.error((Object)("\u9000\u56de\u91cd\u626b--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + ctx.getAIS() + ";" + ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";rescanInfo:" + rescanInfo + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, e);
        }
    }

    @Override
    public String cancelRescan(NoticeImageSysCancelRescanInfo cancelRescanInfo) throws BOSException, ImageSystemException {
        this.bufferParam.setLength(0);
        this.bufferException.setLength(0);
        Context ctx = cancelRescanInfo.getCtx();
        String requestUrl = this.getPostURLHeader(ctx);
        try {
            this.feasUid = cancelRescanInfo.getCancelUser();
            String tail = WebServiceConfig.getPropertiesValue((Context)ctx, (String)"image.cancelrescan");
            tail = tail == null ? "/scan/bill/outside/reject/cancel" : tail;
            requestUrl = requestUrl + tail;
            requestUrl = requestUrl + "?access_token=" + this.getRequestToken(ctx, cancelRescanInfo.getBarCode());
            this.bufferParam.append("[").append(requestUrl).append("][").append(cancelRescanInfo).append("]");
            JSONObject param = new JSONObject();
            param.put((Object)"scanBillNo", (Object)cancelRescanInfo.getBarCode());
            param.put((Object)"cancelRejectReason", (Object)(cancelRescanInfo.getCancelMessage() == null ? "" : cancelRescanInfo.getCancelMessage()));
            String json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
            this.logger.error((Object)("cancelRescan;return json:" + json));
            JSONObject retJsonObj = JSONObject.fromObject((Object)json);
            String errcode = retJsonObj.get("errcode") + "";
            if ("1300".equals(errcode)) {
                this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf!token\u5931\u6548!\u6e05\u9664token,\u91cd\u65b0\u5c1d\u8bd5\u8bf7\u6c42!token:" + this.token + ";retJsonObj:" + retJsonObj.get("description")));
                String oldToken = this.token;
                this.token = null;
                this.token = this.getRequestToken(ctx, cancelRescanInfo.getBarCode());
                requestUrl = requestUrl.replace(oldToken, this.token);
                json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("\u7b2c\u4e8c\u6b21;return json:" + json));
                retJsonObj = JSONObject.fromObject((Object)json);
                errcode = retJsonObj.get("errcode") + "";
            }
            if ("0000".equals(errcode)) {
                return "1";
            }
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf\u53d6\u6d88\u9000\u56de\u91cd\u626b\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
            return "-2";
        }
        catch (RemoteException e) {
            this.logger.error((Object)("\u53d6\u6d88\u9000\u56de\u91cd\u626b--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + ctx.getAIS() + ";" + ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";cancelRescanInfo:" + cancelRescanInfo + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.IMAGESYS_INNER_EXCEPTION, e);
        }
        catch (Exception e) {
            this.logger.error((Object)("\u53d6\u6d88\u9000\u56de\u91cd\u626b--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + ctx.getAIS() + ";" + ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";cancelRescanInfo:" + cancelRescanInfo + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String viewPhoto(NoticeImageSysViewInfo viewPhotoInfo) throws BOSException, ImageSystemException {
        String url = null;
        Context ctx = viewPhotoInfo.getCtx();
        String requestUrl = this.getPostURLHeader(ctx);
        this.bufferParam.setLength(0);
        this.bufferException.setLength(0);
        try {
            try {
                String tail = WebServiceConfig.getPropertiesValue((Context)ctx, (String)"image.view");
                tail = tail == null ? "/scan/bill/outside/getScanUrl" : tail;
                requestUrl = requestUrl + tail;
                requestUrl = requestUrl + "?access_token=" + this.getRequestToken(ctx, viewPhotoInfo.getBarCode());
                this.bufferParam.append("[").append(requestUrl).append("][").append(viewPhotoInfo).append("]");
                JSONObject param = new JSONObject();
                param.put((Object)"scanBillNo", (Object)viewPhotoInfo.getBarCode());
                param.put((Object)"isRemark", (Object)viewPhotoInfo.isAllowRescan());
                param.put((Object)"isRescan", (Object)viewPhotoInfo.isAllowRescan());
                param.put((Object)"isEdit", (Object)false);
                String json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("getScanHomeUrl;return json:" + json));
                JSONObject retJsonObj = JSONObject.fromObject((Object)json);
                String errcode = retJsonObj.get("errcode") + "";
                if ("1300".equals(errcode)) {
                    this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf!token\u5931\u6548!\u6e05\u9664token,\u91cd\u65b0\u5c1d\u8bd5\u8bf7\u6c42!token:" + this.token + ";retJsonObj:" + retJsonObj.get("description")));
                    String oldToken = this.token;
                    this.token = null;
                    this.token = this.getRequestToken(ctx, viewPhotoInfo.getBarCode());
                    requestUrl = requestUrl.replace(oldToken, this.token);
                    json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                    this.logger.error((Object)("\u7b2c\u4e8c\u6b21;return json:" + json));
                    retJsonObj = JSONObject.fromObject((Object)json);
                    errcode = retJsonObj.get("errcode") + "";
                }
                if (!"0000".equals(errcode)) {
                    this.logger.error((Object)("\u83b7\u53d6\u53d1\u7968\u4e91\u67e5\u770b\u5f71\u50cf\u9875\u9762\u8bf7\u6c42\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
                    throw new Exception("\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u67e5\u770b\u5f71\u50cf\u8fd4\u56de\u9519\u8bef\u7801:" + errcode + ";\u9519\u8bef\u4fe1\u606fdescription:" + (retJsonObj.get("description") == null ? "" : retJsonObj.get("description")));
                }
                url = ((Map)retJsonObj.get("data")).get("url") + "";
            }
            catch (RemoteException e) {
                this.logger.error((Object)("\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u67e5\u770b\u5f71\u50cf--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + ctx.getAIS() + ";" + ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";viewPhotoInfo:" + viewPhotoInfo + "\n" + e), (Throwable)e);
                throw new ImageSystemException(ImageSystemException.IMAGESYS_INNER_EXCEPTION, e);
            }
            catch (Exception e) {
                this.logger.error((Object)("\u8bf7\u6c42\u5f71\u50cf\u7cfb\u7edf\u67e5\u770b\u5f71\u50cf--\u8c03\u7528\u5f71\u50cf\u7cfb\u7edf\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38.ctx:" + ctx.getAIS() + ";" + ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";viewPhotoInfo:" + viewPhotoInfo + "\n" + e), (Throwable)e);
                throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, e);
            }
            String string = url;
            return string;
        }
        finally {
            ImageLogUtil.writeErrLog(ctx, viewPhotoInfo.getBarCode(), ImageOperation.viewPhoto, this.bufferParam.toString(), this.bufferException.toString());
        }
    }

    @Override
    public String imageUpload(NoticeImageSysUploadInfo uploadInfo) throws BOSException, ImageSystemException {
        throw new ImageSystemException(ImageSystemException.NOT_IMPLEMENT_YET);
    }

    @Override
    public String viewPhotoOnPhone(NoticeImageSysViewOnPhoneInfo viewPhotoInfo) throws BOSException, ImageSystemException {
        throw new ImageSystemException(ImageSystemException.NOT_IMPLEMENT_YET);
    }

    @Override
    public String viewPhotos(NoticeImageSysViewInfo[] viewPhotoInfos) throws BOSException, ImageSystemException {
        throw new ImageSystemException(ImageSystemException.NOT_IMPLEMENT_YET);
    }

    @Override
    public String viewPhotosOnPhone(NoticeImageSysViewOnPhoneInfo[] viewPhotoInfos) throws BOSException, ImageSystemException {
        throw new ImageSystemException(ImageSystemException.NOT_IMPLEMENT_YET);
    }

    @Override
    public String synVoucherInfo(NoticeImageSysSynVoucherInfo synInfo) throws BOSException, ImageSystemException {
        throw new ImageSystemException(ImageSystemException.NOT_IMPLEMENT_YET);
    }

    @Override
    public String deleteImage(NoticeImageSysDeleteInfo deleteInfo) throws BOSException, ImageSystemException {
        this.bufferParam.setLength(0);
        this.bufferException.setLength(0);
        Context ctx = deleteInfo.getCtx();
        String requestUrl = this.getPostURLHeader(ctx);
        try {
            this.feasUid = deleteInfo.getUserId();
            String tail = WebServiceConfig.getPropertiesValue((Context)ctx, (String)"image.delete");
            tail = tail == null ? "/scan/bill/outside/delete" : tail;
            requestUrl = requestUrl + tail;
            requestUrl = requestUrl + "?access_token=" + this.getRequestToken(ctx, deleteInfo.getBarCode());
            this.bufferParam.append("[").append(requestUrl).append("][").append(deleteInfo).append("]");
            JSONObject param = new JSONObject();
            param.put((Object)"scanBillNo", (Object)deleteInfo.getBarCode());
            param.put((Object)"deleteReason", (Object)deleteInfo.getMessage());
            String json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
            this.logger.error((Object)("deleteImage;return json:" + json));
            JSONObject retJsonObj = JSONObject.fromObject((Object)json);
            String errcode = retJsonObj.get("errcode") + "";
            if ("1300".equals(errcode)) {
                this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf!token\u5931\u6548!\u6e05\u9664token,\u91cd\u65b0\u5c1d\u8bd5\u8bf7\u6c42!token:" + this.token + ";retJsonObj:" + retJsonObj.get("description")));
                String oldToken = this.token;
                this.token = null;
                this.token = this.getRequestToken(ctx, deleteInfo.getBarCode());
                requestUrl = requestUrl.replace(oldToken, this.token);
                json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("\u7b2c\u4e8c\u6b21;return json:" + json));
                retJsonObj = JSONObject.fromObject((Object)json);
                errcode = retJsonObj.get("errcode") + "";
            }
            if ("0000".equals(errcode)) {
                return "1";
            }
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edfdeleteImage(\u5220\u9664)\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
            return "-2";
        }
        catch (RemoteException e) {
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edfdeleteImage(\u5220\u9664)\u51fa\u73b0\u5f02\u5e38.ctx:" + ctx.getAIS() + ";" + ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";deleteInfo:" + deleteInfo + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.IMAGESYS_INNER_EXCEPTION, e);
        }
        catch (Exception e) {
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edfdeleteImage(\u5220\u9664)\u51fa\u73b0\u5f02\u5e38.ctx:" + ctx.getAIS() + ";" + ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";deleteInfo:" + deleteInfo + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, e);
        }
    }

    @Override
    public String destroyImage(NoticeImageSysDestroyInfo destroyInfo) throws BOSException, ImageSystemException {
        this.bufferParam.setLength(0);
        this.bufferException.setLength(0);
        Context ctx = destroyInfo.getCtx();
        String requestUrl = this.getPostURLHeader(ctx);
        try {
            this.feasUid = destroyInfo.getOpreatePerson() == null ? destroyInfo.getSscNumber() : destroyInfo.getOpreatePerson();
            String tail = WebServiceConfig.getPropertiesValue((Context)ctx, (String)"image.delete");
            tail = tail == null ? "/scan/bill/outside/delete" : tail;
            requestUrl = requestUrl + tail;
            requestUrl = requestUrl + "?access_token=" + this.getRequestToken(ctx, destroyInfo.getBarCode());
            this.bufferParam.append("[").append(requestUrl).append("][").append(destroyInfo).append("]");
            JSONObject param = new JSONObject();
            param.put((Object)"scanBillNo", (Object)destroyInfo.getBarCode());
            param.put((Object)"deleteReason", (Object)destroyInfo.getMessage());
            String json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
            this.logger.error((Object)("deleteImage;return json:" + json));
            JSONObject retJsonObj = JSONObject.fromObject((Object)json);
            String errcode = retJsonObj.get("errcode") + "";
            if ("1300".equals(errcode)) {
                this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf!token\u5931\u6548!\u6e05\u9664token,\u91cd\u65b0\u5c1d\u8bd5\u8bf7\u6c42!token:" + this.token + ";retJsonObj:" + retJsonObj.get("description")));
                String oldToken = this.token;
                this.token = null;
                this.token = this.getRequestToken(ctx, destroyInfo.getBarCode());
                requestUrl = requestUrl.replace(oldToken, this.token);
                json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("\u7b2c\u4e8c\u6b21;return json:" + json));
                retJsonObj = JSONObject.fromObject((Object)json);
                errcode = retJsonObj.get("errcode") + "";
            }
            if ("0000".equals(errcode)) {
                return "1";
            }
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edfdestroyImage(\u5220\u9664)\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
            return "-2";
        }
        catch (RemoteException e) {
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edfdestroyImage(\u5220\u9664)\u51fa\u73b0\u5f02\u5e38.ctx:" + ctx.getAIS() + ";" + ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";destroyInfo:" + destroyInfo + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.IMAGESYS_INNER_EXCEPTION, e);
        }
        catch (Exception e) {
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edfdestroyImage(\u5220\u9664)\u51fa\u73b0\u5f02\u5e38.ctx:" + ctx.getAIS() + ";" + ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";destroyInfo:" + destroyInfo + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, e);
        }
    }

    @Override
    public String submit2ImageSys(NoticeImageSysSubmitInfo submitInfo) throws BOSException, ImageSystemException {
        throw new ImageSystemException(ImageSystemException.NOT_IMPLEMENT_YET);
    }

    @Override
    public String freezeArchiveImage(ImageSysSuperBaseInfo superBaseInfo) throws BOSException, ImageSystemException {
        throw new ImageSystemException(ImageSystemException.NOT_IMPLEMENT_YET);
    }

    @Override
    public String noticImageSysCreateScanJob(ImageSysSuperBaseInfo superBaseInfo) throws BOSException, ImageSystemException {
        NoticeImageSysCreateJobInfo createJobInfo = (NoticeImageSysCreateJobInfo)superBaseInfo;
        Context ctx = createJobInfo.getCtx();
        String requestUrl = this.getPostURLHeader(ctx);
        try {
            String tail = WebServiceConfig.getPropertiesValue((Context)ctx, (String)"image.createscanjob");
            tail = tail == null ? "/imgsys/bill/signPost/erpBillPush" : tail;
            requestUrl = requestUrl + tail;
            requestUrl = requestUrl + "?access_token=" + this.getRequestToken(ctx, createJobInfo.getBarCode());
            this.bufferParam.append("[").append(requestUrl).append("][").append(createJobInfo).append("]");
            JSONObject param = new JSONObject();
            param.put((Object)"fscanBillNo", (Object)createJobInfo.getBarCode());
            param.put((Object)"fbillId", (Object)createJobInfo.getBillId());
            param.put((Object)"fbillTypeCode", (Object)createJobInfo.getBillType());
            param.put((Object)"fbillTypeDes", (Object)createJobInfo.getBillTypeName());
            param.put((Object)"fapplyUserName", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getName());
            param.put((Object)"fapplyUserPhone", (Object)this.phoneNumber);
            param.put((Object)"fapplyErpUserName", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getNumber());
            param.put((Object)"ferpDataId", (Object)ctx.getAIS());
            param.put((Object)"fsource", (Object)"2");
            param.put((Object)"fapplyOrganizationCode", (Object)createJobInfo.getOrgNo());
            param.put((Object)"fapplyOrganizationName", (Object)createJobInfo.getOrgName());
            param.put((Object)"ferpDataId", (Object)ctx.getAIS());
            param.put((Object)"fsource", (Object)"2");
            String json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
            this.logger.error((Object)("noticImageSysCreateScanJob;return json:" + json));
            JSONObject retJsonObj = JSONObject.fromObject((Object)json);
            String errcode = retJsonObj.get("errcode") + "";
            if ("1300".equals(errcode)) {
                this.logger.error((Object)("noticImageSysCreateScanJob:" + this.token + ";retJsonObj:" + retJsonObj.get("description")));
                String oldToken = this.token;
                this.token = null;
                this.token = this.getRequestToken(ctx, createJobInfo.getBarCode());
                requestUrl = requestUrl.replace(oldToken, this.token);
                json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("noticImageSysCreateScanJob:" + json));
                retJsonObj = JSONObject.fromObject((Object)json);
                errcode = retJsonObj.get("errcode") + "";
            }
            if ("0000".equals(errcode)) {
                return String.valueOf(true);
            }
            this.logger.error((Object)("noticImageSysCreateScanJob:" + errcode + "!description:" + retJsonObj.get("description")));
            return String.valueOf(false);
        }
        catch (Exception e) {
            this.logger.error((Object)"FPY--noticImageSysCreateScanJob Exception");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return String.valueOf(false);
        }
    }

    @Override
    public String rejectBill(NoticeImageSys2RejectBillInfo rejectBillInfo) throws BOSException, ImageSystemException {
        return null;
    }

    @Override
    public String sendNote(NoticeImageSys2SendNoteInfo sendNote) throws BOSException, ImageSystemException {
        this.bufferParam.setLength(0);
        this.bufferException.setLength(0);
        Context ctx = sendNote.getCtx();
        String requestUrl = this.getPostURLHeader(ctx);
        try {
            String tail = WebServiceConfig.getPropertiesValue((Context)ctx, (String)"image.sendnote");
            tail = tail == null ? "/scan/bill/outside/review" : tail;
            requestUrl = requestUrl + tail;
            requestUrl = requestUrl + "?access_token=" + this.getRequestToken(ctx, sendNote.getBarCode());
            this.bufferParam.append("[").append(requestUrl).append("][").append(sendNote).append("]");
            JSONObject param = new JSONObject();
            param.put((Object)"scanBillNo", (Object)sendNote.getBarCode());
            String json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
            this.logger.error((Object)("sendNote;return json:" + json));
            JSONObject retJsonObj = JSONObject.fromObject((Object)json);
            String errcode = retJsonObj.get("errcode") + "";
            if ("1300".equals(errcode)) {
                this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf!token\u5931\u6548!\u6e05\u9664token,\u91cd\u65b0\u5c1d\u8bd5\u8bf7\u6c42!token:" + this.token + ";retJsonObj:" + retJsonObj.get("description")));
                String oldToken = this.token;
                this.token = null;
                this.token = this.getRequestToken(ctx, sendNote.getBarCode());
                requestUrl = requestUrl.replace(oldToken, this.token);
                json = HttpPostUtil.postInterface(requestUrl, param.toString(), true);
                this.logger.error((Object)("\u7b2c\u4e8c\u6b21;return json:" + json));
                retJsonObj = JSONObject.fromObject((Object)json);
                errcode = retJsonObj.get("errcode") + "";
            }
            if ("0000".equals(errcode)) {
                return "1";
            }
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf\u5ba1\u6838\u901a\u8fc7\u5931\u8d25!errcode:" + errcode + "!description:" + retJsonObj.get("description")));
            return "-2";
        }
        catch (RemoteException e) {
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf\u5ba1\u6838\u901a\u8fc7\u51fa\u73b0\u5f02\u5e38.ctx:" + ctx.getAIS() + ";" + ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";sendNote:" + sendNote + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.IMAGESYS_INNER_EXCEPTION, e);
        }
        catch (Exception e) {
            this.logger.error((Object)("\u901a\u77e5\u53d1\u7968\u4e91\u5f71\u50cf\u7cfb\u7edf\u5ba1\u6838\u901a\u8fc7\u51fa\u73b0\u5f02\u5e38.ctx:" + ctx.getAIS() + ";" + ctx.getCaller() + ";phone:" + this.phoneNumber + "url:" + requestUrl + ";token:" + this.token + ";sendNote:" + sendNote + "\n" + e), (Throwable)e);
            throw new ImageSystemException(ImageSystemException.UNKNOW_IMAGE_EXCEPTION, e);
        }
    }

    @Override
    public String getToImageAppParam(NoticeImageSysToAppParamInfo toAppInfo) throws BOSException, ImageSystemException {
        throw new ImageSystemException(ImageSystemException.NOT_IMPLEMENT_YET);
    }

    @Override
    public Map<String, String> noticeArchive(NoticeImageSysArchive noticeArchiveInfo) throws BOSException, ImageSystemException {
        throw new ImageSystemException(ImageSystemException.NOT_IMPLEMENT_YET);
    }
}

