/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.imageNew.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.wssc.MultiImageServiceFacadeFactory;
import com.kingdee.eas.base.wssc.ShareCenterCollection;
import com.kingdee.eas.base.wssc.ShareCenterFactory;
import com.kingdee.eas.base.wssc.imageNew.pojo.BillFiledOrgTypeInfo;
import com.kingdee.eas.base.wssc.imageNew.util.Configure;
import com.kingdee.eas.base.wssc.imageNew.util.WSSCImageUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class MultiImageManager {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.imageNew.util.MultiImageManager");

    public static String getImageSysId(Context ctx, String bosType, IObjectValue billValue) throws BOSException, EASBizException {
        Map permissionType = MultiImageServiceFacadeFactory.getLocalInstance(ctx).getImagePermissionType();
        if ("org".equals(permissionType.get("type"))) {
            return new PermissionOrg().getImageSysId(ctx, bosType, billValue);
        }
        if ("billType".equals(permissionType.get("type"))) {
            return new PermissionBillType().getImageSysId(ctx, bosType, billValue);
        }
        throw new EASBizException(new NumericExceptionSubItem("00", "\u591a\u5f71\u50cf\u7cfb\u7edf\u6743\u9650\u7c7b\u578b\u914d\u7f6e\u9519\u8bef\uff01"));
    }

    private static class PermissionOrg
    implements IPermission {
        private PermissionOrg() {
        }

        @Override
        public String getImageSysId(Context ctx, String bosType, IObjectValue billValue) throws BOSException, EASBizException {
            String simpleCode = Configure.getBillOrgFiledTypeSimpleCode(ctx);
            BillFiledOrgTypeInfo info = WSSCImageUtils.getBillFiledOrgType(ctx, bosType, billValue, simpleCode);
            return WSSCImageUtils.getImageSysByOrg(ctx, info.getOrgFiledValue(), info.getOrgType(), true);
        }
    }

    private static class PermissionBillType
    implements IPermission {
        private PermissionBillType() {
        }

        @Override
        public String getImageSysId(Context ctx, String bosType, IObjectValue billValue) throws BOSException, EASBizException {
            ShareCenterCollection shareCenterColl = ShareCenterFactory.getLocalInstance(ctx).getShareCenterCollection("select id where cfgType = 'IMAGE'");
            if (shareCenterColl.size() == 0) {
                logger.error((Object)"MultiImageManager.PermissionBillType.getImageSysId******\u672a\u627e\u5230\u4efb\u4f55\u5f71\u50cf\u7cfb\u7edf*****");
                return null;
            }
            if (shareCenterColl.size() == 1) {
                return shareCenterColl.get(0).getId().toString();
            }
            if (StringUtils.isEmpty((CharSequence)bosType) && billValue != null) {
                BOSObjectType billValueBOSType = billValue.getBOSType();
                if (billValueBOSType == null) {
                    Object id = billValue.get("id");
                    if (id != null) {
                        ObjectUuidPK oldUuidPK = new ObjectUuidPK(id.toString());
                        bosType = oldUuidPK.getObjectType().toString();
                    }
                } else {
                    bosType = billValueBOSType.toString();
                }
            }
            try {
                String sql = " SELECT BI.FIMAGESYSID,EB.FBILLBOSTYPE FROM T_WSC_EASBILLTYPE EB INNER JOIN T_WSC_BILLTYPEIMAGE BI ON EB.FNUMBER = BI.FBILLTYPE  WHERE EB.FBILLBOSTYPE = ? ";
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bosType});
                if (rowSet.next()) {
                    return rowSet.getString("FIMAGESYSID");
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
            String defImage = Configure.getDefImage(ctx);
            if (StringUtils.isNotEmpty((CharSequence)defImage)) {
                return defImage;
            }
            logger.error((Object)"MultiImageManager.PermissionBillType.getImageSysId******\u53d1\u751f\u4e86\u5565\uff1f \u4e0d\u4f1a\u8d70\u5230\u8fd9\u91cc\u5427");
            return null;
        }
    }

    private static interface IPermission {
        public String getImageSysId(Context var1, String var2, IObjectValue var3) throws BOSException, EASBizException;
    }
}

