/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.util.common;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.wssc.ImmediateSubmitFacadeFactory;
import com.kingdee.eas.base.wssc.util.FormatUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class LockDataUtils {
    private static Logger logger = Logger.getLogger(LockDataUtils.class);
    public static final String LIST = "list";
    public static final String LOCKID = "lockId";
    public static final String lockSql = "insert into T_WSC_LockData (FBizobj,FLockDataType,FStarttime,FMethodStacks) values(?,?,NOW(),?)";

    public static boolean lockData(Context ctx, String lockKey, String lockType) {
        ArrayList<String> needLockData = new ArrayList<String>(1);
        needLockData.add(lockKey);
        List<String> list = LockDataUtils.tryLockNeedLockData(ctx, needLockData, lockType, LockDataUtils.getStackTrace(), 1);
        return list != null && list.size() == 1;
    }

    public static void unLockData(Context ctx, String lockKey) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)lockKey)) {
                String unLockSql = "delete from T_WSC_LockData where FBizobj = '" + lockKey + "' ";
                ImmediateSubmitFacadeFactory.getLocalInstance(ctx).executeSql(unLockSql);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u5220\u9664lockdata\u4e0a\u9501\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    public static void releaseExpiredLock(Context ctx, int timeSecond, String lockType) {
        try {
            int maxAssignTime = -timeSecond;
            Date date = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(12, maxAssignTime);
            String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(cal.getTime());
            String sql = "select FBizobj from T_WSC_LockData where FStarttime < {ts'" + time + "'} and FLockDataType ='" + lockType + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<String> releaseData = new ArrayList<String>();
            while (rs.next()) {
                releaseData.add(rs.getString("FBizobj"));
            }
            LockDataUtils.unLockData(ctx, releaseData);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void releaseExpiredLock(Context ctx, String lockKey, int timeSecond) {
        try {
            int maxAssignTime = -timeSecond;
            Date date = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(12, maxAssignTime);
            String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(cal.getTime());
            String sql = "select FBizobj from T_WSC_LockData where FStarttime < {ts'" + time + "'} and FBizobj ='" + lockKey + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<String> releaseData = new ArrayList<String>();
            while (rs.next()) {
                releaseData.add(rs.getString("FBizobj"));
            }
            LockDataUtils.unLockData(ctx, releaseData);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static Map<String, Object> lockData(Context ctx, List list, String lockType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (list.isEmpty()) {
            result.put(LIST, list);
            result.put(LOCKID, list);
            return result;
        }
        int size = list.size();
        String stacks = LockDataUtils.getStackTrace();
        Object clazz = null;
        try {
            clazz = list.get(0).getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)"\u5e94\u8be5\u6c38\u8fdc\u4e0d\u4f1a\u53d1\u751f..", (Throwable)e);
        }
        ArrayList<String> lockObjList = new ArrayList<String>(list.size());
        for (int i = 0; i < size; ++i) {
            if (clazz instanceof CoreBaseInfo) {
                lockObjList.add(((CoreBaseInfo)list.get(i)).getId().toString());
                continue;
            }
            if (!(clazz instanceof String)) continue;
            lockObjList.add(list.get(i).toString());
        }
        List<String> needLockData = LockDataUtils.tryLockNeedLockData(ctx, lockObjList, lockType, stacks, 1);
        List<String> lockDataId = needLockData;
        if (lockDataId.size() > 0) {
            block3: for (int j = 0; j < list.size(); ++j) {
                for (int i = 0; i < lockDataId.size(); ++i) {
                    if (clazz instanceof CoreBaseInfo ? lockDataId.get(i).equals(((CoreBaseInfo)list.get(j)).getId().toString()) : clazz instanceof String && lockDataId.get(i).equals(list.get(j).toString())) continue block3;
                }
                list.remove(j--);
            }
        } else {
            list.clear();
        }
        result.put(LOCKID, lockDataId);
        result.put(LIST, list);
        return result;
    }

    private static String getStackTrace() {
        StringBuilder tag = new StringBuilder();
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int i = 0; i < (stackTrace.length > 10 ? 10 : stackTrace.length); ++i) {
                StackTraceElement log = stackTrace[i];
                tag.append(log.getClassName() + "." + log.getMethodName() + ";");
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u5806\u6808\u4fe1\u606f\u9519\u8bef\uff1a" + e));
        }
        return tag.length() > 2000 ? tag.substring(0, 2000) : tag.toString();
    }

    private static synchronized List<String> tryLockNeedLockData(Context ctx, List<String> needLockData, String lockType, String stacks, int tryNumber) {
        int size1;
        if ((needLockData = LockDataUtils.getNeedLockData(ctx, needLockData)) != null && needLockData.size() > 0 && (size1 = needLockData.size()) > 0) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(size1);
            for (int i = 0; i < size1; ++i) {
                Object[] obj = new Object[]{needLockData.get(i), lockType, stacks};
                params.add(obj);
            }
            try {
                ImmediateSubmitFacadeFactory.getLocalInstance(ctx).executeBatchSql(lockSql, params);
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < params.size(); ++i) {
                    sb.append(((Object[])params.get(i))[0] + ";");
                }
                logger.error((Object)("\u7b2c" + tryNumber + "\u6b21\u6570\u636e\u4e0a\u9501\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u8868\u91cc\u9762\u5df2\u7ecf\u6709\u6570\u636e\u4e86\uff1b\u4e0a\u9501\u5931\u8d25\u7684\u6570\u636e\uff1a" + sb.toString()), (Throwable)e);
                needLockData = tryNumber > 3 ? Collections.emptyList() : LockDataUtils.tryLockNeedLockData(ctx, needLockData, lockType, stacks, ++tryNumber);
            }
        }
        return needLockData;
    }

    public static void unLockData(Context ctx, List<String> lockDataId) {
        try {
            if (lockDataId != null && lockDataId.size() > 0) {
                logger.error((Object)("\u5220\u9664lockdata\u4e0a\u9501\u6570\u636e" + FormatUtils.list2Sql(lockDataId)));
                String unLockSql = "delete from T_WSC_LockData where FBizobj in " + FormatUtils.list2Sql(lockDataId) + " ";
                ImmediateSubmitFacadeFactory.getLocalInstance(ctx).executeSql(unLockSql);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u5220\u9664lockdata\u4e0a\u9501\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private static List<String> getNeedLockData(Context ctx, List<String> lockObjList) {
        LinkedList<String> result = new LinkedList<String>(lockObjList);
        try {
            String sql = "select FBizobj from T_WSC_LockData where FBizobj in " + FormatUtils.list2Sql(lockObjList) + "";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                result.remove(rs.getString("FBizobj"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u67e5\u8be2\u4e0a\u9501\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return new ArrayList<String>(result);
    }

    public static Set<String> getLockData(Context ctx) {
        HashSet<String> result = new HashSet<String>();
        try {
            String sql = " select FBizobj from T_WSC_LockData ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                result.add(rs.getString("FBizobj"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u67e5\u8be2\u4e0a\u9501\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return result;
    }
}

