/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.parsing;

import com.kingdee.bos.bsf.parsing.ConfigurationParseException;
import com.kingdee.bos.bsf.parsing.ParserContext;
import com.kingdee.bos.util.XMLParser;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jdom.Element;
import org.jdom.JDOMException;

public class XmlFileReader {
    public Element read(ParserContext parserContext) throws ConfigurationParseException {
        Element root = null;
        String resource = parserContext.getAbsoluteResourceLocation();
        try {
            InputStream is = this.readFile(resource, parserContext.isClassPath());
            if (is == null) {
                throw new ConfigurationParseException("\u627e\u4e0d\u5230\u8d44\u6e90\u6587\u4ef6\u3010" + resource + "\u3011");
            }
            root = XMLParser.parseXML((InputStream)is).getRootElement();
        }
        catch (JDOMException e) {
            throw new ConfigurationParseException(e);
        }
        catch (IOException e) {
            throw new ConfigurationParseException(e);
        }
        return root;
    }

    private InputStream readFile(String resource, boolean isClassPath) {
        try {
            if (!isClassPath) {
                return new FileInputStream(resource);
            }
            return this.getClass().getClassLoader().getResourceAsStream(resource);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationParseException("\u627e\u4e0d\u5230\u8d44\u6e90\u6587\u4ef6\u3010" + resource + "\u3011");
        }
    }

    public Element read(String xmlString) {
        InputStream is = this.getInputStreamFromString(xmlString);
        try {
            return XMLParser.parseXML((InputStream)is).getRootElement();
        }
        catch (JDOMException e) {
            throw new ConfigurationParseException(e);
        }
        catch (IOException e) {
            throw new ConfigurationParseException(e);
        }
    }

    private InputStream getInputStreamFromString(String str) {
        return new ByteArrayInputStream(str.getBytes());
    }
}

