/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.parsing;

import com.kingdee.bos.bsf.IServiceRegister;
import com.kingdee.bos.bsf.model.ServiceRegistry;
import com.kingdee.bos.bsf.parsing.IConfigurationParser;
import com.kingdee.bos.bsf.parsing.ParserContext;
import com.kingdee.bos.bsf.parsing.XmlFileReader;
import org.jdom.Element;

public class XmlServicesConfigParser
implements IConfigurationParser {
    static final String IMPORT_ELEMENT = "import";
    static final String RESOURCE_ATTRIBUTE = "resource";
    static final String SERVICE_ATTRIBUTE = "service";
    private ParserContext parserContext;
    private IServiceRegister serviceRegistry;
    private static final String NAME_PROPERTY = "name";
    private static final String INTERFACE_PROPERTY = "interface";
    private static final String CLASS_PROPERTY = "class";
    private static final String VERSION_PROPERTY = "version";

    public XmlServicesConfigParser(ParserContext parserContext, IServiceRegister serviceRegistry) {
        this.parserContext = parserContext;
        this.serviceRegistry = serviceRegistry;
    }

    public void parse() {
        XmlFileReader reader = new XmlFileReader();
        Element root = reader.read(this.parserContext);
        this.doParse(root);
    }

    private void doParse(Element root) {
        for (Element element : root.getChildren()) {
            String name = element.getName();
            if (IMPORT_ELEMENT.equals(name)) {
                this.parseImport(element);
                continue;
            }
            if (!SERVICE_ATTRIBUTE.equals(name)) continue;
            this.parseService(element);
        }
    }

    private void parseImport(Element element) {
        String resource = element.getAttributeValue(RESOURCE_ATTRIBUTE);
        ParserContext ctx = new ParserContext(this.parserContext.getAbsolutePath(), resource);
        XmlServicesConfigParser parser = new XmlServicesConfigParser(ctx, this.serviceRegistry);
        parser.parse();
    }

    private void parseService(Element element) {
        ServiceRegistry service = new ServiceRegistry(element.getAttributeValue(NAME_PROPERTY), element.getAttributeValue(INTERFACE_PROPERTY), element.getAttributeValue(CLASS_PROPERTY), element.getAttributeValue(VERSION_PROPERTY));
        service.setSource(this.parserContext.getAbsoluteResourceLocation());
        this.serviceRegistry.registerService(service);
    }
}

