/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.GeniusBOSFactory;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.QueryServiceLocator;
import com.kingdee.bos.bsf.service.CreateServiceInstanceException;
import com.kingdee.bos.bsf.service.ServiceClassNotFoundException;
import com.kingdee.bos.orm.template.ORMObject;

final class ServiceFactory {
    private static final String CLIENT_EASROOT = "easclient.root";

    private ServiceFactory() {
    }

    private static boolean isClient() {
        return System.getProperties().keySet().contains(CLIENT_EASROOT);
    }

    static Object createServiceInstance(Context ctx, String serviceName, String serviceInterfaceName, String serviceClassName) {
        Class<?> serviceClass;
        Class<?> serviceInterface;
        try {
            serviceInterface = Class.forName(serviceInterfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceClassNotFoundException("\u627e\u4e0d\u5230\u670d\u52a1\u3010" + serviceName + "\u3011\u7684\u63a5\u53e3\u7c7b\u3010" + serviceInterfaceName + "\u3011", e);
        }
        try {
            serviceClass = Class.forName(serviceClassName);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceClassNotFoundException("\u627e\u4e0d\u5230\u670d\u52a1\u3010" + serviceName + "\u3011\u7684\u5b9e\u73b0\u7c7b\u3010" + serviceClassName + "\u3011", e);
        }
        if (IBOSObject.class.isAssignableFrom(serviceInterface) && ORMObject.class.isAssignableFrom(serviceClass)) {
            return ServiceFactory.createBOSObject(ctx, serviceName, serviceClassName, serviceInterface);
        }
        try {
            return serviceClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new CreateServiceInstanceException("\u521b\u5efa\u670d\u52a1\u3010" + serviceName + "\u3011\u7684\u666e\u901a\u670d\u52a1\u5bf9\u8c61\u5b9e\u4f8b\u51fa\u9519\u3002", e);
        }
        catch (IllegalAccessException e) {
            throw new CreateServiceInstanceException("\u521b\u5efa\u670d\u52a1\u3010" + serviceName + "\u3011\u7684\u666e\u901a\u670d\u52a1\u5bf9\u8c61\u5b9e\u4f8b\u51fa\u9519\u3002", e);
        }
    }

    private static Object createBOSObject(Context ctx, String serviceName, String serviceClassName, Class serviceInterface) {
        if (ServiceFactory.isClient()) {
            if (ctx == null) {
                return ServiceFactory.createRemoteBOSObject(serviceName, serviceInterface, serviceClassName);
            }
            return ServiceFactory.createRemoteBOSObjectWithObjectContext(ctx, serviceName, serviceInterface, serviceClassName);
        }
        if (ctx == null) {
            throw new CreateServiceInstanceException("\u521b\u5efa\u670d\u52a1\u3010" + serviceName + "\u3011\u7684\u670d\u52a1\u7aef\u672c\u5730\u5bf9\u8c61\u5b9e\u4f8b\u7f3a\u5c11Context\u3002");
        }
        return ServiceFactory.createLocalBOSObject(ctx, serviceName, serviceInterface, serviceClassName);
    }

    private static Object createRemoteBOSObjectWithObjectContext(Context ctx, String serviceName, Class serviceInterface, String serviceClassName) {
        try {
            return GeniusBOSFactory.createRemoteBOSObjectWithObjectContext((String)serviceClassName, (Class)serviceInterface, (Context)ctx);
        }
        catch (BOSException e) {
            throw new CreateServiceInstanceException("\u521b\u5efa\u670d\u52a1\u3010" + serviceName + "\u3011\u7684\u8fdc\u7a0bBOS\u670d\u52a1\u5bf9\u8c61\u5b9e\u4f8b\u51fa\u9519\u3002", e);
        }
    }

    private static Object createRemoteBOSObject(String serviceName, Class serviceInterface, String serviceClassName) {
        try {
            return BOSObjectFactory.createRemoteBOSObject((String)QueryServiceLocator.getCurrentServiceURL((boolean)true), (String)serviceClassName, (Class)serviceInterface);
        }
        catch (BOSException e) {
            throw new CreateServiceInstanceException("\u521b\u5efa\u670d\u52a1\u3010" + serviceName + "\u3011\u7684\u8fdc\u7a0bBOS\u670d\u52a1\u5bf9\u8c61\u5b9e\u4f8b\u51fa\u9519\u3002", e);
        }
    }

    private static Object createLocalBOSObject(Context ctx, String serviceName, Class serviceInterface, String serviceClassName) {
        try {
            return BOSObjectFactory.createBOSObject((Context)ctx, (String)serviceClassName, (Class)serviceInterface);
        }
        catch (BOSException e) {
            throw new CreateServiceInstanceException("\u521b\u5efa\u670d\u52a1\u3010" + serviceName + "\u3011\u7684\u672c\u5730BOS\u670d\u52a1\u5bf9\u8c61\u5b9e\u4f8b\u51fa\u9519\u3002", e);
        }
    }
}

