/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.IServiceLocator;
import com.kingdee.bos.bsf.ServiceLocatorException;
import com.kingdee.bos.bsf.service.ServiceFactory;
import com.kingdee.bos.bsf.service.ServiceRegistryNotFoundException;
import com.kingdee.bos.bsf.service.ServiceRepository;

public final class ServiceLocator
implements IServiceLocator {
    private static final IServiceLocator _instance = new ServiceLocator();

    private ServiceLocator() {
        this.init();
    }

    private void init() {
    }

    public static IServiceLocator getInstance() {
        return _instance;
    }

    public Object lookupService(String serviceName) throws ServiceLocatorException {
        return this.lookupService(null, serviceName);
    }

    public Object lookupService(Context ctx, String serviceName) throws ServiceLocatorException {
        assert (serviceName != null);
        String serviceClassName = ServiceRepository.getInstance().getServiceClassName(serviceName);
        String serviceInterfaceName = ServiceRepository.getInstance().getServiceInterfaceName(serviceName);
        if (serviceClassName == null) {
            throw new ServiceRegistryNotFoundException("\u5728\u670d\u52a1\u6ce8\u518c\u5e93\u4e2d\u672a\u627e\u5230\u670d\u52a1\u3010" + serviceName + "\u3011");
        }
        return ServiceFactory.createServiceInstance(ctx, serviceName, serviceInterfaceName, serviceClassName);
    }
}

