/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.model.ServiceRegistry;
import com.kingdee.bos.bsf.service.IServiceRepositoryLoader;
import com.kingdee.bos.bsf.service.ServiceRegistryLoadException;
import com.kingdee.bos.bsf.service.ServiceRepositoryLoaderFactory;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServiceRepository {
    private static final ServiceRepository repository = new ServiceRepository();
    private static final Logger logger = Logger.getLogger(ServiceRepository.class);
    private boolean isInitialized = false;
    private Map<String, String> servicesClassNameCache = new HashMap<String, String>();
    private Map<String, String> servicesInterfaceNameCache = new HashMap<String, String>();

    private ServiceRepository() {
    }

    public static ServiceRepository getInstance() {
        return repository;
    }

    public void initialize(Context ctx) {
        if (this.isInitialized) {
            return;
        }
        this.doInitialize(ctx);
    }

    private synchronized void doInitialize(Context ctx) {
        if (this.isInitialized) {
            return;
        }
        long start = Calendar.getInstance().getTimeInMillis();
        try {
            ServiceRegistry[] services;
            IServiceRepositoryLoader loader = ServiceRepositoryLoaderFactory.getInstance(ctx);
            for (ServiceRegistry service : services = loader.loadServiceRegistry()) {
                this.registerService(service.getName(), service.getInterfaceName(), service.getClassName());
            }
            long time = Calendar.getInstance().getTimeInMillis() - start;
            logger.info((Object)("\u521d\u59cb\u5316\u670d\u52a1\u6ce8\u518c\u5e93\u8017\u65f6\uff1a" + time + "ms."));
            this.isInitialized = true;
        }
        catch (BOSException e) {
            throw new ServiceRegistryLoadException("\u52a0\u8f7d\u670d\u52a1\u6ce8\u518c\u4fe1\u606f\u51fa\u9519\u3002", e);
        }
    }

    private void registerService(String serviceName, String serviceInterface, String serviceClassName) {
        this.servicesClassNameCache.put(serviceName, serviceClassName);
        this.servicesInterfaceNameCache.put(serviceName, serviceInterface);
    }

    String getServiceClassName(String serviceName) {
        return this.servicesClassNameCache.get(serviceName);
    }

    String getServiceInterfaceName(String serviceName) {
        return this.servicesInterfaceNameCache.get(serviceName);
    }
}

