/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.IServiceRegister;
import com.kingdee.bos.bsf.model.ServiceRegistry;
import com.kingdee.bos.bsf.parsing.ParserContext;
import com.kingdee.bos.bsf.parsing.XmlServicesConfigParser;
import com.kingdee.bos.bsf.service.IServiceRepositoryLoader;
import com.kingdee.bos.util.BOSObjectType;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServiceRepositoryLoader
extends AbstractBOSObject
implements IServiceRepositoryLoader,
IServiceRegister {
    private static final Logger logger = Logger.getLogger(ServiceRepositoryLoader.class);
    private static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"BSF__SRL");
    private static final String ROOT_RESOURCE = "/services/services.xml";
    private static final String SERVER_EASROOT = "eas.properties.dir";
    private static Map<String, ServiceRegistry> servicesCache;

    public ServiceRepositoryLoader() {
    }

    public ServiceRepositoryLoader(Context ctx) {
        super(ctx);
    }

    public ServiceRegistry[] loadServiceRegistry() {
        if (servicesCache != null) {
            return this.toArray();
        }
        this.initialize();
        return this.toArray();
    }

    private ServiceRegistry[] toArray() {
        return servicesCache.values().toArray(new ServiceRegistry[servicesCache.size()]);
    }

    private void refresh() {
        servicesCache = null;
        this.initialize();
    }

    private synchronized void initialize() {
        if (servicesCache != null) {
            return;
        }
        servicesCache = new HashMap<String, ServiceRegistry>();
        long start = Calendar.getInstance().getTimeInMillis();
        String resourcePath = System.getProperty(SERVER_EASROOT) + ROOT_RESOURCE;
        XmlServicesConfigParser parser = new XmlServicesConfigParser(new ParserContext(resourcePath), this);
        parser.parse();
        long time = Calendar.getInstance().getTimeInMillis() - start;
        logger.info((Object)("\u670d\u52a1\u6ce8\u518c\u5e93\u52a0\u8f7d\u670d\u52a1\u4fe1\u606f\u8017\u65f6\uff1a" + time + "ms\uff1b\u670d\u52a1\u6570\u91cf\uff1a" + servicesCache.size()));
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    public void registerService(ServiceRegistry service) {
        ServiceRegistry sr = servicesCache.get(service.getName());
        if (sr != null) {
            logger.warn((Object)("\u5df2\u7ecf\u5b58\u5728\u540d\u79f0\u4e3a\u3010" + sr.getName() + "\u3011\u7684\u670d\u52a1\uff0c\u6e90\u3010" + sr.getSource() + "\u3011\uff0c\u88ab\u6e90\u3010" + service.getSource() + "\u3011\u7684\u540c\u540d\u670d\u52a1\u8986\u76d6\u3002"));
        }
        servicesCache.put(service.getName(), service);
    }
}

