/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common.url.service.web;

import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.cp.common.url.service.web.LicenseObj;
import com.kingdee.eas.cp.eip.sso.web.auth.EASWebLicenceHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import org.apache.log4j.Logger;

public class SessionManagerListener
implements HttpSessionAttributeListener {
    private Logger logger = Logger.getLogger((String)SessionManagerListener.class.getName());
    private static Map sessionMap = Collections.synchronizedMap(new HashMap());

    public static void putSession(Object sessionId, Object obj) {
        sessionMap.put(sessionId, obj);
    }

    public static void removeSession(Object sessionId) {
        sessionMap.remove(sessionId);
    }

    public static Map getSessionMap() {
        return sessionMap;
    }

    public static LicenseObj getLicenseObj(LicenseUserInfo info) {
        if (info == null) {
            return null;
        }
        String clientIP = info.getUserIP();
        String userName = info.getUserID();
        if (userName == null) {
            userName = info.getUserName();
        }
        return new LicenseObj(clientIP, userName);
    }

    public static boolean hasSessionId(String sessionId) {
        if (sessionId == null || sessionMap == null) {
            return false;
        }
        Set sets = sessionMap.entrySet();
        for (Map.Entry entry : sets) {
            Object obj = entry.getValue();
            if (!(obj instanceof LicenseUserInfo) || !sessionId.equals(((LicenseUserInfo)obj).getSessionID())) continue;
            return true;
        }
        return false;
    }

    public void attributeAdded(HttpSessionBindingEvent arg0) {
        if ("licesnseId".equals(arg0.getName())) {
            if (!(arg0.getValue() instanceof LicenseUserInfo)) {
                return;
            }
            LicenseUserInfo info = (LicenseUserInfo)arg0.getValue();
            SessionManagerListener.putSession(SessionManagerListener.getLicenseObj(info), info);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent arg0) {
        if ("licesnseId".equals(arg0.getName())) {
            if (!(arg0.getValue() instanceof LicenseUserInfo)) {
                return;
            }
            try {
                LicenseUserInfo info = (LicenseUserInfo)arg0.getValue();
                EASWebLicenceHelper.releaseLicense((String)info.getSessionID(), (String)"com.kingdee.eas.portal.web.action.PortalAction");
                SessionManagerListener.removeSession(SessionManagerListener.getLicenseObj(info));
            }
            catch (Exception e) {
                this.logger.error((Object)"rlealse License error:", (Throwable)e);
            }
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent arg0) {
    }
}

