/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.common.web.util;

import com.kingdee.bos.ctrl.swing.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPath;

public class PortalPersonalSetUtil {
    private static Document personalSetControlDoc = null;
    private static Document portalUIResourceConfigDoc = null;
    private static Map personalSetMap = null;
    private static Map portalUIMap = null;
    private static String personalconfigfilename = "personalSetControl.xml";
    private static String portalUIResourceconfigfilename = "portalUIResourceConfig.xml";
    private static Logger logger = Logger.getLogger(PortalPersonalSetUtil.class);
    private static String reloadTimeMark = "";

    private static void load() {
        if (personalSetControlDoc == null) {
            PortalPersonalSetUtil.loadPersonalSetControlFile();
        }
        if (portalUIResourceConfigDoc == null) {
            PortalPersonalSetUtil.loadPortalUIResourceFile();
        }
    }

    public static String getReloadTimeMark() {
        return reloadTimeMark;
    }

    private static void setReloadTimeMark(String newTime) {
        reloadTimeMark = newTime;
    }

    public static void reload() {
        PortalPersonalSetUtil.loadPersonalSetControlFile();
    }

    private static void loadPersonalSetControlFile() {
        try {
            String fileName = System.getProperty("EAS_HOME");
            if (fileName == null) {
                throw new RuntimeException("cann't find the config dir!");
            }
            File eas_home_dir = new File(fileName);
            if (!eas_home_dir.exists()) {
                personalSetControlDoc = null;
                return;
            }
            File personalConfigFile = new File(fileName = fileName + "/server/properties/personalset/" + personalconfigfilename);
            if (!personalConfigFile.exists()) {
                personalSetControlDoc = null;
                logger.info((Object)("File " + personalconfigfilename + " not found"));
                return;
            }
            SAXBuilder builder = new SAXBuilder();
            logger.info((Object)("Load personalConfigFile from[" + personalconfigfilename + "]......"));
            personalSetControlDoc = builder.build(personalConfigFile);
            PortalPersonalSetUtil.setReloadTimeMark(System.currentTimeMillis() + "");
            PortalPersonalSetUtil.ganeratePersonalSetControlMap();
        }
        catch (Exception e) {
            logger.error((Object)("read file " + personalconfigfilename + " exception"), (Throwable)e);
        }
    }

    private static void ganeratePersonalSetControlMap() {
        personalSetMap = new HashMap();
        Element rootNode = personalSetControlDoc.getRootElement();
        List elements = rootNode.getChildren();
        for (Element element : elements) {
            Map m = PortalPersonalSetUtil.ganerateConfigItemsMap(element);
            personalSetMap.put(element.getAttributeValue("name"), m);
        }
        logger.info((Object)("personalSetControl.xml: " + personalSetMap.toString()));
    }

    private static void ganeratePortalUIResourceConfigMap() {
        portalUIMap = new HashMap();
        Element rootNode = portalUIResourceConfigDoc.getRootElement();
        List elements = rootNode.getChildren();
        for (Element element : elements) {
            Map m = PortalPersonalSetUtil.ganerateConfigItemsMap(element);
            portalUIMap.put(element.getAttributeValue("name"), m);
        }
        logger.info((Object)("portalUIResourceConfig.xml: " + portalUIMap.toString()));
    }

    private static Map ganerateConfigItemsMap(Element element) {
        HashMap<String, Map> m = new HashMap<String, Map>();
        List children = element.getChildren();
        for (Element elem : children) {
            Map attrMap = PortalPersonalSetUtil.ganerateAttributeItemsMap(elem);
            m.put(elem.getAttributeValue("name"), attrMap);
        }
        return m;
    }

    private static Map ganerateAttributeItemsMap(Element element) {
        HashMap<String, String> m = new HashMap<String, String>();
        List attributes = element.getChildren();
        for (Element a : attributes) {
            m.put(a.getAttributeValue("key"), a.getAttributeValue("value"));
        }
        return m;
    }

    private static void loadPortalUIResourceFile() {
        try {
            String fileName = System.getProperty("EAS_HOME");
            if (fileName == null) {
                throw new RuntimeException("cann't find the config dir!");
            }
            File eas_home_dir = new File(fileName);
            if (!eas_home_dir.exists()) {
                portalUIResourceConfigDoc = null;
                return;
            }
            File portalUIResourceconfigfile = new File(fileName = fileName + "/server/properties/personalset/" + portalUIResourceconfigfilename);
            if (!portalUIResourceconfigfile.exists()) {
                portalUIResourceConfigDoc = null;
                logger.info((Object)("File " + portalUIResourceconfigfilename + " not found"));
                return;
            }
            SAXBuilder builder = new SAXBuilder();
            logger.info((Object)("Load portalUIResourceconfigfile from[" + portalUIResourceconfigfilename + "]......"));
            portalUIResourceConfigDoc = builder.build(portalUIResourceconfigfile);
            PortalPersonalSetUtil.ganeratePortalUIResourceConfigMap();
        }
        catch (Exception e) {
            logger.error((Object)("read file " + portalUIResourceconfigfilename + " exception"), (Throwable)e);
        }
    }

    public static Element getConfigItem(String type, String configItemName) {
        if (personalSetControlDoc == null) {
            return null;
        }
        Element configItem = null;
        try {
            if (personalSetControlDoc == null) {
                return null;
            }
            configItem = (Element)XPath.selectSingleNode((Object)personalSetControlDoc, (String)("/config/configitem[@name='" + type + "']/configitem[@name='" + configItemName + "']"));
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        return configItem;
    }

    public static String getAttribute(String type, String configItemName, String attributeName, Locale locale) {
        String localeStr = "";
        localeStr = locale == null ? "L2" : ((localeStr = locale.toString().trim()).equalsIgnoreCase("zh_cn") || localeStr.equalsIgnoreCase("l2") ? "L2" : (localeStr.equalsIgnoreCase("zh_tw") || localeStr.equalsIgnoreCase("l3") ? "L3" : "L1"));
        attributeName = attributeName + "_" + localeStr.toUpperCase();
        return PortalPersonalSetUtil.getAttribute(type, configItemName, attributeName);
    }

    public static String getAttribute(HttpServletRequest request, String type, String configItemName, String attributeName, String schema, int flag, Locale locale) {
        String imageFileUrl;
        File f;
        String imageUrl;
        String personalUrlPrefix = "/easWebClient/personalset";
        String baseUrl = System.getProperty("EAS_HOME");
        String imageUrlPrefix = "/server/deploy/fileserver.ear/easWebClient/personalset";
        String picsuffix = "";
        String localeStr = "L2";
        if (flag == 1 && locale != null) {
            localeStr = locale.toString();
            if ((localeStr = localeStr.trim()).equalsIgnoreCase("en_us") || localeStr.equalsIgnoreCase("l1")) {
                picsuffix = "_en";
            }
        }
        if (schema != null) {
            if (schema.equals("02")) {
                schema = "03";
            } else if (schema.equals("03")) {
                schema = "04";
            } else if (schema.equals("04")) {
                schema = "02";
            }
        }
        if (!StringUtils.isEmpty((String)(imageUrl = PortalPersonalSetUtil.getValueFromPersonalSet(type, configItemName, attributeName = attributeName + "_" + schema))) && (f = new File(imageFileUrl = baseUrl + imageUrlPrefix + imageUrl)).exists()) {
            return personalUrlPrefix + imageUrl;
        }
        imageUrl = PortalPersonalSetUtil.getValueFromUIResource(type, configItemName, attributeName);
        if (flag == 1) {
            return imageUrl.replaceAll("\\.", picsuffix + ".");
        }
        if (flag == 0) {
            return imageUrl;
        }
        return "";
    }

    public static String getAttribute(String type, String configItemName, String attributeName) {
        String value = PortalPersonalSetUtil.getValueFromPersonalSet(type, configItemName, attributeName);
        if (StringUtils.isEmpty((String)value)) {
            value = PortalPersonalSetUtil.getValueFromUIResource(type, configItemName, attributeName);
        }
        return value;
    }

    private static String getValueFromUIResource(String type, String configItemName, String attributeName) {
        if (portalUIMap == null || type == null || configItemName == null || attributeName == null) {
            return "";
        }
        Map m = (Map)portalUIMap.get(type);
        return PortalPersonalSetUtil.getValueFromMap(m, configItemName, attributeName);
    }

    private static String getValueFromPersonalSet(String type, String configItemName, String attributeName) {
        if (personalSetMap == null || type == null || configItemName == null || attributeName == null) {
            return "";
        }
        Map m = (Map)personalSetMap.get(type);
        return PortalPersonalSetUtil.getValueFromMap(m, configItemName, attributeName);
    }

    private static String getValueFromMap(Map m, String configItemName, String attributeName) {
        if (m == null) {
            return "";
        }
        if ((m = (Map)m.get(configItemName)) == null) {
            return "";
        }
        return (String)m.get(attributeName);
    }

    static {
        PortalPersonalSetUtil.load();
    }
}

