/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.bicomponent.BIComponentResource;
import com.kingdee.bos.ctrl.analysis.bicomponent.CalculateMemberBuilderUIPanel;
import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.MemberTree;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Member;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Model;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_QueryManager;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.NonIcon;
import com.kingdee.bos.olap.CalculatedMember;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.CacheType;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.Formula;
import com.kingdee.bos.olap.mdx.Literal;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.MemberProperty;
import com.kingdee.bos.olap.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class CalculateMemberBuilder
extends TypicalDialog {
    private OlapModel olapModel;
    private Member currentMember = null;
    KDComboBox cbHierarchy = new KDComboBox();
    KDLabelContainer lcHierarchy = new KDLabelContainer(BIComponentResource.getString(BIComponentResource.class, (String)"Dimension"), (JComponent)this.cbHierarchy);
    KDPromptBox pbParent = new KDPromptBox();
    KDLabelContainer lcParent = new KDLabelContainer(BIComponentResource.getString(BIComponentResource.class, (String)"ParentMember"), (JComponent)this.pbParent);
    KDTextField tfName = new KDTextField();
    KDLabelContainer lcName = new KDLabelContainer(BIComponentResource.getString(BIComponentResource.class, (String)"MemberName"), (JComponent)this.tfName);
    KDTextArea taExpression = new KDTextArea();
    KDLabelContainer lcExpression = new KDLabelContainer(BIComponentResource.getString(BIComponentResource.class, (String)"Expression"), (JComponent)new KDScrollPane((Component)this.taExpression));
    KDWorkButton btnCheck = new KDWorkButton(BIComponentResource.getString(BIComponentResource.class, (String)"Check"));
    KDTextField tfFormatString = new KDTextField();
    KDLabelContainer lcFormatString = new KDLabelContainer(BIComponentResource.getString(BIComponentResource.class, (String)"FormatString"), (JComponent)this.tfFormatString);
    KDTextField tfSolveOrder = new KDTextField("0");
    KDLabelContainer lcSolveOrder = new KDLabelContainer(BIComponentResource.getString(BIComponentResource.class, (String)"SolveOrder"), (JComponent)this.tfSolveOrder);
    KDWorkButton btnCheck2 = new KDWorkButton(BIComponentResource.getString(BIComponentResource.class, (String)"Check"));

    public CalculateMemberBuilder() {
    }

    public CalculateMemberBuilder(Frame owner) {
        super(owner);
    }

    public CalculateMemberBuilder(Dialog owner) {
        super(owner);
    }

    public void clear() {
        this.tfName.setText("");
        this.tfName.setEnabled(true);
        this.tfSolveOrder.setText("0");
        this.tfFormatString.setText("");
        this.taExpression.setText("");
        this.pbParent.setValue(null);
        this.currentMember = null;
    }

    public void setOlapModel(OlapModel olapModel) {
        this.olapModel = olapModel;
        this.cbHierarchy.removeAllItems();
        Dimension[] dims = olapModel.getDimensions();
        for (int i = 0; i < dims.length; ++i) {
            Hierarchy[] hiers = dims[i].getHierarchies();
            for (int j = 0; j < hiers.length; ++j) {
                this.cbHierarchy.addItem((Object)hiers[j]);
            }
        }
    }

    public void setCurrentHierarchy(Hierarchy hier) {
        if (hier.equals(this.cbHierarchy.getSelectedItem())) {
            return;
        }
        this.cbHierarchy.setSelectedItem((Object)hier);
        this.pbParent.setValue(null);
        this.pbParent.setEnabled(!hier.getDimension().isMeasure());
    }

    public Hierarchy getCurrentHierarchy() {
        return (Hierarchy)this.cbHierarchy.getSelectedItem();
    }

    public void editMember(Member member) {
        this.tfName.setEnabled(false);
        this.currentMember = member;
        if (member instanceof KDOLAP_Member) {
            com.kingdee.bos.olap.Member kdMember = ((KDOLAP_Member)member).getKDMember();
            Formula formula = ((CalculatedMember)kdMember).getFormula();
            this.tfName.setText(member.getName());
            this.taExpression.setText(formula.getExp().toMdx());
            MemberProperty[] mps = formula.getMemberProperties();
            if (mps != null && mps.length > 0) {
                for (int i = 0; i < mps.length; ++i) {
                    if (mps[i].getName().equalsIgnoreCase("formatString") || mps[i].getName().equalsIgnoreCase("FORMAT_STRING")) {
                        this.tfFormatString.setText(((Literal)mps[i].getExp()).stringValue());
                        continue;
                    }
                    if (!mps[i].getName().equalsIgnoreCase("SOLVE_ORDER")) continue;
                    this.tfSolveOrder.setText(mps[i].getExp().toMdx());
                }
            }
        }
    }

    public void commitEdit() {
        try {
            if (this.currentMember instanceof KDOLAP_Member) {
                int i;
                com.kingdee.bos.olap.Member kdMember = ((KDOLAP_Member)this.currentMember).getKDMember();
                Formula formula = ((CalculatedMember)kdMember).getFormula();
                Exp exp = this.olapModel.createFormulaExp(this.taExpression.getText());
                String formatString = this.tfFormatString.getText();
                String solveOrder = this.getSolveOrder();
                ArrayList<MemberProperty> list = new ArrayList<MemberProperty>(2);
                MemberProperty mp = null;
                if (formatString != null && formatString.length() > 0) {
                    mp = new MemberProperty("formatString", (Exp)Literal.createString((String)("'" + formatString + "'")));
                    list.add(mp);
                }
                if (solveOrder != null && (i = Integer.parseInt(solveOrder)) > 0) {
                    mp = new MemberProperty("SOLVE_ORDER", (Exp)Literal.create((Integer)new Integer(i)));
                    list.add(mp);
                }
                formula.setExp(exp);
                formula.setMemberProperties(list.toArray(new MemberProperty[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void todoInit() {
        this.setTitle(BIComponentResource.getString(BIComponentResource.class, (String)"CalculateMemberBuilder"));
        this.setSize(700, 600);
        WindowUtil.makeCneterBounds((Window)((Object)this));
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        this.cbHierarchy.setEnabled(false);
        this.lcHierarchy.setBoundLabelLength(100);
        this.lcParent.setBoundLabelLength(100);
        this.lcName.setBoundLabelLength(100);
        this.lcSolveOrder.setBoundLabelLength(100);
        this.lcExpression.setBoundLabelAlignment(8);
        this.lcFormatString.setBoundLabelLength(100);
        Table layout = thisCell.splitRow(10);
        layout.rowStyle(0).setMarginBottom(10);
        layout.rowStyle(2).setMarginBottom(10);
        layout.rowStyle(3).setMarginBottom(10);
        layout.rowStyle(4).setMarginBottom(10);
        layout.rowStyle(5).setMarginBottom(10);
        layout.rowStyle(6).setMarginBottom(10);
        layout.rowStyle(4).setHeight(400);
        layout.rowStyle(7).setMarginBottom(10);
        layout.rowStyle(7).setMarginRight(80);
        layout.rowStyle(9).setPriY(1);
        parent.add((Component)this.lcHierarchy, layout.cell(0));
        parent.add((Component)this.lcName, layout.cell(2));
        parent.add((Component)new JSeparator(), layout.cell(3));
        Table tableExpCalculate = layout.cell(4).splitRow(2);
        tableExpCalculate.rowStyle(0).setPriY(1);
        tableExpCalculate.rowStyle(1).lockHeight(250);
        CalculateMemberBuilderUIPanel uiPanel = new CalculateMemberBuilderUIPanel(this.olapModel);
        parent.add((Component)((Object)uiPanel), tableExpCalculate.cell(1));
        uiPanel.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                CalculateMemberBuilderUIPanel obj = (CalculateMemberBuilderUIPanel)((Object)eventObj.getSource());
                String oldText = CalculateMemberBuilder.this.taExpression.getText();
                int selStart = CalculateMemberBuilder.this.taExpression.getSelectionStart();
                int selEnd = CalculateMemberBuilder.this.taExpression.getSelectionEnd();
                String newText = oldText.substring(0, selStart) + obj.getBuildedString() + oldText.substring(selEnd, oldText.length());
                CalculateMemberBuilder.this.taExpression.setText(newText);
            }
        });
        Table tableExp = tableExpCalculate.cell(0).splitCol(2);
        tableExp.colStyle(0).setPriX(1);
        tableExp.colStyle(1).setWidth(80);
        tableExp.colStyle(1).setMarginLeft(10);
        parent.add((Component)this.lcExpression, tableExp.cell(0));
        Table tableCheck = tableExp.cell(1).splitRow(3);
        tableCheck.rowStyle(0).setPriY(1);
        tableCheck.rowStyle(2).setPriY(1);
        parent.add((Component)this.btnCheck, tableCheck.cell(1));
        parent.add((Component)new JSeparator(), layout.cell(5));
        tableExp = layout.cell(6).splitCol(2);
        tableExp.colStyle(0).setPriX(1);
        tableExp.colStyle(1).setWidth(80);
        tableExp.colStyle(1).setMarginLeft(10);
        parent.add((Component)this.lcFormatString, tableExp.cell(0));
        tableCheck = tableExp.cell(1).splitRow(3);
        tableCheck.rowStyle(0).setPriY(1);
        tableCheck.rowStyle(2).setPriY(1);
        parent.add((Component)this.btnCheck2, tableCheck.cell(1));
        parent.add((Component)this.lcSolveOrder, layout.cell(7));
        this.pbParent.setSelector((KDPromptSelector)new MemberTreeSelector());
        this.btnCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculateMemberBuilder.this.checkExpression();
            }
        });
        this.btnCheck2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculateMemberBuilder.this.checkFormatString();
            }
        });
    }

    public boolean checkFormatString() {
        return this.checkFormatString(true);
    }

    public boolean checkFormatString(boolean alert) {
        String s = this.tfFormatString.getText();
        if (s == null || s.trim().length() == 0) {
            return true;
        }
        try {
            new DecimalFormat(s);
        }
        catch (Exception e) {
            WindowUtil.alert((Component)((Object)this), (String)(BIComponentResource.getString(BIComponentResource.class, (String)"IllegalFormatString") + e.getMessage()));
            return false;
        }
        if (alert) {
            WindowUtil.alert((Component)((Object)this), (String)BIComponentResource.getString(BIComponentResource.class, (String)"Correct"));
        }
        return true;
    }

    public boolean checkExpression() {
        return this.checkExpression(true);
    }

    public boolean checkExpression(boolean alert) {
        String exp = this.taExpression.getText();
        try {
            this.olapModel.createFormulaExp(exp);
        }
        catch (OlapException e) {
            WindowUtil.alert((Component)((Object)this), (String)(BIComponentResource.getString(BIComponentResource.class, (String)"IllegalExpression") + "\n" + e.getMessage()));
            return false;
        }
        if (alert) {
            WindowUtil.alert((Component)((Object)this), (String)BIComponentResource.getString(BIComponentResource.class, (String)"Correct"));
        }
        return true;
    }

    private String getMemberName() {
        String s = this.tfName.getText();
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    private String getSolveOrder() {
        String s = this.tfSolveOrder.getText();
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    public boolean verify() {
        boolean ret;
        String memberName = this.getMemberName();
        if (memberName == null || memberName.length() == 0) {
            WindowUtil.alert((Component)((Object)this), (String)BIComponentResource.getString(BIComponentResource.class, (String)"InputMemberName"));
            return false;
        }
        boolean bl = ret = this.checkExpression(false) && this.checkFormatString(false);
        if (!ret) {
            return false;
        }
        String solveOrder = this.getSolveOrder();
        if (solveOrder != null && !solveOrder.matches("\\d+")) {
            WindowUtil.alert((Component)((Object)this), (String)"\u6c42\u89e3\u987a\u5e8f\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
            return false;
        }
        return true;
    }

    public Member getResult() {
        Hierarchy hier = this.getCurrentHierarchy();
        Member parentMember = (Member)this.pbParent.getValue();
        if (this.olapModel instanceof KDOLAP_Model) {
            KDOLAP_Model kdOlapModel = (KDOLAP_Model)this.olapModel;
            MdxQuery kdMdxQuery = null;
            kdMdxQuery = ((KDOLAP_QueryManager)kdOlapModel.getQueryManager()).getKDQuery();
            String[] names = null;
            if (parentMember != null) {
                try {
                    String[] names2 = Util.explode((String)parentMember.getUniqueName());
                    names = new String[names2.length + 1];
                    System.arraycopy(names2, 0, names, 0, names2.length);
                    names[names.length - 1] = this.getMemberName();
                }
                catch (OLAPException e1) {
                    e1.printStackTrace();
                }
            } else {
                names = new String[2];
                try {
                    names[0] = Util.explode((String)hier.getDimension().getUniqueName())[0];
                }
                catch (OLAPException e1) {
                    e1.printStackTrace();
                }
                names[1] = this.getMemberName();
            }
            try {
                int i;
                Exp exp = this.olapModel.createFormulaExp(this.taExpression.getText());
                String formatString = this.tfFormatString.getText();
                String solveOrder = this.getSolveOrder();
                ArrayList<MemberProperty> list = new ArrayList<MemberProperty>(2);
                MemberProperty mp = null;
                if (formatString != null && formatString.length() > 0) {
                    mp = new MemberProperty("formatString", (Exp)Literal.createString((String)("'" + formatString + "'")));
                    list.add(mp);
                }
                if (solveOrder != null && (i = Integer.parseInt(solveOrder)) > 0) {
                    mp = new MemberProperty("SOLVE_ORDER", (Exp)Literal.create((Integer)new Integer(i)));
                    list.add(mp);
                }
                Formula formula = list.size() > 0 ? kdMdxQuery.addFormula(names, exp, list.toArray(new MemberProperty[0]), CacheType.NO) : kdMdxQuery.addFormula(names, exp, null, CacheType.NO);
                formula.createElement(kdMdxQuery);
                return this.olapModel.lookupMember(Util.implode((String[])names));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return null;
    }

    private DefaultKingdeeTreeNode createMemberNode(Member member) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)member);
        node.setText(member.getLabel());
        node.setAllowsChildren(this.getMemberTree().hasChildren(member));
        node.setCustomIcon((Icon)NonIcon.getInstance());
        return node;
    }

    MemberTree getMemberTree() {
        MemberTree memberTree = (MemberTree)this.olapModel.getExtension("memberTree");
        return memberTree;
    }

    class HierarchyTreeModel
    extends DefaultTreeModel
    implements TreeModel {
        DefaultKingdeeTreeNode calculateFolderNode;
        Hierarchy hierarchy;

        HierarchyTreeModel(Hierarchy hierarchy) {
            super(null, true);
            this.setRoot(this.createRoot(hierarchy));
            this.hierarchy = hierarchy;
            this.expandRoot();
        }

        private TreeNode createRoot(Hierarchy hierarchy) {
            this.root = new DefaultKingdeeTreeNode((Object)hierarchy);
            ((DefaultKingdeeTreeNode)this.root).setText(hierarchy.getLabel());
            return this.root;
        }

        private void expandRoot() {
            Member[] members = CalculateMemberBuilder.this.getMemberTree().getRootMembers(this.hierarchy);
            ArrayList<Member> calMemberList = new ArrayList<Member>();
            for (int i = 0; i < members.length; ++i) {
                if (members[i].isCalculated()) {
                    calMemberList.add(members[i]);
                    continue;
                }
                ((DefaultKingdeeTreeNode)this.root).add((MutableTreeNode)CalculateMemberBuilder.this.createMemberNode(members[i]));
            }
        }
    }

    class MemberTreeSelector
    extends TypicalDialog
    implements KDPromptSelector {
        KDTree tree = new KDTree();

        MemberTreeSelector() {
        }

        public void show() {
            this.showDialog();
        }

        public boolean showDialog() {
            this.tree.setModel((TreeModel)new HierarchyTreeModel(CalculateMemberBuilder.this.getCurrentHierarchy()));
            return super.showDialog();
        }

        protected void todoInit() {
            this.setTitle(BIComponentResource.getString(BIComponentResource.class, (String)"SelectParentMember"));
            this.setSize(480, 320);
            WindowUtil.makeCneterBounds((Window)((Object)this));
        }

        protected void todoAddControls(Container parent, Cell thisCell) {
            this.tree.setShowsRootHandles(false);
            this.tree.setShowCheckBox(false);
            parent.add((Component)this.tree, thisCell);
        }

        public boolean isCanceled() {
            return !this.isOk;
        }

        public Object getData() {
            return ((DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent()).getUserObject();
        }

        protected boolean verify() {
            if (this.tree.getLastSelectedPathComponent() == null) {
                WindowUtil.alert((Component)((Object)this), (String)BIComponentResource.getString(BIComponentResource.class, (String)"SelectMember"));
                return false;
            }
            return true;
        }
    }
}

