/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.AxisMembersHelper;
import com.kingdee.bos.ctrl.analysis.olap.ChangeSlicer;
import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.DimensionProperty;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.MemberTree;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Result;
import com.kingdee.bos.ctrl.analysis.olap.SwapAxes;
import com.kingdee.bos.ctrl.analysis.util.StringUtil;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class OlapModelUtil {
    public static MemberTree getMemberTree(OlapModel olapModel) {
        if (olapModel != null) {
            return (MemberTree)olapModel.getExtension("memberTree");
        }
        return null;
    }

    public static ChangeSlicer getChangeSlicer(OlapModel olapModel) {
        if (olapModel != null) {
            return (ChangeSlicer)olapModel.getExtension("changeSlicer");
        }
        return null;
    }

    public static Member[] getSliceMembers(OlapModel olapModel) {
        return OlapModelUtil.getChangeSlicer(olapModel).getSlicer();
    }

    public static List getSliceHierarchy(OlapModel olapModel) {
        Member[] sliceMembers = OlapModelUtil.getSliceMembers(olapModel);
        ArrayList<Hierarchy> list = new ArrayList<Hierarchy>();
        for (int i = 0; i < sliceMembers.length; ++i) {
            list.add(sliceMembers[i].getLevel().getHierarchy());
        }
        return list;
    }

    public static List getAllHierarchy(OlapModel olapModel) {
        Dimension[] dims = olapModel.getDimensions();
        ArrayList<Hierarchy> list = new ArrayList<Hierarchy>();
        for (int i = 0; i < dims.length; ++i) {
            list.addAll(Arrays.asList(dims[i].getHierarchies()));
        }
        return list;
    }

    public static Member[] getAllMeasure(OlapModel olapModel) {
        return olapModel.getMeasures();
    }

    public static Axis getTopAxis(OlapModel olapModel) throws OlapException {
        Result result = olapModel.getResult();
        return OlapModelUtil.getTopAxis(result);
    }

    public static Axis getTopAxis(Result result) {
        return result.getColumnAxis();
    }

    public static Axis getLeftAxis(OlapModel olapModel) throws OlapException {
        Result result = olapModel.getResult();
        return OlapModelUtil.getLeftAxis(result);
    }

    public static Axis getLeftAxis(Result result) {
        return result.getRowAxis();
    }

    public static DimensionProperty[] getDimensionProperties(Axis axis) {
        return axis.getDimensionProperties();
    }

    public static int getDimensionPropertyCount(Axis axis) {
        int i;
        DimensionProperty[] props = OlapModelUtil.getDimensionProperties(axis);
        if (props == null) {
            return 0;
        }
        int count = 0;
        Hierarchy[] hies = axis.getHierarchies();
        ArrayList<Dimension> list = new ArrayList<Dimension>(hies.length);
        for (i = 0; i < hies.length; ++i) {
            list.add(hies[i].getDimension());
        }
        for (i = 0; i < props.length; ++i) {
            if (!list.contains(props[i].getDimension())) continue;
            ++count;
        }
        return count;
    }

    public static DimensionProperty[] getDimensionProperties(Axis axis, Dimension dim) {
        DimensionProperty[] props = OlapModelUtil.getDimensionProperties(axis);
        if (props == null) {
            return null;
        }
        ArrayList<DimensionProperty> list = new ArrayList<DimensionProperty>();
        for (int i = 0; i < props.length; ++i) {
            if (props[i].getDimension() != dim) continue;
            list.add(props[i]);
        }
        props = new DimensionProperty[list.size()];
        list.toArray(props);
        return props;
    }

    public static Hierarchy[] getTopAxisHies(OlapModel olapModel) throws OlapException {
        return OlapModelUtil.getTopAxis(olapModel).getHierarchies();
    }

    public static Hierarchy[] getLeftAxisHies(OlapModel olapModel) throws OlapException {
        return OlapModelUtil.getLeftAxis(olapModel).getHierarchies();
    }

    public static Axis getAxisOfHierarchy(OlapModel olapModel, Hierarchy hie) throws OlapException {
        Axis axis = null;
        axis = OlapModelUtil.getTopAxis(olapModel);
        if (Arrays.asList(axis.getHierarchies()).contains(hie)) {
            return axis;
        }
        axis = OlapModelUtil.getLeftAxis(olapModel);
        if (Arrays.asList(axis.getHierarchies()).contains(hie)) {
            return axis;
        }
        return null;
    }

    public static boolean isExpanded(OlapModel olapModel, Member member) {
        return olapModel.getQueryManager().isExpanded(member);
    }

    public static void hierarchize(OlapModel olapModel, List listMember) {
        final MemberTree memberTree = OlapModelUtil.getMemberTree(olapModel);
        Collections.sort(listMember, new Comparator(){

            public int compare(Object o1, Object o2) {
                int depth2;
                Member m1 = (Member)o1;
                Member m2 = (Member)o2;
                int depth1 = m1.getDepth();
                if (depth1 == (depth2 = m2.getDepth())) {
                    Member p2;
                    Member p1 = memberTree.getParent(m1);
                    if (p1 == (p2 = memberTree.getParent(m2))) {
                        Member[] children = null;
                        children = p1 != null ? memberTree.getChildren(p1) : memberTree.getRootMembers(m1.getHierarchy());
                        List<Member> list = Arrays.asList(children);
                        int index1 = list.indexOf(m1);
                        int index2 = list.indexOf(m2);
                        return index1 - index2;
                    }
                    return this.compare(p1, p2);
                }
                if (depth1 > depth2) {
                    for (int i = 0; i < depth1 - depth2; ++i) {
                        m1 = memberTree.getParent(m1);
                    }
                    if (m1 == m2) {
                        return 1;
                    }
                    return this.compare(m1, m2);
                }
                for (int i = 0; i < depth2 - depth1; ++i) {
                    m2 = memberTree.getParent(m2);
                }
                if (m1 == m2) {
                    return -1;
                }
                return this.compare(m1, m2);
            }
        });
    }

    public static List lookupMembers(OlapModel olapModel, String dimName, String[] memberUniqueNames) {
        ArrayList<Member> list = new ArrayList<Member>();
        for (int i = 0; i < memberUniqueNames.length; ++i) {
            String[] nameParts = memberUniqueNames[i].split("\\.");
            for (int j = 0; j < nameParts.length; ++j) {
                nameParts[j] = Util.trimBracketsAround((String)nameParts[j]);
            }
            String uniqueName = nameParts.length == 1 ? StringUtil.createUName(new String[]{dimName, nameParts[0]}, -1) : StringUtil.createUName(nameParts, -1);
            Member member = olapModel.lookupMember(uniqueName);
            if (member == null) continue;
            list.add(member);
        }
        return list;
    }

    public static List lookupMembers(OlapModel olapModel, String[] memberUniqueNames) {
        ArrayList<Member> list = new ArrayList<Member>();
        for (int i = 0; i < memberUniqueNames.length; ++i) {
            String[] nameParts = memberUniqueNames[i].split("\\.");
            for (int j = 0; j < nameParts.length; ++j) {
                nameParts[j] = Util.trimBracketsAround((String)nameParts[j]);
            }
            String uniqueName = StringUtil.createUName(nameParts, -1);
            Member member = olapModel.lookupMember(uniqueName);
            if (member == null) continue;
            list.add(member);
        }
        return list;
    }

    public static List findVisibleMembers(OlapModel olapModel, Hierarchy hierarchy) {
        AxisMembersHelper amh = (AxisMembersHelper)olapModel.getExtension("axisMembersHelper");
        return amh.findVisibleMembers(hierarchy);
    }

    public static void swapAxis(OlapModel olapModel) {
        SwapAxes swap;
        swap.setSwapAxes(!(swap = (SwapAxes)olapModel.getExtension("swapAxes")).isSwapAxes());
    }

    public static boolean moveToTop(OlapModel olapModel, Hierarchy hie) {
        Hierarchy hie2 = null;
        try {
            hie2 = OlapModelUtil.getTopAxisHies(olapModel)[0];
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        return OlapModelUtil.moveBefore(olapModel, hie, hie2);
    }

    public static boolean moveToLeft(OlapModel olapModel, Hierarchy hie) {
        Hierarchy hie2 = null;
        try {
            hie2 = OlapModelUtil.getLeftAxisHies(olapModel)[0];
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        return OlapModelUtil.moveBefore(olapModel, hie, hie2);
    }

    public static boolean moveToSlice(OlapModel olapModel, Hierarchy hie) {
        try {
            olapModel.disableModelChangedEvent();
            boolean bl = OlapModelUtil.innerMoveToSlice(olapModel, hie);
            return bl;
        }
        finally {
            olapModel.postModelChanged();
        }
    }

    private static boolean inSlicer(OlapModel olapModel, Hierarchy hie) {
        Axis axis = null;
        try {
            axis = OlapModelUtil.getAxisOfHierarchy(olapModel, hie);
            return axis == null;
        }
        catch (OlapException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean innerMoveToSlice(OlapModel olapModel, Hierarchy hie) {
        Axis axis = null;
        try {
            axis = OlapModelUtil.getAxisOfHierarchy(olapModel, hie);
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        if (axis != null) {
            if (axis.getHierarchies().length == 1) {
                return false;
            }
            AxisMembersHelper amh = (AxisMembersHelper)olapModel.getExtension("axisMembersHelper");
            List members = amh.findVisibleMembers(hie);
            amh.removeHierarchy(axis, hie);
            if (members != null && members.size() == 1) {
                OlapModelUtil.getChangeSlicer(olapModel).setMember((Member)members.get(0));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void swap(OlapModel olapModel, Hierarchy hie, Hierarchy hie2) {
        try {
            olapModel.disableModelChangedEvent();
            AxisMembersHelper amh = (AxisMembersHelper)olapModel.getExtension("axisMembersHelper");
            List members = null;
            if (OlapModelUtil.inSlicer(olapModel, hie)) {
                members = amh.findVisibleMembers(hie2);
            } else if (OlapModelUtil.inSlicer(olapModel, hie2)) {
                members = amh.findVisibleMembers(hie);
            }
            amh.swapHierarchy(hie, hie2);
            if (members != null && members.size() == 1) {
                OlapModelUtil.getChangeSlicer(olapModel).setMember((Member)members.get(0));
            }
        }
        finally {
            olapModel.postModelChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveBefore(OlapModel olapModel, Hierarchy hie, Hierarchy tohie) {
        try {
            olapModel.disableModelChangedEvent();
            boolean bl = OlapModelUtil.innerMoveBefore(olapModel, hie, tohie);
            return bl;
        }
        finally {
            olapModel.postModelChanged();
        }
    }

    private static boolean innerMoveBefore(OlapModel olapModel, Hierarchy hie, Hierarchy tohie) {
        int index;
        Axis axis1 = null;
        Axis axis2 = null;
        int index1 = -1;
        int index2 = -1;
        Axis topAxis = null;
        try {
            topAxis = OlapModelUtil.getTopAxis(olapModel);
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        Axis leftAxis = null;
        try {
            leftAxis = OlapModelUtil.getLeftAxis(olapModel);
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        Hierarchy[] topAxisHies = null;
        if (null != topAxis) {
            topAxisHies = topAxis.getHierarchies();
        }
        Hierarchy[] leftAxisHies = null;
        if (null != leftAxis) {
            leftAxisHies = leftAxis.getHierarchies();
        }
        if ((index = Arrays.asList(topAxisHies).indexOf(tohie)) > -1) {
            axis1 = topAxis;
            index1 = index;
        }
        if ((index = Arrays.asList(leftAxisHies).indexOf(tohie)) > -1) {
            axis1 = leftAxis;
            index1 = index;
        }
        if ((index = Arrays.asList(topAxisHies).indexOf(hie)) > -1) {
            axis2 = topAxis;
            index2 = index;
            if (null != topAxisHies && topAxisHies.length == 1) {
                return false;
            }
        }
        if ((index = Arrays.asList(leftAxisHies).indexOf(hie)) > -1) {
            axis2 = leftAxis;
            index2 = index;
            if (null != leftAxisHies && leftAxisHies.length == 1) {
                return false;
            }
        }
        AxisMembersHelper amh = (AxisMembersHelper)olapModel.getExtension("axisMembersHelper");
        List members = null;
        if (OlapModelUtil.inSlicer(olapModel, tohie) && !OlapModelUtil.inSlicer(olapModel, hie)) {
            members = amh.findVisibleMembers(hie);
        }
        if (axis1 != null && axis1 == axis2) {
            amh.removeHierarchy(axis2, hie);
            if (index1 > index2) {
                --index1;
            }
            amh.addHierarchy(axis1, hie, index1);
        } else {
            if (axis1 != null) {
                amh.addHierarchy(axis1, hie, index1);
            }
            if (axis2 != null) {
                amh.removeHierarchy(axis2, hie);
            } else {
                OlapModelUtil.getChangeSlicer(olapModel).removeHierarchy(hie);
            }
        }
        if (members != null && members.size() == 1) {
            OlapModelUtil.getChangeSlicer(olapModel).setMember((Member)members.get(0));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveAfter(OlapModel olapModel, Hierarchy hie, Hierarchy tohie) {
        try {
            olapModel.disableModelChangedEvent();
            boolean bl = OlapModelUtil.innerMoveAfter(olapModel, hie, tohie);
            return bl;
        }
        finally {
            olapModel.postModelChanged();
        }
    }

    private static boolean innerMoveAfter(OlapModel olapModel, Hierarchy hie, Hierarchy tohie) {
        int index;
        Axis axis1 = null;
        Axis axis2 = null;
        int index1 = -1;
        int index2 = -1;
        Axis topAxis = null;
        try {
            topAxis = OlapModelUtil.getTopAxis(olapModel);
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        Axis leftAxis = null;
        try {
            leftAxis = OlapModelUtil.getLeftAxis(olapModel);
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        Hierarchy[] topAxisHies = null;
        if (null != topAxis) {
            topAxisHies = topAxis.getHierarchies();
        }
        Hierarchy[] leftAxisHies = null;
        if (null != leftAxis) {
            leftAxisHies = leftAxis.getHierarchies();
        }
        if ((index = Arrays.asList(topAxisHies).indexOf(tohie)) > -1) {
            axis1 = topAxis;
            index1 = index;
        }
        if ((index = Arrays.asList(leftAxisHies).indexOf(tohie)) > -1) {
            axis1 = leftAxis;
            index1 = index;
        }
        if ((index = Arrays.asList(topAxisHies).indexOf(hie)) > -1) {
            axis2 = topAxis;
            index2 = index;
            if (null != topAxisHies && topAxisHies.length == 1) {
                return false;
            }
        }
        if ((index = Arrays.asList(leftAxisHies).indexOf(hie)) > -1) {
            axis2 = leftAxis;
            index2 = index;
            if (null != leftAxisHies && leftAxisHies.length == 1) {
                return false;
            }
        }
        AxisMembersHelper amh = (AxisMembersHelper)olapModel.getExtension("axisMembersHelper");
        List members = null;
        if (OlapModelUtil.inSlicer(olapModel, tohie) && !OlapModelUtil.inSlicer(olapModel, hie)) {
            members = amh.findVisibleMembers(hie);
        }
        if (axis1 != null && axis1 == axis2) {
            amh.removeHierarchy(axis2, hie);
            if (index1 > index2) {
                --index1;
            }
            amh.addHierarchy(axis1, hie, index1 + 1);
        } else {
            if (axis1 != null) {
                amh.addHierarchy(axis1, hie, index1 + 1);
            }
            if (axis2 != null) {
                amh.removeHierarchy(axis2, hie);
            } else {
                OlapModelUtil.getChangeSlicer(olapModel).removeHierarchy(hie);
            }
        }
        if (members != null && members.size() == 1) {
            OlapModelUtil.getChangeSlicer(olapModel).setMember((Member)members.get(0));
        }
        return true;
    }

    public static void changeHierarchyMembers(OlapModel olapModel, Hierarchy hier, List memberList) {
        Axis axis = null;
        try {
            axis = OlapModelUtil.getAxisOfHierarchy(olapModel, hier);
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        if (axis == null) {
            Member[] slicer = OlapModelUtil.getSliceMembers(olapModel);
            for (int i = 0; i < slicer.length; ++i) {
                if (slicer[i].getHierarchy() != hier) continue;
                slicer[i] = (Member)memberList.get(0);
                OlapModelUtil.getChangeSlicer(olapModel).setSlicer(slicer);
                break;
            }
        } else {
            AxisMembersHelper amh = (AxisMembersHelper)olapModel.getExtension("axisMembersHelper");
            Exp expression = amh.createMemberExpression(memberList);
            Hierarchy[] hiers = axis.getHierarchies();
            Exp[] expressions = new Exp[hiers.length];
            for (int i = 0; i < expressions.length; ++i) {
                if (hiers[i] == hier) {
                    expressions[i] = expression;
                    continue;
                }
                expressions[i] = amh.createMemberExpression(hiers[i]);
                if (expressions[i] != null) continue;
                return;
            }
            amh.setQueryAxis(axis, hiers, expressions);
        }
    }
}

