/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.bicomponent.DimensionNavigatorF7;
import com.kingdee.bos.ctrl.analysis.bicomponent.HierarchyCellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.bicomponent.WorksheetComponent;
import com.kingdee.bos.ctrl.analysis.olap.ChangeSlicer;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class SlicerListPanel
extends KDPanel {
    WorksheetComponent worksheet;
    MyFlowLayout layout;

    public SlicerListPanel(WorksheetComponent wc) {
        this.worksheet = wc;
        this.layout = new MyFlowLayout(3, 10, 5);
        this.setLayout(this.layout);
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (this.layout.preferHeight == -1) {
            return dim;
        }
        return new Dimension(dim.width, this.layout.preferHeight);
    }

    public Dimension getMinimumSize() {
        if (this.layout.preferHeight == -1) {
            return new Dimension(0, 0);
        }
        return new Dimension(0, this.layout.preferHeight);
    }

    public void render() {
        if (this.worksheet.olapModel == null) {
            return;
        }
        this.removeAll();
        Member[] sliceMembers = OlapModelUtil.getSliceMembers(this.worksheet.olapModel);
        int size = sliceMembers.length;
        for (int i = 0; i < size; ++i) {
            this.add(this.createSlicerComponent(sliceMembers[i]));
        }
    }

    JComponent createSlicerComponent(Member member) {
        KDLabelContainer lc = new KDLabelContainer();
        lc.setFocusable(true);
        KDLabel label = new KDLabel(" " + member.getHierarchy().getCaption() + "   ");
        label.setFocusable(true);
        label.setBorder(LineBorder.createGrayLineBorder());
        label.setOpaque(true);
        lc.setBoundLabel((JLabel)label);
        lc.setBoundLabelUnderline(true);
        lc.setBoundLabelLength(80);
        lc.setPreferredSize(new Dimension(200, 21));
        lc.setBoundEditor((JComponent)this.createSlicerF7(member));
        lc.addMouseListener((MouseListener)new MyMouseAdapter(member.getHierarchy()));
        return lc;
    }

    KDPromptBox createSlicerF7(Member member) {
        Hierarchy hie = member.getHierarchy();
        DimensionNavigatorF7 f7 = new DimensionNavigatorF7(this.worksheet.getDimensionNavigator(), hie);
        KDPromptBox pb = new KDPromptBox();
        pb.setBorder(LineBorder.createGrayLineBorder());
        pb.addDataChangeListener((DataChangeListener)new DataChangeAdapter(member));
        pb.setSelector((KDPromptSelector)f7);
        pb.setValue((Object)member);
        pb.setEditable(false);
        return pb;
    }

    class MyFlowLayout
    extends FlowLayout {
        int row;
        int preferHeight;

        public MyFlowLayout() {
            this.preferHeight = -1;
        }

        public MyFlowLayout(int align, int hgap, int vgap) {
            super(align, hgap, vgap);
            this.preferHeight = -1;
        }

        public MyFlowLayout(int align) {
            super(align);
            this.preferHeight = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container target) {
            this.row = 0;
            Object object = target.getTreeLock();
            synchronized (object) {
                Insets insets = target.getInsets();
                int maxwidth = target.getWidth() - (insets.left + insets.right + this.getHgap() * 2);
                int nmembers = target.getComponentCount();
                int x = 0;
                int y = insets.top + this.getVgap();
                int rowh = 0;
                int start = 0;
                boolean ltr = target.getComponentOrientation().isLeftToRight();
                for (int i = 0; i < nmembers; ++i) {
                    Component m = target.getComponent(i);
                    if (!m.isVisible()) continue;
                    Dimension d = m.getPreferredSize();
                    m.setSize(d.width, d.height);
                    if (x == 0 || x + d.width <= maxwidth) {
                        if (x > 0) {
                            x += this.getHgap();
                        }
                        x += d.width;
                        rowh = Math.max(rowh, d.height);
                        continue;
                    }
                    this.moveComponents(target, insets.left + this.getHgap(), y, maxwidth - x, rowh, start, i, ltr);
                    x = d.width;
                    y += this.getVgap() + rowh;
                    rowh = d.height;
                    start = i;
                }
                this.moveComponents(target, insets.left + this.getHgap(), y, maxwidth - x, rowh, start, nmembers, ltr);
                Dimension d = target.getSize();
                this.preferHeight = y + rowh + insets.bottom + this.getVgap();
                target.setSize(d.width, this.preferHeight);
                target.getParent().doLayout();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
            ++this.row;
            Object object = target.getTreeLock();
            synchronized (object) {
                switch (this.getAlignment()) {
                    case 0: {
                        x += ltr ? 0 : width;
                        break;
                    }
                    case 1: {
                        x += width / 2;
                        break;
                    }
                    case 2: {
                        x += ltr ? width : 0;
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        x += width;
                    }
                }
                for (int i = rowStart; i < rowEnd; ++i) {
                    Component m = target.getComponent(i);
                    if (!m.isVisible()) continue;
                    if (ltr) {
                        m.setLocation(x, y + (height - m.getHeight()) / 2);
                    } else {
                        m.setLocation(target.getWidth() - x - m.getWidth(), y + (height - m.getHeight()) / 2);
                    }
                    x += m.getWidth() + this.getHgap();
                }
            }
        }
    }

    class MyMouseAdapter
    extends MouseAdapter {
        Hierarchy hie;

        MyMouseAdapter(Hierarchy hie) {
            this.hie = hie;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                SlicerListPanel.this.worksheet.popupCellItem = new HierarchyCellItem(SlicerListPanel.this.worksheet.olapModel, this.hie, 2);
                SlicerListPanel.this.worksheet.popupForHierarchy((HierarchyCellItem)SlicerListPanel.this.worksheet.popupCellItem, e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class DataChangeAdapter
    implements DataChangeListener {
        Member member;

        DataChangeAdapter(Member member) {
            this.member = member;
        }

        public void dataChanged(DataChangeEvent eventObj) {
            if (eventObj.getOldValue() != null) {
                ChangeSlicer cs = SlicerListPanel.this.worksheet.getChangeSlicer();
                Member[] ms = cs.getSlicer();
                for (int i = 0; i < ms.length; ++i) {
                    if (ms[i].getHierarchy() != this.member.getHierarchy()) continue;
                    ms[i] = (Member)eventObj.getNewValue();
                }
                cs.setSlicer(ms);
            }
        }
    }
}

