/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.bicomponent.BIComponentBase;
import com.kingdee.bos.ctrl.analysis.bicomponent.BIComponentResource;
import com.kingdee.bos.ctrl.analysis.bicomponent.CellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.CellRender;
import com.kingdee.bos.ctrl.analysis.bicomponent.ComponentConfig;
import com.kingdee.bos.ctrl.analysis.bicomponent.DataCellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.DimensionPropertyCellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.DimensionPropertyValueCellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.ExpandHelper;
import com.kingdee.bos.ctrl.analysis.bicomponent.HierarchyCellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.MemberCellItem;
import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.bicomponent.SlicerListPanel;
import com.kingdee.bos.ctrl.analysis.bicomponent.WorksheetMergeExpert;
import com.kingdee.bos.ctrl.analysis.bicomponent.WorksheetStyleExpert;
import com.kingdee.bos.ctrl.analysis.bicomponent.event.CellItemClickEvent;
import com.kingdee.bos.ctrl.analysis.bicomponent.layout.LayoutDesigner;
import com.kingdee.bos.ctrl.analysis.mdxw.FileChooserUtil;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.AxisMembersHelper;
import com.kingdee.bos.ctrl.analysis.olap.Cell;
import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.DimensionProperty;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Level;
import com.kingdee.bos.ctrl.analysis.olap.MdxQuery;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.NonEmpty;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.olap.Property;
import com.kingdee.bos.ctrl.analysis.olap.Result;
import com.kingdee.bos.ctrl.analysis.olap.base.FilterBase;
import com.kingdee.bos.ctrl.analysis.report.ui.AdjustColOrderDialog;
import com.kingdee.bos.ctrl.analysis.report.ui.ChartAnalysisFrame;
import com.kingdee.bos.ctrl.analysis.report.ui.DataFilterDialog;
import com.kingdee.bos.ctrl.analysis.report.ui.DataSizerDialog;
import com.kingdee.bos.ctrl.analysis.report.ui.MdxQueryDialog;
import com.kingdee.bos.ctrl.analysis.report.ui.SortRankDialog;
import com.kingdee.bos.ctrl.analysis.report.ui.style.DSDialog;
import com.kingdee.bos.ctrl.analysis.report.ui.style.LabelValueBean;
import com.kingdee.bos.ctrl.analysis.report.ui.style.MergeDialog;
import com.kingdee.bos.ctrl.analysis.report.ui.style.MergeItem;
import com.kingdee.bos.ctrl.analysis.util.FaceUtil;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.print.extend.KDTableImagePrinter;
import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.exception.HierarchyNoMemberException;
import com.kingdee.bos.olap.exception.TooManyMemberException;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class WorksheetComponent
extends BIComponentBase {
    static Logger logger = CommonLogger.getLogger(WorksheetComponent.class);
    private KDPanel rootPanel;
    private SlicerListPanel slicerPanel;
    private KDTable table;
    private CellRender render;
    private WorksheetStyleExpert styleExpert;
    private WorksheetMergeExpert mergeExpert;
    private ExpandHelper expandHelper;
    private boolean useSlicer;
    KDTDataRequestListener dataRequestListener = new KDTDataRequestListener(){

        public void tableDataRequest(KDTDataRequestEvent e) {
            WorksheetComponent.this.requestTableData(e);
        }
    };
    KDTMouseListener mouseListener = new KDTMouseListener(){

        public void tableClicked(KDTMouseEvent e) {
            int row = e.getRowIndex();
            int column = e.getColIndex();
            if (row >= 0 && column >= 0) {
                if (SwingUtilities.isLeftMouseButton((MouseEvent)e)) {
                    WorksheetComponent.this.cellClicked(WorksheetComponent.this.table, e.getClickCount() == 2, row, column, e.getOriginView(), e.getX(), e.getY(), e.getType() == 0);
                } else if (WorksheetComponent.this.config.showPopupMenuForMember) {
                    WorksheetComponent.this.popup(WorksheetComponent.this.table, row, column, e.getOriginView(), e.getX(), e.getY(), e.getType() == 0);
                }
            }
        }
    };
    private boolean empty = false;
    private JPopupMenu popupMenuForMember;
    Action actionDown = new AbstractAction(BIComponentResource.getString(BIComponentResource.class, (String)"expand")){

        @Override
        public void actionPerformed(ActionEvent e) {
            MemberCellItem mci = (MemberCellItem)WorksheetComponent.this.popupCellItem;
            WorksheetComponent.this.drilldown(mci.position, mci.member, false);
        }
    };
    Action actionDownReplace = new AbstractAction(BIComponentResource.getString(BIComponentResource.class, (String)"drilldown")){

        @Override
        public void actionPerformed(ActionEvent e) {
            MemberCellItem mci = (MemberCellItem)WorksheetComponent.this.popupCellItem;
            WorksheetComponent.this.drilldown(mci.position, mci.member, true);
        }
    };
    Action actionUp = new AbstractAction(BIComponentResource.getString(BIComponentResource.class, (String)"collapse")){

        @Override
        public void actionPerformed(ActionEvent e) {
            MemberCellItem mci = (MemberCellItem)WorksheetComponent.this.popupCellItem;
            WorksheetComponent.this.rollup(mci.position, mci.member, false);
        }
    };
    Action actionUpReplace = new AbstractAction(BIComponentResource.getString(BIComponentResource.class, (String)"rollup")){

        @Override
        public void actionPerformed(ActionEvent e) {
            MemberCellItem mci = (MemberCellItem)WorksheetComponent.this.popupCellItem;
            WorksheetComponent.this.rollup(mci.position, mci.member, true);
        }
    };
    Action actionShowOnlyMe = new AbstractAction(BIComponentResource.getString(BIComponentResource.class, (String)"onlyme")){

        @Override
        public void actionPerformed(ActionEvent e) {
            MemberCellItem mci = (MemberCellItem)WorksheetComponent.this.popupCellItem;
            WorksheetComponent.this.showOnlyMe(mci.getMember());
        }
    };
    Action actionHideMe = new AbstractAction(BIComponentResource.getString(BIComponentResource.class, (String)"hideme")){

        @Override
        public void actionPerformed(ActionEvent e) {
            MemberCellItem mci = (MemberCellItem)WorksheetComponent.this.popupCellItem;
            WorksheetComponent.this.hideMe(mci.getMember());
        }
    };
    JMenu menuDrill = new JMenu(BIComponentResource.getString(BIComponentResource.class, (String)"drill"));
    private LayoutDesigner layoutDesigner;
    private ChartAnalysisFrame ca = null;
    private SortRankDialog sortRankDialog;
    private DataSizerDialog dataSizerDialog = null;
    private AdjustColOrderDialog adjustColOrderDialog = null;
    private List dataStyleList = null;
    private List mergeList = null;
    private DSDialog dd;
    private MergeDialog mm;
    private DataFilterDialog dfd = null;
    private FileChooserUtil chooser;
    private MdxQueryDialog mdxQueryDialog;

    public WorksheetComponent(KDTable table) {
        this(table, ComponentConfig.getConfig(), false);
    }

    public WorksheetComponent(KDTable table, boolean useSlicer) {
        this(table, ComponentConfig.getConfig(), useSlicer);
    }

    public WorksheetComponent(KDTable table, ComponentConfig config) {
        this(table, config, false);
    }

    public WorksheetComponent(KDTable table, ComponentConfig config, boolean useSlicer) {
        super(config);
        if (table == null || config == null) {
            throw new NullPointerException();
        }
        this.useSlicer = useSlicer;
        this.expandHelper = new ExpandHelper(config);
        this.render = new CellRender(this.expandHelper, config);
        this.table = table;
        table.getStyleAttributes().setLocked(true);
        if (useSlicer) {
            this.slicerPanel = new SlicerListPanel(this);
            this.rootPanel = new KDPanel();
            this.rootPanel.setLayout((LayoutManager)new BorderLayout());
            this.rootPanel.add((Component)((Object)this.slicerPanel), (Object)"North");
            this.rootPanel.add((Component)table, (Object)"Center");
        }
        this.initListener();
        this.styleExpert = new WorksheetStyleExpert(this);
        this.mergeExpert = new WorksheetMergeExpert(this);
    }

    private void initListener() {
        this.table.addKDTMouseListener(this.mouseListener);
    }

    void popup(KDTable table, int row, int column, Component parent, int x, int y, boolean header) {
        try {
            if (!header && row > -1 && column > -1) {
                table.getSelectManager().select(row, column);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ICell cell = this.getRow(table, header, row).getCell(column);
        Object value = cell.getValue();
        if (value instanceof CellItem) {
            this.popupCellItem = (CellItem)value;
            if (value instanceof MemberCellItem && this.config.showPopupMenuForMember) {
                MemberCellItem mci = (MemberCellItem)value;
                if (mci.isVirtual()) {
                    return;
                }
                this.actionUp.setEnabled(!this.expandHelper.canExpand(mci) || mci.isVirtual() && this.getParentMember(mci.getMember()) == null);
                this.actionUpReplace.setEnabled(this.getParentMember(mci.getMember()) != null);
                this.actionDown.setEnabled(!mci.isLeaf() && this.expandHelper.canExpand(mci));
                this.actionDownReplace.setEnabled(!mci.isLeaf());
                if (this.getMemberListOfHierarchy(mci.getMember().getLevel().getHierarchy()).size() == 1) {
                    this.actionHideMe.setEnabled(false);
                } else {
                    this.actionHideMe.setEnabled(true);
                }
                this.getPopupMenuForMember().show(parent, x, y);
            } else if (value instanceof HierarchyCellItem && this.config.showPopupMenuForDimensionHeader) {
                this.popupForHierarchy((HierarchyCellItem)value, parent, x, y);
            }
            if (value instanceof CellItem) {
                CellItemClickEvent event = new CellItemClickEvent((CellItem)value, false, true);
                this.fireCellItemClicked(event);
            }
        }
    }

    private Position getPosition(MemberCellItem mci, int row, int column) {
        Position pos = mci.locate == 0 ? (Position)this.table.getColumn(column).getUserObject() : (Position)this.table.getRow(row).getUserObject();
        return pos;
    }

    void cellClicked(KDTable table, boolean doubleClick, int row, int column, Component parent, int x, int y, boolean header) {
        ICell cell = this.getRow(table, header, row).getCell(column);
        Object value = cell.getValue();
        if (!(value instanceof CellItem)) {
            return;
        }
        if (doubleClick) {
            if (value instanceof MemberCellItem && this.config.drillDownWhenDoubleClickMember) {
                MemberCellItem mci = (MemberCellItem)value;
                Member member = mci.getMember();
                this.drilldown(this.getPosition(mci, row, column), member, true);
            } else if (value instanceof HierarchyCellItem) {
                // empty if block
            }
        } else {
            CellRender render = (CellRender)cell.getRenderer();
            if (render != null && render.inClickRect((CellItem)value, x, y) && value instanceof MemberCellItem) {
                MemberCellItem mci = (MemberCellItem)value;
                Member member = mci.getMember();
                if (mci.isVirtual()) {
                    return;
                }
                if (!mci.isLeaf()) {
                    if (this.expandHelper.canCollapse(mci)) {
                        this.rollup(mci.position, member, false);
                    } else {
                        this.drilldown(mci.position, member, false);
                    }
                }
            }
        }
        CellItemClickEvent event = new CellItemClickEvent((CellItem)value, doubleClick, false);
        this.fireCellItemClicked(event);
    }

    private void requestTableData(KDTDataRequestEvent e) {
    }

    @Override
    public void beforeRender() {
        super.beforeRender();
        if (this.slicerPanel != null) {
            this.slicerPanel.render();
            this.slicerPanel.validate();
            this.slicerPanel.doLayout();
            this.rootPanel.validate();
            this.rootPanel.doLayout();
            this.rootPanel.repaint();
        }
    }

    @Override
    public void render() {
        int i;
        int i2;
        Result result;
        if (this.table == null || this.olapModel == null) {
            return;
        }
        this.empty = false;
        this.table.removeColumns();
        this.table.getViewManager().unFreeze();
        try {
            result = this.olapModel.getResult();
        }
        catch (OlapException e) {
            if (e.getCause() instanceof HierarchyNoMemberException) {
                this.showEmptyCell(0, 0, e.getCause().getLocalizedMessage());
            } else {
                Throwable cause = e.getCause();
                if (cause instanceof OLAPException) {
                    if (cause.getCause() instanceof TooManyMemberException) {
                        MsgBox.showWarning((String)cause.getCause().getMessage());
                    } else {
                        cause.printStackTrace();
                        logger.error((Object)cause.getMessage());
                    }
                } else if (cause != null) {
                    cause.printStackTrace();
                    logger.error((Object)cause.getMessage());
                } else {
                    logger.error((Object)e);
                }
                this.showEmptyCell(0, 0);
            }
            return;
        }
        long t1 = System.currentTimeMillis();
        Axis topAxis = OlapModelUtil.getTopAxis(result);
        Axis leftAxis = OlapModelUtil.getLeftAxis(result);
        if (topAxis == null || leftAxis == null) {
            this.showEmptyCell(0, 0);
            return;
        }
        Hierarchy[] topAxisHies = topAxis.getHierarchies();
        Hierarchy[] leftAxisHies = leftAxis.getHierarchies();
        int topAxisHieCount = topAxisHies.length;
        int leftAxisHieCount = leftAxisHies.length;
        int leftAxisPropertyCount = OlapModelUtil.getDimensionPropertyCount(leftAxis);
        int bodyRowCount = leftAxis.getPositions().size();
        int bodyColCount = topAxis.getPositions().size();
        int leftSumMaxDepth = this.sumMaxDepthOfAxis(leftAxis);
        int topSumMaxDepth = this.sumMaxDepthOfAxis(topAxis);
        int rowCount = (this.config.showColumnDimensionHeader ? topAxisHieCount : 0) + (this.config.showNestMemberForColumn ? topSumMaxDepth : topAxisHieCount) + bodyRowCount;
        int colCount = (this.config.showNestMemberForRow ? leftSumMaxDepth : leftAxisHieCount) + (bodyColCount == 0 ? 1 : bodyColCount);
        colCount += leftAxisPropertyCount;
        if (this.config.showColumnHeaderInTableHeader) {
            if (this.config.showColumnDimensionHeader) {
                rowCount -= topAxisHieCount;
                for (i2 = 0; i2 < topAxisHieCount; ++i2) {
                    this.table.addHeadRow();
                }
            }
            int j = this.config.showNestMemberForColumn ? topSumMaxDepth : topAxisHieCount;
            rowCount -= j;
            for (int i3 = 0; i3 < j; ++i3) {
                this.table.addHeadRow();
            }
        }
        for (i2 = 0; i2 < rowCount; ++i2) {
            this.table.addRow();
        }
        for (i2 = 0; i2 < colCount; ++i2) {
            this.table.addColumn().setKey("F" + i2);
        }
        int rowStart = 0;
        int colStart = 0;
        rowStart = 0;
        colStart = this.config.showNestMemberForRow ? leftSumMaxDepth : leftAxisHieCount;
        colStart += leftAxisPropertyCount;
        if (this.config.showColumnDimensionHeader) {
            this.renderTopHierarchy(topAxisHies, rowStart, colStart);
        }
        rowStart = this.config.showColumnDimensionHeader ? topAxisHieCount : 0;
        this.renderTopAxis(topAxis, rowStart, colStart);
        rowStart = (this.config.showColumnDimensionHeader ? topAxisHieCount : 0) + (this.config.showNestMemberForColumn ? topSumMaxDepth : topAxisHieCount) - 1;
        colStart = 0;
        this.renderLeftHierarchy(leftAxis, leftAxisHies, rowStart, colStart);
        rowStart = !this.config.showColumnHeaderInTableHeader ? ++rowStart : 0;
        colStart = 0;
        this.renderLeftAxis(leftAxis, rowStart, colStart);
        colStart = this.config.showNestMemberForRow ? leftSumMaxDepth : leftAxisHieCount;
        this.renderData(topAxis, leftAxis, result, rowStart, colStart += leftAxisPropertyCount);
        this.table.reLayoutAndPaint();
        int top = 0;
        int left = 0;
        int bottom = (this.config.showColumnDimensionHeader ? topAxisHieCount : 0) + (this.config.showNestMemberForColumn ? topSumMaxDepth : topAxisHieCount) - 2;
        int right = (this.config.showNestMemberForRow ? leftSumMaxDepth : leftAxisHieCount) - 1 + leftAxisPropertyCount;
        if (bottom > top || right > left) {
            this.getMergeManager(this.table, this.config.showColumnHeaderInTableHeader).mergeBlock(top, left, bottom, right);
        }
        if (this.config.showColumnDimensionHeader) {
            top = 0;
            left = (this.config.showNestMemberForRow ? leftSumMaxDepth : leftAxisHieCount) + 1 + leftAxisPropertyCount;
            bottom = topAxisHieCount - 1;
            right = this.table.getColumnCount() - 1;
            if (bottom > top || right > left) {
                this.getMergeManager(this.table, this.config.showColumnHeaderInTableHeader).mergeBlock(top, left, bottom, right);
            }
        }
        Integer[] leftMemberDepth = null;
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (!this.config.showNestMemberForRow) {
            AxisMembersHelper amh = (AxisMembersHelper)this.olapModel.getExtension("axisMembersHelper");
            for (i = 0; i < leftAxisHies.length; ++i) {
                Hierarchy hie = leftAxisHies[i];
                List ms = amh.findVisibleMembers(hie);
                int depth = -1;
                for (Member m : ms) {
                    if (m.getDepth() <= depth) continue;
                    depth = m.getDepth();
                }
                list.add(new Integer(++depth));
                DimensionProperty[] dps = OlapModelUtil.getDimensionProperties(leftAxis, hie.getDimension());
                if (dps == null || dps.length <= 0) continue;
                Integer zero = new Integer(0);
                for (int j = 0; j < dps.length; ++j) {
                    list.add(zero);
                }
            }
            leftMemberDepth = new Integer[list.size()];
            list.toArray(leftMemberDepth);
        }
        if (this.config.autoColumnWidth) {
            int c = (this.config.showNestMemberForRow ? leftSumMaxDepth : leftAxisHieCount) + leftAxisPropertyCount;
            for (i = 0; i < this.table.getColumnCount(); ++i) {
                if (i < c) {
                    if (this.config.showNestMemberForRow) {
                        this.table.getColumns().autoFitColumnWidth(i, 20);
                        continue;
                    }
                    int depth = leftMemberDepth[i];
                    this.table.getColumns().autoFitColumnWidth(i, 20 + 10 * depth);
                    continue;
                }
                this.table.getColumns().autoFitColumnWidth(i, 40);
            }
        }
        if (!this.config.showColumnHeaderInTableHeader) {
            this.table.getViewManager().setFreezeView((this.config.showColumnDimensionHeader ? topAxisHieCount : 0) + (this.config.showNestMemberForColumn ? topSumMaxDepth : topAxisHieCount), (this.config.showNestMemberForRow ? leftSumMaxDepth : leftAxisHieCount) + leftAxisPropertyCount);
        } else {
            this.table.getViewManager().setFreezeView(-1, (this.config.showNestMemberForRow ? leftSumMaxDepth : leftAxisHieCount) + leftAxisPropertyCount);
        }
        this.table.reLayoutAndPaint();
        this.popupMenuForHierarchy = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("WorksheetComponent render cost " + (System.currentTimeMillis() - t1) + "ms."));
        }
    }

    @Override
    public void afterRender() {
        super.afterRender();
        this.mergeExpert.render();
    }

    private KDTMergeManager getMergeManager(KDTable table, boolean header) {
        if (header) {
            return table.getHeadMergeManager();
        }
        return table.getMergeManager();
    }

    void removeAllLevel() throws OlapException {
        if (!this.config.showAllLevelWhenNest) {
            return;
        }
        if (this.config.showNestMemberForColumn) {
            Axis axis = OlapModelUtil.getTopAxis(this.olapModel);
            Hierarchy[] hies = axis.getHierarchies();
            int[] depth = new int[hies.length];
            for (int i = 0; i < hies.length; ++i) {
                depth[i] = this.maxDepthOfHierarchy(hies[i]);
            }
            int rowStart = this.config.showColumnDimensionHeader ? hies.length : 0;
            for (int i = hies.length - 1; i >= 0; --i) {
                if (depth[i] <= 1 || !hies[i].getLevels()[0].isAll()) continue;
                int index = 0;
                for (int j = 0; j < i; ++j) {
                    index += depth[j];
                }
                if (this.config.showColumnHeaderInTableHeader) {
                    this.table.removeHeadRow(index + rowStart);
                    continue;
                }
                this.table.removeRow(index + rowStart);
            }
        }
        if (this.config.showNestMemberForRow) {
            int i;
            Hierarchy[] hies = OlapModelUtil.getLeftAxisHies(this.olapModel);
            int[] depth = new int[hies.length];
            for (i = 0; i < hies.length; ++i) {
                depth[i] = this.maxDepthOfHierarchy(hies[i]);
            }
            for (i = hies.length - 1; i >= 0; --i) {
                if (depth[i] <= 1 || !hies[i].getLevels()[0].isAll()) continue;
                int index = 0;
                for (int j = 0; j < i; ++j) {
                    index += depth[j];
                }
                this.table.removeColumn(index);
            }
        }
    }

    private int sumMaxDepthOfAxis(Axis axis) {
        int depth = 0;
        Hierarchy[] hies = axis.getHierarchies();
        for (int i = 0; i < hies.length; ++i) {
            depth += this.maxDepthOfHierarchy(hies[i]);
        }
        return depth;
    }

    public List getMemberListOfHierarchy(Hierarchy hie) {
        AxisMembersHelper amh = (AxisMembersHelper)this.olapModel.getExtension("axisMembersHelper");
        return amh.findVisibleMembers(hie);
    }

    private int maxDepthOfHierarchy(Hierarchy hie) {
        int depth = 0;
        int temp = 0;
        Member member2 = null;
        List memberList = this.getMemberListOfHierarchy(hie);
        for (Member member2 : memberList) {
            temp = member2.getDepth();
            if (temp <= depth) continue;
            depth = temp;
        }
        return depth + 1;
    }

    private void renderTopHierarchy(Hierarchy[] hies, int rowStart, int colStart) {
        for (int i = 0; i < hies.length; ++i) {
            this.fillCellItem(this.table, this.config.showColumnHeaderInTableHeader, i + rowStart, colStart, new HierarchyCellItem(this.olapModel, hies[i], 0));
        }
    }

    IRow getRow(KDTable table, boolean header, int rowIndex) {
        if (header) {
            return table.getHeadRow(rowIndex);
        }
        return table.getRow(rowIndex);
    }

    private void renderTopAxis(Axis axis, int rowStart, int colStart) {
        if (this.config.showNestMemberForColumn) {
            this.renderTopAxisForNest(axis, rowStart, colStart);
            return;
        }
        List poses = axis.getPositions();
        if (poses.size() == 0) {
            return;
        }
        int hieCount = axis.getHierarchies().length;
        int[] span = new int[hieCount];
        for (int i = 0; i < hieCount; ++i) {
            span[i] = 0;
        }
        ICell[] lastCell = new ICell[hieCount];
        int[] lastCellIndice = new int[hieCount];
        MemberCellItem[] lastCellItem = new MemberCellItem[hieCount];
        for (int i = 0; i < poses.size(); ++i) {
            Position position = (Position)poses.get(i);
            this.table.getColumn(i + colStart).setUserObject((Object)position);
            Member[] ms = position.getMembers();
            for (int j = 0; j < ms.length; ++j) {
                MemberCellItem cellItem;
                ICell cell = this.getRow(this.table, this.config.showColumnHeaderInTableHeader, j + rowStart).getCell(i + colStart);
                if (lastCellItem[j] != null) {
                    boolean b = false;
                    for (int k = j; k >= 0; --k) {
                        int index = lastCellIndice[j];
                        MemberCellItem cellItem2 = null;
                        while (cellItem2 == null) {
                            ICell ancestorOfLastCell = this.getRow(this.table, this.config.showColumnHeaderInTableHeader, k + rowStart).getCell(index-- + colStart);
                            cellItem2 = (MemberCellItem)ancestorOfLastCell.getValue();
                        }
                        if (ms[k].equals(cellItem2.getMember())) continue;
                        b = true;
                        break;
                    }
                    if (!b && this.config.autoMergeColumnHead) {
                        ++lastCellItem[j].colSpan;
                        continue;
                    }
                    int row = lastCell[j].getRowIndex();
                    int col = lastCell[j].getColumnIndex();
                    int colSpan = lastCellItem[j].colSpan;
                    this.merge(this.config.showColumnHeaderInTableHeader, row, col, row, col + colSpan);
                }
                lastCell[j] = cell;
                lastCellIndice[j] = i;
                lastCellItem[j] = cellItem = new MemberCellItem(this.olapModel, position, ms[j], 0);
                this.fillCellItem(this.table, this.config.showColumnHeaderInTableHeader, j + rowStart, i + colStart, cellItem);
            }
        }
        for (int j = 0; j < hieCount; ++j) {
            int row = lastCell[j].getRowIndex();
            int col = lastCell[j].getColumnIndex();
            int colSpan = lastCellItem[j].colSpan;
            this.merge(this.config.showColumnHeaderInTableHeader, row, col, row, col + colSpan);
        }
    }

    private void renderLeftHierarchy(Axis axis, Hierarchy[] hies, int rowStart, int colStart) {
        if (!this.config.showRowDimensionHeader) {
            return;
        }
        int index = 0;
        for (int i = 0; i < hies.length; ++i) {
            DimensionProperty[] dimProps;
            if (!this.config.showNestMemberForRow) {
                if (i > 0) {
                    ++index;
                }
            } else if (i > 0) {
                index += this.maxDepthOfHierarchy(hies[i - 1]);
            }
            this.fillCellItem(this.table, this.config.showColumnHeaderInTableHeader, rowStart, colStart + index, new HierarchyCellItem(this.olapModel, hies[i], 1));
            if (this.config.showNestMemberForRow) {
                int depth = this.maxDepthOfHierarchy(hies[i]);
                for (int k = 1; k < depth; ++k) {
                    this.fillCellItem(this.table, this.config.showColumnHeaderInTableHeader, rowStart, colStart + index + k, new HierarchyCellItem(this.olapModel, hies[i], 1));
                }
                this.merge(this.config.showColumnHeaderInTableHeader, rowStart, colStart + index, rowStart, colStart + index + depth - 1);
            }
            if ((dimProps = OlapModelUtil.getDimensionProperties(axis, hies[i].getDimension())) == null || dimProps.length <= 0) continue;
            for (int j = 0; j < dimProps.length; ++j) {
                int col = colStart + ++index;
                if (this.config.showNestMemberForRow) {
                    col += this.maxDepthOfHierarchy(hies[i]) - 1;
                }
                this.fillCellItem(this.table, this.config.showColumnHeaderInTableHeader, rowStart, col, new DimensionPropertyCellItem(this.olapModel, dimProps[j], 1));
            }
        }
    }

    private void renderLeftAxisForNest(Axis axis, int rowStart, int colStart) {
        List poses = axis.getPositions();
        if (poses.size() == 0) {
            return;
        }
        int hieCount = axis.getHierarchies().length;
        int[] maxDepth = new int[hieCount];
        for (int i = 0; i < hieCount; ++i) {
            maxDepth[i] = this.maxDepthOfHierarchy(axis.getHierarchies()[i]);
        }
        ArrayList<Integer> propColumns = new ArrayList<Integer>();
        for (int i = 0; i < poses.size(); ++i) {
            Position position = (Position)poses.get(i);
            this.table.getRow(i + rowStart).setUserObject((Object)position);
            Member[] ms = position.getMembers();
            int propIndent = 0;
            for (int j = 0; j < hieCount; ++j) {
                int index = 0;
                for (int k = 0; k < j; ++k) {
                    index += maxDepth[k];
                }
                int propIndex = index + maxDepth[j] + propIndent;
                MemberCellItem cellItem = new MemberCellItem(this.olapModel, position, ms[j], 1, false);
                this.fillCellItem(this.table, rowStart + i, colStart + (index += ms[j].getDepth()) + propIndent, cellItem);
                if (this.config.showAllLevelWhenNest && maxDepth[j] > 1 && ms[j].isAll()) {
                    this.fillCellItem(this.table, rowStart + i, colStart + index + 1 + propIndent, cellItem);
                }
                int index2 = index;
                Member temp = this.getParentMember(ms[j]);
                while (temp != null) {
                    MemberCellItem mci = new MemberCellItem(this.olapModel, null, temp, 1, true);
                    this.fillCellItem(this.table, rowStart + i, colStart + --index2 + propIndent, mci);
                    temp = this.getParentMember(temp);
                }
                DimensionProperty[] dimProps = OlapModelUtil.getDimensionProperties(axis, ms[j].getDimension());
                if (dimProps == null) continue;
                for (int k = 0; k < dimProps.length; ++k) {
                    DimensionPropertyValueCellItem dpvCI;
                    Property property;
                    Level level = dimProps[k].getLevel();
                    if (level == null) {
                        property = ms[j].getProperty(dimProps[k].getPropertyName());
                        dpvCI = new DimensionPropertyValueCellItem(this.olapModel, property, 1);
                    } else if (level.getHierarchy().getDimension().isParentChildren()) {
                        property = ms[j].getProperty(dimProps[k].getPropertyName());
                        dpvCI = new DimensionPropertyValueCellItem(this.olapModel, property, 1);
                    } else if (ms[j].getLevel() == level) {
                        property = ms[j].getProperty(dimProps[k].getPropertyName());
                        dpvCI = new DimensionPropertyValueCellItem(this.olapModel, property, 1);
                    } else {
                        dpvCI = new DimensionPropertyValueCellItem(this.olapModel, null, 1);
                    }
                    this.fillCellItem(this.table, i + rowStart, colStart + propIndex + k, dpvCI);
                    if (propColumns.contains(new Integer(colStart + propIndex + k))) continue;
                    propColumns.add(new Integer(colStart + propIndex + k));
                }
                propIndent += dimProps.length;
            }
        }
        int sumdepth = this.sumMaxDepthOfAxis(axis);
        sumdepth += propColumns.size();
        Object value = null;
        Position lastPosition = null;
        for (int i = 0; i < poses.size(); ++i) {
            int rowindex = rowStart + i;
            IRow row = this.table.getRow(rowindex);
            int span = 0;
            for (int j = sumdepth - 1; j > -1; --j) {
                Dimension dim;
                ICell upCell;
                Object upvalue;
                if (propColumns.contains(new Integer(j))) continue;
                ICell cell = row.getCell(colStart + j);
                value = cell.getValue();
                if (value == null) {
                    ++span;
                } else if (span > 0) {
                    this.merge(rowindex, colStart + j, rowindex, colStart + j + span);
                    span = 0;
                }
                if (value == null || i <= 0 || !value.equals(upvalue = (upCell = this.table.getCell(rowindex - 1, colStart + j)).getValue())) continue;
                Position pos = (Position)poses.get(i);
                if (value instanceof MemberCellItem) {
                    dim = ((MemberCellItem)value).member.getDimension();
                } else {
                    int index = colStart + j;
                    while (!(value instanceof MemberCellItem)) {
                        value = this.table.getCell(rowindex - 1, --index).getValue();
                    }
                    dim = ((MemberCellItem)value).member.getDimension();
                }
                Member[] ms = pos.getMembers();
                boolean same = true;
                for (int k = 0; k < ms.length && !ms[k].getDimension().equals(dim); ++k) {
                    if (ms[k].equals(lastPosition.getMembers()[k])) continue;
                    same = false;
                    break;
                }
                if (!same) continue;
                KDTMergeBlock mb = upCell.getMergeBlock();
                if (mb == null) {
                    this.merge(rowindex - 1, colStart + j, rowindex, colStart + j);
                    int propIndex = colStart + j;
                    while (propColumns.contains(new Integer(++propIndex))) {
                        this.merge(rowindex - 1, propIndex, rowindex, propIndex);
                    }
                    continue;
                }
                int top = mb.getTop();
                int left = mb.getLeft();
                int bottom = mb.getBottom();
                int right = mb.getRight();
                this.split(top, left, bottom, right);
                this.merge(top, left, bottom + 1, right);
                int propIndex = right;
                while (propColumns.contains(new Integer(++propIndex))) {
                    this.split(top, propIndex, bottom, propIndex);
                    this.merge(top, propIndex, bottom + 1, propIndex);
                }
            }
            lastPosition = (Position)poses.get(i);
        }
    }

    private void renderTopAxisForNest(Axis axis, int rowStart, int colStart) {
        List poses = axis.getPositions();
        if (poses.size() == 0) {
            return;
        }
        int hieCount = axis.getHierarchies().length;
        int[] maxDepth = new int[hieCount];
        for (int i = 0; i < hieCount; ++i) {
            maxDepth[i] = this.maxDepthOfHierarchy(axis.getHierarchies()[i]);
        }
        for (int i = 0; i < poses.size(); ++i) {
            Position position = (Position)poses.get(i);
            this.table.getColumn(i + colStart).setUserObject((Object)position);
            Member[] ms = position.getMembers();
            for (int j = 0; j < hieCount; ++j) {
                int index = 0;
                for (int k = 0; k < j; ++k) {
                    index += maxDepth[k];
                }
                MemberCellItem cellItem = new MemberCellItem(this.olapModel, position, ms[j], 0);
                this.fillCellItem(this.table, this.config.showColumnHeaderInTableHeader, rowStart + (index += ms[j].getDepth()), colStart + i, cellItem);
                if (this.config.showAllLevelWhenNest && maxDepth[j] > 1 && ms[j].isAll()) {
                    this.fillCellItem(this.table, this.config.showColumnHeaderInTableHeader, rowStart + index + 1, colStart + i, cellItem);
                }
                Member temp = this.getParentMember(ms[j]);
                while (temp != null) {
                    MemberCellItem mci = new MemberCellItem(this.olapModel, null, temp, 0, true);
                    this.fillCellItem(this.table, this.config.showColumnHeaderInTableHeader, rowStart + --index, colStart + i, mci);
                    temp = this.getParentMember(temp);
                }
            }
        }
        int sumdepth = this.sumMaxDepthOfAxis(axis);
        Object value = null;
        Position lastPosition = null;
        for (int i = 0; i < poses.size(); ++i) {
            int colindex = colStart + i;
            int span = 0;
            for (int j = sumdepth - 1; j > -1; --j) {
                KDTMergeBlock mb;
                ICell cell = this.getRow(this.table, this.config.showColumnHeaderInTableHeader, rowStart + j).getCell(colindex);
                value = cell.getValue();
                if (value == null) {
                    ++span;
                } else if (span > 0) {
                    this.merge(this.config.showColumnHeaderInTableHeader, rowStart + j, colindex, rowStart + j + span, colindex);
                    span = 0;
                }
                if (value == null || i <= 0) continue;
                ICell upCell = this.getRow(this.table, this.config.showColumnHeaderInTableHeader, rowStart + j).getCell(colindex - 1);
                Object upvalue = upCell.getValue();
                if (value.equals(upvalue)) {
                    Dimension dim;
                    Position pos = (Position)poses.get(i);
                    if (value instanceof MemberCellItem) {
                        dim = ((MemberCellItem)value).member.getDimension();
                    } else {
                        int index = rowStart + j;
                        while (!(value instanceof MemberCellItem)) {
                            value = this.table.getCell(--index, colindex - 1).getValue();
                        }
                        dim = ((MemberCellItem)value).member.getDimension();
                    }
                    Member[] ms = pos.getMembers();
                    boolean same = true;
                    for (int k = 0; k < ms.length && !ms[k].getDimension().equals(dim); ++k) {
                        if (ms[k].equals(lastPosition.getMembers()[k])) continue;
                        same = false;
                        break;
                    }
                    if (!same) continue;
                    KDTMergeBlock mb2 = upCell.getMergeBlock();
                    if (mb2 == null) {
                        this.merge(this.config.showColumnHeaderInTableHeader, rowStart + j, colindex - 1, rowStart + j, colindex);
                        continue;
                    }
                    int top = mb2.getTop();
                    int left = mb2.getLeft();
                    int bottom = mb2.getBottom();
                    int right = mb2.getRight();
                    this.split(this.config.showColumnHeaderInTableHeader, top, left, bottom, right);
                    this.merge(this.config.showColumnHeaderInTableHeader, top, left, bottom, right + 1);
                    continue;
                }
                if (upvalue == null && (mb = upCell.getMergeBlock()) != null) {
                    upvalue = this.getRow(this.table, this.config.showColumnHeaderInTableHeader, mb.getTop()).getCell(mb.getLeft()).getValue();
                }
                if (upvalue != null && value instanceof MemberCellItem && !(upvalue instanceof MemberCellItem)) continue;
            }
            lastPosition = (Position)poses.get(i);
        }
    }

    private void renderLeftAxis(Axis axis, int rowStart, int colStart) {
        int j;
        if (this.config.showNestMemberForRow) {
            this.renderLeftAxisForNest(axis, rowStart, colStart);
            return;
        }
        List poses = axis.getPositions();
        if (poses.size() == 0) {
            return;
        }
        int hieCount = axis.getHierarchies().length;
        int dimPropCount = OlapModelUtil.getDimensionPropertyCount(axis);
        int[] span = new int[hieCount];
        for (int i = 0; i < hieCount; ++i) {
            span[i] = 0;
        }
        ICell[] lastCell = new ICell[hieCount];
        int[] lastCellIndice = new int[hieCount];
        MemberCellItem[] lastCellItem = new MemberCellItem[hieCount];
        Member[] ms = ((Position)poses.get(0)).getMembers();
        for (j = 0; j < ms.length + dimPropCount; ++j) {
            IColumn col = this.table.getColumn(j + colStart);
            col.setWidth((int)((double)col.getWidth() * 1.5));
        }
        for (int i = 0; i < poses.size(); ++i) {
            int j2;
            Position position = (Position)poses.get(i);
            ms = position.getMembers();
            int propIndent = 0;
            int[] lastPropIndent = new int[ms.length];
            for (j2 = 0; j2 < ms.length; ++j2) {
                lastPropIndent[j2] = 0;
            }
            this.table.getRow(i + rowStart).setUserObject((Object)position);
            for (j2 = 0; j2 < ms.length; ++j2) {
                MemberCellItem cellItem;
                DimensionProperty[] dimProps;
                ICell cell = this.table.getCell(i + rowStart, j2 + colStart + propIndent);
                if (lastCellItem[j2] != null) {
                    boolean b = false;
                    for (int k = j2; k >= 0; --k) {
                        int index = lastCellIndice[k];
                        if (index == i) {
                            b = true;
                            break;
                        }
                        CellItem cellItem2 = null;
                        while (cellItem2 == null) {
                            ICell ancestorOfLastCell = this.table.getCell(index-- + rowStart, k + colStart + (k > 0 ? lastPropIndent[k - 1] : 0));
                            cellItem2 = (CellItem)ancestorOfLastCell.getValue();
                        }
                        if (cellItem2 instanceof MemberCellItem && ms[k].equals(((MemberCellItem)cellItem2).getMember())) continue;
                        b = true;
                        break;
                    }
                    if (!b && this.config.autoMergeRowHead) {
                        ++lastCellItem[j2].rowSpan;
                        dimProps = OlapModelUtil.getDimensionProperties(axis, ms[j2].getDimension());
                        if (dimProps == null) continue;
                        lastPropIndent[j2] = propIndent += dimProps.length;
                        continue;
                    }
                    int row = lastCell[j2].getRowIndex();
                    int col = lastCell[j2].getColumnIndex();
                    int rowSpan = lastCellItem[j2].rowSpan;
                    this.table.getMergeManager().mergeBlock(row, col, row + rowSpan, col);
                    DimensionProperty[] dimProps2 = OlapModelUtil.getDimensionProperties(axis, ms[j2].getDimension());
                    if (dimProps2 != null) {
                        for (int k = 0; k < dimProps2.length; ++k) {
                            this.table.getMergeManager().mergeBlock(row, col + k + 1, row + rowSpan, col + k + 1);
                        }
                    }
                }
                lastCell[j2] = cell;
                lastCellIndice[j2] = i;
                lastCellItem[j2] = cellItem = new MemberCellItem(this.olapModel, position, ms[j2], 1, false);
                this.fillCellItem(this.table, i + rowStart, j2 + colStart + propIndent, cellItem);
                dimProps = OlapModelUtil.getDimensionProperties(axis, ms[j2].getDimension());
                if (dimProps == null) continue;
                for (int k = 0; k < dimProps.length; ++k) {
                    Property property;
                    Level level = dimProps[k].getLevel();
                    if (level == null) {
                        property = ms[j2].getProperty(dimProps[k].getPropertyName());
                        DimensionPropertyValueCellItem dpvCI = new DimensionPropertyValueCellItem(this.olapModel, property, 1);
                        this.fillCellItem(this.table, i + rowStart, j2 + colStart + propIndent + k + 1, dpvCI);
                        continue;
                    }
                    if (level.getHierarchy().getDimension().isParentChildren()) {
                        property = ms[j2].getProperty(dimProps[k].getPropertyName());
                        DimensionPropertyValueCellItem dpvCI = new DimensionPropertyValueCellItem(this.olapModel, property, 1);
                        this.fillCellItem(this.table, i + rowStart, j2 + colStart + propIndent + k + 1, dpvCI);
                        continue;
                    }
                    if (ms[j2].getLevel() == level) {
                        property = ms[j2].getProperty(dimProps[k].getPropertyName());
                        DimensionPropertyValueCellItem dpvCI = new DimensionPropertyValueCellItem(this.olapModel, property, 1);
                        this.fillCellItem(this.table, i + rowStart, j2 + colStart + propIndent + k + 1, dpvCI);
                        continue;
                    }
                    DimensionPropertyValueCellItem dpvCI = new DimensionPropertyValueCellItem(this.olapModel, null, 1);
                    this.fillCellItem(this.table, i + rowStart, j2 + colStart + propIndent + k + 1, dpvCI);
                }
                lastPropIndent[j2] = propIndent += dimProps.length;
            }
        }
        for (j = 0; j < hieCount; ++j) {
            int row = lastCell[j].getRowIndex();
            int col = lastCell[j].getColumnIndex();
            int rowSpan = lastCellItem[j].rowSpan;
            this.table.getMergeManager().mergeBlock(row, col, row + rowSpan, col);
            DimensionProperty[] dimProps = OlapModelUtil.getDimensionProperties(axis, ms[j].getDimension());
            if (dimProps == null) continue;
            for (int k = 0; k < dimProps.length; ++k) {
                this.table.getMergeManager().mergeBlock(row, col + k + 1, row + rowSpan, col + k + 1);
            }
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private void showEmptyCell(int row, int col) {
        this.showEmptyCell(row, col, null);
    }

    private void showEmptyCell(int row, int col, String message) {
        this.empty = true;
        ICell cell = this.table.getCell(row = row < 0 ? 0 : row, col = col < 0 ? 0 : col);
        if (cell == null) {
            this.table.removeColumns();
            this.table.removeRows();
            this.table.addHeadRow();
            this.table.addColumn().setKey("FF" + col);
            cell = this.table.addRow().getCell(0);
        }
        if (message == null) {
            message = "(" + BIComponentResource.getString(BIComponentResource.class, (String)"Empty") + ")";
        } else {
            this.table.getHeadRow(0).getCell(0).setValue((Object)BIComponentResource.getString(BIComponentResource.class, (String)"Error"));
            this.table.getColumn(0).setWidth(100);
        }
        cell.setValue((Object)message);
    }

    private void renderData(Axis topAxis, Axis leftAxis, Result result, int rowStart, int colStart) {
        List leftPoses = leftAxis.getPositions();
        List topPoses = topAxis.getPositions();
        if (leftPoses.size() == 0 && topPoses.size() == 0 && !this.config.showColumnHeaderInTableHeader) {
            this.showEmptyCell(rowStart - 1, colStart);
            return;
        }
        int leftAxisCount = leftPoses.size();
        int topAxisCount = topPoses.size();
        for (int i = 0; i < leftAxisCount; ++i) {
            for (int j = 0; j < topAxisCount; ++j) {
                Cell cell = result.getCell(j, i);
                this.fillCellItem(this.table, i + rowStart, j + colStart, new DataCellItem(this.olapModel, cell));
            }
        }
    }

    void split(boolean header, int rowbegin, int colbegin, int rowend, int colend) {
        if (header) {
            this.table.getHeadMergeManager().splitBlock(rowbegin, colbegin, rowend, colend);
        } else {
            this.table.getMergeManager().splitBlock(rowbegin, colbegin, rowend, colend);
        }
    }

    void split(int rowbegin, int colbegin, int rowend, int colend) {
        this.split(false, rowbegin, colbegin, rowend, colend);
    }

    void merge(boolean header, int rowbegin, int colbegin, int rowend, int colend) {
        if (header) {
            this.table.getHeadMergeManager().mergeBlock(rowbegin, colbegin, rowend, colend);
        } else {
            this.table.getMergeManager().mergeBlock(rowbegin, colbegin, rowend, colend);
        }
    }

    void merge(int rowbegin, int colbegin, int rowend, int colend) {
        this.merge(false, rowbegin, colbegin, rowend, colend);
    }

    void fillCellItem(ICell cell, CellItem cellItem) {
        cell.setValue((Object)cellItem);
        cell.setRenderer((IBasicRender)((CellRender)this.render.clone()));
        cell.getStyleAttributes().setHorizontalAlign(cellItem.getHorizontalAlignment());
        cell.getStyleAttributes().setFontColor(cellItem.getForeColor());
        if (cellItem.getBgColor() != null) {
            cell.getStyleAttributes().setBackground(cellItem.getBgColor());
        }
        if (cellItem instanceof DataCellItem) {
            this.styleExpert.render((DataCellItem)cellItem, cell);
        }
    }

    void fillCellItem(KDTable table, boolean header, int row, int column, CellItem cellItem) {
        ICell cell = this.getRow(table, header, row).getCell(column);
        this.fillCellItem(cell, cellItem);
    }

    void fillCellItem(KDTable table, int row, int column, CellItem cellItem) {
        this.fillCellItem(table, false, row, column, cellItem);
    }

    public WorksheetStyleExpert getStyleExpert() {
        return this.styleExpert;
    }

    public WorksheetMergeExpert getMergeExpert() {
        return this.mergeExpert;
    }

    public CellItem getCellItem(ICell cell) {
        Object o = cell.getValue();
        if (o instanceof CellItem) {
            return (CellItem)o;
        }
        return null;
    }

    public JPopupMenu getPopupMenuForMember() {
        if (this.popupMenuForMember == null) {
            this.popupMenuForMember = new JPopupMenu();
            this.popupMenuForMember.add(this.actionDown);
            this.popupMenuForMember.add(this.actionDownReplace);
            this.popupMenuForMember.add(this.actionUp);
            this.popupMenuForMember.add(this.actionUpReplace);
            this.popupMenuForMember.addSeparator();
            this.popupMenuForMember.add(this.actionHideMe);
            this.popupMenuForMember.add(this.actionShowOnlyMe);
        }
        return this.popupMenuForMember;
    }

    @Override
    public JComponent getJComponent() {
        if (this.useSlicer) {
            return this.rootPanel;
        }
        return this.table;
    }

    public KDTable getKDTable() {
        return this.table;
    }

    private LayoutDesigner getLayoutDesigner() {
        if (this.layoutDesigner == null) {
            this.layoutDesigner = (LayoutDesigner)WindowUtil.createWindow(LayoutDesigner.class, (Component)this.getJComponent());
        }
        return this.layoutDesigner;
    }

    public void openLayoutDesigner() {
        if (this.olapModel == null) {
            return;
        }
        LayoutDesigner layoutDesigner = this.getLayoutDesigner();
        layoutDesigner.setOlapModel(this.getOlapModel());
        if (layoutDesigner.showDialog()) {
            super.refresh();
        }
    }

    public void openChartAnalysis(Connection connection, String mdx, String filter, ComponentConfig cc) {
        if (this.olapModel == null) {
            return;
        }
        if (this.ca == null) {
            this.ca = new ChartAnalysisFrame(cc);
        }
        this.ca.setOlapModel(this.olapModel, connection, mdx, filter);
        this.ca.setVisible(true);
    }

    public void sortRank() {
        if (this.olapModel == null) {
            return;
        }
        if (this.sortRankDialog == null) {
            this.sortRankDialog = (SortRankDialog)((Object)WindowUtil.createWindow(SortRankDialog.class, (Component)this.getJComponent()));
        }
        this.sortRankDialog.setOlapModel(this.olapModel);
        this.olapModel.disableModelChangedEvent();
        if (this.sortRankDialog.showDialog()) {
            this.olapModel.postModelChanged();
        } else {
            this.olapModel.enableModelChangedEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sizerData() {
        if (this.olapModel == null) {
            return;
        }
        if (this.dataSizerDialog == null) {
            this.dataSizerDialog = (DataSizerDialog)WindowUtil.createWindow(DataSizerDialog.class, (Component)this.getJComponent());
        }
        this.dataSizerDialog.setOlapModel(this.olapModel);
        FilterBase filter = (FilterBase)this.olapModel.getExtension("filter");
        if (this.dataSizerDialog.showDialog()) {
            boolean use = this.dataSizerDialog.useFilter();
            String condition = this.dataSizerDialog.getCondition(false);
            try {
                this.olapModel.disableModelChangedEvent();
                filter.setFiltering(use);
                filter.setCondition(condition);
                this.dataSizerDialog.disableModelChange();
                this.olapModel.postModelChanged();
            }
            catch (Exception e) {
                WindowUtil.alert((Component)((Object)this.dataSizerDialog), (String)e.getMessage());
            }
            finally {
                this.olapModel.enableModelChangedEvent();
                this.dataSizerDialog.enableModelChange();
            }
        }
    }

    public void adjustColOrder() {
        if (this.olapModel == null) {
            return;
        }
        if (this.adjustColOrderDialog == null) {
            this.adjustColOrderDialog = (AdjustColOrderDialog)((Object)WindowUtil.createWindow(AdjustColOrderDialog.class, (Component)this.getJComponent()));
        }
        this.adjustColOrderDialog.setOlapModel(this.olapModel);
        this.olapModel.disableModelChangedEvent();
        if (this.adjustColOrderDialog.showDialog()) {
            this.adjustColOrderDialog.apply();
        } else {
            this.olapModel.enableModelChangedEvent();
        }
    }

    public void doPrint(boolean preview, KDChart kdchart, HeadFootModel header) {
        if (this.olapModel == null) {
            return;
        }
        KDTableImagePrinter printer = new KDTableImagePrinter();
        printer.setSpace(20);
        printer.addDataParser(KDTable.class, KDTableImagePrinter.TABLE_PARSER);
        printer.addDataParser(Image.class, KDTableImagePrinter.IMAGE_PARSER);
        printer.setParent((Component)this.getJComponent());
        ArrayList<Object> dataList = new ArrayList<Object>();
        dataList.add(this.table);
        if (kdchart != null) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ChartUtilities.writeChartAsPNG((OutputStream)os, (JFreeChart)kdchart.getDelegate(), (int)kdchart.getWidth(), (int)kdchart.getHeight());
                Image img = new ImageIcon(os.toByteArray()).getImage();
                dataList.add(img);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        printer.setPrintData(dataList.toArray());
        if (header == null) {
            header = new HeadFootModel();
            header.addRow(this.olapModel.getCubeName());
        }
        printer.setHeader(header);
        if (preview) {
            printer.printPreview();
        } else {
            printer.print();
        }
    }

    public void applyDataStyle() {
        this.getStyleExpert().clear();
        if (this.dataStyleList != null) {
            int n = this.dataStyleList.size();
            for (int i = 0; i < n; ++i) {
                LabelValueBean lvb = (LabelValueBean)this.dataStyleList.get(i);
                this.getStyleExpert().addCellStylePattern((String)lvb.getValue());
            }
        }
    }

    public void applyMerge() {
        this.getMergeExpert().clear();
        if (this.mergeList != null) {
            int n = this.mergeList.size();
            for (int i = 0; i < n; ++i) {
                LabelValueBean lvb = (LabelValueBean)this.mergeList.get(i);
                MergeItem item = (MergeItem)lvb.getValue();
                this.getMergeExpert().addItem(item.getMemberUniqueNames(), item.getContentIndex());
            }
        }
    }

    public void dataStyle() {
        if (this.olapModel != null) {
            Window obj = SwingUtilities.getWindowAncestor(this.getJComponent());
            this.dd = obj instanceof Frame ? new DSDialog((Frame)obj) : new DSDialog((Dialog)obj);
            this.dd.setModel(this.olapModel, this.dataStyleList);
            this.dd.setSize(800, 550);
            FaceUtil.center((Window)((Object)this.dd));
            if (this.dd.showDialog()) {
                this.dataStyleList = this.dd.getDataStyleList();
                this.applyDataStyle();
                this.refresh();
            }
        }
    }

    public void mergeStyle() {
        if (this.olapModel != null) {
            if (this.mm == null) {
                Window obj = SwingUtilities.getWindowAncestor(this.getJComponent());
                this.mm = obj instanceof Frame ? new MergeDialog((Frame)obj) : new MergeDialog((Dialog)obj);
            }
            this.mm.setModel(this.olapModel, this.mergeList);
            this.mm.setSize(400, 300);
            FaceUtil.center((Window)((Object)this.mm));
            if (this.mm.showDialog()) {
                this.mergeList = this.mm.getMergeStyleList();
                this.applyMerge();
                this.refresh();
            }
        }
    }

    public List getDataStyleList() {
        return this.dataStyleList;
    }

    public void setDataStyleList(List dataStyleList) {
        this.dataStyleList = dataStyleList;
    }

    public List getMergeList() {
        return this.mergeList;
    }

    public void setMergeList(List mergeList) {
        this.mergeList = mergeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterData() {
        if (this.olapModel == null) {
            return;
        }
        if (this.dfd == null) {
            Window obj = SwingUtilities.getWindowAncestor(this.getJComponent());
            this.dfd = obj instanceof Frame ? new DataFilterDialog((Frame)obj) : new DataFilterDialog((Dialog)obj);
        }
        this.dfd.setOlapModel(this.olapModel);
        FilterBase filter = (FilterBase)this.olapModel.getExtension("filter");
        while (this.dfd.showDialog()) {
            boolean use = this.dfd.useFilter();
            String condition = this.dfd.getCondition();
            try {
                this.olapModel.disableModelChangedEvent();
                filter.setFiltering(use);
                filter.setCondition(condition);
                this.olapModel.postModelChanged();
                break;
            }
            catch (Exception e) {
                WindowUtil.alert((Component)this.getJComponent(), (String)e.getMessage());
            }
            finally {
                this.olapModel.enableModelChangedEvent();
            }
        }
    }

    public void export2Excel() {
        if (this.olapModel == null) {
            return;
        }
        if (this.chooser == null) {
            this.chooser = new FileChooserUtil(this.getJComponent());
        }
        ExportManager man = new ExportManager();
        man.setExporterParmeter(ExporterParameter.BOOK_LOCKED, (Object)Boolean.FALSE);
        man.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
        man.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"false");
        File f = this.chooser.saveFile(BIComponentResource.getString(BIComponentResource.class, (String)"OutputExcel"), "xls", BIComponentResource.getString(BIComponentResource.class, (String)"ExcelFile"));
        if (f != null) {
            KDSBook book = null;
            book = new KDSBook("kdtable export");
            String fileName = f.getAbsolutePath();
            if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                fileName = fileName + ".xls";
            }
            try {
                book.addSheet(null, this.table.getIOManager().saveToKDSSheet(book, true, false, false, this.table.getName() == null ? "Sheet 1" : this.table.getName()));
                man.exportToExcel(book, fileName);
                JOptionPane.showMessageDialog(this.getJComponent(), BIComponentResource.getString(BIComponentResource.class, (String)"OutputSuccess"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String mdxQuery() {
        if (this.olapModel == null) {
            return null;
        }
        if (this.mdxQueryDialog == null) {
            Window obj = SwingUtilities.getWindowAncestor(this.getJComponent());
            this.mdxQueryDialog = obj instanceof Frame ? new MdxQueryDialog((Frame)obj) : new MdxQueryDialog((Dialog)obj);
        }
        MdxQuery mdxQuery = (MdxQuery)this.olapModel.getExtension("mdxQuery");
        this.mdxQueryDialog.setMdx(mdxQuery.getMdxQuery());
        String mdx = mdxQuery.getMdxQuery();
        while (this.mdxQueryDialog.showDialog()) {
            try {
                this.olapModel.disableModelChangedEvent();
                mdxQuery.setMdxQuery(this.mdxQueryDialog.getMdx());
                NonEmpty nonEmpty = (NonEmpty)this.olapModel.getExtension("nonEmpty");
                nonEmpty.setNonEmptyForColumn(this.config.nonEmptyForColumn);
                nonEmpty.setNonEmptyForRow(this.config.nonEmptyForRow);
                this.olapModel.postModelChanged();
                break;
            }
            catch (OlapException e) {
                WindowUtil.alert((Component)((Frame)SwingUtilities.getWindowAncestor(this.getJComponent())), (String)e.getMessage());
            }
            finally {
                this.olapModel.enableModelChangedEvent();
            }
        }
        return mdx;
    }

    public void dispose() {
        if (this.ca != null) {
            this.ca.dispose();
        }
    }
}

