/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent.style;

import com.kingdee.bos.ctrl.analysis.bicomponent.style.ExecuteContext;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.ExprBase;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.Macro;
import com.kingdee.bos.ctrl.analysis.bicomponent.style.StyleException;
import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import java.util.ArrayList;

public class CompoundId
extends ExprBase {
    private ArrayList names = new ArrayList();

    public CompoundId(String name, boolean isKey) {
        this.names.add(new NamePart(name, isKey));
    }

    public CompoundId(String name) {
        this(name, false);
    }

    public void append(String name, boolean isKey) {
        this.names.add(new NamePart(name, isKey));
    }

    public void append(String name) {
        this.names.add(new NamePart(name, false));
    }

    public String[] toStringArray() {
        String[] ret = new String[this.names.size()];
        int i = 0;
        for (NamePart np : this.names) {
            ret[i++] = np.name;
        }
        return ret;
    }

    private CompoundId() {
    }

    public Object clone() {
        CompoundId cloned = new CompoundId();
        for (NamePart np : this.names) {
            cloned.append(np.name, np.isKey);
        }
        return cloned;
    }

    public String toString() {
        String str = "";
        boolean isFollow = false;
        for (NamePart np : this.names) {
            if (isFollow) {
                str = str + ".";
            }
            isFollow = true;
            str = str + "[" + np.name + "]";
        }
        return str;
    }

    @Override
    public Object execute(ExecuteContext context) {
        OlapModel olapModel = context.getOlapModel();
        String uniqueName = this.toString();
        if (this.names.size() == 1) {
            String name = ((NamePart)this.names.get(0)).name;
            if (Macro.isMacro(name)) {
                return new Macro(name).execute(context);
            }
            Dimension dim = olapModel.lookupDimension(uniqueName);
            if (dim == null) {
                throw new StyleException(uniqueName + "\u9884\u671f\u4e3a\u7ef4\u5ea6\u540d\u79f0\uff0c\u4f46\u662f\u6ca1\u6709\u627e\u5230\u3002");
            }
            return dim;
        }
        Member member = olapModel.lookupMember(uniqueName);
        if (member == null) {
            throw new StyleException(uniqueName + "\u9884\u671f\u4e3a\u6210\u5458\u540d\u79f0\uff0c\u4f46\u662f\u6ca1\u6709\u627e\u5230\u3002");
        }
        return member;
    }

    private class NamePart {
        private String name;
        private boolean isKey;

        protected NamePart(String name, boolean isKey) {
            this.name = name.startsWith("[") ? name.substring(1, name.length() - 1) : name;
            this.isKey = isKey;
        }
    }
}

