/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.cubemodel.designer;

import com.kingdee.bos.ctrl.analysis.AnalysisException;
import com.kingdee.bos.ctrl.analysis.cubemodel.CubeModelResource;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.CubeModelEditor;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.NodeData;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.model.Column;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.model.Table;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.WizardContext;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.AbstractWizardStep;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.Cube_DefineMeasure;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.Cube_SelectFactTable;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.Dim_PC_SelectColumn;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.Dim_SelectCreateType;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.Dim_Std_CreateLevel;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.Dim_Time_SelectColumnAndHieType;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Aggregation;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_ChildKey;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Column;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Cube;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Dimension;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Expression;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Fact;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_FactJoinRef;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Hierarchy;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Join;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Level;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Measure;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_MemberAlias;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_MemberKey;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_MemberName;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_ParentKey;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Property;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Rule;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_Table;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel_TableRef;
import com.kingdee.bos.ctrl.analysis.report.schema.OlapRpt_MeasureFormat;
import com.kingdee.bos.ctrl.analysis.xmlutil.Names;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class WizardHelper {
    private final CubeModelEditor editor;
    private Table factTable;
    private HashSet setName = new HashSet(4);
    private HashSet setAlias = new HashSet(4);

    WizardHelper(CubeModelEditor editor) {
        this.editor = editor;
    }

    private WizardDialog newWizardDialog() {
        Window window = SwingUtilities.getWindowAncestor((Component)((Object)this.editor));
        WizardDialog wd = window instanceof Dialog ? new WizardDialog((Dialog)window, true) : new WizardDialog((Frame)window, true);
        wd.setSize(800, 600);
        wd.hidePicture();
        wd.setResizable(true);
        WindowUtil.makeCneterBounds((Window)wd);
        return wd;
    }

    public boolean doEditCubeNodeWizard() {
        DefaultKingdeeTreeNode currentNode = this.editor.getSelectedNode();
        if (currentNode == null) {
            return false;
        }
        NodeData nd = (NodeData)currentNode.getUserObject();
        CubeModel_Cube cube = (CubeModel_Cube)((NodeData)this.editor.getSelectedCubeNode().getUserObject()).model;
        switch (nd.type) {
            case 20: {
                return this.doEditFact(nd, cube);
            }
            case 70: {
                return this.doEditDimension(nd, cube);
            }
        }
        return false;
    }

    private boolean doEditDimension(NodeData nd, CubeModel_Cube cube) {
        WizardContext.PropertyInfo pi;
        int n;
        CubeModel_Property[] cps;
        Table table;
        WizardContext context = new WizardContext();
        context.put("DataProvider", this.editor.dataProvider);
        WizardDialog wd = this.newWizardDialog();
        wd.setTitle("\u4fee\u6539\u7ef4\u5ea6\u5c5e\u6027");
        CubeModel_Dimension dim = (CubeModel_Dimension)nd.model;
        String tableName = dim.getTableRefs()[0].getName();
        try {
            table = this.editor.dataProvider.queryTableModel(tableName);
        }
        catch (AnalysisException e) {
            WindowUtil.alert((Component)this.editor.getWindow(), (String)e.getMessage());
            return false;
        }
        context.put("EnableFinish", Boolean.TRUE);
        context.put("DimensionTable", table);
        context.put("FactTable", this.factTable);
        context.put("SetName", this.setName);
        context.put("SetAlias", this.setAlias);
        context.put("DimensionName", dim.getName());
        context.put("DimensionAlias", dim.getAlias());
        context.put("HasAll", dim.getHierarchys()[0].isHasAll());
        context.put("AllMemberName", dim.getHierarchys()[0].getAllMemberName());
        context.put("AllMemberCaption", dim.getHierarchys()[0].getAllMemberCaption());
        String type = dim.getType();
        context.put("DimensionType", type);
        ArrayList<AbstractWizardStep> list = new ArrayList<AbstractWizardStep>(3);
        if ("standard".equals(type)) {
            list.add(new Dim_Std_CreateLevel(context));
            CubeModel_Level[] levels = dim.getHierarchys()[0].getLevels();
            WizardContext.ALevel[] aLevels = new WizardContext.ALevel[levels.length];
            for (int i = 0; i < levels.length; ++i) {
                CubeModel_Level level = levels[i];
                Column key = new Column(level.getMemberKey().getExp().getColumns()[0].getName(), null);
                Column name = new Column(level.getMemberName().getExp().getColumns()[0].getName(), null);
                Column alis = new Column(level.getMemberAlias().getExp().getColumns()[0].getName(), null);
                aLevels[i] = new WizardContext.ALevel(level.getName(), level.getAlias(), key, name, alis, level.getOrderBy(), level.getOrderMethod());
                cps = level.getProperties();
                if (cps == null) continue;
                n = cps.length;
                for (int j = 0; j < n; ++j) {
                    pi = new WizardContext.PropertyInfo();
                    pi.name = cps[j].getName();
                    pi.caption = cps[j].getCaption();
                    pi.column = cps[j].getColumn();
                    aLevels[i].addPropertyInfo(pi);
                }
            }
            context.put("LevelInfo", new WizardContext.LevelInfo(aLevels));
        } else if ("time".equals(type)) {
            list.add(new Dim_Time_SelectColumnAndHieType(context));
            WizardContext.TimeInfo timeInfo = new WizardContext.TimeInfo(new Column(dim.getTimeColumn().getName(), dim.getTimeColumn().getAlias(), null), dim.getHierarchys()[0].getType());
            context.put("TimeInfo", timeInfo);
        } else {
            list.add(new Dim_PC_SelectColumn(context));
            CubeModel_Hierarchy hie = dim.getHierarchys()[0];
            Column key = new Column(hie.getMemberKey().getExp().getColumns()[0].getName(), null, null);
            Column name = new Column(hie.getMemberName().getExp().getColumns()[0].getName(), null, null);
            Column alias = new Column(hie.getMemberAlias().getExp().getColumns()[0].getName(), null, null);
            Column parentKey = new Column(hie.getParentKey().getExp().getColumns()[0].getName(), null, null);
            Column childKey = null;
            if (hie.getChildKey() != null) {
                childKey = new Column(hie.getChildKey().getExp().getColumns()[0].getName(), null, null);
            }
            WizardContext.ParentChildInfo pcInfo = new WizardContext.ParentChildInfo(key, name, alias, parentKey, childKey, hie.getRule() == null ? null : hie.getRule().getName(), hie.getOrderBy(), hie.getOrderMethod());
            cps = hie.getProperties();
            if (cps != null) {
                n = cps.length;
                for (int i = 0; i < n; ++i) {
                    pi = new WizardContext.PropertyInfo();
                    pi.name = cps[i].getName();
                    pi.caption = cps[i].getCaption();
                    pi.column = cps[i].getColumn();
                    pcInfo.addPropertyInfo(pi);
                }
            }
            context.put("ParentChildInfo", pcInfo);
        }
        CubeModel_Join[] joins = cube.getJoins();
        for (int i = 0; i < joins.length; ++i) {
            if (!joins[i].getLeftTable().equals(tableName)) continue;
            WizardContext.DimensionFactJoinInfo join = new WizardContext.DimensionFactJoinInfo(new Column(joins[i].getLeftColumn(), null), new Column(joins[i].getRightColumn(), null));
            context.put("DimensionFactJoinInfo", join);
            break;
        }
        this.setName.remove(dim.getName());
        this.setAlias.remove(dim.getAlias());
        wd.setStepsList(list);
        wd.show();
        if (context.get("Finish") != null) {
            this.deleteDimension(dim);
            TreePath pp = this.editor.tree.getSelectionPath().getParentPath();
            this.editor.actionHelper.doDeleteDimension(true);
            this.editor.tree.setSelectionPath(pp);
            CubeModel_Dimension newDim = this.makeDimension(context, cube);
            CubeModel_Dimension[] dims = cube.getDimensions();
            CubeModel_Dimension[] newDims = new CubeModel_Dimension[dims.length + 1];
            System.arraycopy(dims, 0, newDims, 0, dims.length);
            newDims[dims.length] = newDim;
            cube.setDimensions(newDims);
            this.addDimensionNode(cube, newDim);
            if (newDim.getFactJoinRef() != null) {
                this.editor.diagramHelper.addDimensionTableForCube(cube, newDim, (Table)context.get("DimensionTable"));
            }
            return true;
        }
        this.setName.add(dim.getName());
        this.setAlias.add(dim.getAlias());
        return false;
    }

    private boolean doEditFact(NodeData nd, CubeModel_Cube cube) {
        Table table;
        WizardContext context = new WizardContext();
        context.put("DataProvider", this.editor.dataProvider);
        WizardDialog wd = this.newWizardDialog();
        wd.setTitle("\u4fee\u6539\u4e8b\u5b9e\u8868\u5c5e\u6027");
        CubeModel_Fact fact = (CubeModel_Fact)nd.model;
        String tableName = fact.getTableRef().getName();
        try {
            table = this.editor.dataProvider.queryTableModel(tableName);
        }
        catch (AnalysisException e) {
            WindowUtil.alert((Component)this.editor.getWindow(), (String)e.getMessage());
            return false;
        }
        context.put("FactTable", table);
        CubeModel_Measure[] measures = fact.getMeasures();
        WizardContext.AMeasure[] ams = new WizardContext.AMeasure[measures.length];
        for (int i = 0; i < measures.length; ++i) {
            WizardContext.AMeasure am;
            ams[i] = am = new WizardContext.AMeasure(measures[i].getName(), measures[i].getAlias(), new Column(measures[i].getExp().getColumns()[0].getName(), null), measures[i].getAgg().getFunction(), measures[i].getFormat().getFormatString());
        }
        context.put("MeasureInfo", new WizardContext.MeasureInfo(ams));
        context.put("CubeName", cube.getName());
        context.put("CubeAlias", cube.getAlias());
        context.put("EnableFinish", Boolean.TRUE);
        ArrayList<Cube_DefineMeasure> list = new ArrayList<Cube_DefineMeasure>(2);
        list.add(new Cube_DefineMeasure(context));
        wd.setStepsList(list);
        wd.show();
        if (context.get("Finish") != null) {
            CubeModel_Dimension[] dims = cube.getDimensions();
            TreePath pp = this.editor.tree.getSelectionPath().getParentPath();
            TreePath pp2 = pp.getParentPath();
            this.editor.tree.setSelectionPath(pp);
            this.deleteCube();
            this.editor.actionHelper.doDeleteCube(true);
            this.editor.tree.setSelectionPath(pp2);
            CubeModel_Cube newCube = this.makeCube(context);
            DefaultKingdeeTreeNode cubeNameNode = (DefaultKingdeeTreeNode)pp2.getLastPathComponent();
            try {
                this.addCubeNode(cubeNameNode, newCube);
            }
            catch (AnalysisException e1) {
                WindowUtil.alert((Component)this.editor.getWindow(), (String)e1.getMessage());
                return false;
            }
            this.editor.diagramHelper.addJoinPanelForCube(newCube, (Table)context.get("FactTable"));
            newCube.setDimensions(dims);
            newCube.setJoins(cube.getJoins());
            newCube.setTables(cube.getTables());
            DefaultKingdeeTreeNode dimRoot = (DefaultKingdeeTreeNode)cubeNameNode.getChildAt(0).getChildAt(1);
            int n = dims.length;
            for (int i = 0; i < n; ++i) {
                this.addDimensionNode(newCube, dims[i]);
                if (dims[i].getFactJoinRef() == null) continue;
                try {
                    this.editor.diagramHelper.addDimensionTableForCube(newCube, dims[i]);
                    continue;
                }
                catch (AnalysisException e) {
                    WindowUtil.alert((Component)this.editor.getWindow(), (String)e.getMessage());
                    return false;
                }
            }
            this.editor.tree.setSelectionNode((DefaultKingdeeTreeNode)dimRoot.getParent().getChildAt(0));
            this.editor.mapCubeToMapRefCount.remove(cube);
            this.editor.actionHelper.buildRefCountInfo(newCube);
            return true;
        }
        return false;
    }

    public boolean doCreateCubeWizard() {
        DefaultKingdeeTreeNode currentNode = this.editor.getSelectedNode();
        if (currentNode == null) {
            return false;
        }
        if (this.factTable != null) {
            WindowUtil.alert((Component)this.editor.getWindow(), (String)CubeModelResource.getString(CubeModelResource.class, (String)"OnlyOneCubeSupported"));
            return false;
        }
        WizardContext context = new WizardContext();
        context.put("DataProvider", this.editor.dataProvider);
        WizardDialog wd = this.newWizardDialog();
        wd.setTitle(CubeModelResource.getString(CubeModelResource.class, (String)"CubeWizard"));
        ArrayList<Cube_SelectFactTable> list = new ArrayList<Cube_SelectFactTable>(5);
        list.add(new Cube_SelectFactTable(context));
        wd.setStepsList(list);
        wd.show();
        if (context.get("Finish") != null) {
            CubeModel_Cube cube = this.makeCube(context);
            try {
                this.addCubeNode(currentNode, cube);
            }
            catch (AnalysisException e) {
                WindowUtil.alert((Component)this.editor.getWindow(), (String)e.getMessage());
                return false;
            }
            this.editor.diagramHelper.addJoinPanelForCube(cube, (Table)context.get("FactTable"));
            return true;
        }
        return false;
    }

    void addCubeNode(DefaultKingdeeTreeNode currentNode, CubeModel_Cube cube) throws AnalysisException {
        this.factTable = this.editor.dataProvider.queryTableModel(cube.getFact().getTableRef().getName());
        DefaultKingdeeTreeNode cubeNode = this.editor.createNode(10, cube.getAlias(), cube.getName(), this.editor.iconCube, cube);
        this.editor.tree.addNodeInto((MutableTreeNode)cubeNode, (MutableTreeNode)currentNode);
        DefaultKingdeeTreeNode factNode = this.editor.createNode(20, CubeModelResource.getString(CubeModelResource.class, (String)"Fact"), "", this.editor.iconFact, cube.getFact());
        this.editor.tree.addNodeInto((MutableTreeNode)factNode, (MutableTreeNode)cubeNode);
        DefaultKingdeeTreeNode tableFolderNode = this.editor.createNode(30, CubeModelResource.getString(CubeModelResource.class, (String)"Table"), "", null, null);
        this.editor.tree.addNodeInto((MutableTreeNode)tableFolderNode, (MutableTreeNode)factNode);
        CubeModel_Table table = this.editor.findTable(cube, cube.getFact().getTableRef().getName());
        DefaultKingdeeTreeNode tableNode = this.editor.createNode(35, table.getAlias(), table.getName(), this.editor.iconTable, null);
        this.editor.tree.addNodeInto((MutableTreeNode)tableNode, (MutableTreeNode)tableFolderNode);
        DefaultKingdeeTreeNode measureFolderNode = this.editor.createNode(40, CubeModelResource.getString(CubeModelResource.class, (String)"Measure"), null, null, null);
        this.editor.tree.addNodeInto((MutableTreeNode)measureFolderNode, (MutableTreeNode)factNode);
        for (int i = 0; i < cube.getFact().getMeasures().length; ++i) {
            CubeModel_Measure measure = cube.getFact().getMeasures()[i];
            DefaultKingdeeTreeNode measureNode = this.editor.createNode(50, this.measureLabel(measure), measure.getName(), this.editor.iconMeasure, cube.getFact().getMeasures()[i]);
            this.editor.tree.addNodeInto((MutableTreeNode)measureNode, (MutableTreeNode)measureFolderNode);
        }
        DefaultKingdeeTreeNode dimFolderNode = this.editor.createNode(60, CubeModelResource.getString(CubeModelResource.class, (String)"Dimension"), null, null, null);
        this.editor.tree.addNodeInto((MutableTreeNode)dimFolderNode, (MutableTreeNode)cubeNode);
        DefaultKingdeeTreeNode joinFolderNode = this.editor.createNode(100, CubeModelResource.getString(CubeModelResource.class, (String)"Join"), null, null, null);
        this.editor.tree.addNodeInto((MutableTreeNode)joinFolderNode, (MutableTreeNode)cubeNode);
        this.editor.tree.setSelectionNode(cubeNode);
        this.editor.tree.expandAllNodes(true, (TreeNode)cubeNode);
    }

    CubeModel_Cube makeCube(WizardContext context) {
        CubeModel_Cube cube = new CubeModel_Cube();
        HashMap<String, Integer> mapRefCount = new HashMap<String, Integer>();
        this.editor.mapCubeToMapRefCount.put(cube, mapRefCount);
        cube.setName((String)context.get("CubeName"));
        cube.setAlias((String)context.get("CubeAlias"));
        Table table = (Table)context.get("FactTable");
        CubeModel_Table factTableModel = new CubeModel_Table();
        factTableModel.setName(table.getName());
        factTableModel.setAlias(table.getAlias());
        cube.setTables(new CubeModel_Table[]{factTableModel});
        mapRefCount.put(this.editor.tableKey(table.getName()), new Integer(1));
        WizardContext.MeasureInfo measureInfo = (WizardContext.MeasureInfo)context.get("MeasureInfo");
        WizardContext.AMeasure[] measures = measureInfo.measures;
        CubeModel_Measure[] measureModels = new CubeModel_Measure[measures.length];
        for (int i = 0; i < measures.length; ++i) {
            measureModels[i] = new CubeModel_Measure();
            measureModels[i].setName(measures[i].name);
            measureModels[i].setAlias(measures[i].alias);
            OlapRpt_MeasureFormat format = new OlapRpt_MeasureFormat();
            format.setFormatString(measures[i].format);
            measureModels[i].setFormat(format);
            CubeModel_Aggregation agg = new CubeModel_Aggregation();
            agg.setFunction(measures[i].agg);
            measureModels[i].setAgg(agg);
            CubeModel_Expression exp = new CubeModel_Expression();
            CubeModel_Column column = new CubeModel_Column();
            column.setTable(table.getName());
            column.setName(measures[i].column.getName());
            column.setAlias(table.getAlias() + "." + measures[i].column.getName());
            exp.setColumns(new CubeModel_Column[]{column});
            measureModels[i].setExp(exp);
        }
        CubeModel_Fact fact = new CubeModel_Fact();
        fact.setName(cube.getName());
        fact.setMeasures(measureModels);
        CubeModel_TableRef tableRef = new CubeModel_TableRef();
        tableRef.setName(table.getName());
        fact.setTableRef(tableRef);
        cube.setFact(fact);
        return cube;
    }

    public boolean doCreateDimensionWizard() {
        if (this.setName.size() > 7) {
            WindowUtil.alert((Component)this.editor.getWindow(), (String)(CubeModelResource.getString(CubeModelResource.class, (String)"MaxDimCount") + "8" + CubeModelResource.getString(CubeModelResource.class, (String)"Ge")));
            return false;
        }
        DefaultKingdeeTreeNode cubeNode = this.editor.getSelectedCubeNode();
        if (cubeNode == null) {
            return false;
        }
        NodeData cubeData = (NodeData)cubeNode.getUserObject();
        CubeModel_Cube cube = (CubeModel_Cube)cubeData.model;
        WizardContext context = new WizardContext();
        context.put("DataProvider", this.editor.dataProvider);
        WizardDialog wd = this.newWizardDialog();
        wd.setTitle(CubeModelResource.getString(CubeModelResource.class, (String)"DimensionWizard"));
        ArrayList<Dim_SelectCreateType> list = new ArrayList<Dim_SelectCreateType>(5);
        list.add(new Dim_SelectCreateType(context));
        if (this.factTable == null) {
            try {
                this.factTable = this.editor.dataProvider.queryTableModel(cube.getFact().getTableRef().getName());
            }
            catch (AnalysisException e) {
                WindowUtil.alert((Component)this.editor.getWindow(), (String)e.getMessage());
                return false;
            }
        }
        context.put("FactTable", this.factTable);
        context.put("SetName", this.setName);
        context.put("SetAlias", this.setAlias);
        wd.setStepsList(list);
        wd.show();
        if (context.get("Finish") != null) {
            CubeModel_Dimension dimension = this.makeDimension(context, cube);
            if (cube.getDimensions() == null) {
                cube.setDimensions(new CubeModel_Dimension[]{dimension});
            } else {
                CubeModel_Dimension[] dimensions2 = new CubeModel_Dimension[cube.getDimensions().length + 1];
                System.arraycopy(cube.getDimensions(), 0, dimensions2, 0, dimensions2.length - 1);
                dimensions2[dimensions2.length - 1] = dimension;
                cube.setDimensions(dimensions2);
            }
            this.addDimensionNode(cube, dimension);
            if (dimension.getFactJoinRef() != null) {
                this.editor.diagramHelper.addDimensionTableForCube(cube, dimension, (Table)context.get("DimensionTable"));
            }
            return true;
        }
        return false;
    }

    String measureLabel(CubeModel_Measure measure) {
        String func = measure.getAgg().getFunction();
        return measure.getAlias() + "(" + Names.AggTypes.getTypeLabel(Locale.getDefault(), func) + ")";
    }

    String dimensionLabel(CubeModel_Dimension dimension) {
        if (dimension.isTime()) {
            return dimension.getAlias() + "(" + CubeModelResource.getString(CubeModelResource.class, (String)"TimeDimension") + ")";
        }
        if (dimension.isParentChild()) {
            return dimension.getAlias() + "(" + CubeModelResource.getString(CubeModelResource.class, (String)"PCDimension") + ")";
        }
        return dimension.getAlias() + "(" + CubeModelResource.getString(CubeModelResource.class, (String)"StandardDimension") + ")";
    }

    void addDimensionNode(CubeModel_Cube cube, CubeModel_Dimension dimension) {
        this.setName.add(dimension.getName());
        this.setAlias.add(dimension.getAlias());
        DefaultKingdeeTreeNode dimensionFolderNode = this.editor.getSelectedDimensionFolderNode();
        DefaultKingdeeTreeNode dimNode = this.editor.createNode(70, this.dimensionLabel(dimension), null, this.editor.iconDimension, dimension);
        this.editor.tree.addNodeInto((MutableTreeNode)dimNode, (MutableTreeNode)dimensionFolderNode);
        DefaultKingdeeTreeNode tableFolderNode = this.editor.createNode(30, CubeModelResource.getString(CubeModelResource.class, (String)"Table"), null, null, null);
        this.editor.tree.addNodeInto((MutableTreeNode)tableFolderNode, (MutableTreeNode)dimNode);
        CubeModel_TableRef[] tableRefs = dimension.getTableRefs();
        for (int i = 0; i < tableRefs.length; ++i) {
            CubeModel_Table table = this.editor.findTable(cube, tableRefs[i].getName());
            DefaultKingdeeTreeNode tableNode = this.editor.createNode(35, table.getAlias(), table.getName(), this.editor.iconTable, null);
            this.editor.tree.addNodeInto((MutableTreeNode)tableNode, (MutableTreeNode)tableFolderNode);
        }
        DefaultKingdeeTreeNode levelFolderNode = this.editor.createNode(40, CubeModelResource.getString(CubeModelResource.class, (String)"Level"), null, null, null);
        this.editor.tree.addNodeInto((MutableTreeNode)levelFolderNode, (MutableTreeNode)dimNode);
        CubeModel_Hierarchy hie = dimension.getHierarchys()[0];
        if (dimension.isTime()) {
            String type = Names.TimeHierarchyTypes.getTypeLabel(Locale.getDefault(), hie.getType());
            String[] levels = Names.TimeHierarchyTypes.split(type);
            String timeColumn = dimension.getTimeColumn().getAlias();
            for (int i = 0; i < levels.length; ++i) {
                DefaultKingdeeTreeNode levelNode = this.editor.createNode(90, levels[i] + "(" + timeColumn + ")", null, this.editor.iconLevel, null);
                this.editor.tree.addNodeInto((MutableTreeNode)levelNode, (MutableTreeNode)levelFolderNode);
            }
        } else if (dimension.isParentChild()) {
            DefaultKingdeeTreeNode levelNode = this.editor.createNode(90, hie.getMemberKey().toString() + "," + hie.getParentKey().toString(), null, this.editor.iconLevel, null);
            this.editor.tree.addNodeInto((MutableTreeNode)levelNode, (MutableTreeNode)levelFolderNode);
        } else {
            CubeModel_Level[] levels = hie.getLevels();
            for (int i = 0; i < levels.length; ++i) {
                DefaultKingdeeTreeNode levelNode = this.editor.createNode(90, levels[i].getAlias() + "(" + levels[i].getMemberKey().toString() + ")", null, this.editor.iconLevel, levels[i]);
                this.editor.tree.addNodeInto((MutableTreeNode)levelNode, (MutableTreeNode)levelFolderNode);
            }
        }
        if (dimension.getFactJoinRef() != null) {
            CubeModel_Join join = this.editor.findJoin(cube, dimension.getFactJoinRef().getName());
            DefaultKingdeeTreeNode joinFolderNode = this.editor.getSelectedJoinFolderNode();
            Enumeration children = joinFolderNode.children();
            boolean found = false;
            while (children.hasMoreElements()) {
                NodeData childData = (NodeData)((DefaultKingdeeTreeNode)children.nextElement()).getUserObject();
                if (!childData.id.equals(join.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                DefaultKingdeeTreeNode joinNode = this.editor.createNode(110, join.getAlias(), join.getName(), this.editor.iconJoin, join);
                this.editor.tree.addNodeInto((MutableTreeNode)joinNode, (MutableTreeNode)joinFolderNode);
            }
        }
        this.editor.tree.setSelectionNode(dimNode);
        this.editor.tree.expandAllNodes(true, (TreeNode)dimNode);
    }

    CubeModel_Dimension makeDimension(WizardContext context, CubeModel_Cube cube) {
        CubeModel_Dimension dimension;
        block14: {
            CubeModel_Hierarchy hie;
            Table dimTable;
            block15: {
                block13: {
                    HashMap mapRefCount = (HashMap)this.editor.mapCubeToMapRefCount.get(cube);
                    dimension = new CubeModel_Dimension();
                    dimension.setName((String)context.get("DimensionName"));
                    dimension.setAlias((String)context.get("DimensionAlias"));
                    dimTable = (Table)context.get("DimensionTable");
                    CubeModel_Table dimTableModel = new CubeModel_Table();
                    dimTableModel.setName(dimTable.getName());
                    dimTableModel.setAlias(dimTable.getAlias());
                    Integer count = (Integer)mapRefCount.get(this.editor.tableKey(dimTable.getName()));
                    if (count == null) {
                        CubeModel_Table[] tables = cube.getTables();
                        CubeModel_Table[] tables2 = new CubeModel_Table[tables.length + 1];
                        System.arraycopy(tables, 0, tables2, 0, tables.length);
                        tables2[tables.length] = dimTableModel;
                        cube.setTables(tables2);
                        mapRefCount.put(this.editor.tableKey(dimTable.getName()), new Integer(1));
                    } else {
                        mapRefCount.put(this.editor.tableKey(dimTable.getName()), new Integer(count + 1));
                    }
                    CubeModel_TableRef tableRef = new CubeModel_TableRef();
                    tableRef.setName(dimTable.getName());
                    dimension.setTableRefs(new CubeModel_TableRef[]{tableRef});
                    WizardContext.DimensionFactJoinInfo dfjinfo = (WizardContext.DimensionFactJoinInfo)context.get("DimensionFactJoinInfo");
                    if (dfjinfo != null) {
                        CubeModel_Join join = new CubeModel_Join(this.editor.findTable(cube, dimTable.getName()), this.editor.findTable(cube, cube.getFact().getTableRef().getName()), dfjinfo.dimensionColumn.getName(), dfjinfo.factColumn.getName());
                        CubeModel_Join[] joins = cube.getJoins();
                        if (joins == null) {
                            cube.setJoins(new CubeModel_Join[]{join});
                            mapRefCount.put(this.editor.joinKey(join.getName()), new Integer(1));
                        } else {
                            count = (Integer)mapRefCount.get(this.editor.joinKey(join.getName()));
                            if (count == null) {
                                CubeModel_Join[] joins2 = new CubeModel_Join[joins.length + 1];
                                System.arraycopy(joins, 0, joins2, 0, joins.length);
                                joins2[joins.length] = join;
                                cube.setJoins(joins2);
                                mapRefCount.put(this.editor.joinKey(join.getName()), new Integer(1));
                            } else {
                                mapRefCount.put(this.editor.joinKey(join.getName()), new Integer(count + 1));
                            }
                        }
                        CubeModel_FactJoinRef factJoinRef = new CubeModel_FactJoinRef();
                        factJoinRef.setName(join.getName());
                        dimension.setFactJoinRef(factJoinRef);
                    }
                    String type = (String)context.get("DimensionType");
                    dimension.setType(type);
                    hie = new CubeModel_Hierarchy();
                    hie.setHasAll((Boolean)context.get("HasAll"));
                    if (hie.isHasAll()) {
                        hie.setAllMemberName((String)context.get("AllMemberName"));
                        hie.setAllMemberCaption((String)context.get("AllMemberCaption"));
                    }
                    dimension.setHierarchys(new CubeModel_Hierarchy[]{hie});
                    if (!dimension.isTime()) break block13;
                    WizardContext.TimeInfo timeInfo = (WizardContext.TimeInfo)context.get("TimeInfo");
                    CubeModel_Column timeColumn = new CubeModel_Column();
                    timeColumn.setTable(dimTable.getName());
                    timeColumn.setName(timeInfo.timeColumn.getName());
                    timeColumn.setAlias(dimTable.getAlias() + "." + timeInfo.timeColumn.getName());
                    dimension.setTimeColumn(timeColumn);
                    hie.setType(timeInfo.hieType);
                    break block14;
                }
                if (!dimension.isParentChild()) break block15;
                WizardContext.ParentChildInfo pcInfo = (WizardContext.ParentChildInfo)context.get("ParentChildInfo");
                CubeModel_MemberKey memberKey = new CubeModel_MemberKey();
                CubeModel_Expression exp = new CubeModel_Expression();
                CubeModel_Column column = new CubeModel_Column();
                column.setName(pcInfo.keyColumn.getName());
                column.setTable(dimTable.getName());
                column.setAlias(dimTable.getAlias() + "." + pcInfo.keyColumn.getName());
                exp.setColumns(new CubeModel_Column[]{column});
                memberKey.setExp(exp);
                hie.setMemberKey(memberKey);
                CubeModel_MemberName memberName = new CubeModel_MemberName();
                exp = new CubeModel_Expression();
                column = new CubeModel_Column();
                column.setName(pcInfo.nameColumn.getName());
                column.setTable(dimTable.getName());
                column.setAlias(dimTable.getAlias() + "." + pcInfo.nameColumn.getName());
                exp.setColumns(new CubeModel_Column[]{column});
                memberName.setExp(exp);
                hie.setMemberName(memberName);
                CubeModel_MemberAlias memberAlias = new CubeModel_MemberAlias();
                exp = new CubeModel_Expression();
                column = new CubeModel_Column();
                column.setName(pcInfo.aliasColumn.getName());
                column.setTable(dimTable.getName());
                column.setAlias(dimTable.getAlias() + "." + pcInfo.aliasColumn.getName());
                exp.setColumns(new CubeModel_Column[]{column});
                memberAlias.setExp(exp);
                hie.setMemberAlias(memberAlias);
                CubeModel_ParentKey parentKey = new CubeModel_ParentKey();
                exp = new CubeModel_Expression();
                column = new CubeModel_Column();
                column.setName(pcInfo.parentKeyColumn.getName());
                column.setTable(dimTable.getName());
                column.setAlias(dimTable.getAlias() + "." + pcInfo.parentKeyColumn.getName());
                exp.setColumns(new CubeModel_Column[]{column});
                parentKey.setExp(exp);
                hie.setParentKey(parentKey);
                if (pcInfo.childKeyColumn != null) {
                    CubeModel_ChildKey childKey = new CubeModel_ChildKey();
                    exp = new CubeModel_Expression();
                    column = new CubeModel_Column();
                    column.setName(pcInfo.childKeyColumn.getName());
                    column.setTable(dimTable.getName());
                    column.setAlias(dimTable.getAlias() + "." + pcInfo.childKeyColumn.getName());
                    exp.setColumns(new CubeModel_Column[]{column});
                    childKey.setExp(exp);
                    hie.setChildKey(childKey);
                }
                if (pcInfo.parentMemberRule != null) {
                    CubeModel_Rule rule = new CubeModel_Rule();
                    rule.setName(pcInfo.parentMemberRule);
                    hie.setRule(rule);
                }
                hie.setOrderBy(pcInfo.orderBy);
                hie.setOrderMethod(pcInfo.orderMethod);
                if (pcInfo.getPropertyCount() <= 0) break block14;
                int n = pcInfo.getPropertyCount();
                for (int i = 0; i < n; ++i) {
                    WizardContext.PropertyInfo pi = pcInfo.getPropertyInfo(i);
                    CubeModel_Property cp = new CubeModel_Property();
                    cp.setName(pi.name);
                    cp.setCaption(pi.caption);
                    cp.setColumn(pi.column);
                    hie.addProperty(cp);
                }
                break block14;
            }
            WizardContext.LevelInfo levelInfo = (WizardContext.LevelInfo)context.get("LevelInfo");
            CubeModel_Level[] levels = new CubeModel_Level[levelInfo.levels.length];
            hie.setLevels(levels);
            for (int i = 0; i < levels.length; ++i) {
                levels[i] = new CubeModel_Level();
                levels[i].setName(levelInfo.levels[i].name);
                levels[i].setAlias(levelInfo.levels[i].alias);
                levels[i].setOrderBy(levelInfo.levels[i].orderBy);
                levels[i].setOrderMethod(levelInfo.levels[i].orderMethod);
                CubeModel_MemberKey memberKey = new CubeModel_MemberKey();
                CubeModel_Expression exp = new CubeModel_Expression();
                CubeModel_Column column = new CubeModel_Column();
                column.setName(levelInfo.levels[i].columnKey.getName());
                column.setTable(dimTable.getName());
                column.setAlias(dimTable.getAlias() + "." + levelInfo.levels[i].columnKey.getName());
                exp.setColumns(new CubeModel_Column[]{column});
                memberKey.setExp(exp);
                CubeModel_MemberName memberName = new CubeModel_MemberName();
                exp = new CubeModel_Expression();
                column = new CubeModel_Column();
                column.setName(levelInfo.levels[i].columnName.getName());
                column.setTable(dimTable.getName());
                column.setAlias(dimTable.getAlias() + "." + levelInfo.levels[i].columnName.getName());
                exp.setColumns(new CubeModel_Column[]{column});
                memberName.setExp(exp);
                CubeModel_MemberAlias memberAlias = new CubeModel_MemberAlias();
                exp = new CubeModel_Expression();
                column = new CubeModel_Column();
                column.setName(levelInfo.levels[i].columnAlias.getName());
                column.setTable(dimTable.getName());
                column.setAlias(dimTable.getAlias() + "." + levelInfo.levels[i].columnAlias.getName());
                exp.setColumns(new CubeModel_Column[]{column});
                memberAlias.setExp(exp);
                levels[i].setMemberKey(memberKey);
                levels[i].setMemberName(memberName);
                levels[i].setMemberAlias(memberAlias);
                if (levelInfo.levels[i].getPropertyCount() <= 0) continue;
                int n = levelInfo.levels[i].getPropertyCount();
                for (int j = 0; j < n; ++j) {
                    WizardContext.PropertyInfo pi = levelInfo.levels[i].getPropertyInfo(j);
                    CubeModel_Property cp = new CubeModel_Property();
                    cp.setName(pi.name);
                    cp.setCaption(pi.caption);
                    cp.setColumn(pi.column);
                    levels[i].addProperty(cp);
                }
            }
        }
        return dimension;
    }

    void deleteDimension(CubeModel_Dimension dim) {
        this.setName.remove(dim.getName());
        this.setAlias.remove(dim.getAlias());
    }

    void deleteCube() {
        this.setName.clear();
        this.setAlias.clear();
        this.factTable = null;
    }
}

