/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olap;

import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.MdxQuery;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.base.DrillExpandPositionBase;
import com.kingdee.bos.ctrl.analysis.olap.base.DrillReplaceBase;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_AxisMembersHelper;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_ChangeSlicer;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Filter;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_MdxQuery;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_MemberTree;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Model;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_NonEmpty;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_SortRank;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_SwapAxes;
import com.kingdee.bos.olap.Connection;

public class ModelFactory {
    public static KDOLAP_Model createKDModel() {
        KDOLAP_Model model = new KDOLAP_Model();
        model.addExtension(new DrillExpandPositionBase());
        model.addExtension(new DrillReplaceBase());
        model.addExtension(new KDOLAP_SwapAxes());
        model.addExtension(new KDOLAP_MemberTree());
        model.addExtension(new KDOLAP_NonEmpty());
        model.addExtension(new KDOLAP_MdxQuery());
        model.addExtension(new KDOLAP_Filter());
        model.addExtension(new KDOLAP_SortRank());
        model.addExtension(new KDOLAP_AxisMembersHelper());
        model.addExtension(new KDOLAP_ChangeSlicer());
        return model;
    }

    public static OlapModel makeDefaultKDOlapModel(Connection con) throws OlapException {
        return ModelFactory.makeDefaultKDOlapModel(con, con.getDefaultCubeName());
    }

    public static OlapModel makeDefaultKDOlapModel(Connection con, String cube) throws OlapException {
        KDOLAP_Model model = ModelFactory.createKDModel();
        model.setConnection(con);
        model.setCurrentCubeName(cube);
        model.initialize();
        Dimension dim = model.getDimensions()[0];
        if (dim.isMeasure()) {
            dim = model.getDimensions()[1];
        }
        StringBuffer sb = new StringBuffer("select {[Measures].members");
        sb.append("} on columns,{").append(dim.getUniqueName()).append(".levels(0).members} on rows from [").append(cube).append("]");
        MdxQuery mdxQuery = (MdxQuery)model.getExtension("mdxQuery");
        mdxQuery.setMdxQuery(sb.toString());
        return model;
    }

    public static OlapModel makeKDOlapModel(Connection con, String mdx) throws OlapException {
        KDOLAP_Model model = ModelFactory.createKDModel();
        model.setConnection(con);
        model.setMdxQuery(mdx);
        model.initialize();
        return model;
    }
}

