/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olap.base;

import com.kingdee.bos.ctrl.analysis.modelcore.ExtensionSupport;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelSupport;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.olap.SortRank;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.QueryAxisChangeListener;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.QueryAxisManager;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import org.apache.log4j.Logger;

public abstract class SortRankBase
extends ExtensionSupport
implements SortRank,
QueryAxisChangeListener {
    protected int topBottomCount = 10;
    protected double topBottomValue = 10.0;
    protected int sortMode = 1;
    protected boolean sorting = false;
    protected Position sortPosition = null;
    protected QueryAxisManager qamToSort = null;
    static Logger logger = CommonLogger.getLogger(SortRankBase.class);

    public SortRankBase() {
        super.setId("sortRank");
    }

    @Override
    public void queryAxisChanged(QueryAxisManager qam, Object source, boolean changedByNavi) {
        if (qam != this.qamToSort) {
            return;
        }
        if (!changedByNavi) {
            return;
        }
        if (!this.sorting) {
            return;
        }
        this.sorting = false;
        ModelSupport model = (ModelSupport)this.getModel();
        model.fireModelChanged();
    }

    @Override
    public int getTopBottomCount() {
        return this.topBottomCount;
    }

    @Override
    public double getTopBottomValue() {
        return this.topBottomValue;
    }

    @Override
    public void setTopBottomCount(int topBottomCount) {
        if (this.topBottomCount == topBottomCount) {
            return;
        }
        this.topBottomCount = topBottomCount;
        if (this.sorting && this.sortPosition != null && (this.sortMode == 5 || this.sortMode == 6)) {
            ((ModelSupport)this.getModel()).fireModelChanged();
        }
    }

    @Override
    public void setTopBottomValue(double topBottomValue) {
        if (this.topBottomValue == topBottomValue) {
            return;
        }
        this.topBottomValue = topBottomValue;
        if (this.sorting && this.sortPosition != null && (this.sortMode == 7 || this.sortMode == 8 || this.sortMode == 9 || this.sortMode == 10)) {
            ((ModelSupport)this.getModel()).fireModelChanged();
        }
    }

    @Override
    public int getSortMode() {
        return this.sortMode;
    }

    @Override
    public void setSortMode(int sortMode) {
        if (this.sortMode == sortMode) {
            return;
        }
        this.sortMode = sortMode;
        if (this.sorting && this.sortPosition != null) {
            ((ModelSupport)this.getModel()).fireModelChanged();
        }
    }

    private boolean compareMembers(Member[] aMem1, Member[] aMem2) {
        if (aMem1.length != aMem2.length) {
            return false;
        }
        for (int i = 0; i < aMem1.length; ++i) {
            if (aMem1[i] == null) {
                return false;
            }
            if (aMem1[i].equals(aMem2[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isCurrentSorting(Position position) {
        if (!this.sorting || this.sortPosition == null) {
            return false;
        }
        return this.compareMembers(this.sortPosition.getMembers(), position.getMembers());
    }

    public boolean isSortable(Position position) {
        Member[] members = position.getMembers();
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].getLevel().getHierarchy().getDimension().isMeasure()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSorting() {
        return this.sorting;
    }

    @Override
    public void setSorting(boolean sorting) {
        if (sorting == this.sorting) {
            return;
        }
        this.sorting = sorting;
        ((ModelSupport)this.getModel()).fireModelChanged();
    }

    public void reset() {
        this.topBottomCount = 10;
        this.topBottomValue = 10.0;
        this.sortMode = 1;
        this.sorting = false;
        this.sortPosition = null;
        OlapModel model = (OlapModel)this.getModel();
        QueryAxisManager[] qames = model.getQueryManager().getQueryAxisManageres();
        for (int i = 0; i < qames.length; ++i) {
            qames[i].addChangeListener(this);
        }
    }

    public abstract void addSortToQuery();

    public int getQuaxToSort() {
        return this.qamToSort.getOrdinal();
    }

    public int activeQueryAxisToSort() {
        if (this.sorting && this.sortPosition != null) {
            return this.qamToSort.getOrdinal();
        }
        return -1;
    }

    @Override
    public void setAxisToSort(int ordinal) {
        OlapModel model = (OlapModel)this.getModel();
        this.qamToSort = model.getQueryManager().getQueryAxisManageres()[ordinal];
    }

    public boolean isSortOnQuery() {
        return this.sorting && this.sortPosition != null;
    }

    @Override
    public Position getSortPosition() {
        return this.sortPosition;
    }

    @Override
    public void setSortPosition(Position sortPosition) {
        this.sortPosition = sortPosition;
    }
}

