/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap;

import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.DimensionProperty;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_DimensionProperty;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Hierarchy;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Model;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Position;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_QueryManager;
import com.kingdee.bos.ctrl.analysis.util.Visitor;
import com.kingdee.bos.olap.mdx.MdxAxis;
import com.kingdee.bos.olap.mdx.MdxMember;
import com.kingdee.bos.olap.mdx.MdxPosition;
import com.kingdee.bos.olap.mdx.QueryAxis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KDOLAP_Axis
implements Axis {
    private MdxAxis kdAxis = null;
    private KDOLAP_Model model = null;
    private ArrayList aPositions = null;
    private KDOLAP_Hierarchy[] hierarchies = null;
    private int ordinal;
    private String name;

    public KDOLAP_Axis(int iOrdinal, MdxAxis kdAxis, KDOLAP_Model model) throws OlapException {
        this.ordinal = iOrdinal;
        this.name = kdAxis.name;
        this.kdAxis = kdAxis;
        this.model = model;
        this.aPositions = new ArrayList();
        if (iOrdinal >= 0) {
            KDOLAP_QueryManager queryManager = (KDOLAP_QueryManager)model.getQueryManager();
            com.kingdee.bos.olap.Hierarchy[] kdHiers = queryManager.getKDQuery().getMdxHierarchiesOnAxis(iOrdinal);
            this.hierarchies = new KDOLAP_Hierarchy[kdHiers.length];
            for (int j = 0; j < this.hierarchies.length; ++j) {
                this.hierarchies[j] = (KDOLAP_Hierarchy)model.lookupHierarchy(kdHiers[j].getUniqueName());
            }
        }
        MdxPosition[] kdPositions = kdAxis.positions();
        for (int i = 0; i < kdPositions.length; ++i) {
            KDOLAP_Position position = new KDOLAP_Position(kdPositions[i], iOrdinal, model);
            this.aPositions.add(position);
            if (iOrdinal != -1) continue;
            MdxMember[] kdMdxMembers = kdPositions[i].getMdxMembers();
            if (i != 0) continue;
            this.hierarchies = new KDOLAP_Hierarchy[kdMdxMembers.length];
            for (int j = 0; j < kdMdxMembers.length; ++j) {
                Member member = model.lookupMember(kdMdxMembers[j].getUniqueName());
                this.hierarchies[j] = (KDOLAP_Hierarchy)member.getHierarchy();
            }
        }
        if (iOrdinal == -1) {
            KDOLAP_QueryManager queryManager = (KDOLAP_QueryManager)model.getQueryManager();
            ArrayList<Hierarchy> listHiers = new ArrayList<Hierarchy>();
            listHiers.addAll(Arrays.asList(model.getHierarchies()));
            for (int i = queryManager.getQueryAxisManageres().length - 1; i >= 0; --i) {
                com.kingdee.bos.olap.Hierarchy[] kdHiers = queryManager.getKDQuery().getMdxHierarchiesOnAxis(i);
                block4: for (int j = 0; j < kdHiers.length; ++j) {
                    for (int k = 0; k < listHiers.size(); ++k) {
                        Hierarchy hie = (Hierarchy)listHiers.get(k);
                        if (!hie.getUniqueName().equals(kdHiers[j].getUniqueName())) continue;
                        listHiers.remove(hie);
                        continue block4;
                    }
                }
            }
            if (kdPositions.length > 0) {
                MdxPosition position = kdPositions[0];
                MdxMember[] kdMdxMembers = position.getMdxMembers();
                KDOLAP_Hierarchy[] hierarchies2 = new KDOLAP_Hierarchy[listHiers.size()];
                MdxMember[] kdMdxMembers2 = new MdxMember[listHiers.size()];
                for (int i = 0; i < listHiers.size(); ++i) {
                    Hierarchy hie = (Hierarchy)listHiers.get(i);
                    boolean found = false;
                    for (int j = 0; j < kdMdxMembers.length; ++j) {
                        Member member = model.lookupMember(kdMdxMembers[j].getUniqueName());
                        if (!hie.getUniqueName().equals(member.getHierarchy().getUniqueName())) continue;
                        hierarchies2[i] = this.hierarchies[j];
                        kdMdxMembers2[i] = kdMdxMembers[j];
                        found = true;
                        break;
                    }
                    if (found) continue;
                    hierarchies2[i] = (KDOLAP_Hierarchy)model.lookupHierarchy(hie.getUniqueName());
                    kdMdxMembers2[i] = new MdxMember(((KDOLAP_Hierarchy)hie).getKDHierarchy().getDefaultMember());
                }
                this.hierarchies = hierarchies2;
                this.aPositions.clear();
                this.aPositions.add(new KDOLAP_Position(new MdxPosition(kdMdxMembers2), iOrdinal, model));
            } else {
                KDOLAP_Hierarchy[] hierarchies2 = new KDOLAP_Hierarchy[listHiers.size()];
                com.kingdee.bos.olap.Member[] kdMembers2 = new com.kingdee.bos.olap.Member[listHiers.size()];
                for (int i = 0; i < listHiers.size(); ++i) {
                    Hierarchy hie = (Hierarchy)listHiers.get(i);
                    hierarchies2[i] = (KDOLAP_Hierarchy)model.lookupHierarchy(hie.getUniqueName());
                    kdMembers2[i] = ((KDOLAP_Hierarchy)hie).getKDHierarchy().getDefaultMember();
                }
                this.hierarchies = hierarchies2;
                this.aPositions.clear();
                this.aPositions.add(new KDOLAP_Position(new MdxPosition(kdMembers2), iOrdinal, model));
            }
        }
    }

    @Override
    public List getPositions() {
        return this.aPositions;
    }

    @Override
    public Hierarchy[] getHierarchies() {
        return this.hierarchies;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitAxis(this);
    }

    @Override
    public Object getRootDecoree() {
        return this;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DimensionProperty[] getDimensionProperties() {
        if (this.ordinal < 0) {
            return null;
        }
        KDOLAP_QueryManager queryManager = (KDOLAP_QueryManager)this.model.getQueryManager();
        QueryAxis queryAxis = queryManager.getKDQuery().getAxes()[this.ordinal];
        com.kingdee.bos.olap.mdx.DimensionProperty[] kdDimProps = queryAxis.getResolvedProps();
        if (kdDimProps == null) {
            return null;
        }
        DimensionProperty[] props = new DimensionProperty[kdDimProps.length];
        for (int i = 0; i < kdDimProps.length; ++i) {
            props[i] = new KDOLAP_DimensionProperty(this.model, kdDimProps[i]);
        }
        return props;
    }
}

