/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap;

import com.kingdee.bos.ctrl.analysis.modelcore.Extension;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeEvent;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeListener;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelSupport;
import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Level;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Result;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.QueryManager;
import com.kingdee.bos.ctrl.analysis.olapadapter.OlapAdapterResource;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Dimension;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Filter;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Hierarchy;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Level;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Member;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_QueryManager;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Result;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_RuntimeException;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_SortRank;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.CompoundId;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.Formula;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.Lexer;
import com.kingdee.bos.olap.mdx.Literal;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.MdxResult;
import com.kingdee.bos.olap.mdx.SchemaLookup;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.parser;
import com.kingdee.bos.olap.remoting.RemoteConnection;
import com.kingdee.bos.olap.util.Util;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;
import org.apache.log4j.Logger;

public class KDOLAP_Model
extends ModelSupport
implements OlapModel {
    static Logger logger = CommonLogger.getLogger(KDOLAP_Model.class);
    private Connection kdConnection = null;
    private String mdxQuery = null;
    private String currentMdx = null;
    private KDOLAP_Result result = null;
    private String currentCubeName;
    private HashMap hDimensions = new HashMap();
    private HashMap hHierarchies = new HashMap();
    private HashMap hLevels = new HashMap();
    private HashMap hMembers = new HashMap();
    private ArrayList aMeasures = new ArrayList();
    private KDOLAP_QueryManager queryManager = null;
    private boolean isInitialized = false;
    private String ID = null;

    @Override
    public String getID() {
        return this.ID;
    }

    @Override
    public void setID(String ID) {
        this.ID = ID;
    }

    public KDOLAP_Model() {
        this.addModelChangeListener(new ModelChangeListener(){

            @Override
            public void modelChanged(ModelChangeEvent e) {
                KDOLAP_Model.this.result = null;
            }
        });
    }

    @Override
    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    @Override
    public synchronized void setMdxResult(MdxResult mdxResult) throws OlapException {
        this.getResult(mdxResult);
    }

    @Override
    public synchronized Result getResult() throws OlapException {
        return this.getResult(null);
    }

    @Override
    public synchronized MdxResult getKDResult() {
        if (this.result != null) {
            return this.result.getKDResult();
        }
        return null;
    }

    private synchronized Result getResult(MdxResult mdxResult) throws OlapException {
        if (this.result != null) {
            return this.result;
        }
        if (!this.isInitialized) {
            throw new OlapException("Model not initialized");
        }
        this.queryManager.onExecute();
        MdxResult kdResult = null;
        try {
            long t1 = System.currentTimeMillis();
            this.queryManager.getKDQuery().resolve();
            kdResult = mdxResult == null ? (this.kdConnection instanceof RemoteConnection ? this.kdConnection.executeMdxQuery(this.queryManager.getKDQuery().toMdx()) : this.kdConnection.executeMdxQuery(this.queryManager.getKDQuery())) : mdxResult;
            long t2 = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("execute mdx query cost " + (t2 - t1) + " ms.return " + kdResult.getAxes()[1].positions.length + " rows and " + kdResult.getAxes()[0].positions.length + " columns."));
            }
        }
        catch (OLAPException ex) {
            throw new OlapException(ex);
        }
        this.result = new KDOLAP_Result(kdResult, this);
        this.queryManager.afterExecute(this.result);
        return this.result;
    }

    @Override
    public Result getResult(int rowStart, int rowEnd) throws OlapException {
        return null;
    }

    KDOLAP_Result currentResult() {
        return this.result;
    }

    @Override
    public Dimension[] getDimensions() {
        return this.hDimensions.values().toArray(new Dimension[0]);
    }

    public Dimension getDimension(String name) {
        return this.lookupDimension(name);
    }

    public Hierarchy[] getHierarchies() {
        return this.hHierarchies.values().toArray(new Hierarchy[0]);
    }

    @Override
    public Member[] getMeasures() {
        return this.aMeasures.toArray(new Member[0]);
    }

    public void setMdxQuery(String mdxQuery) {
        this.mdxQuery = mdxQuery;
        this.currentMdx = mdxQuery.replaceAll("\r", "");
        this.result = null;
        this.queryManager = null;
    }

    @Override
    public void initialize() throws OlapException {
        if (this.kdConnection == null) {
            String err = "KDOlap connection is null.";
            logger.error((Object)err);
            throw new OlapException(err);
        }
        if (this.mdxQuery == null) {
            if (this.currentCubeName == null) {
                String err = "Cube name is null.";
                logger.error((Object)err);
                throw new OlapException(err);
            }
            this.resetMetaData();
        } else {
            MdxQuery kdQuery = null;
            try {
                kdQuery = this.parseMDX();
            }
            catch (OlapException e) {
                String err = e.getMessage();
                logger.error((Object)err);
                throw new OlapException(err);
            }
            this.currentCubeName = kdQuery.getCubeName();
            this.resetMetaData();
            this.queryManager = new KDOLAP_QueryManager(this, kdQuery);
            this.resetExt();
        }
        this.isInitialized = true;
        Map extMap = this.getExtensions();
        Collection extensions = extMap.values();
        for (Extension extension : extensions) {
            extension.modelInitialized();
        }
    }

    @Override
    public Exp createFormulaExp(String expression) throws OlapException {
        parser fcp = new parser((Scanner)new Lexer((Reader)new StringReader(expression)));
        try {
            Symbol parse_tree = fcp.parse();
            if (!(parse_tree.value instanceof FunCall || parse_tree.value instanceof Literal || parse_tree.value instanceof CompoundId)) {
                throw new OlapException(OlapAdapterResource.getString(OlapAdapterResource.class, (String)"SyntaxError"));
            }
            Exp exp = (Exp)parse_tree.value;
            exp.resolve(this.queryManager.getKDQuery().createExpResolver());
            return exp;
        }
        catch (OlapException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OlapException(e);
        }
    }

    @Override
    public Exp createExp(String expression) throws OlapException {
        parser fcp = new parser((Scanner)new Lexer((Reader)new StringReader(expression)));
        try {
            Symbol parse_tree = fcp.parse();
            if (parse_tree == null || parse_tree.value == null) {
                return null;
            }
            Exp exp = (Exp)parse_tree.value;
            exp.resolve(this.queryManager.getKDQuery().createExpResolver());
            return exp;
        }
        catch (Exception e) {
            throw new OlapException(e);
        }
    }

    private MdxQuery parseMDX() throws OlapException {
        MdxQuery kdQuery = null;
        try {
            kdQuery = this.getConnection().parseQuery(this.mdxQuery);
        }
        catch (OLAPException ex) {
            Throwable rootCause = this.getRootCause(ex);
            throw new OlapException(rootCause.getMessage());
        }
        catch (Exception ex) {
            throw new OlapException(ex);
        }
        if (kdQuery == null) {
            throw new OlapException("unexpected parse failure");
        }
        return kdQuery;
    }

    private Throwable getRootCause(OLAPException ex) {
        Throwable rootCause = ex;
        for (Throwable cause = ex.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    private KDOLAP_Dimension addDimension(com.kingdee.bos.olap.Dimension kdDimension) {
        String uniqueName = kdDimension.getUniqueName();
        if (!this.hDimensions.containsKey(uniqueName)) {
            KDOLAP_Dimension dimension = new KDOLAP_Dimension(kdDimension, this);
            this.hDimensions.put(uniqueName, dimension);
            com.kingdee.bos.olap.Hierarchy[] kdHiers = kdDimension.getHierarchies();
            for (int i = 0; i < kdHiers.length; ++i) {
                this.addHierarchy(kdHiers[i], dimension);
            }
            return dimension;
        }
        return (KDOLAP_Dimension)this.hDimensions.get(uniqueName);
    }

    private KDOLAP_Hierarchy addHierarchy(com.kingdee.bos.olap.Hierarchy kdHierarchy, KDOLAP_Dimension dimension) {
        String uniqueName = kdHierarchy.getUniqueName();
        if (!this.hHierarchies.containsKey(uniqueName)) {
            KDOLAP_Hierarchy hierarchy = new KDOLAP_Hierarchy(kdHierarchy, dimension, this);
            this.hHierarchies.put(uniqueName, hierarchy);
            com.kingdee.bos.olap.Level[] kdLevels = kdHierarchy.getLevels();
            for (int i = 0; i < kdLevels.length; ++i) {
                this.addLevel(kdLevels[i], hierarchy);
            }
            return hierarchy;
        }
        return (KDOLAP_Hierarchy)this.hHierarchies.get(uniqueName);
    }

    protected void addLevel(com.kingdee.bos.olap.Level kdLevel, KDOLAP_Hierarchy hierarchy) {
        String uniqueName = kdLevel.getUniqueName();
        if (!this.hLevels.containsKey(uniqueName)) {
            KDOLAP_Level level = new KDOLAP_Level(kdLevel, hierarchy, this);
            this.hLevels.put(uniqueName, level);
            if (kdLevel.getChildLevel() != null) {
                this.addLevel(kdLevel.getChildLevel(), hierarchy);
            }
        }
    }

    public KDOLAP_Member addMember(com.kingdee.bos.olap.Member kdMember) {
        String uniqueName = kdMember.getUniqueName();
        if (this.hMembers.containsKey(uniqueName)) {
            return (KDOLAP_Member)this.hMembers.get(uniqueName);
        }
        com.kingdee.bos.olap.Level kdLevel = kdMember.getLevel();
        KDOLAP_Level level = (KDOLAP_Level)this.lookupLevel(kdLevel.getUniqueName());
        KDOLAP_Member member = new KDOLAP_Member(kdMember, level, this);
        this.hMembers.put(uniqueName, member);
        if (kdMember.isMeasure()) {
            this.aMeasures.add(member);
        }
        return member;
    }

    public KDOLAP_Member addMember(String uniqueName) throws OlapException {
        if (this.hMembers.containsKey(uniqueName)) {
            return (KDOLAP_Member)this.hMembers.get(uniqueName);
        }
        return (KDOLAP_Member)this.lookupMember(uniqueName);
    }

    @Override
    public Dimension lookupDimension(String uniqueName) {
        KDOLAP_Dimension dim = (KDOLAP_Dimension)this.hDimensions.get(uniqueName);
        if (dim != null) {
            return dim;
        }
        SchemaReader scr = this.getConnection().getSchemaReader();
        try {
            String[] uniqueNameParts = Util.explode((String)uniqueName);
            Cube cube = this.queryManager.getKDQuery().getCube();
            com.kingdee.bos.olap.Dimension kdDim = (com.kingdee.bos.olap.Dimension)SchemaLookup.lookupCompound((SchemaReader)scr, (OLAPElement)cube, (String[])uniqueNameParts, (int)2);
            if (kdDim != null) {
                return (Dimension)this.hDimensions.get(kdDim.getUniqueName());
            }
        }
        catch (OLAPException e) {
            logger.debug((Object)("can't find dimension " + uniqueName), (Throwable)e);
            return null;
        }
        return null;
    }

    @Override
    public Hierarchy lookupHierarchy(String uniqueName) {
        KDOLAP_Hierarchy hie = (KDOLAP_Hierarchy)this.hHierarchies.get(uniqueName);
        if (hie != null) {
            return hie;
        }
        SchemaReader scr = this.getConnection().getSchemaReader();
        try {
            String[] uniqueNameParts = Util.explode((String)uniqueName);
            Cube cube = this.queryManager.getKDQuery().getCube();
            com.kingdee.bos.olap.Hierarchy kdHie = (com.kingdee.bos.olap.Hierarchy)SchemaLookup.lookupCompound((SchemaReader)scr, (OLAPElement)cube, (String[])uniqueNameParts, (int)3);
            if (kdHie != null) {
                return (Hierarchy)this.hHierarchies.get(kdHie.getUniqueName());
            }
        }
        catch (OLAPException e) {
            logger.debug((Object)("can't find hierarchy " + uniqueName), (Throwable)e);
            return null;
        }
        return null;
    }

    @Override
    public Level lookupLevel(String uniqueName) {
        KDOLAP_Level level = (KDOLAP_Level)this.hLevels.get(uniqueName);
        if (level != null) {
            return level;
        }
        SchemaReader scr = this.getConnection().getSchemaReader();
        try {
            String[] uniqueNameParts = Util.explode((String)uniqueName);
            Cube cube = this.queryManager.getKDQuery().getCube();
            com.kingdee.bos.olap.Level kdLevel = (com.kingdee.bos.olap.Level)SchemaLookup.lookupCompound((SchemaReader)scr, (OLAPElement)cube, (String[])uniqueNameParts, (int)4);
            if (kdLevel != null) {
                this.addLevel(kdLevel, (KDOLAP_Hierarchy)this.hHierarchies.get(kdLevel.getHierarchy().getUniqueName()));
                return (Level)this.hLevels.get(kdLevel.getUniqueName());
            }
        }
        catch (OLAPException e) {
            logger.debug((Object)("can't find level " + uniqueName), (Throwable)e);
            return null;
        }
        return null;
    }

    @Override
    public Member lookupMember(String uniqueName) {
        KDOLAP_Member m = (KDOLAP_Member)this.hMembers.get(uniqueName);
        if (m != null) {
            return m;
        }
        SchemaReader scr = this.getConnection().getSchemaReader();
        try {
            String[] uniqueNameParts = Util.explode((String)uniqueName);
            Cube cube = this.queryManager.getKDQuery().getCube();
            com.kingdee.bos.olap.Member kdMember = (com.kingdee.bos.olap.Member)SchemaLookup.lookupCompound((SchemaReader)scr, (OLAPElement)cube, (String[])uniqueNameParts, (int)6);
            if (kdMember != null) {
                return this.addMember(kdMember);
            }
            if (kdMember == null) {
                Formula[] formulas = this.queryManager.getKDQuery().getFormulas();
                for (int i = 0; i < formulas.length; ++i) {
                    kdMember = formulas[i].getMember();
                    if (kdMember == null || !uniqueName.equalsIgnoreCase(kdMember.getUniqueName())) continue;
                    return this.addMember(kdMember);
                }
            }
            if (uniqueName.startsWith("V$SLICERCOMPOMPOUNDMEMBER")) {
                // empty if block
            }
            if ((kdMember = this.queryManager.getKDQuery().getSlicerCompoundMember(uniqueName)) != null) {
                return this.addMember(kdMember);
            }
        }
        catch (OLAPException e) {
            logger.debug((Object)("can't find member " + uniqueName), (Throwable)e);
            return null;
        }
        return null;
    }

    @Override
    public Member[] getCalculatedMembers() {
        Formula[] formulas = this.queryManager.getKDQuery().getFormulas();
        if (formulas == null || formulas.length == 0) {
            return null;
        }
        ArrayList<KDOLAP_Member> list = new ArrayList<KDOLAP_Member>();
        for (int i = 0; i < formulas.length; ++i) {
            if (!formulas[i].isMember()) continue;
            com.kingdee.bos.olap.Member kdMember = formulas[i].getMember();
            list.add(this.addMember(kdMember));
        }
        return list.toArray(new Member[0]);
    }

    private void resetMetaData() {
        int i;
        this.hDimensions = new HashMap();
        this.hHierarchies = new HashMap();
        this.hLevels = new HashMap();
        this.hMembers = new HashMap();
        this.aMeasures = new ArrayList();
        SchemaReader sr = this.kdConnection.getSchemaReader();
        Cube cube = sr.getCube(this.currentCubeName);
        com.kingdee.bos.olap.Dimension[] kdDims = cube.getDimensions(true);
        for (int i2 = 0; i2 < kdDims.length; ++i2) {
            this.addDimension(kdDims[i2]);
        }
        com.kingdee.bos.olap.Member[] measures = cube.getMeasures();
        for (i = 0; i < measures.length; ++i) {
            this.addMember(measures[i]);
        }
        for (i = 0; i < kdDims.length; ++i) {
            com.kingdee.bos.olap.Hierarchy[] kdHiers = kdDims[i].getHierarchies();
            for (int j = 0; j < kdHiers.length; ++j) {
                com.kingdee.bos.olap.Member[] calcMembers = sr.getCalculatedMembers(cube, kdHiers[j]);
                if (calcMembers == null) continue;
                for (int k = 0; k < calcMembers.length; ++k) {
                    this.addMember(calcMembers[k]);
                }
            }
        }
    }

    protected Connection getConnection() {
        return this.kdConnection;
    }

    @Override
    public String getCurrentMdx() {
        if (this.result != null) {
            return this.currentMdx;
        }
        if (this.queryManager == null) {
            return this.mdxQuery;
        }
        try {
            this.getResult();
        }
        catch (Exception e) {
            logger.error((Object)("unexpected Exeption getResult " + e.toString()));
            throw new KDOLAP_RuntimeException(e);
        }
        return this.currentMdx;
    }

    boolean setUserMdx(String mdxQuery) throws OlapException {
        if (mdxQuery.equals(this.currentMdx)) {
            return false;
        }
        String saveMdx = this.mdxQuery;
        this.mdxQuery = mdxQuery;
        MdxQuery kdQuery = null;
        try {
            kdQuery = this.parseMDX();
        }
        catch (OlapException e) {
            this.mdxQuery = saveMdx;
            throw e;
        }
        String cubeName = kdQuery.getCubeName();
        if (!cubeName.equalsIgnoreCase(this.currentCubeName)) {
            this.currentCubeName = cubeName;
        }
        this.resetMetaData();
        this.queryManager = new KDOLAP_QueryManager(this, kdQuery);
        this.resetExt();
        this.result = null;
        this.currentMdx = mdxQuery;
        return true;
    }

    private void resetExt() {
        KDOLAP_SortRank sortExt;
        KDOLAP_Filter filterExt = (KDOLAP_Filter)this.getExtension("filter");
        if (filterExt != null) {
            filterExt.reset();
        }
        if ((sortExt = (KDOLAP_SortRank)this.getExtension("sortRank")) != null) {
            sortExt.reset();
        }
    }

    protected String getMdxQuery() {
        return this.mdxQuery;
    }

    public Object getRootDecoree() {
        return this;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.result = null;
        this.queryManager = null;
        this.hDimensions = null;
        this.hHierarchies = null;
        this.hLevels = null;
        this.hMembers = null;
    }

    protected void setCurrentMdx(String currentMdx) {
        this.currentMdx = currentMdx;
    }

    public void setConnection(Connection cn) {
        this.kdConnection = cn;
    }

    public void setCurrentCubeName(String currentCubeName) {
        this.currentCubeName = currentCubeName;
    }

    @Override
    public String getCubeName() {
        return this.currentCubeName;
    }
}

