/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap;

import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.SortRank;
import com.kingdee.bos.ctrl.analysis.olap.base.SortRankBase;
import com.kingdee.bos.ctrl.analysis.olap.querymanage.QueryAxisChangeListener;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Member;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Model;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_QueryManager;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.Literal;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.QueryAxis;
import com.kingdee.bos.olap.mdx.SortDirection;
import com.kingdee.bos.olap.mdx.Syntax;
import com.kingdee.bos.olap.mdx.elementexp.ExprUtil;
import org.apache.log4j.Logger;

public class KDOLAP_SortRank
extends SortRankBase
implements SortRank,
QueryAxisChangeListener {
    static Logger logger = CommonLogger.getLogger(KDOLAP_SortRank.class);

    public KDOLAP_SortRank() {
        super.setId("sortRank");
    }

    @Override
    public void addSortToQuery() {
        KDOLAP_Model model = (KDOLAP_Model)this.getModel();
        this.removeOrder(model);
        if (this.sorting && this.sortPosition != null) {
            switch (this.sortMode) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    int kdSortMode = KDOLAP_SortRank.sortMode2KD(this.sortMode);
                    this.orderAxis(model, kdSortMode);
                    break;
                }
                case 5: {
                    this.topBottomAxis(model, "TopCount");
                    break;
                }
                case 6: {
                    this.topBottomAxis(model, "BottomCount");
                    break;
                }
                case 7: {
                    this.topBottomAxis(model, "TopPercent");
                    break;
                }
                case 8: {
                    this.topBottomAxis(model, "BottomPercent");
                    break;
                }
                case 9: {
                    this.topBottomAxis(model, "TopSum");
                    break;
                }
                case 10: {
                    this.topBottomAxis(model, "BottomSum");
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private static int sortMode2KD(int sortMode) {
        switch (sortMode) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return -1;
    }

    private void removeOrder(OlapModel model) {
        KDOLAP_QueryManager queryManager = (KDOLAP_QueryManager)model.getQueryManager();
        MdxQuery kdQuery = ((KDOLAP_QueryManager)model.getQueryManager()).getKDQuery();
        QueryAxis[] kdAx = kdQuery.getAxes();
        for (int i = 0; i < 2; ++i) {
            FunCall f;
            Exp setForAx = kdAx[i].getExp();
            if (!(setForAx instanceof FunCall) || !(f = (FunCall)setForAx).isWrapSortOrFilter() || !"Order".equalsIgnoreCase(f.getFunName())) continue;
            kdAx[i].setExp(f.getArg(0));
        }
    }

    private void orderAxis(OlapModel model, int kdSortMode) {
        Exp kdToSort;
        KDOLAP_QueryManager queryManager = (KDOLAP_QueryManager)model.getQueryManager();
        MdxQuery kdQuery = ((KDOLAP_QueryManager)model.getQueryManager()).getKDQuery();
        int iAx = this.qamToSort.getOrdinal();
        QueryAxis kdAx = kdQuery.getAxes()[iAx];
        Exp setForAx = kdAx.getExp();
        if (this.sortPosition.getMembers().length == 1) {
            kdToSort = ExprUtil.toExp((OLAPElement)((KDOLAP_Member)this.sortPosition.getMembers()[0]).getKDMember());
        } else {
            Member[] kdMembers = new Member[this.sortPosition.getMembers().length];
            for (int i = 0; i < kdMembers.length; ++i) {
                kdMembers[i] = ((KDOLAP_Member)this.sortPosition.getMembers()[i]).getKDMember();
            }
            kdToSort = new FunCall("()", (Exp[])ExprUtil.toExp((Member[])kdMembers), Syntax.Parentheses);
        }
        String sDirection = SortDirection.instance().getName(kdSortMode);
        FunCall funOrder = new FunCall("Order", new Exp[]{setForAx, kdToSort, Literal.createSymbol((String)sDirection)});
        funOrder.setWrapSortOrFilter(true);
        kdAx.setExp((Exp)funOrder);
    }

    private void topBottomAxis(OlapModel model, String function) {
        Exp kdToSort;
        KDOLAP_QueryManager queryManager = (KDOLAP_QueryManager)model.getQueryManager();
        MdxQuery kdQuery = ((KDOLAP_QueryManager)model.getQueryManager()).getKDQuery();
        int iAx = this.qamToSort.getOrdinal();
        QueryAxis kdAx = kdQuery.getAxes()[iAx];
        Exp setForAx = kdAx.getExp();
        if (this.sortPosition.getMembers().length > 1) {
            Member[] kdMembers = new Member[this.sortPosition.getMembers().length];
            for (int i = 0; i < kdMembers.length; ++i) {
                kdMembers[i] = ((KDOLAP_Member)this.sortPosition.getMembers()[i]).getKDMember();
            }
            kdToSort = new FunCall("()", (Exp[])ExprUtil.toExp((Member[])kdMembers), Syntax.Parentheses);
        } else {
            kdToSort = ExprUtil.toExp((OLAPElement)((KDOLAP_Member)this.sortPosition.getMembers()[0]).getKDMember());
        }
        if (kdAx.isNonEmpty()) {
            setForAx = this.qamToSort.genExp(false);
        }
        if (setForAx == null) {
            return;
        }
        FunCall funOrder = null;
        if ("TopCount".equalsIgnoreCase(function) || "BottomCount".equalsIgnoreCase(function)) {
            funOrder = new FunCall(function, new Exp[]{setForAx, Literal.create((Integer)new Integer(this.topBottomCount)), kdToSort});
        } else if ("TopPercent".equalsIgnoreCase(function) || "BottomPercent".equalsIgnoreCase(function)) {
            funOrder = new FunCall(function, new Exp[]{setForAx, Literal.create((Double)new Double(this.topBottomValue)), kdToSort});
        } else if ("TopSum".equalsIgnoreCase(function) || "BottomSum".equalsIgnoreCase(function)) {
            funOrder = new FunCall(function, new Exp[]{setForAx, Literal.create((Double)new Double(this.topBottomValue)), kdToSort});
        }
        if (null != funOrder) {
            funOrder.setWrapSortOrFilter(true);
        }
        kdAx.setExp((Exp)funOrder);
    }
}

