/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.ui;

import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.AxisMembersHelper;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.report.ReportResource;
import com.kingdee.bos.ctrl.analysis.resource.Resources;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.TypicalDialogWithApply;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.olap.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;

public class AdjustColOrderDialog
extends TypicalDialogWithApply {
    private static final long serialVersionUID = 1L;
    private OlapModel olapModel = null;
    private Axis axis = null;
    private KDTable tblList = new KDTable();
    private KDContainer container = new KDContainer();
    private KDWorkButton btnUp = null;
    private KDWorkButton btnDown = null;
    private KDWorkButton btnDelete = null;
    private ButtonActionListener buttonActionListener = new ButtonActionListener();
    private static int DLG_WIDTH = 500;
    private static int DLG_HEIGHT = 400;

    public AdjustColOrderDialog() {
    }

    public AdjustColOrderDialog(Frame frame) {
        super(frame);
    }

    public AdjustColOrderDialog(Dialog owner) {
        super(owner);
    }

    public void setOlapModel(OlapModel olapModel) {
        try {
            this.olapModel = olapModel;
            this.btnApply.setEnabled(false);
            this.axis = OlapModelUtil.getTopAxis(olapModel);
            this.fillTblList();
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
    }

    public void apply() {
        if (this.axis == null || this.olapModel == null) {
            return;
        }
        AxisMembersHelper amh = (AxisMembersHelper)this.olapModel.getExtension("axisMembersHelper");
        if (amh == null) {
            return;
        }
        amh.setQueryAxis(this.axis, this.axis.getHierarchies(), this.getPostionArray());
        this.olapModel.postModelChanged();
    }

    protected void onApply() {
        this.apply();
        this.btnApply.setEnabled(false);
    }

    protected void onOk() {
        if (this.alreadyApply()) {
            super.onCancel();
        } else {
            super.onOk();
        }
    }

    protected void onCancel() {
        super.onCancel();
    }

    protected void todoInit() {
        this.setTitle(ReportResource.getString(ReportResource.class, (String)"AdjustColumnDesigner"));
        this.setSize(DLG_WIDTH, DLG_HEIGHT);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        this.createButtons();
        this.createTblList();
        this.createContainer();
        parent.add((Component)this.container, thisCell);
    }

    private boolean alreadyApply() {
        return !this.btnApply.isEnabled();
    }

    private void createButtons() {
        this.btnUp = this.createBarButton(ReportResource.getString(ReportResource.class, (String)"MoveUp"), Resources.getIcon("icon/tbtn_movetop.gif"));
        this.btnDown = this.createBarButton(ReportResource.getString(ReportResource.class, (String)"MoveDown"), Resources.getIcon("icon/tbtn_movedown.gif"));
        this.btnDelete = this.createBarButton(ReportResource.getString(ReportResource.class, (String)"DeleteColumn"), Resources.getIcon("icon/tbtn_delete.gif"));
    }

    private void createTblList() {
        this.tblList.getSelectManager().setSelectMode(10);
        this.tblList.getStyleAttributes().setLocked(true);
    }

    private void createContainer() {
        this.container.setTitle(ReportResource.getString(ReportResource.class, (String)"AdjustColumnPrompt"));
        this.container.setTitleStyle(2);
        this.container.setEnableActive(false);
        this.container.getContentPane().setLayout(new BorderLayout(0, 0));
        this.container.getContentPane().add((Component)this.tblList, "Center");
        this.container.addButton((JButton)this.btnUp);
        this.container.addButton((JButton)this.btnDown);
        this.container.addButton((JButton)this.btnDelete);
    }

    private void fillTblList() {
        this.tblList.removeRows();
        this.tblList.removeColumns();
        Hierarchy[] hies = this.axis.getHierarchies();
        for (int i = 0; i < hies.length; ++i) {
            this.tblList.addColumn();
        }
        IRow header = this.tblList.addHeadRow();
        for (int i = 0; i < hies.length; ++i) {
            header.getCell(i).setValue((Object)hies[i]);
        }
        List poses = this.axis.getPositions();
        Iterator iter = poses.iterator();
        while (iter.hasNext()) {
            IRow row = this.tblList.addRow();
            Position pos = (Position)iter.next();
            Member[] ms = pos.getMembers();
            for (int i = 0; i < hies.length; ++i) {
                row.getCell(i).setValue((Object)ms[i]);
                row.setUserObject((Object)pos);
            }
        }
        this.tblList.getSelectManager().select(0, -1);
    }

    private KDWorkButton createBarButton(String tip, Icon icon) {
        KDWorkButton btn = new KDWorkButton();
        btn.setText(null);
        btn.setIcon(icon);
        btn.setToolTipText(tip);
        btn.addActionListener((ActionListener)this.buttonActionListener);
        return btn;
    }

    private void deletRow() {
        KDTRange r = this.tblList.getSelectManager().toRange();
        for (int i = this.tblList.getRowCount() - 1; i >= 0; --i) {
            if (!r.contains(0, i) || this.tblList.getRowCount() <= 1) continue;
            this.tblList.removeRow(i);
            this.btnApply.setEnabled(true);
        }
    }

    private void moveRow(boolean isUp) {
        int to;
        int from;
        int i;
        ArrayList<Integer> selectedList = new ArrayList<Integer>();
        KDTRange r = this.tblList.getSelectManager().toRange();
        for (int i2 = 0; i2 < this.tblList.getRowCount(); ++i2) {
            if (!r.contains(0, i2)) continue;
            selectedList.add(new Integer(i2));
        }
        int n = selectedList.size();
        if (n == 0) {
            return;
        }
        int lastTo = -1;
        ArrayList<Integer> newSelectedList = new ArrayList<Integer>();
        if (isUp) {
            for (i = 0; i < n; ++i) {
                from = (Integer)selectedList.get(i);
                to = from - 1;
                if (to < 0) {
                    lastTo = 0;
                } else if (to == lastTo) {
                    lastTo = from;
                } else {
                    lastTo = to;
                    this.btnApply.setEnabled(true);
                    this.tblList.moveRow(from, to);
                }
                newSelectedList.add(new Integer(lastTo));
            }
        } else {
            for (i = n - 1; i >= 0; --i) {
                from = (Integer)selectedList.get(i);
                to = from + 1;
                if (to >= this.tblList.getRowCount()) {
                    lastTo = this.tblList.getRowCount() - 1;
                } else if (to == lastTo) {
                    lastTo = from;
                } else {
                    lastTo = to;
                    this.btnApply.setEnabled(true);
                    this.tblList.moveRow(to, from);
                }
                newSelectedList.add(new Integer(lastTo));
            }
        }
        this.tblList.getSelectManager().getBlocks().clear();
        for (int i3 = newSelectedList.size() - 1; i3 >= 0; --i3) {
            int rIndex = (Integer)newSelectedList.get(i3);
            this.tblList.getSelectManager().add(rIndex, 0, rIndex, 1);
        }
    }

    private Position[] getPostionArray() {
        Position[] p = new Position[this.tblList.getRowCount()];
        for (int i = 0; i < p.length; ++i) {
            p[i] = (Position)this.tblList.getRow(i).getUserObject();
        }
        return p;
    }

    class ButtonActionListener
    implements ActionListener {
        ButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            if (obj == AdjustColOrderDialog.this.btnUp) {
                AdjustColOrderDialog.this.moveRow(true);
            } else if (obj == AdjustColOrderDialog.this.btnDown) {
                AdjustColOrderDialog.this.moveRow(false);
            } else if (obj == AdjustColOrderDialog.this.btnDelete) {
                AdjustColOrderDialog.this.deletRow();
            } else {
                Util.assertTrue((boolean)false);
            }
        }
    }
}

