/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.ui;

import com.kingdee.bos.ctrl.analysis.AnalysisException;
import com.kingdee.bos.ctrl.analysis.IExceptionHandler;
import com.kingdee.bos.ctrl.analysis.bicomponent.ChartComponent;
import com.kingdee.bos.ctrl.analysis.bicomponent.ComponentConfig;
import com.kingdee.bos.ctrl.analysis.bicomponent.WorksheetComponent;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModel;
import com.kingdee.bos.ctrl.analysis.cubemodel.schema.CubeModelUtil;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelSupport;
import com.kingdee.bos.ctrl.analysis.olap.ModelFactory;
import com.kingdee.bos.ctrl.analysis.olap.NonEmpty;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.SwapAxes;
import com.kingdee.bos.ctrl.analysis.report.ICubeExecutor;
import com.kingdee.bos.ctrl.analysis.report.IOlapReportStorage;
import com.kingdee.bos.ctrl.analysis.report.OlapReportException;
import com.kingdee.bos.ctrl.analysis.report.ReportResource;
import com.kingdee.bos.ctrl.analysis.report.UIContext;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.ConnectStringParser;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.ConnectionInfoWrapper;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.IURLResolver;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.ui.OlapConnectionInfoListUI;
import com.kingdee.bos.ctrl.analysis.report.schema.OlapRpt_CSS;
import com.kingdee.bos.ctrl.analysis.report.schema.OlapRpt_Chart;
import com.kingdee.bos.ctrl.analysis.report.schema.OlapRpt_ColumnHeader;
import com.kingdee.bos.ctrl.analysis.report.schema.OlapRpt_Cube;
import com.kingdee.bos.ctrl.analysis.report.schema.OlapRpt_DataStyle;
import com.kingdee.bos.ctrl.analysis.report.schema.OlapRpt_MapItem;
import com.kingdee.bos.ctrl.analysis.report.schema.OlapRpt_Merge;
import com.kingdee.bos.ctrl.analysis.report.schema.OlapRpt_OlapConnection;
import com.kingdee.bos.ctrl.analysis.report.schema.OlapRpt_OlapReport;
import com.kingdee.bos.ctrl.analysis.report.schema.OlapRpt_Page;
import com.kingdee.bos.ctrl.analysis.report.schema.OlapRpt_QueryInfo;
import com.kingdee.bos.ctrl.analysis.report.schema.OlapRpt_RowHeader;
import com.kingdee.bos.ctrl.analysis.report.schema.OlapRpt_Style;
import com.kingdee.bos.ctrl.analysis.report.schema.OlapRpt_Worksheet;
import com.kingdee.bos.ctrl.analysis.report.ui.BaseAction;
import com.kingdee.bos.ctrl.analysis.report.ui.CheckMenuItem;
import com.kingdee.bos.ctrl.analysis.report.ui.Config;
import com.kingdee.bos.ctrl.analysis.report.ui.FileOlapReportStorage;
import com.kingdee.bos.ctrl.analysis.report.ui.FileURLResolver;
import com.kingdee.bos.ctrl.analysis.report.ui.LocalCubeExecutor;
import com.kingdee.bos.ctrl.analysis.report.ui.MenuItem;
import com.kingdee.bos.ctrl.analysis.report.ui.TestCubeModelSelectComponent;
import com.kingdee.bos.ctrl.analysis.report.ui.TestOlapConnectionStorage;
import com.kingdee.bos.ctrl.analysis.report.ui.ToggleAction;
import com.kingdee.bos.ctrl.analysis.report.ui.ToggleButton;
import com.kingdee.bos.ctrl.analysis.report.ui.WorkButton;
import com.kingdee.bos.ctrl.analysis.report.ui.style.LabelValueBean;
import com.kingdee.bos.ctrl.analysis.report.ui.style.MergeItem;
import com.kingdee.bos.ctrl.analysis.resource.Resources;
import com.kingdee.bos.ctrl.analysis.xmlutil.Names;
import com.kingdee.bos.ctrl.analysis.xmlutil.XMLException;
import com.kingdee.bos.ctrl.analysis.xmlutil.XMLUtil;
import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.def.SchemaParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;

public class Workbench
extends KDFrame
implements IExceptionHandler {
    KDTable worksheetTable;
    KDChart kdchart;
    KDPanel rootPanel;
    KDPanel topPanel;
    Config config;
    OlapModel olapModel;
    Connection connection;
    ComponentConfig componentConfig;
    WorksheetComponent worksheetComponent;
    ChartComponent chartComponent;
    Icon iconNew;
    Icon iconOpen;
    Icon iconSave;
    Icon iconSaveAs;
    Icon iconPrint;
    Icon iconPreview;
    Icon iconChartDown;
    Icon iconChartUp;
    Icon iconNestingForColumn;
    Icon iconNestingForRow;
    Icon iconNonEmptyForColumn;
    Icon iconNonEmptyForRow;
    Icon iconExpandByPosition;
    Icon iconSwap;
    Icon iconMdx;
    Icon iconLayout;
    Icon iconShowSlice;
    Icon iconStaticReport;
    Icon iconSortRank;
    Icon iconDataStyle;
    Icon iconMerge;
    Icon iconExport2Excel;
    Icon iconChartAnalysis;
    Icon iconFiltData;
    Icon iconMovetier;
    Icon iconExit;
    KDToolBar toolbar;
    KDMenuBar mb;
    UIContext context;
    boolean simpleUse;
    private BaseAction actionNew = null;
    private BaseAction actionOpen = null;
    private BaseAction actionSave = null;
    private BaseAction actionSaveAs = null;
    private BaseAction actionPreview = null;
    private BaseAction actionPrint = null;
    private ToggleAction actionChart = null;
    private ToggleAction actionNestingForColumn = null;
    private ToggleAction actionNestingForRow = null;
    private ToggleAction actionNonEmptyForColumn = null;
    private ToggleAction actionNonEmptyForRow = null;
    private ToggleAction actionExpandByPosition = null;
    private BaseAction actionSwap = null;
    private BaseAction actionMdx = null;
    private BaseAction actionLayout = null;
    private BaseAction actionExit = null;
    private BaseAction actionDataStyle = null;
    private BaseAction actionMergeStyle = null;
    private BaseAction actionExport2Excel = null;
    private BaseAction actionSortRank;
    private BaseAction actionChartAnalysis;
    private BaseAction actionFiltData;
    private BaseAction actionColOrderAdjust;
    private KDMenu[] menus;
    Action extendAfterExitAction;
    Action extendAfterSaveAction;
    OlapConnectionInfoListUI cnListUI;
    String connectString;
    Object dbSchema;
    String cubeName;
    Config originConfig;
    private String mdx = "";
    private String originMdx;

    public Workbench() {
        this(null);
    }

    public Workbench(UIContext context) {
        if (context == null) {
            context = this.getDefaultUIContext();
            this.simpleUse = true;
        }
        this.context = context;
        this.initIcon();
        this.initAction();
        this.actionNonEmptyForRow.getButtonModel().setSelected(true);
        this.initToolbar();
        this.initMenu();
        this.initUI();
    }

    public Component getRootComponent() {
        return this.rootPanel;
    }

    public WorksheetComponent getWorksheetComponent() {
        return this.worksheetComponent;
    }

    private void initIcon() {
        this.iconPrint = Resources.getIcon("icon/tbtn_print.gif");
        this.iconPreview = Resources.getIcon("icon/preview.gif");
        this.iconChartDown = Resources.getIcon("icon/chart-down.png");
        this.iconChartUp = Resources.getIcon("icon/tbtn_chart.gif");
        this.iconNestingForColumn = Resources.getIcon("icon/tbtn_nest_columns.gif");
        this.iconNestingForRow = Resources.getIcon("icon/tbtn_nest_rows.gif");
        this.iconNonEmptyForColumn = Resources.getIcon("icon/tbtn_nonempty_columns.gif");
        this.iconNonEmptyForRow = Resources.getIcon("icon/tbtn_nonempty_rows.gif");
        this.iconSwap = Resources.getIcon("icon/tbtn_swapaxes.gif");
        this.iconMdx = Resources.getIcon("icon/tbtn_mdx.gif");
        this.iconLayout = Resources.getIcon("icon/tbtn_layout.gif");
        this.iconShowSlice = Resources.getIcon("icon/tbtn_slice.gif");
        this.iconNew = Resources.getIcon("icon/tbtn_new.gif");
        this.iconOpen = Resources.getIcon("icon/tbtn_open.gif");
        this.iconSave = Resources.getIcon("icon/tbtn_save.gif");
        this.iconSaveAs = Resources.getIcon("icon/tbtn_saveas.gif");
        this.iconExit = Resources.getIcon("icon/tbtn_quit.gif");
        this.iconStaticReport = Resources.getIcon("icon/tbtn_staticreport.gif");
        this.iconDataStyle = Resources.getIcon("icon/tree_dataformat.gif");
        this.iconMerge = Resources.getIcon("icon/tbtn_merge.gif");
        this.iconExport2Excel = Resources.getIcon("icon/tbtn_importexcel.gif");
        this.iconExpandByPosition = Resources.getIcon("icon/tbtn_expandByPosition.gif");
        this.iconSortRank = Resources.getIcon("icon/tbtn_sortRank.gif");
        this.iconChartAnalysis = Resources.getIcon("icon/tbtn_graphsetting.gif");
        this.iconFiltData = Resources.getIcon("icon/tbtn_billfilter.gif");
        this.iconMovetier = Resources.getIcon("icon/tbtn_movetier.gif");
    }

    private void initAction() {
        this.actionNew = new BaseAction(ReportResource.getString(ReportResource.class, (String)"new"), this.iconNew, null, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.newReport();
            }
        };
        this.actionOpen = new BaseAction(ReportResource.getString(ReportResource.class, (String)"open"), this.iconOpen, null, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.openReport();
            }
        };
        this.actionSave = new BaseAction(ReportResource.getString(ReportResource.class, (String)"save"), this.iconSave, null, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.saveReport();
            }
        };
        this.actionSaveAs = new BaseAction(ReportResource.getString(ReportResource.class, (String)"saveas"), this.iconSaveAs, null, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.saveAsReport();
            }
        };
        this.actionPrint = new BaseAction("\u6253\u5370", this.iconPrint, null, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.worksheetComponent.doPrint(false, Workbench.this.actionChart.getButtonModel().isSelected() ? Workbench.this.kdchart : null, null);
            }
        };
        this.actionPreview = new BaseAction("\u6253\u5370\u9884\u89c8", this.iconPreview, null, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.worksheetComponent.doPrint(true, Workbench.this.actionChart.getButtonModel().isSelected() ? Workbench.this.kdchart : null, null);
            }
        };
        this.actionChart = new ToggleAction(ReportResource.getString(ReportResource.class, (String)"showChart"), this.iconChartUp, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.toggleChart();
            }
        };
        this.actionNestingForColumn = new ToggleAction("\u5d4c\u5957\u663e\u793a(\u6a2a\u8f74)", this.iconNestingForColumn, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.toggleNestingForColumn();
            }
        };
        this.actionNestingForRow = new ToggleAction("\u5d4c\u5957\u663e\u793a(\u7eb5\u8f74)", this.iconNestingForRow, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.toggleNestingForRow();
            }
        };
        this.actionNonEmptyForColumn = new ToggleAction("\u9690\u85cf\u7a7a\u6210\u5458(\u6a2a\u8f74)", this.iconNonEmptyForColumn, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.toggleNonEmptyForColumn();
            }
        };
        this.actionNonEmptyForRow = new ToggleAction("\u9690\u85cf\u7a7a\u6210\u5458(\u7eb5\u8f74)", this.iconNonEmptyForRow, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.toggleNonEmptyForRow();
            }
        };
        this.actionExpandByPosition = new ToggleAction("\u5c55\u5f00\u6a21\u5f0f\uff1a\u53ea\u5c55\u5f00\u5f53\u524d\u4f4d\u7f6e\u7684\u9009\u4e2d\u6210\u5458", this.iconExpandByPosition, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.toggleExpandByPosition();
            }
        };
        this.actionSwap = new BaseAction(ReportResource.getString(ReportResource.class, (String)"SwapRowColumn"), this.iconSwap, this.iconSwap, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.swap();
            }
        };
        this.actionMdx = new BaseAction("MDX\u67e5\u8be2", this.iconMdx, this.iconMdx, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.mdx = Workbench.this.worksheetComponent.mdxQuery();
            }
        };
        this.actionLayout = new BaseAction("\u5e03\u5c40", this.iconLayout, this.iconLayout, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.worksheetComponent.openLayoutDesigner();
            }
        };
        this.actionExit = new BaseAction(ReportResource.getString(ReportResource.class, (String)"Exit"), this.iconExit, null, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.exit();
            }
        };
        this.actionDataStyle = new BaseAction("\u5355\u5143\u683c\u683c\u5f0f", this.iconDataStyle, null, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.worksheetComponent.dataStyle();
            }
        };
        this.actionMergeStyle = new BaseAction("\u5355\u5143\u683c\u878d\u5408", this.iconMerge, null, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.worksheetComponent.mergeStyle();
            }
        };
        this.actionExport2Excel = new BaseAction("\u5bfc\u51fa\u5230Excel", this.iconExport2Excel, null, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.worksheetComponent.export2Excel();
            }
        };
        this.actionSortRank = new BaseAction("\u6392\u5e8f\u6392\u540d", this.iconSortRank, null, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.worksheetComponent.sortRank();
            }
        };
        this.actionChartAnalysis = new BaseAction("\u56fe\u5f62\u5206\u6790", this.iconChartAnalysis, null, -1){

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.worksheetComponent.openChartAnalysis(Workbench.this.connection, Workbench.this.mdx, null, new ComponentConfig());
            }
        };
        this.actionFiltData = new BaseAction(ReportResource.getString(ReportResource.class, (String)"SizerData"), this.iconFiltData, null, -1){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.worksheetComponent.sizerData();
            }
        };
        this.actionColOrderAdjust = new BaseAction(ReportResource.getString(ReportResource.class, (String)"AdjustColumn"), this.iconMovetier, null, -1){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Workbench.this.worksheetComponent.adjustColOrder();
            }
        };
    }

    public Action getExitAction() {
        return this.actionExit;
    }

    public KDToolBar getToolbar() {
        return this.toolbar;
    }

    private void initToolbar() {
        this.toolbar = new KDToolBar();
        if (this.simpleUse) {
            this.toolbar.addWorkButton((KDWorkButton)new WorkButton(this.actionNew));
            this.toolbar.addWorkButton((KDWorkButton)new WorkButton(this.actionOpen));
        }
        this.toolbar.addWorkButton((KDWorkButton)new WorkButton(this.actionSave));
        if (this.simpleUse) {
            this.toolbar.addWorkButton((KDWorkButton)new WorkButton(this.actionSaveAs));
        }
        this.toolbar.addSeparator();
        this.toolbar.addWorkButton((KDWorkButton)new WorkButton(this.actionPreview));
        this.toolbar.addWorkButton((KDWorkButton)new WorkButton(this.actionPrint));
        this.toolbar.addSeparator();
        this.toolbar.addWorkButton((KDWorkButton)new WorkButton(this.actionSwap));
        if (this.simpleUse) {
            this.toolbar.addWorkButton((KDWorkButton)new WorkButton(this.actionMdx));
            this.toolbar.addWorkButton((KDWorkButton)new WorkButton(this.actionLayout));
        }
        this.toolbar.addSeparator();
        this.toolbar.add((Component)((Object)new ToggleButton(this.actionNestingForColumn)));
        this.toolbar.add((Component)((Object)new ToggleButton(this.actionNestingForRow)));
        this.toolbar.add((Component)((Object)new ToggleButton(this.actionNonEmptyForColumn)));
        this.toolbar.add((Component)((Object)new ToggleButton(this.actionNonEmptyForRow)));
        this.toolbar.add((Component)((Object)new ToggleButton(this.actionChart)));
        this.toolbar.addSeparator();
        this.toolbar.addWorkButton((KDWorkButton)new WorkButton(this.actionChartAnalysis));
        this.toolbar.addWorkButton((KDWorkButton)new WorkButton(this.actionSortRank));
        this.toolbar.addWorkButton((KDWorkButton)new WorkButton(this.actionDataStyle));
        this.toolbar.addWorkButton((KDWorkButton)new WorkButton(this.actionMergeStyle));
        this.toolbar.addWorkButton((KDWorkButton)new WorkButton(this.actionFiltData));
        this.toolbar.addWorkButton((KDWorkButton)new WorkButton(this.actionColOrderAdjust));
        this.toolbar.addWorkButton((KDWorkButton)new WorkButton(this.actionExport2Excel));
        if (this.simpleUse) {
            this.toolbar.addSeparator();
            this.toolbar.addWorkButton((KDWorkButton)new WorkButton(this.actionExit));
        }
    }

    public KDMenu[] getMenus() {
        return this.menus;
    }

    private void initMenu() {
        this.mb = new KDMenuBar();
        this.mb.hideLogo();
        KDMenu file = new KDMenu(ReportResource.getString(ReportResource.class, (String)"File2") + "(F)");
        file.setMnemonic('F');
        if (this.simpleUse) {
            file.add((JMenuItem)((Object)new MenuItem(this.actionNew)));
            file.add((JMenuItem)((Object)new MenuItem(this.actionOpen)));
        }
        file.add((JMenuItem)((Object)new MenuItem(this.actionSave)));
        if (this.simpleUse) {
            file.add((JMenuItem)((Object)new MenuItem(this.actionSaveAs)));
        }
        file.add((JMenuItem)((Object)new MenuItem(this.actionPreview)));
        file.add((JMenuItem)((Object)new MenuItem(this.actionPrint)));
        if (this.simpleUse) {
            file.addSeparator();
            file.add((JMenuItem)((Object)new MenuItem(this.actionExit)));
        }
        this.mb.add((JMenu)file);
        KDMenu config = new KDMenu(ReportResource.getString(ReportResource.class, (String)"Show") + "(C)");
        config.setMnemonic('C');
        config.add((JMenuItem)((Object)new MenuItem(this.actionSwap)));
        config.addSeparator();
        config.add((JMenuItem)((Object)new CheckMenuItem(this.actionNestingForColumn)));
        config.add((JMenuItem)((Object)new CheckMenuItem(this.actionNestingForRow)));
        config.add((JMenuItem)((Object)new CheckMenuItem(this.actionNonEmptyForColumn)));
        config.add((JMenuItem)((Object)new CheckMenuItem(this.actionNonEmptyForRow)));
        config.add((JMenuItem)((Object)new CheckMenuItem(this.actionChart)));
        config.addSeparator();
        config.add((JMenuItem)((Object)new MenuItem(this.actionChartAnalysis)));
        config.add((JMenuItem)((Object)new MenuItem(this.actionSortRank)));
        config.add((JMenuItem)((Object)new MenuItem(this.actionDataStyle)));
        config.add((JMenuItem)((Object)new MenuItem(this.actionMergeStyle)));
        config.add((JMenuItem)((Object)new MenuItem(this.actionFiltData)));
        config.add((JMenuItem)((Object)new MenuItem(this.actionColOrderAdjust)));
        config.add((JMenuItem)((Object)new MenuItem(this.actionExport2Excel)));
        this.mb.add((JMenu)config);
        KDMenu help = new KDMenu(ReportResource.getString(ReportResource.class, (String)"help") + "(H)");
        help.setMnemonic('H');
        this.mb.add((JMenu)help);
        this.menus = new KDMenu[2];
        this.menus[0] = file;
        this.menus[1] = config;
    }

    public void initUI() {
        this.setJMenuBar((JMenuBar)this.mb);
        this.addToolBar((JToolBar)this.toolbar);
        this.setTitle("Olap" + ReportResource.getString(ReportResource.class, (String)"analysisWorkbence"));
        this.setBounds(0, 0, 800, 600);
        this.setExtendedState(6);
        this.rootPanel = new KDPanel((LayoutManager)new BorderLayout());
        this.rootPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Container pane = super.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.add((Component)this.rootPanel, "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Workbench.this.exit();
            }
        });
        this.worksheetTable = new KDTable();
        this.initDefaultComponentConfig();
        this.worksheetComponent = new WorksheetComponent(this.worksheetTable, this.componentConfig, true);
        this.topPanel = new KDPanel();
        this.topPanel.setLayout((LayoutManager)new BorderLayout());
        this.topPanel.add((Component)this.worksheetComponent.getJComponent(), (Object)"Center");
    }

    private void initDefaultComponentConfig() {
        this.componentConfig = ComponentConfig.getConfig();
        this.componentConfig.showColumnDimensionHeader = true;
        this.componentConfig.showRowDimensionHeader = true;
        this.componentConfig.showColumnHeaderInTableHeader = true;
        this.componentConfig.showPopupMenuForMember = true;
    }

    private void loadConfigFromAction(Config config) {
        config.showNestingForColumn = this.actionNestingForColumn.getButtonModel().isSelected();
        config.showNestingForRow = this.actionNestingForRow.getButtonModel().isSelected();
        config.nonEmptyForColumn = this.actionNonEmptyForColumn.getButtonModel().isSelected();
        config.nonEmptyForRow = this.actionNonEmptyForRow.getButtonModel().isSelected();
        config.showChart = this.actionChart.getButtonModel().isSelected();
        this.componentConfig.nonEmptyForColumn = config.nonEmptyForColumn;
        this.componentConfig.nonEmptyForRow = config.nonEmptyForRow;
        this.componentConfig.showNestMemberForColumn = config.showNestingForColumn;
        this.componentConfig.showNestMemberForRow = config.showNestingForRow;
        this.showChart(config.showChart);
    }

    private void setConfig(Config config) {
        this.actionNestingForColumn.getButtonModel().setSelected(config.showNestingForColumn);
        this.actionNestingForRow.getButtonModel().setSelected(config.showNestingForRow);
        this.actionNonEmptyForColumn.getButtonModel().setSelected(config.nonEmptyForColumn);
        this.actionNonEmptyForRow.getButtonModel().setSelected(config.nonEmptyForRow);
        this.actionChart.getButtonModel().setSelected(config.showChart);
        this.componentConfig.nonEmptyForColumn = config.nonEmptyForColumn;
        this.componentConfig.nonEmptyForRow = config.nonEmptyForRow;
        this.componentConfig.showNestMemberForColumn = config.showNestingForColumn;
        this.componentConfig.showNestMemberForRow = config.showNestingForRow;
        this.showChart(config.showChart);
    }

    private void showChart(boolean show) {
        this.rootPanel.removeAll();
        if (!show) {
            this.rootPanel.add((Component)this.topPanel, (Object)"Center");
        } else {
            if (this.chartComponent == null) {
                this.kdchart = new KDChart();
                this.chartComponent = new ChartComponent(this.kdchart, this.componentConfig);
                this.chartComponent.setModel(this.olapModel);
            } else {
                this.chartComponent.refresh();
            }
            KDSplitPane sp = new KDSplitPane(0);
            sp.setTopComponent((Component)this.topPanel);
            sp.setBottomComponent((Component)this.kdchart);
            sp.setDividerLocation(400);
            this.rootPanel.add((Component)sp, (Object)"Center");
        }
        this.rootPanel.validate();
    }

    private void toggleChart(boolean show) {
        this.showChart(show);
        if (this.config != null) {
            this.config.showChart = show;
        }
    }

    protected void exit() {
        if (this.canExit()) {
            if (this.extendAfterExitAction != null) {
                this.extendAfterExitAction.actionPerformed(null);
            }
            this.worksheetComponent.dispose();
            this.dispose();
        }
    }

    boolean canExit() {
        if (this.dirty()) {
            int r = MessageDialog.show((Component)((Object)this), (Object)ReportResource.getString(ReportResource.class, (String)"shouldSave"), (String)ReportResource.getString(ReportResource.class, (String)"Informattion"), (int)1);
            if (r == 0) {
                return this.saveReport();
            }
            return r == 1;
        }
        return true;
    }

    public void setExtendAfterExitAction(Action action) {
        this.extendAfterExitAction = action;
    }

    public void setExtendAfterSaveAction(Action action) {
        this.extendAfterSaveAction = action;
    }

    protected void swap() {
        if (this.worksheetComponent != null) {
            this.worksheetComponent.swapAxis();
            this.config.swap = !this.config.swap;
            boolean nonEmptyForRow = this.actionNonEmptyForRow.getButtonModel().isSelected();
            boolean nonEmptyForColumn = this.actionNonEmptyForColumn.getButtonModel().isSelected();
            if (nonEmptyForRow == nonEmptyForColumn) {
                return;
            }
            this.actionNonEmptyForRow.getButtonModel().setSelected(nonEmptyForColumn);
            this.config.nonEmptyForRow = nonEmptyForColumn;
            this.worksheetComponent.getConfig().nonEmptyForRow = nonEmptyForColumn;
            this.actionNonEmptyForColumn.getButtonModel().setSelected(nonEmptyForRow);
            this.config.nonEmptyForColumn = nonEmptyForRow;
            this.worksheetComponent.getConfig().nonEmptyForColumn = nonEmptyForRow;
        }
    }

    protected void toggleNonEmptyForColumn() {
        boolean nonEmpty;
        if (this.worksheetComponent == null || this.olapModel == null) {
            return;
        }
        this.config.nonEmptyForColumn = nonEmpty = this.actionNonEmptyForColumn.getButtonModel().isSelected();
        this.worksheetComponent.getConfig().nonEmptyForColumn = nonEmpty;
        ((NonEmpty)this.olapModel.getExtension("nonEmpty")).setNonEmptyForColumn(nonEmpty);
    }

    protected void toggleNonEmptyForRow() {
        boolean nonEmpty;
        if (this.worksheetComponent == null || this.olapModel == null) {
            return;
        }
        this.config.nonEmptyForRow = nonEmpty = this.actionNonEmptyForRow.getButtonModel().isSelected();
        this.worksheetComponent.getConfig().nonEmptyForRow = nonEmpty;
        ((NonEmpty)this.olapModel.getExtension("nonEmpty")).setNonEmptyForRow(nonEmpty);
    }

    protected void toggleExpandByPosition() {
        boolean expandByPosition;
        if (this.worksheetComponent == null || this.olapModel == null) {
            return;
        }
        this.config.expandByPosition = expandByPosition = this.actionExpandByPosition.getButtonModel().isSelected();
        this.worksheetComponent.getConfig().expandMode = expandByPosition ? 1 : 0;
    }

    void toggleStaticReport() {
        if (this.worksheetComponent == null) {
            return;
        }
        this.worksheetComponent.refresh();
    }

    protected void toggleNestingForColumn() {
        if (this.worksheetComponent == null) {
            return;
        }
        ComponentConfig cconfig = this.worksheetComponent.getConfig();
        cconfig.showNestMemberForColumn = this.actionNestingForColumn.getButtonModel().isSelected();
        this.worksheetComponent.refresh();
        this.config.showNestingForColumn = cconfig.showNestMemberForColumn;
    }

    protected void toggleNestingForRow() {
        if (this.worksheetComponent == null) {
            return;
        }
        ComponentConfig cconfig = this.worksheetComponent.getConfig();
        cconfig.showNestMemberForRow = this.actionNestingForRow.getButtonModel().isSelected();
        this.worksheetComponent.refresh();
        this.config.showNestingForRow = cconfig.showNestMemberForRow;
    }

    protected void toggleChart() {
        if (this.worksheetComponent == null) {
            return;
        }
        this.toggleChart(this.actionChart.getButtonModel().isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveAsReport() {
        if (this.worksheetComponent == null || this.olapModel == null) {
            return true;
        }
        OlapRpt_OlapReport schema = this.makeSchema();
        IOlapReportStorage storage = (IOlapReportStorage)this.context.get(UIContext.KEY_OlapReportStorage);
        OutputStream out = storage.getSaveAsOutputStream();
        if (out != null) {
            boolean bl;
            try {
                schema.output(out);
                if (this.extendAfterSaveAction != null) {
                    this.extendAfterSaveAction.actionPerformed(null);
                }
                WindowUtil.alert((Component)((Object)this), (String)ReportResource.getString(ReportResource.class, (String)"saveSucceed"));
                this.makePure();
                bl = true;
            }
            catch (XMLException e) {
                try {
                    this.handleException(e);
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{out});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{out});
            }
            CloseUtil.close((Closeable[])new Closeable[]{out});
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveReport() {
        OutputStream out;
        if (this.worksheetComponent == null || this.olapModel == null) {
            return true;
        }
        OlapRpt_OlapReport schema = this.makeSchema();
        IOlapReportStorage storage = (IOlapReportStorage)this.context.get(UIContext.KEY_OlapReportStorage);
        if (null != storage && (out = storage.getOutputStream()) != null) {
            boolean bl;
            try {
                schema.output(out);
                if (this.extendAfterSaveAction != null) {
                    this.extendAfterSaveAction.actionPerformed(null);
                }
                this.makePure();
                WindowUtil.alert((Component)((Object)this), (String)ReportResource.getString(ReportResource.class, (String)"saveSucceed"));
                bl = true;
            }
            catch (XMLException e) {
                try {
                    this.handleException(e);
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{out});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{out});
            }
            CloseUtil.close((Closeable[])new Closeable[]{out});
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openReport() {
        IOlapReportStorage storage = (IOlapReportStorage)this.context.get(UIContext.KEY_OlapReportStorage);
        InputStream in = storage.getInputStream();
        if (in != null) {
            try {
                OlapRpt_OlapReport olapReport = XMLUtil.loadOlapReport(in);
                this.openReport(olapReport);
                this.makePure();
            }
            catch (Exception e) {
                try {
                    this.handleException(e);
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{in});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{in});
            }
            CloseUtil.close((Closeable[])new Closeable[]{in});
        }
    }

    public void editReport(boolean show) {
        this.openReport();
        if (show) {
            this.setVisible(true);
        }
    }

    public void editReport() {
        this.editReport(true);
    }

    public void browseReport() {
        this.browseReport(true);
    }

    public void browseReport(boolean show) {
        this.openReport();
        if (show) {
            this.setVisible(true);
        }
    }

    private OlapRpt_OlapReport makeSchema() {
        LabelValueBean lvb;
        int i;
        int n;
        OlapRpt_MapItem[] items;
        OlapRpt_OlapReport olapReport = new OlapRpt_OlapReport();
        olapReport.setDefaultPage("page1");
        OlapRpt_OlapConnection olapConnection = new OlapRpt_OlapConnection();
        olapReport.setOlapConnection(olapConnection);
        olapConnection.setEncryptType("");
        olapConnection.setText(this.connectString);
        OlapRpt_QueryInfo queryInfo = new OlapRpt_QueryInfo();
        olapReport.setQueryInfo(queryInfo);
        OlapRpt_Cube cube = new OlapRpt_Cube();
        queryInfo.setCube(cube);
        cube.setName(this.cubeName);
        queryInfo.setType("mdx");
        queryInfo.setMdx(this.olapModel.getCurrentMdx());
        OlapRpt_Style style = new OlapRpt_Style();
        olapReport.setStyle(style);
        OlapRpt_Page page = new OlapRpt_Page();
        olapReport.setPage(page);
        page.setTitle(ReportResource.getString(ReportResource.class, (String)"page") + "1");
        page.setName("page1");
        page.setPosition("1");
        OlapRpt_Worksheet schemaWorksheet = new OlapRpt_Worksheet();
        page.setWorksheet(schemaWorksheet);
        boolean nonEmptyForColumn = this.actionNonEmptyForColumn.getButtonModel().isSelected();
        boolean nonEmptyForRow = this.actionNonEmptyForRow.getButtonModel().isSelected();
        boolean showNestingForColumn = this.actionNestingForColumn.getButtonModel().isSelected();
        boolean showNestingForRow = this.actionNestingForRow.getButtonModel().isSelected();
        schemaWorksheet.setSliceInSheet(Boolean.valueOf(false).toString());
        OlapRpt_RowHeader rowHeader = new OlapRpt_RowHeader();
        OlapRpt_ColumnHeader columnHeader = new OlapRpt_ColumnHeader();
        rowHeader.setShowNesting(Boolean.valueOf(showNestingForRow).toString());
        columnHeader.setShowNesting(Boolean.valueOf(showNestingForColumn).toString());
        rowHeader.setNonEmpty(Boolean.valueOf(nonEmptyForRow).toString());
        columnHeader.setNonEmpty(Boolean.valueOf(nonEmptyForColumn).toString());
        schemaWorksheet.setRowHeader(rowHeader);
        schemaWorksheet.setColumnHeader(columnHeader);
        OlapRpt_DataStyle ds = new OlapRpt_DataStyle();
        schemaWorksheet.setDataStyle(ds);
        if (this.worksheetComponent.getDataStyleList() != null) {
            OlapRpt_CSS css = new OlapRpt_CSS();
            items = new OlapRpt_MapItem[this.worksheetComponent.getDataStyleList().size()];
            n = this.worksheetComponent.getDataStyleList().size();
            for (i = 0; i < n; ++i) {
                lvb = (LabelValueBean)this.worksheetComponent.getDataStyleList().get(i);
                items[i] = new OlapRpt_MapItem();
                items[i].setName(lvb.getLabel());
                items[i].setValue((String)lvb.getValue());
            }
            css.setMapItems(items);
            ds.setCss(css);
        }
        if (this.worksheetComponent.getMergeList() != null) {
            OlapRpt_Merge merge = new OlapRpt_Merge();
            items = new OlapRpt_MapItem[this.worksheetComponent.getMergeList().size()];
            n = this.worksheetComponent.getMergeList().size();
            for (i = 0; i < n; ++i) {
                lvb = (LabelValueBean)this.worksheetComponent.getMergeList().get(i);
                items[i] = new OlapRpt_MapItem();
                items[i].setName(lvb.getLabel());
                items[i].setValue(((MergeItem)lvb.getValue()).toString());
            }
            merge.setMapItems(items);
            ds.setMerge(merge);
        }
        OlapRpt_Chart schemaChart = null;
        if (this.actionChart.getButtonModel().isSelected()) {
            schemaChart = new OlapRpt_Chart();
            page.setChart(schemaChart);
            schemaChart.setType(Names.ChartTypes.getChartType(this.chartComponent.getKdchart()));
        }
        return olapReport;
    }

    public void newReport() {
        try {
            if (this.cnListUI == null) {
                this.cnListUI = new OlapConnectionInfoListUI((Frame)((Object)this), this.context);
            }
            if (this.cnListUI.showDialog()) {
                Connection connection;
                this.connectString = this.cnListUI.getOlapConnectionInfo().getConnectString();
                this.dbSchema = this.cnListUI.getDBSchema();
                this.cubeName = this.cnListUI.getCubeName();
                Map param = null;
                ICubeExecutor executor = (ICubeExecutor)this.context.get(UIContext.KEY_CubeExecutor);
                this.connection = connection = (Connection)executor.execute(this.dbSchema, this.cubeName, param);
                this.designReport(connection, this.cubeName);
                if (!this.isShowing()) {
                    this.setVisible(true);
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void newReport(String url, CubeModel cubeModel, String cubeName) {
        this.newReport(url, cubeModel, cubeName, true);
    }

    public void newReport(String url, CubeModel cubeModel, String cubeName, boolean show) {
        try {
            Connection connection;
            this.connectString = url;
            this.dbSchema = cubeModel;
            if (cubeName == null) {
                cubeName = cubeModel.getCubes()[0].getName();
            }
            this.cubeName = cubeName;
            ICubeExecutor executor = (ICubeExecutor)this.context.get(UIContext.KEY_CubeExecutor);
            this.connection = connection = (Connection)executor.execute(this.dbSchema, cubeName);
            this.designReport(connection, cubeName);
            if (show) {
                this.setVisible(true);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void handleException(Exception e) {
        e.printStackTrace();
        WindowUtil.alert((Component)this.worksheetTable, (String)e.getMessage());
    }

    private void setModel(OlapModel olapModel, boolean fireModelChangeEvent) throws AnalysisException {
        try {
            olapModel.disableModelChangedEvent();
            this.worksheetComponent.setModel(olapModel, false);
            if (this.chartComponent != null) {
                this.chartComponent.setModel(olapModel, false);
            }
            if (fireModelChangeEvent) {
                ((ModelSupport)((Object)olapModel)).postModelChanged();
            }
        }
        finally {
            olapModel.enableModelChangedEvent();
        }
    }

    private void setModel(OlapModel olapModel) throws AnalysisException {
        this.setModel(olapModel, true);
    }

    private void designReport(Connection connection, String cube) throws AnalysisException {
        this.config = new Config();
        this.loadConfigFromAction(this.config);
        this.worksheetComponent.getStyleExpert().clear();
        this.worksheetComponent.getMergeExpert().clear();
        this.olapModel = ModelFactory.makeDefaultKDOlapModel(connection, cube);
        this.mdx = "";
        this.setModel(this.olapModel);
    }

    private void openReport(OlapRpt_OlapReport schema) throws AnalysisException {
        this.config = new Config();
        this.originConfig = (Config)this.config.clone();
        this.worksheetComponent.getStyleExpert().clear();
        this.worksheetComponent.getMergeExpert().clear();
        OlapRpt_OlapConnection olapConnection = schema.getOlapConnection();
        OlapRpt_QueryInfo queryInfo = schema.getQueryInfo();
        OlapRpt_Page page = schema.getPage();
        OlapRpt_Worksheet schemaWorksheet = page.getWorksheet();
        OlapRpt_Chart schemaChart = page.getChart();
        this.config.showChart = schemaChart != null;
        OlapRpt_RowHeader rowHeader = schemaWorksheet.getRowHeader();
        OlapRpt_ColumnHeader columnHeader = schemaWorksheet.getColumnHeader();
        this.config.nonEmptyForColumn = Boolean.valueOf(rowHeader.getNonEmpty());
        this.config.nonEmptyForRow = Boolean.valueOf(columnHeader.getNonEmpty());
        this.config.showNestingForColumn = Boolean.valueOf(columnHeader.getShowNesting());
        this.config.showNestingForRow = Boolean.valueOf(rowHeader.getShowNesting());
        this.connectString = olapConnection.getText();
        ConnectionInfoWrapper info = new ConnectStringParser().parse(this.connectString);
        String mdx = queryInfo.getMdx();
        if (mdx == null || mdx.equals("")) {
            throw new OlapReportException(ReportResource.getString(ReportResource.class, (String)"illegalTemplete") + "mdx" + ReportResource.getString(ReportResource.class, (String)"IsNull"));
        }
        this.setConfig(this.config);
        this.olapModel = this.executeQuery(info, mdx);
        ((SwapAxes)this.olapModel.getExtension("swapAxes")).setSwapAxes(this.config.swap);
        this.worksheetComponent.setDataStyleList(null);
        this.worksheetComponent.setMergeList(null);
        OlapRpt_DataStyle ds = schemaWorksheet.getDataStyle();
        if (ds != null) {
            OlapRpt_Merge merge;
            OlapRpt_CSS css = ds.getCss();
            if (css != null && css.getMapItems() != null) {
                this.worksheetComponent.setDataStyleList(this.mapItemsToLabelStringValueBeanList(css.getMapItems()));
            }
            if ((merge = ds.getMerge()) != null && merge.getMapItems() != null) {
                this.worksheetComponent.setMergeList(this.mapItemsToLabelMergeItemValueBeanList(merge.getMapItems()));
            }
        }
        this.worksheetComponent.applyDataStyle();
        this.setModel(this.olapModel, false);
        this.worksheetComponent.applyMerge();
        this.olapModel.postModelChanged();
    }

    private List mapItemsToLabelStringValueBeanList(OlapRpt_MapItem[] items) {
        ArrayList<LabelValueBean> list = new ArrayList<LabelValueBean>();
        int n = items.length;
        for (int i = 0; i < n; ++i) {
            LabelValueBean lvb = new LabelValueBean(items[i].getName(), items[i].getValue());
            list.add(lvb);
        }
        return list;
    }

    private List mapItemsToLabelMergeItemValueBeanList(OlapRpt_MapItem[] items) {
        ArrayList<LabelValueBean> list = new ArrayList<LabelValueBean>();
        int n = items.length;
        for (int i = 0; i < n; ++i) {
            LabelValueBean lvb = new LabelValueBean(items[i].getName(), MergeItem.parseFrom(items[i].getValue()));
            list.add(lvb);
        }
        return list;
    }

    private OlapModel executeQuery(ConnectionInfoWrapper info, String mdx) throws AnalysisException {
        block6: {
            int type = info.getConnectType();
            String url = info.getUrl();
            try {
                Connection connection;
                if (type != 0) break block6;
                IURLResolver urlResolver = (IURLResolver)this.context.get(UIContext.KEY_URLResolver);
                InputStream in = urlResolver.openInputStream(url);
                Document doc = null;
                Object dbSchema = null;
                try {
                    doc = new SAXBuilder().build(in);
                    dbSchema = CubeModelUtil.loadSchema(doc);
                }
                catch (XMLException e) {
                    XMLException ex = e;
                    try {
                        dbSchema = SchemaParser.parse((Document)doc);
                    }
                    catch (OLAPException ee) {
                        throw ex;
                    }
                }
                ICubeExecutor executor = (ICubeExecutor)this.context.get(UIContext.KEY_CubeExecutor);
                this.connection = connection = (Connection)executor.execute(dbSchema, this.cubeName);
                OlapModel olapModel = ModelFactory.makeKDOlapModel(connection, mdx);
                this.mdx = mdx;
                return olapModel;
            }
            catch (Exception e) {
                throw new OlapReportException(ReportResource.getString(ReportResource.class, (String)"CantOpen") + "olap" + ReportResource.getString(ReportResource.class, (String)"Con") + url + ", " + ReportResource.getString(ReportResource.class, (String)"FileBad"), e);
            }
        }
        return null;
    }

    private void makePure() {
        if (this.olapModel != null) {
            this.originMdx = this.olapModel.getCurrentMdx();
        }
        this.originConfig = (Config)this.config.clone();
    }

    private boolean dirty() {
        if (this.olapModel != null) {
            boolean ret = !this.olapModel.getCurrentMdx().equals(this.originMdx) || !this.config.equals(this.originConfig);
            return ret;
        }
        return false;
    }

    private UIContext getDefaultUIContext() {
        UIContext context = new UIContext();
        context.put(UIContext.KEY_CubeModelSelectComponent, new TestCubeModelSelectComponent());
        context.put(UIContext.KEY_OlapConnectionStorage, new TestOlapConnectionStorage());
        context.put(UIContext.KEY_URLResolver, new FileURLResolver());
        context.put(UIContext.KEY_CubeExecutor, new LocalCubeExecutor());
        context.put(UIContext.KEY_OlapReportStorage, new FileOlapReportStorage((Component)((Object)this)));
        return context;
    }

    public static void main(String[] args) throws Exception {
        CtrlUIEnv.setKingdeeLAF();
        Workbench bench = new Workbench();
        bench.show();
    }
}

