/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax;

import com.kingdee.bos.ctrl.analysis.olap.ModelFactory;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.web.ajax.BIReportPage;
import com.kingdee.bos.ctrl.analysis.web.solution.AbstractVarProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportVarProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.MacroVariant;
import com.kingdee.bos.ctrl.analysis.web.solution.ScriptSQL;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterValue;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class MdxQueryO {
    private static Logger logger = CommonLogger.getLogger(MdxQueryO.class);
    private Object lock = new Object();
    BIReportPage page;
    private String name;
    private String mdx;
    private boolean dirty;
    private OlapModel olapModel;

    MdxQueryO(BIReportPage page, String name, String mdx) {
        this.page = page;
        this.name = name;
        this.mdx = mdx;
        this.dirty = false;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirty(boolean dirty) {
        Object object = this.lock;
        synchronized (object) {
            this.dirty = dirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapModel getOlapModel(HttpServletRequest request) throws BIReportException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.dirty && this.olapModel != null) {
                return this.olapModel;
            }
            this.olapModel = this.createOlapModel(request);
            this.dirty = false;
        }
        return this.olapModel;
    }

    private OlapModel createOlapModel(HttpServletRequest request) throws BIReportException {
        List macroList;
        FilterValue fv = this.page.getFilterValue();
        BIReportVarProvider varProvider = new BIReportVarProvider(BISystem.getContext(request), !BISystem.isEAS(), this.page.getSubject().getRuntimeVarFilename(), this.page.getSubject().getRuntimeVarClassname(), this.page.getBIReport().getDatacenter());
        String newMDX = this.mdx;
        if (fv != null && (macroList = fv.getMacroList()) != null && macroList.size() > 0) {
            newMDX = MacroVariant.handleStatement(macroList, this.mdx);
            varProvider.putMacroList(macroList);
        }
        newMDX = new ScriptSQL().transSql(newMDX, (AbstractVarProvider)varProvider, Arrays.asList("[V$All]"), Arrays.asList("[V&All]"));
        try {
            logger.debug((Object)("[MDX] " + newMDX));
            return ModelFactory.makeKDOlapModel(this.page.getOlapConnection(request, varProvider), newMDX);
        }
        catch (OlapException e) {
            throw new BIReportException(e);
        }
    }

    public void release() {
        if (this.olapModel != null) {
            this.olapModel.destroy();
            this.olapModel = null;
        }
    }
}

